/*
 * Decompiled with CFR 0.152.
 */
package pool.service.service;

import cms.api.OrganizationApi;
import cms.api.dto.OrganizationDto;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class OrganizationApiStub {
    @MotanReferer
    OrganizationApi organizationApi;
    @Autowired
    RedisTemplate redisTemplate;
    private String ORGNIZATION_CODE_KEY = "provider-service:organization:";

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public OrganizationDto findOrganizationByOrgCode(String organizationCode) {
        BoundValueOperations boundValueOperations = this.redisTemplate.boundValueOps((Object)(this.ORGNIZATION_CODE_KEY + organizationCode));
        if (boundValueOperations.get() != null) {
            return (OrganizationDto)boundValueOperations.get();
        }
        OrganizationDto organization = this.organizationApi.findOrganizationByOrgCode(organizationCode);
        boundValueOperations.set((Object)organization, 1L, TimeUnit.DAYS);
        return organization;
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public List<OrganizationDto> findOrganizationAll() {
        BoundValueOperations boundValueOperations = this.redisTemplate.boundValueOps((Object)(this.ORGNIZATION_CODE_KEY + "all"));
        if (boundValueOperations.get() != null) {
            return (List)boundValueOperations.get();
        }
        List organizations = this.organizationApi.findOrganizationAll();
        boundValueOperations.set((Object)organizations, 1L, TimeUnit.DAYS);
        return organizations;
    }
}

