/*
 * Decompiled with CFR 0.152.
 */
package pool.service.service.ServiceImpl;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.ProductBrandApi;
import goods.dto.product.ProductBrandDto;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ma.glasnost.orika.MapperFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pool.commonUtil.MessageDictionary;
import pool.dto.BrandDto;
import pool.dto.BrandQueryDto;
import pool.dto.brand.brandmapper.BrandMapperDto;
import pool.model.ProviderProductBrand;
import pool.model.repository.ProviderProductBrandRepos;
import pool.service.service.BrandService;
import pool.service.service.ProductModelService;
import pool.service.service.ProviderGoodsService;
import pool.service.service.ServiceImpl.BrandServiceImpl;
import pool.vo.BrandVo;
import pool.vo.ProductBrandPageVo;
import pool.vo.ProviderProductBrandVo;
import pool.vo.query.brand.brandmapper.BrandMapperQueryVo;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;
import utils.sql.PageVo;
import utils.sql.QueryByPage;
import utils.string.ChineseInital;
import utils.string.StringUtils;

@Service
public class BrandServiceImpl
implements BrandService {
    private static final Logger logger = LoggerFactory.getLogger(BrandServiceImpl.class);
    @Autowired
    private ProviderProductBrandRepos providerProductBrandRepos;
    @Autowired
    private MapperFacade mapperFacade;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private QueryByPage queryByPage;
    @Autowired
    private ProductModelService productModelService;
    @Autowired
    private ProviderGoodsService providerGoodsService;
    @MotanReferer
    private ProductBrandApi productBrandApi;

    public BaseResponse<Map<String, String>> saveBrand(BrandDto brandDto) {
        BaseResponse baseResponse = null;
        try {
            if (Lang.isEmpty((Object)brandDto)) {
                return new BaseResponse(false, "\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a", (Object)"", "3001");
            }
            if (Lang.isEmpty((Object)brandDto.getName())) {
                return new BaseResponse(false, "\u8bf7\u6c42\u53c2\u6570name\u4e0d\u80fd\u4e3a\u7a7a", (Object)"", "3001");
            }
            ProviderProductBrand providerProductBrand = (ProviderProductBrand)this.mapperFacade.map((Object)brandDto, ProviderProductBrand.class);
            List validateProviderProductBrand = this.providerProductBrandRepos.findByNameAndStoreIdAndIsDelete(brandDto.getName(), brandDto.getStoreId(), false);
            if (!Lang.isEmpty((Object)validateProviderProductBrand)) {
                return new BaseResponse(false, "\u54c1\u724c\u5df2\u5b58\u5728", (Object)"", "3005");
            }
            String ch_name = null;
            String en_name = null;
            String[] nameArray = this.splitName(brandDto.getName());
            if (nameArray.length == 2) {
                ch_name = nameArray[0];
                en_name = nameArray[1];
            } else if (nameArray.length == 1) {
                if (StringUtils.isChinese((String)nameArray[0])) {
                    ch_name = nameArray[0];
                } else {
                    en_name = nameArray[0];
                }
            }
            List list = new ArrayList();
            if (!Lang.isEmpty((Object)ch_name) || !Lang.isEmpty((Object)en_name)) {
                list = this.findProductBrand(ch_name, en_name);
            }
            if (list.size() > 0) {
                providerProductBrand.setProductBrandId(((BrandVo)list.get(0)).getId());
                providerProductBrand.setProductBrandName(((BrandVo)list.get(0)).getName());
                providerProductBrand.setMatchSource("1");
                providerProductBrand.setMatchFlag("1");
            } else {
                providerProductBrand.setMatchFlag("0");
                providerProductBrand.setMatchSource("0");
            }
            String firstLetter = ChineseInital.getFirstLetter((String)brandDto.getName());
            providerProductBrand.setFirstLetter(firstLetter.toUpperCase());
            providerProductBrand = (ProviderProductBrand)this.providerProductBrandRepos.saveAndFlush((Object)providerProductBrand);
            baseResponse = new BaseResponse();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("brandId", providerProductBrand.getId());
            baseResponse.setResult(map);
            baseResponse.setSuccess(true);
            baseResponse.setResultCode("0000");
            baseResponse.setResultMessage("\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            baseResponse = new BaseResponse(false, "\u5185\u90e8\u9519\u8bef", (Object)"", "110013");
        }
        return baseResponse;
    }

    public BaseResponse<PageVo<BrandVo>> queryBrands(BrandQueryDto brandQueryDto) {
        BaseResponse baseResponse = new BaseResponse();
        try {
            if (!Lang.isEmpty((Object)brandQueryDto) && Lang.isEmpty((Object)brandQueryDto.getPageNo())) {
                brandQueryDto.setPageNo(MessageDictionary.DEFAULT_PAGENO);
            }
            if (!Lang.isEmpty((Object)brandQueryDto) && Lang.isEmpty((Object)brandQueryDto.getPageSize())) {
                brandQueryDto.setPageSize(MessageDictionary.DEFAULT_PAGESIZE);
            }
            if (Lang.isEmpty((Object)brandQueryDto)) {
                brandQueryDto.setPageSize(MessageDictionary.DEFAULT_PAGESIZE);
                brandQueryDto.setPageNo(MessageDictionary.DEFAULT_PAGENO);
            }
            int realPageNo = brandQueryDto.getPageNo() - 1 > 0 ? brandQueryDto.getPageNo() - 1 : 0;
            PageRequest pageable = new PageRequest(realPageNo, brandQueryDto.getPageSize().intValue());
            ProviderProductBrand providerProductBrand = new ProviderProductBrand();
            providerProductBrand.setCategoryId(brandQueryDto.getCategoryId());
            providerProductBrand.setId(brandQueryDto.getBrandId());
            1 specification = new /* Unavailable Anonymous Inner Class!! */;
            Page page = this.providerProductBrandRepos.findAll((Specification)specification, (Pageable)pageable);
            List providerProductBrandList = page.getContent();
            ArrayList<BrandVo> brandVos = new ArrayList<BrandVo>();
            for (ProviderProductBrand item : providerProductBrandList) {
                BrandVo brandVo = new BrandVo();
                brandVo.setId(item.getId());
                brandVo.setName(item.getName());
                brandVo.setSimpleName(item.getSimpleName());
                brandVo.setDescription(item.getDescription());
                brandVo.setIsCarefullyChosen(item.getIsCarefullyChosen());
                brandVo.setIsDisable(item.getIsDisable());
                brandVo.setWebsitesUrl(item.getWebsitesUrl());
                brandVo.setSourceCode(item.getStoreId());
                brandVos.add(brandVo);
            }
            ProductBrandPageVo productBrandPageVo = new ProductBrandPageVo(brandVos, Integer.valueOf(page.getNumber() + 1), Integer.valueOf(page.getSize()), Long.valueOf(page.getTotalElements()));
            baseResponse.setResult((Object)productBrandPageVo);
            baseResponse.setResultCode("0000");
            baseResponse.setResultMessage("\u64cd\u4f5c\u6210\u529f");
            baseResponse.setSuccess(true);
        }
        catch (Exception e) {
            baseResponse = new BaseResponse(false, "\u5185\u90e8\u9519\u8bef", (Object)"", "110013");
            e.printStackTrace();
        }
        return baseResponse;
    }

    public BrandMapperDto queryBrand(String id) {
        BrandMapperDto brandMapperDto = new BrandMapperDto();
        ProviderProductBrand providerProductBrand = (ProviderProductBrand)this.providerProductBrandRepos.findOne((Serializable)((Object)id));
        if (Lang.isEmpty((Object)providerProductBrand)) {
            return null;
        }
        brandMapperDto.setId(providerProductBrand.getId());
        brandMapperDto.setName(providerProductBrand.getName());
        brandMapperDto.setProductBrandId(providerProductBrand.getProductBrandId());
        return brandMapperDto;
    }

    @Transactional
    public BaseResponse<String> deleteBrand(String brandId) {
        BaseResponse baseResponse;
        try {
            ProviderProductBrand providerProductBrand;
            if (Lang.isEmpty((Object)brandId)) {
                new BaseResponse(false, "\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a", (Object)"", "3001");
            }
            if (Lang.isEmpty((Object)(providerProductBrand = (ProviderProductBrand)this.providerProductBrandRepos.findOne((Serializable)((Object)brandId))))) {
                BaseResponse baseResponse2 = new BaseResponse(false, "\u54c1\u724c\u4e0d\u5b58\u5728", (Object)"", "3003");
                return baseResponse2;
            }
            if (!Lang.isEmpty((Object)providerProductBrand) && providerProductBrand.getIsDelete().booleanValue()) {
                BaseResponse baseResponse3 = new BaseResponse(false, "\u54c1\u724c\u5df2\u5220\u9664", (Object)"", "3004");
                return baseResponse3;
            }
            providerProductBrand.setIsDelete(Boolean.valueOf(true));
            this.providerProductBrandRepos.save((Object)providerProductBrand);
            baseResponse = new BaseResponse(true, "\u64cd\u4f5c\u6210\u529f", (Object)"", "0000");
        }
        catch (Exception e) {
            e.printStackTrace();
            baseResponse = new BaseResponse(false, "\u5185\u90e8\u9519\u8bef", (Object)"", "110013");
        }
        return baseResponse;
    }

    public int findCountByStandardBrandId(String standardBrandId) {
        return this.providerProductBrandRepos.findByProductBrandId(standardBrandId);
    }

    public PageVo<BrandMapperDto> pageQueryForMapper(BrandMapperQueryVo brandMapperQueryVo, Pageable pageable) {
        PageVo pageVo = new PageVo();
        try {
            ArrayList<String> argsList = new ArrayList<String>();
            StringBuffer sb = new StringBuffer("");
            String selectStr = "select a.id as id,a.store_id as storeId ,a.name as name,a.match_source as matchSource,a.match_flag as matchFlag,a.product_brand_id as productBrandId,pb.name as productBrandName,c.store_name as storeName from provider_product_brand a  left join product_brand pb on pb.id = a.product_brand_id  left join store b on a.store_id = b.id  left join store_ext c on c.store_id = b.id ";
            String whereStr = " where 1=1 ";
            sb.append(selectStr).append(whereStr);
            if (!Lang.isEmpty((Object)brandMapperQueryVo)) {
                if (!Lang.isEmpty((Object)brandMapperQueryVo.getStoreId())) {
                    sb.append(" and a.store_id like ?");
                    argsList.add("%" + brandMapperQueryVo.getStoreId() + "%");
                }
                if (!Lang.isEmpty((Object)brandMapperQueryVo.getMatchFlag())) {
                    sb.append(" and a.match_flag = ?");
                    argsList.add(brandMapperQueryVo.getMatchFlag());
                }
                if (!Lang.isEmpty((Object)brandMapperQueryVo.getMatchSource())) {
                    sb.append(" and a.match_source = ?");
                    argsList.add(brandMapperQueryVo.getMatchSource());
                }
                if (!Lang.isEmpty((Object)brandMapperQueryVo.getProductBrandName())) {
                    sb.append(" and pb.name like ?");
                    argsList.add("%" + brandMapperQueryVo.getProductBrandName() + "%");
                }
                if (!Lang.isEmpty((Object)brandMapperQueryVo.getName())) {
                    sb.append(" and a.name like ?");
                    argsList.add("%" + brandMapperQueryVo.getName() + "%");
                }
                if (!Lang.isEmpty((Object)brandMapperQueryVo.getNameOne())) {
                    if ("1".equals(brandMapperQueryVo.getLinkOne())) {
                        sb.append(" and a.name like ?");
                        argsList.add("%" + brandMapperQueryVo.getNameOne() + "%");
                    }
                    if ("2".equals(brandMapperQueryVo.getLinkOne())) {
                        sb.append(" and a.name = ?");
                        argsList.add(brandMapperQueryVo.getNameOne());
                    }
                }
                if (!Lang.isEmpty((Object)brandMapperQueryVo.getNameTwo())) {
                    if ("1".equals(brandMapperQueryVo.getJoinOne())) {
                        if ("1".equals(brandMapperQueryVo.getLinkTwo())) {
                            sb.append(" or a.name like ?");
                            argsList.add("%" + brandMapperQueryVo.getNameTwo() + "%");
                        } else if ("2".equals(brandMapperQueryVo.getLinkTwo())) {
                            sb.append(" or a.name = ?");
                            argsList.add(brandMapperQueryVo.getNameTwo());
                        }
                    } else if ("1".equals(brandMapperQueryVo.getLinkTwo())) {
                        sb.append(" and a.name like ?");
                        argsList.add("%" + brandMapperQueryVo.getNameTwo() + "%");
                    } else if ("2".equals(brandMapperQueryVo.getLinkTwo())) {
                        sb.append(" and a.name = ?");
                        argsList.add(brandMapperQueryVo.getNameTwo());
                    }
                }
                if (!Lang.isEmpty((Object)brandMapperQueryVo.getNameThree())) {
                    if ("1".equals(brandMapperQueryVo.getJoinTwo())) {
                        if ("1".equals(brandMapperQueryVo.getLinkThree())) {
                            sb.append(" or a.name like ?");
                            argsList.add("%" + brandMapperQueryVo.getNameThree() + "%");
                        } else if ("2".equals(brandMapperQueryVo.getLinkThree())) {
                            sb.append(" or a.name = ?");
                            argsList.add(brandMapperQueryVo.getNameThree());
                        }
                    } else if ("1".equals(brandMapperQueryVo.getLinkThree())) {
                        sb.append(" and a.name like ?");
                        argsList.add("%" + brandMapperQueryVo.getNameThree() + "%");
                    } else if ("2".equals(brandMapperQueryVo.getLinkThree())) {
                        sb.append(" and a.name = ?");
                        argsList.add(brandMapperQueryVo.getNameThree());
                    }
                }
            }
            Object[] argsArray = argsList.toArray();
            pageVo = this.queryByPage.query(sb.toString(), BrandMapperDto.class, Integer.valueOf(pageable.getPageNumber()), Integer.valueOf(pageable.getPageSize()), argsArray);
            System.out.println(pageVo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pageVo;
    }

    public BrandMapperDto findById(String id) {
        ProviderProductBrand providerProductBrand = (ProviderProductBrand)this.providerProductBrandRepos.findOne((Serializable)((Object)id));
        return (BrandMapperDto)this.mapperFacade.map((Object)providerProductBrand, BrandMapperDto.class);
    }

    public Boolean bindStandardBrand(String id, String productBrandId) {
        ProviderProductBrand providerProductBrand = (ProviderProductBrand)this.providerProductBrandRepos.findOne((Serializable)((Object)id));
        if (Lang.isEmpty((Object)providerProductBrand)) {
            return false;
        }
        ProductBrandDto productBrandDto = this.productBrandApi.findByIdAndIsDelete(productBrandId, false);
        if (Lang.isEmpty((Object)productBrandDto)) {
            return false;
        }
        providerProductBrand.setProductBrandId(productBrandId);
        providerProductBrand.setMatchFlag("1");
        providerProductBrand.setMatchSource("2");
        providerProductBrand.setProductBrandName(productBrandDto.getName());
        this.providerProductBrandRepos.save((Object)providerProductBrand);
        BrandVo brandVo = new BrandVo();
        brandVo.setId(productBrandDto.getId());
        this.productModelService.updateProviderProductMappingInfo(id, false, brandVo);
        return true;
    }

    public Boolean cancelBindStandardBrand(String id) {
        ProviderProductBrand providerProductBrand = (ProviderProductBrand)this.providerProductBrandRepos.findOne((Serializable)((Object)id));
        if (Lang.isEmpty((Object)providerProductBrand)) {
            return false;
        }
        providerProductBrand.setProductBrandId(null);
        providerProductBrand.setMatchFlag("0");
        providerProductBrand.setMatchSource("0");
        providerProductBrand.setProductBrandName(null);
        this.providerProductBrandRepos.save((Object)providerProductBrand);
        BrandVo brandVo = new BrandVo();
        this.productModelService.updateProviderProductMappingInfo(id, false, brandVo);
        return true;
    }

    private String[] splitName(String initBrand) {
        String[] initStrings = initBrand.split("\uff08|\\(|\\/");
        for (int i = 0; i < initStrings.length; ++i) {
            String str;
            initStrings[i] = str = initStrings[i].trim().replaceAll("\\s+", " ").replaceAll("\uff09|\\)", "");
        }
        return initStrings;
    }

    private List<BrandVo> findProductBrand(String ch_name, String en_name) {
        ArrayList<String> argList = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        List<Object> list = new ArrayList<BrandVo>();
        if (!Lang.isEmpty((Object)ch_name) || !Lang.isEmpty((Object)en_name)) {
            String selectStr = "select id,name from product_brand pb where 1=1 ";
            sb.append(selectStr);
            if (!Lang.isEmpty((Object)ch_name) && !Lang.isEmpty((Object)en_name)) {
                sb.append(" and ch_name = ? or lower(en_name) = ?");
                argList.add(ch_name);
                argList.add(en_name);
            } else if (!Lang.isEmpty((Object)ch_name)) {
                sb.append(" and ch_name = ? ");
                argList.add(ch_name);
            } else if (!Lang.isEmpty((Object)en_name)) {
                sb.append(" and lower(en_name) = ?");
                argList.add(en_name.toLowerCase());
            } else {
                sb.append(" and 1 = 2");
            }
            sb.append(" and is_delete = ? ");
            argList.add("0");
            list = this.jdbcTemplate.query(sb.toString(), argList.toArray(), (RowMapper)new BeanPropertyRowMapper(BrandVo.class));
        }
        return list;
    }

    public List<BrandMapperDto> findStores() {
        String querySQL = " select distinct ppd.store_id as storeId,se.store_name as storeName from provider_product_brand ppd , store_ext se where ppd.store_id = se.store_id";
        List brandMapperDtoList = this.jdbcTemplate.query(querySQL, (RowMapper)new BeanPropertyRowMapper(BrandMapperDto.class));
        return brandMapperDtoList;
    }

    public ProviderProductBrandVo findBrandByNameAndStoreId(String brandName, String storeId) {
        List providerProductBrands = this.providerProductBrandRepos.findByNameAndStoreIdAndIsDelete(brandName, storeId, false);
        if (!Lang.isEmpty((Object)providerProductBrands)) {
            return (ProviderProductBrandVo)this.mapperFacade.map(providerProductBrands.get(0), ProviderProductBrandVo.class);
        }
        return null;
    }

    public List<String> findStoresOfProviderByProductCategoryId(String productCategoryId) {
        String querySql = " select distinct pg.store_id from PROVIDER_PRODUCT_FASHION pg , provider_product ppm where pg.PROVIDER_PRODUCT_ID = ppm.ID and pg.store_id = ppm.store_id and pg.is_delete = ? and ppm.product_category_id = ? ";
        List storeIdList = this.jdbcTemplate.queryForList(querySql, new Object[]{false, productCategoryId}, String.class);
        return storeIdList;
    }

    public void updateProviderBrandMappingInfo(BrandVo brandVo) {
        this.providerProductBrandRepos.updateProviderBrandMappingInfo(brandVo.getId(), brandVo.getName());
    }
}

