/*
 * Decompiled with CFR 0.152.
 */
package pool.service.service.ServiceImpl;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import goods.api.ProductCategoryApi;
import goods.api.ProductFashionApi;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ma.glasnost.orika.MapperFacade;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.transaction.annotation.Transactional;
import pool.dto.GoodsUpperAndLowerDto;
import pool.dto.GoodsUpperAndLowerQueryDto;
import pool.dto.ProviderGoodsDto;
import pool.model.ProviderProductFashion;
import pool.model.repository.ProviderProductFashionRepos;
import pool.service.service.GoodsUpperAndLowerService;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;
import utils.sql.JdbcTemplatePage;
import utils.sql.PageVo;

@MotanService
public class GoodsUpperAndLowerServiceImpl
implements GoodsUpperAndLowerService {
    private static final Logger log = LoggerFactory.getLogger(GoodsUpperAndLowerServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(GoodsUpperAndLowerServiceImpl.class);
    @Autowired
    private JdbcTemplatePage jdbcTemplatePage;
    @Autowired
    private ProviderProductFashionRepos providerProductFashionRepos;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @MotanReferer
    ProductFashionApi productFashionApi;
    @MotanReferer
    ProductCategoryApi productCategoryApi;
    @Autowired
    private MapperFacade mapperFacade;
    static final String SORT_FRONTPRICE = "frontPrice";
    static final String SORT_SALEPRICE = "salePrice";
    static final String SORT_COSTPRICE = "costPrice";
    static final String SORT_AGREEMENTDISCOUNTRATE = "agreementDiscountRate";
    static final String SORT_REALTIMEDISCOUNTRATE = "realTimeDiscountRate";
    static final String SORT_RATEMODERATE = "rateModeRate";
    static final String ISUP_NOT_SHELF = "0";
    static final String ISUP_ALREADY_SHELF = "1";
    static final String PREFERENCE_NO = "0";
    static final String PREFERENCE_YES = "1";

    public BaseResponse<PageVo<GoodsUpperAndLowerDto>> findGoodsUpperAndLowers(GoodsUpperAndLowerQueryDto goodsUpperAndLowerQueryDto, int number, int size) {
        long millis = System.currentTimeMillis();
        PageVo pageVo = null;
        Map sqlListMap = this.findGoodsUpperAndLowersSql(goodsUpperAndLowerQueryDto);
        try {
            pageVo = this.jdbcTemplatePage.query(String.valueOf(sqlListMap.get("sql")), GoodsUpperAndLowerDto.class, Integer.valueOf(number), Integer.valueOf(size), (Map)sqlListMap.get("params"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new BaseResponse(false, "\u5546\u54c1\u5217\u8868\u5206\u9875\u67e5\u8be2\u5931\u8d25", pageVo);
        }
        logger.info("jdbcTemplatePage\u67e5\u8be2\u5217\u8868\u6570\u636e\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - millis));
        return new BaseResponse(true, "\u5546\u54c1\u5217\u8868\u5206\u9875\u67e5\u8be2\u6210\u529f", (Object)pageVo);
    }

    public Map<String, Object> findGoodsUpperAndLowersSql(GoodsUpperAndLowerQueryDto goodsUpperAndLowerQueryDto) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuffer sql = new StringBuffer();
        String orgCodeStr = "";
        if (!Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getOrgCode()) && !"all".equals(goodsUpperAndLowerQueryDto.getOrgCode().trim())) {
            orgCodeStr = " and gc.organization_code = :orgcode ";
            params.put("orgcode", goodsUpperAndLowerQueryDto.getOrgCode().trim());
        }
        sql.append(" select  rownum as gIndex, g.* from ").append("    (").append("        SELECT").append("            ppf.category_name AS categoryname,").append("            ppf.provider_name AS providername,").append("            ppf.sku AS sku,").append("            ppf.name AS name,").append("            ppf.brand_name AS brandname,").append("            ppf.market_price AS originalPrice,").append("            ppf.cost_price AS costprice,").append("            gcc.price AS saleprice,").append("            ppf.agreement_discount_rate AS agreementdiscountrate,").append("            ppf.real_time_discount_rate AS realtimediscountrate,").append("            ppf.rate_mode_rate AS ratemoderate,").append("            gcc.is_up AS isup,").append("            gcc.is_preferred AS ispreferred,").append("            ppf.store_id AS storeid,").append("            ppf.category_id as categoryid,").append("            ppf.brand_id as brandid,").append("            gcc.organization_code AS organizationcode ").append("        FROM").append("            provider_product_fashion ppf,").append("           ( select gc.price, gc.is_up, gc.is_preferred, gc.sku, gc.user_id, gc.organization_code ").append("            from  goods_config gc where  gc.is_delete = 0 ").append(orgCodeStr).append("            ) gcc").append("        WHERE").append("                ppf.sku = gcc.sku (+)").append("            AND").append("                ppf.store_id = gcc.user_id (+)").append("            AND").append("                ppf.provider_sale_status = '1'").append("            AND").append("                ppf.is_delete = 0").append("    ) g ").append(" WHERE 1=1 ");
        if (!Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getIsUp()) && !"all".equals(goodsUpperAndLowerQueryDto.getIsUp().trim())) {
            if ("0".equals(goodsUpperAndLowerQueryDto.getIsUp())) {
                sql.append("  and (g.isup = :isup or g.isup is null)");
            }
            if ("1".equals(goodsUpperAndLowerQueryDto.getIsUp())) {
                sql.append("  and (g.isup = :isup )");
            }
            params.put("isup", goodsUpperAndLowerQueryDto.getIsUp());
        }
        if (!Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getIsPreferred()) && !"all".equals(goodsUpperAndLowerQueryDto.getIsPreferred().trim())) {
            if ("0".equals(goodsUpperAndLowerQueryDto.getIsPreferred())) {
                sql.append("  and (g.ispreferred = :ispreferred or g.ispreferred is null)");
            }
            if ("1".equals(goodsUpperAndLowerQueryDto.getIsPreferred())) {
                sql.append("  and g.ispreferred = :ispreferred ");
            }
            params.put("ispreferred", goodsUpperAndLowerQueryDto.getIsPreferred());
        }
        if (!Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getStartSalePrice()) && Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getEndSalePrice())) {
            sql.append("  and g.saleprice >= :saleprice ");
            params.put("saleprice", goodsUpperAndLowerQueryDto.getStartSalePrice());
        } else if (Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getStartSalePrice()) && !Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getEndSalePrice())) {
            sql.append("  and g.saleprice <= :saleprice ");
            params.put("saleprice", goodsUpperAndLowerQueryDto.getEndSalePrice());
        } else if (!Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getStartSalePrice()) && !Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getEndSalePrice())) {
            sql.append("  and g.saleprice >= :startsaleprice  and g.saleprice <= :endsaleprice ");
            params.put("startsaleprice", goodsUpperAndLowerQueryDto.getStartSalePrice());
            params.put("endsaleprice", goodsUpperAndLowerQueryDto.getEndSalePrice());
        }
        if (!Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getProductCategoryId())) {
            List threeCategoryId = this.productCategoryApi.findThreeCategoryByCategoryId(goodsUpperAndLowerQueryDto.getProductCategoryId());
            sql.append(" and g.categoryid  in (:categoryid) ");
            params.put("categoryid", threeCategoryId);
        }
        if (!Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getSku())) {
            sql.append(" and g.sku = :sku ");
            params.put("sku", goodsUpperAndLowerQueryDto.getSku());
        }
        if (!Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getStoreId()) && !"all".equals(goodsUpperAndLowerQueryDto.getStoreId().trim())) {
            sql.append(" and g.storeid = :storeid ");
            params.put("storeid", goodsUpperAndLowerQueryDto.getStoreId());
        }
        if (!Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getName())) {
            sql.append(" and g.name like (:name) ");
            params.put("name", "%" + goodsUpperAndLowerQueryDto.getName() + "%");
        }
        if (!Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getBrandIds())) {
            String[] brandArry;
            ArrayList<String> list = new ArrayList<String>();
            for (String brand : brandArry = goodsUpperAndLowerQueryDto.getBrandIds().split(",")) {
                list.add(brand);
            }
            sql.append(" and g.brandid in (:brandid) ");
            params.put("brandid", list);
        }
        if (!Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getStartCostPrice()) && Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getEndCostPrice())) {
            sql.append("  and g.costprice >= :costprice ");
            params.put("costprice", goodsUpperAndLowerQueryDto.getStartCostPrice());
        } else if (Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getStartCostPrice()) && !Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getEndCostPrice())) {
            sql.append("  and g.costprice <= :costprice ");
            params.put("costprice", goodsUpperAndLowerQueryDto.getEndCostPrice());
        } else if (!Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getStartCostPrice()) && !Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getEndCostPrice())) {
            sql.append("  and g.costprice >= :startcostprice  and g.costprice <= :endcostprice ");
            params.put("startcostprice", goodsUpperAndLowerQueryDto.getStartCostPrice());
            params.put("endcostprice", goodsUpperAndLowerQueryDto.getEndCostPrice());
        }
        if (!Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getStartRateModeRate()) && Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getEndRateModeRate())) {
            sql.append("  and g.ratemoderate >= :ratemoderate ");
            params.put("ratemoderate", goodsUpperAndLowerQueryDto.getStartRateModeRate());
        } else if (Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getStartRateModeRate()) && !Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getEndRateModeRate())) {
            sql.append("  and g.ratemoderate <= :ratemoderate ");
            params.put("ratemoderate", goodsUpperAndLowerQueryDto.getEndRateModeRate());
        } else if (!Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getStartRateModeRate()) && !Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getEndRateModeRate())) {
            sql.append("  and g.ratemoderate >= :startratemoderate  and g.ratemoderate <= :endratemoderate ");
            params.put("startratemoderate", goodsUpperAndLowerQueryDto.getStartRateModeRate());
            params.put("endratemoderate", goodsUpperAndLowerQueryDto.getEndRateModeRate());
        }
        if (!Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getStartAgreementDiscountRate()) && Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getEndAgreementDiscountRate())) {
            sql.append("  and g.agreementdiscountrate >= :agreementdiscountrate ");
            params.put("agreementdiscountrate", goodsUpperAndLowerQueryDto.getStartAgreementDiscountRate());
        } else if (Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getStartAgreementDiscountRate()) && !Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getEndAgreementDiscountRate())) {
            sql.append("  and g.agreementdiscountrate <= :agreementdiscountrate ");
            params.put("agreementdiscountrate", goodsUpperAndLowerQueryDto.getEndAgreementDiscountRate());
        } else if (!Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getStartAgreementDiscountRate()) && !Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getEndAgreementDiscountRate())) {
            sql.append("  and g.agreementdiscountrate >= :startagreementdiscountrate  and g.agreementdiscountrate <= :endagreementdiscountrate ");
            params.put("startagreementdiscountrate", goodsUpperAndLowerQueryDto.getStartAgreementDiscountRate());
            params.put("endagreementdiscountrate", goodsUpperAndLowerQueryDto.getEndAgreementDiscountRate());
        }
        if (!Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getStartRealTimeDiscountRate()) && Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getEndRealTimeDiscountRate())) {
            sql.append("  and  g.realtimediscountrate >= :realtimediscountrate ");
            params.put("realtimediscountrate", goodsUpperAndLowerQueryDto.getStartRealTimeDiscountRate());
        } else if (Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getStartRealTimeDiscountRate()) && !Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getEndRealTimeDiscountRate())) {
            sql.append("  and  g.realtimediscountrate <= :realtimediscountrate ");
            params.put("realtimediscountrate", goodsUpperAndLowerQueryDto.getEndRealTimeDiscountRate());
        } else if (!Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getStartRealTimeDiscountRate()) && !Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getEndRealTimeDiscountRate())) {
            sql.append("  and  g.realtimediscountrate >= :startrealtimediscountrate  and  g.realtimediscountrate <= :endrealtimediscountrate ");
            params.put("startrealtimediscountrate", goodsUpperAndLowerQueryDto.getStartRealTimeDiscountRate());
            params.put("endrealtimediscountrate", goodsUpperAndLowerQueryDto.getEndRealTimeDiscountRate());
        }
        log.info("\u5546\u54c1\u4e0a\u4e0b\u67b6\u9875\u9762\u5217\u8868\u67e5\u8be2sql===\u300b\uff1a{}", (Object)sql.toString());
        HashedMap map = new HashedMap();
        map.put("sql", sql.toString());
        map.put("params", params);
        return map;
    }

    public BaseResponse<List<GoodsUpperAndLowerDto>> findGoodsUpperAndLowersByQuery(GoodsUpperAndLowerQueryDto goodsUpperAndLowerQueryDto) {
        List goodsUpperAndLowerDtos = null;
        Map sqlListMap = this.findGoodsUpperAndLowersSql(goodsUpperAndLowerQueryDto);
        try {
            NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.jdbcTemplate.getDataSource());
            goodsUpperAndLowerDtos = namedParameterJdbcTemplate.query(String.valueOf(sqlListMap.get("sql")), (Map)sqlListMap.get("params"), (RowMapper)new BeanPropertyRowMapper(GoodsUpperAndLowerDto.class));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u5546\u54c1\u5217\u8868\u67e5\u8be2\u5931\u8d25 {}", (Throwable)e);
            return new BaseResponse(false, "\u5546\u54c1\u5217\u8868\u67e5\u8be2\u5931\u8d25", goodsUpperAndLowerDtos);
        }
        return new BaseResponse(true, "\u5546\u54c1\u5217\u8868\u67e5\u8be2\u6210\u529f", (Object)goodsUpperAndLowerDtos);
    }

    public BaseResponse<Integer> findCountByGoodsUpperAndLowersByQuery(GoodsUpperAndLowerQueryDto goodsUpperAndLowerQueryDto) {
        Integer count = null;
        Map sqlListMap = this.findGoodsUpperAndLowersSql(goodsUpperAndLowerQueryDto);
        try {
            String sqlCount = "select count(*) from (" + sqlListMap.get("sql") + ")  ";
            NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.jdbcTemplate.getDataSource());
            count = (Integer)namedParameterJdbcTemplate.queryForObject(sqlCount, (Map)sqlListMap.get("params"), Integer.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u5546\u54c1\u5217\u8868\u67e5\u8be2\u5931\u8d25 {}", (Throwable)e);
            return new BaseResponse(false, "\u5546\u54c1\u5217\u8868\u67e5\u8be2\u5931\u8d25", count);
        }
        return new BaseResponse(true, "\u5546\u54c1\u5217\u8868\u67e5\u8be2\u6210\u529f", (Object)count);
    }

    @Transactional
    public ProviderGoodsDto getGoodsDetailInfo(String sku, String storeId) {
        ProviderProductFashion providerProductFashion = this.providerProductFashionRepos.findOneBySkuAndStoreId(sku, storeId);
        return (ProviderGoodsDto)this.mapperFacade.map((Object)providerProductFashion, ProviderGoodsDto.class);
    }

    public BaseResponse editGoodsInfoCompletion(String sku, String storeId, String individuaDescription) {
        ProviderProductFashion providerProductFashion1 = null;
        try {
            ProviderProductFashion providerProductFashion = this.providerProductFashionRepos.findOneBySkuAndStoreId(sku, storeId);
            providerProductFashion.setIndividuaDescription(individuaDescription);
            providerProductFashion1 = (ProviderProductFashion)this.providerProductFashionRepos.save((Object)providerProductFashion);
            this.productFashionApi.updateIndividuaDescriptionBySkuAndStoreId(sku, storeId, individuaDescription);
            logger.info("\u5546\u54c1\u4fe1\u606f\u8865\u5168\u6210\u529f,sku{},\u5546\u54c1\u4e2a\u6027\u5316\u4fe1\u606f{}", (Object)providerProductFashion1.getSku(), (Object)providerProductFashion1.getIndividuaDescription());
            return new BaseResponse(true, "\u5546\u54c1\u4fe1\u606f\u8865\u5168\u6210\u529f", (Object)providerProductFashion1.getSku());
        }
        catch (Exception e) {
            e.printStackTrace();
            return new BaseResponse(false, "\u5546\u54c1\u4fe1\u606f\u8865\u5168\u5931\u8d25", (Object)providerProductFashion1.getSku());
        }
    }
}

