/*
 * Decompiled with CFR 0.152.
 */
package pool.service.service.ServiceImpl;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.GoodsApi;
import goods.api.GoodsConfigApi;
import goods.api.ProductApi;
import goods.vo.query.GoodsConfigQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pool.dto.GoodsUpperLowerDto;
import pool.dto.ProviderProductFashionDto;
import pool.model.repository.ProviderProductFashionRepos;
import pool.service.service.GoodsAutosyncFilterService;
import pool.service.service.ProductModelService;
import pool.service.service.ProviderProductFashionService;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;

@Service
public class PreferenceAndUpperShelvesImpl {
    private static final Logger log = LoggerFactory.getLogger(PreferenceAndUpperShelvesImpl.class);
    static final Integer GOODS_STATE_UP = 1;
    static final Integer GOODS_STATE_LOW = 0;
    @MotanReferer
    GoodsConfigApi goodsConfigApi;
    @Autowired
    ProductModelService productModelService;
    @Autowired
    GoodsAutosyncFilterService goodsAutosyncFilterService;
    @Autowired
    ProviderProductFashionRepos providerProductFashionRepos;
    @MotanReferer
    ProductApi productApi;
    @MotanReferer
    GoodsApi goodsApi;
    @Autowired
    ProviderProductFashionService providerProductFashionService;

    @Transactional
    public BaseResponse<List<String>> preferredImpl(List<GoodsUpperLowerDto> goodsUpperLowerDtos, boolean isPreferred, String organizationCode) {
        ArrayList returnSku = new ArrayList();
        ArrayList errSku = new ArrayList();
        try {
            goodsUpperLowerDtos.forEach(goodsUpperLowerDto -> {
                GoodsConfigQuery goodsConfigQuery = new GoodsConfigQuery();
                String sku = goodsUpperLowerDto.getSku();
                String storeId = goodsUpperLowerDto.getStoreId();
                goodsConfigQuery.setOrganizationCode(organizationCode);
                goodsConfigQuery.setStoreId(storeId);
                goodsConfigQuery.setSkus(Arrays.asList(sku));
                List configList = this.goodsConfigApi.findGoodsConfig(goodsConfigQuery);
                configList.forEach(goodsConfig -> {
                    try {
                        if (Lang.isEmpty((Object)goodsConfig.getIsPreferred()) || isPreferred != goodsConfig.getIsPreferred()) {
                            goodsConfig.setIsPreferred(Boolean.valueOf(isPreferred));
                            this.goodsConfigApi.save(goodsConfig);
                            returnSku.add(goodsConfig.getSku());
                        }
                    }
                    catch (Exception e) {
                        errSku.add(goodsConfig.getSku());
                        log.error("-\u8bbe\u7f6e\u4f18\u9009\u5931\u8d25", (Throwable)e);
                    }
                });
            });
        }
        catch (Exception e) {
            log.error("---\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
            goodsUpperLowerDtos.forEach(goodsUpperLowerDto -> errSku.add(goodsUpperLowerDto.getSku()));
            return new BaseResponse(false, "\u64cd\u4f5c\u5931\u8d25", errSku);
        }
        if (Lang.isEmpty(returnSku)) {
            log.info("---\u8bbe\u7f6e\u4f18\u9009\u5931\u8d25,\u6ca1\u6709\u64cd\u4f5c\u6210\u529f\u6570\u636e,\u5931\u8d25\u7684sku:{}", (Object)((Object)errSku).toString());
            return new BaseResponse(false, "\u8bbe\u7f6e\u4f18\u9009\u5931\u8d25,\u6ca1\u6709\u64cd\u4f5c\u6210\u529f\u6570\u636e", errSku);
        }
        if (Lang.isEmpty(errSku)) {
            log.info("---\u8bbe\u7f6e\u4f18\u9009\u5168\u90e8\u64cd\u4f5c\u6210\u529f");
            return new BaseResponse(true, "\u8bbe\u7f6e\u4f18\u9009\u5168\u90e8\u64cd\u4f5c\u6210\u529f");
        }
        log.info("---\u64cd\u4f5c\u6210\u529f,\u5931\u8d25\u7684sku:{}", (Object)((Object)errSku).toString());
        return new BaseResponse(true, "\u8bbe\u7f6e\u4f18\u9009\u6210\u529f", errSku);
    }

    public BaseResponse<List<String>> goodsUpOrNot(List<GoodsUpperLowerDto> goodsUpperLowerDtos, boolean isUp, String organizationCode) {
        ArrayList successSku = new ArrayList();
        ArrayList errorSku = new ArrayList();
        HashMap skuMap = new HashMap();
        goodsUpperLowerDtos.forEach(goodsUpperLowerDto -> {
            String storeId = goodsUpperLowerDto.getStoreId();
            String sku = goodsUpperLowerDto.getSku();
            if (!Lang.isEmpty(skuMap.get(storeId))) {
                ((List)skuMap.get(storeId)).add(sku);
            } else {
                ArrayList<String> skus = new ArrayList<String>();
                skus.add(sku);
                skuMap.put(storeId, skus);
            }
        });
        Set storeIds = skuMap.keySet();
        try {
            storeIds.forEach(storeId -> {
                if (!isUp) {
                    try {
                        this.goodsConfigApi.artificialDownMallOrganizationGoods((List)skuMap.get(storeId), storeId, organizationCode);
                        successSku.add(true);
                    }
                    catch (Exception e) {
                        ((List)skuMap.get(storeId)).forEach(sku -> errorSku.add(sku));
                        log.error("-\u4e0b\u67b6\u5931\u8d25", (Throwable)e);
                    }
                } else {
                    ArrayList upSku = new ArrayList();
                    ((List)skuMap.get(storeId)).forEach(sku -> {
                        try {
                            long a2 = System.currentTimeMillis();
                            boolean ifCateUp = this.productModelService.isSynCateAndBrand(sku, storeId, organizationCode);
                            log.info("\u5224\u65ad sku:{} \u662f\u5426\u7b26\u5408\u4e0a\u67b6\u89c4\u5219\u8017\u65f6 {} ms", sku, (Object)(System.currentTimeMillis() - a2));
                            if (ifCateUp) {
                                long a3 = System.currentTimeMillis();
                                ProviderProductFashionDto providerProductFashionDto = this.providerProductFashionService.findBySkuAndStoreId(sku, storeId, false);
                                BaseResponse response = this.productApi.syncProduct(providerProductFashionDto);
                                log.info("sku:{} \u4fe1\u606f\u540c\u6b65\u8017\u65f6 {} ms", sku, (Object)(System.currentTimeMillis() - a3));
                                long a4 = System.currentTimeMillis();
                                if (response.isSuccess()) {
                                    String skuSyn = response.getResultCode();
                                    upSku.add(skuSyn);
                                } else {
                                    String resultCode = response.getResultCode();
                                    errorSku.add(resultCode);
                                    log.info("sku:{} \u4fe1\u606f\u540c\u6b65\u5931\u8d25", sku);
                                }
                                log.info("a4 {} ", (Object)(System.currentTimeMillis() - a4));
                            } else {
                                errorSku.add(sku);
                                log.info("sku:{} \u4e0d\u7b26\u5408\u4e0a\u67b6\u89c4\u5219", sku);
                            }
                        }
                        catch (Exception e) {
                            errorSku.add(sku);
                            log.info("sku:{} \u4e0a\u67b6\u5f02\u5e38", sku, (Object)e);
                        }
                    });
                    try {
                        if (!Lang.isEmpty(upSku)) {
                            long a5 = System.currentTimeMillis();
                            log.info("sku:{} \u5f00\u59cb\u4e0a\u67b6", (Object)((Object)upSku).toString());
                            this.goodsConfigApi.artificialPutWayMallOrganizationGoods(upSku, storeId, organizationCode);
                            successSku.add(true);
                            log.info("sku:{} \u4e0a\u67b6\u8017\u65f6 {} ms", (Object)((Object)upSku).toString(), (Object)(System.currentTimeMillis() - a5));
                        }
                    }
                    catch (Exception e) {
                        errorSku.addAll(upSku);
                        log.error("sku:{} \u6267\u884c\u4e0a\u67b6\u64cd\u4f5c\u5931\u8d25", (Object)((Object)upSku).toString(), (Object)e);
                    }
                }
            });
        }
        catch (Exception e) {
            log.error("---\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
            goodsUpperLowerDtos.forEach(goodsUpperLowerDto -> errorSku.add(goodsUpperLowerDto.getSku()));
            return new BaseResponse(false, "\u64cd\u4f5c\u5931\u8d25", errorSku);
        }
        if (Lang.isEmpty(successSku)) {
            log.info("---\u5546\u54c1\u4e0a\u4e0b\u67b6\u5931\u8d25,\u6ca1\u6709\u64cd\u4f5c\u6210\u529f\u6570\u636e,\u5931\u8d25\u7684sku:{}", (Object)((Object)errorSku).toString());
            return new BaseResponse(false, "\u5546\u54c1\u4e0a\u4e0b\u67b6\u5931\u8d25,\u6ca1\u6709\u64cd\u4f5c\u6210\u529f\u6570\u636e", errorSku);
        }
        if (Lang.isEmpty(errorSku)) {
            log.info("---\u5546\u54c1\u4e0a\u4e0b\u67b6\u5168\u90e8\u6210\u529f");
            return new BaseResponse(true, "\u5546\u54c1\u4e0a\u4e0b\u67b6\u5168\u90e8\u6210\u529f");
        }
        log.info("---\u5546\u54c1\u4e0a\u4e0b\u67b6\u6210\u529f,\u5931\u8d25\u7684sku:{}", (Object)((Object)errorSku).toString());
        return new BaseResponse(true, "\u5546\u54c1\u4e0a\u4e0b\u67b6\u6210\u529f", errorSku);
    }
}

