/*
 * Decompiled with CFR 0.152.
 */
package pool.service.service.ServiceImpl;

import cms.api.OrganizationApi;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.ProductBrandApi;
import goods.api.ProductCategoryApi;
import goods.api.ProductCategoryconfigApi;
import java.util.ArrayList;
import java.util.List;
import ma.glasnost.orika.MapperFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pool.commonUtil.MessageDictionary;
import pool.dto.ProductModelDto;
import pool.dto.ProductModelQueryDto;
import pool.dto.brand.brandmapper.BrandMapperDto;
import pool.model.ProviderProduct;
import pool.model.ProviderProductFashion;
import pool.model.repository.ProviderProductBrandRepos;
import pool.model.repository.ProviderProductCategoryRepos;
import pool.model.repository.ProviderProductFashionRepos;
import pool.model.repository.ProviderProductRepos;
import pool.service.service.BrandService;
import pool.service.service.ProductModelService;
import pool.service.service.ServiceImpl.ProductModelServiceImpl;
import pool.vo.BrandVo;
import pool.vo.ProductModelPageVo;
import pool.vo.ProductModelVo;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;
import utils.sql.PageVo;

@Service
public class ProductModelServiceImpl
implements ProductModelService {
    private static final Logger log = LoggerFactory.getLogger(ProductModelServiceImpl.class);
    @Autowired
    private ProviderProductRepos providerProductRepos;
    @Autowired
    private MapperFacade mapperFacade;
    @Autowired
    private BrandService brandService;
    @Autowired
    ProviderProductCategoryRepos providerProductCategoryRepos;
    @Autowired
    ProviderProductBrandRepos providerProductBrandRepos;
    @MotanReferer
    ProductCategoryApi productCategoryApi;
    @MotanReferer
    ProductBrandApi productBrandApi;
    @Autowired
    ProviderProductFashionRepos providerProductFashionRepos;
    @MotanReferer
    ProductCategoryconfigApi ProductCategoryconfigApi;
    @MotanReferer
    OrganizationApi organizationApi;

    public BaseResponse<PageVo<ProductModelVo>> queryModels(ProductModelQueryDto productModelQueryDto) {
        BaseResponse baseResponse = new BaseResponse();
        try {
            if (!Lang.isEmpty((Object)productModelQueryDto) && Lang.isEmpty((Object)productModelQueryDto.getPageNo())) {
                productModelQueryDto.setPageNo(MessageDictionary.DEFAULT_PAGENO);
            }
            if (!Lang.isEmpty((Object)productModelQueryDto) && Lang.isEmpty((Object)productModelQueryDto.getPageSize())) {
                productModelQueryDto.setPageSize(MessageDictionary.DEFAULT_PAGESIZE);
            }
            if (Lang.isEmpty((Object)productModelQueryDto)) {
                productModelQueryDto = new ProductModelQueryDto();
                productModelQueryDto.setPageNo(MessageDictionary.DEFAULT_PAGENO);
                productModelQueryDto.setPageSize(MessageDictionary.DEFAULT_PAGESIZE);
            }
            int pageSize = productModelQueryDto.getPageSize();
            int realPageNo = productModelQueryDto.getPageNo() - 1 > 0 ? productModelQueryDto.getPageNo() - 1 : 0;
            PageRequest pageable = new PageRequest(realPageNo, pageSize);
            ProviderProduct finalProviderProduct = (ProviderProduct)this.mapperFacade.map((Object)productModelQueryDto, ProviderProduct.class);
            1 specification = new /* Unavailable Anonymous Inner Class!! */;
            Page page = this.providerProductRepos.findAll((Specification)specification, (Pageable)pageable);
            List providerProductList = page.getContent();
            ArrayList<ProductModelVo> productModelVos = new ArrayList<ProductModelVo>();
            for (ProviderProduct item : providerProductList) {
                ProductModelVo productModelVo = new ProductModelVo();
                productModelVo.setModelId(item.getModelId());
                productModelVo.setName(item.getName());
                productModelVo.setModelSku(item.getModelSku());
                productModelVos.add(productModelVo);
            }
            ProductModelPageVo productModelPageVo = new ProductModelPageVo(productModelVos, Integer.valueOf(page.getNumber() + 1), Integer.valueOf(page.getSize()), Long.valueOf(page.getTotalElements()));
            baseResponse.setResult((Object)productModelPageVo);
            baseResponse.setResultCode("0000");
            baseResponse.setResultMessage("\u64cd\u4f5c\u6210\u529f");
            baseResponse.setSuccess(true);
        }
        catch (Exception e) {
            baseResponse = new BaseResponse(false, "\u5185\u90e8\u9519\u8bef", (Object)"", "110013");
            e.printStackTrace();
        }
        return baseResponse;
    }

    @Transactional
    public BaseResponse saveModel(ProductModelDto productModelDto) {
        BaseResponse baseResponse = new BaseResponse();
        try {
            if (Lang.isEmpty((Object)productModelDto)) {
                return new BaseResponse(false, "\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a", (Object)"", "3001");
            }
            if (!Lang.isEmpty((Object)productModelDto) && Lang.isEmpty((Object)productModelDto.getName())) {
                return new BaseResponse(false, "\u8bf7\u6c42\u53c2\u6570name\u4e0d\u80fd\u4e3a\u7a7a", (Object)"", "3001");
            }
            if (!Lang.isEmpty((Object)productModelDto) && Lang.isEmpty((Object)productModelDto.getModelSku())) {
                return new BaseResponse(false, "\u8bf7\u6c42\u53c2\u6570modelSku\u4e0d\u80fd\u4e3a\u7a7a", (Object)"", "3001");
            }
            if (!Lang.isEmpty((Object)productModelDto) && Lang.isEmpty((Object)productModelDto.getCategoryId())) {
                return new BaseResponse(false, "\u8bf7\u6c42\u53c2\u6570categoryId\u4e0d\u80fd\u4e3a\u7a7a", (Object)"", "3001");
            }
            if (!Lang.isEmpty((Object)productModelDto) && Lang.isEmpty((Object)productModelDto.getBrandId())) {
                return new BaseResponse(false, "\u8bf7\u6c42\u53c2\u6570brandId\u4e0d\u80fd\u4e3a\u7a7a", (Object)"", "3001");
            }
            ProviderProduct providerProduct = (ProviderProduct)this.mapperFacade.map((Object)productModelDto, ProviderProduct.class);
            ProviderProduct providerProduct2 = this.providerProductRepos.findOneByModelSkuAndStoreId(providerProduct.getModelSku(), providerProduct.getStoreId());
            if (!Lang.isEmpty((Object)providerProduct2)) {
                return new BaseResponse(false, "\u5546\u54c1\u6a21\u578b\u5df2\u7ecf\u5b58\u5728", (Object)"", "3005");
            }
            String providerProductBrandId = providerProduct.getBrandId();
            BrandMapperDto brandMapperDto = this.brandService.queryBrand(providerProductBrandId);
            if (Lang.isEmpty((Object)brandMapperDto)) {
                return new BaseResponse(false, "\u54c1\u724c\u4e0d\u5b58\u5728", (Object)"", "3003");
            }
            providerProduct.setProductBrandId(brandMapperDto.getProductBrandId());
            providerProduct = (ProviderProduct)this.providerProductRepos.saveAndFlush((Object)providerProduct);
            ProductModelVo productModelVo = new ProductModelVo();
            productModelVo.setModelSku(providerProduct.getModelSku());
            productModelVo.setName(providerProduct.getName());
            productModelVo.setModelId(providerProduct.getModelId());
            baseResponse.setResult((Object)productModelVo);
            baseResponse.setResultCode("0000");
            baseResponse.setSuccess(true);
            baseResponse.setResultMessage("\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            baseResponse = new BaseResponse(false, "\u5185\u90e8\u9519\u8bef", (Object)"", "110013");
        }
        return baseResponse;
    }

    @Transactional
    public BaseResponse updateModel(ProductModelDto productModelDto) {
        BaseResponse baseResponse = null;
        try {
            if (Lang.isEmpty((Object)productModelDto)) {
                return new BaseResponse(false, "\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a", (Object)"", "3001");
            }
            if (!Lang.isEmpty((Object)productModelDto) && Lang.isEmpty((Object)productModelDto.getName())) {
                return new BaseResponse(false, "\u8bf7\u6c42\u53c2\u6570name\u4e0d\u80fd\u4e3a\u7a7a", (Object)"", "3001");
            }
            if (!Lang.isEmpty((Object)productModelDto) && Lang.isEmpty((Object)productModelDto.getModelSku())) {
                return new BaseResponse(false, "\u8bf7\u6c42\u53c2\u6570modelSku\u4e0d\u80fd\u4e3a\u7a7a", (Object)"", "3001");
            }
            if (!Lang.isEmpty((Object)productModelDto) && Lang.isEmpty((Object)productModelDto.getCategoryId())) {
                return new BaseResponse(false, "\u8bf7\u6c42\u53c2\u6570categoryId\u4e0d\u80fd\u4e3a\u7a7a", (Object)"", "3001");
            }
            if (!Lang.isEmpty((Object)productModelDto) && Lang.isEmpty((Object)productModelDto.getBrandId())) {
                return new BaseResponse(false, "\u8bf7\u6c42\u53c2\u6570brandId\u4e0d\u80fd\u4e3a\u7a7a", (Object)"", "3001");
            }
            baseResponse = new BaseResponse();
            ProviderProduct providerProduct = this.providerProductRepos.findOneByModelSkuAndStoreId(productModelDto.getModelSku(), productModelDto.getStoreId());
            if (Lang.isEmpty((Object)providerProduct)) {
                return new BaseResponse(false, "\u5546\u54c1\u6a21\u578b\u4e0d\u5b58\u5728", (Object)"", "3003");
            }
            String providerProductBrandId = providerProduct.getBrandId();
            BrandMapperDto brandMapperDto = this.brandService.queryBrand(providerProductBrandId);
            if (!Lang.isEmpty((Object)brandMapperDto)) {
                providerProduct.setProductBrandId(brandMapperDto.getProductBrandId());
            }
            providerProduct.setName(productModelDto.getName());
            providerProduct.setModelSku(productModelDto.getModelSku());
            providerProduct.setCategoryId(productModelDto.getCategoryId());
            providerProduct.setBrandId(productModelDto.getBrandId());
            providerProduct.setProductBrandId(productModelDto.getBrandId());
            providerProduct = (ProviderProduct)this.providerProductRepos.save((Object)providerProduct);
            ProductModelVo productModelVo = (ProductModelVo)this.mapperFacade.map((Object)providerProduct, ProductModelVo.class);
            baseResponse.setResult((Object)productModelVo);
            baseResponse.setResultCode("0000");
            baseResponse.setSuccess(true);
            baseResponse.setResultMessage("\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            baseResponse = new BaseResponse(false, "\u5185\u90e8\u9519\u8bef", (Object)"", "110013");
        }
        return baseResponse;
    }

    public BaseResponse<String> deleteModel(String modelSku, String storeId) {
        BaseResponse baseResponse = new BaseResponse();
        try {
            if (Lang.isEmpty((Object)modelSku)) {
                return new BaseResponse(false, "\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a", (Object)"", "3001");
            }
            ProviderProduct providerProduct = this.providerProductRepos.findOneByModelSkuAndStoreId(modelSku, storeId);
            if (Lang.isEmpty((Object)providerProduct)) {
                baseResponse.setResultCode("3003");
                baseResponse.setResultMessage("\u5546\u54c1\u6a21\u578b\u4e0d\u5b58\u5728");
                baseResponse.setSuccess(false);
                return baseResponse;
            }
            if (!Lang.isEmpty((Object)providerProduct) && providerProduct.getIsDelete().booleanValue()) {
                baseResponse.setResultCode("3004");
                baseResponse.setResultMessage("\u5546\u54c1\u6a21\u578b\u5df2\u5220\u9664");
                baseResponse.setSuccess(false);
                return baseResponse;
            }
            providerProduct.setIsDelete(Boolean.valueOf(true));
            this.providerProductRepos.save((Object)providerProduct);
            baseResponse.setSuccess(true);
            baseResponse.setResultMessage("\u64cd\u4f5c\u6210\u529f");
            baseResponse.setResultCode("0000");
            baseResponse.setResult((Object)"");
        }
        catch (Exception e) {
            e.printStackTrace();
            baseResponse = new BaseResponse(false, "\u5185\u90e8\u9519\u8bef", (Object)"", "110013");
        }
        return baseResponse;
    }

    @Transactional
    public List<ProductModelDto> findByBrandIdAndIsDelete(String providerProductBrandId, Boolean isDelete) {
        List providerProductList = this.providerProductRepos.findAll((Specification)new /* Unavailable Anonymous Inner Class!! */);
        List productModelDtoList = this.mapperFacade.mapAsList((Iterable)providerProductList, ProductModelDto.class);
        return productModelDtoList;
    }

    public ProductModelDto findByModelSkuAndStoreId(String modelSku, String storeId) {
        ProviderProduct providerProduct = this.providerProductRepos.findOneByModelSkuAndStoreId(modelSku, storeId);
        ProductModelDto productModelDto = (ProductModelDto)this.mapperFacade.map((Object)providerProduct, ProductModelDto.class);
        return productModelDto;
    }

    public boolean isSynCateAndBrand(String sku, String storeId, String orgCode) {
        ProviderProduct providerProduct;
        String orgId = this.organizationApi.findOrganizationIdByOrgCode(orgCode);
        List providerProductFashionList = this.providerProductFashionRepos.findBySkuAndStoreIdAndIsDelete(sku, storeId, false);
        if (providerProductFashionList != null && providerProductFashionList.size() > 0 && !Lang.isEmpty((Object)(providerProduct = ((ProviderProductFashion)providerProductFashionList.get(0)).getProviderProduct()))) {
            if (Lang.isEmpty((Object)providerProduct.getCategoryId()) || Lang.isEmpty((Object)providerProduct.getProductBrandId())) {
                log.info("========sku:{}\u5206\u7c7b\u54c1\u724c\u672a\u6620\u5c04storeId:{}", (Object)sku, (Object)storeId);
                return false;
            }
            boolean isUp = this.ProductCategoryconfigApi.findIsUpByCategoryIdAndOrgIdAndIsDelete(providerProduct.getCategoryId(), orgId, false);
            log.info("========sku:{}\u6240\u5c5e\u5206\u7c7b\uff1a{}\u5728\u5546\u57ce\uff1a{}\u662f\u5426\u4e0a\u67b6isUp:{}", new Object[]{sku, providerProduct.getCategoryId(), orgCode, isUp});
            return isUp;
        }
        return false;
    }

    @Transactional
    public void updateProviderProductMappingInfo(String providerBrandId, boolean isDelete, BrandVo brandVo) {
        try {
            List providerProducts = this.providerProductRepos.findByBrandIdAndIsDelete(providerBrandId, isDelete);
            for (ProviderProduct providerProduct : providerProducts) {
                providerProduct.setProductBrandId(brandVo.getId());
            }
            this.providerProductRepos.save((Iterable)providerProducts);
        }
        catch (Exception e) {
            log.info("provider product update mapping info failed!");
        }
    }
}

