/*
 * Decompiled with CFR 0.152.
 */
package pool.service.service.ServiceImpl;

import cart.api.OrderMainApi;
import cart.api.dto.order.OrderItemDto;
import cart.api.dto.order.OrderMainDto;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.GoodsProductCatgoryApi;
import goods.api.ProductApi;
import goods.api.ProductBrandApi;
import goods.api.ProductCategoryApi;
import goods.dto.product.ProductBrandDto;
import goods.vo.ProductCategoryVo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import localstore.dto.LocalStoreOrderVo;
import localstore.dto.ProviderGoodsStockVo;
import ma.glasnost.orika.MapperFacade;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import pool.api.ProviderProductFashionManagerApi;
import pool.commonUtil.MessageDictionary;
import pool.dto.BrandDto;
import pool.dto.GoodsUpperAndLowerDto;
import pool.dto.GoodsUpperAndLowerQueryDto;
import pool.dto.ProductModelDto;
import pool.dto.ProductQueryDto;
import pool.dto.ProviderCategoryDto;
import pool.dto.ProviderGoodsDto;
import pool.dto.ProviderGoodsPrice;
import pool.dto.ProviderGoodsStatus;
import pool.dto.ProviderGoodsStock;
import pool.dto.ProviderProductFashionDto;
import pool.dto.enumeration.ProviderProductFashionStatusEnum;
import pool.model.ProviderGoodsSpecification;
import pool.model.ProviderProduct;
import pool.model.ProviderProductBrand;
import pool.model.ProviderProductCategory;
import pool.model.ProviderProductFashion;
import pool.model.ProviderProductFashionPicture;
import pool.model.ProviderProductFashion_;
import pool.model.repository.ProviderGoodsSpecificationRepos;
import pool.model.repository.ProviderProductBrandRepos;
import pool.model.repository.ProviderProductCategoryRepos;
import pool.model.repository.ProviderProductFashionPictureRepos;
import pool.model.repository.ProviderProductFashionRepos;
import pool.model.repository.ProviderProductRepos;
import pool.service.listeners.MqHandleProducer;
import pool.service.service.BrandService;
import pool.service.service.GoodsAutosyncFilterService;
import pool.service.service.OrganizationApiStub;
import pool.service.service.ProductModelService;
import pool.service.service.ProviderGoodsService;
import pool.service.service.ProviderProductFashionService;
import pool.service.service.ProviderProductFashionTransactionService;
import pool.service.service.ServiceImpl.PreferenceAndUpperShelvesImpl;
import pool.service.service.StoreService;
import pool.service.specification.QueryProviderGoodsSpecification;
import pool.utils.SequenceUtil;
import pool.vo.GoodsUpperAndLowerVo;
import pool.vo.ProductReturnVo;
import pool.vo.ProductUpdateResult;
import pool.vo.ProviderGoodsVo;
import pool.vo.UpdateProviderGoodsVo;
import sinomall.global.common.response.BaseResponse;
import store.api.dto.modeldto.core.StoreDto;
import utils.Lang;
import utils.sql.PageVo;

@Service
public class ProviderGoodsServiceImpl
implements ProviderGoodsService {
    private static final Logger log = LoggerFactory.getLogger(ProviderGoodsServiceImpl.class);
    @MotanReferer
    ProviderProductFashionManagerApi providerProductFashionManagerApi;
    @MotanReferer
    GoodsProductCatgoryApi goodsProductCatgoryApi;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private ProviderProductFashionRepos providerProductFashionRepos;
    @Autowired
    private ProviderProductFashionPictureRepos providerProductFashionPictureRepos;
    @Autowired
    private ProviderGoodsSpecificationRepos specificationRepos;
    @Autowired
    private MapperFacade mapperFacade;
    @Autowired
    private MqHandleProducer mqHandleProducer;
    @Autowired
    StoreService storeService;
    @Autowired
    GoodsAutosyncFilterService goodsAutosyncFilterService;
    @Autowired
    PreferenceAndUpperShelvesImpl preferenceAndUpperShelvesImpl;
    @Autowired
    ProviderProductCategoryRepos providerProductCategoryRepos;
    @Autowired
    ProviderProductBrandRepos providerProductBrandRepos;
    @Autowired
    private BrandService brandService;
    @Autowired
    private ProductModelService productModelService;
    @Autowired
    ProviderProductRepos providerProductRepos;
    @MotanReferer
    ProductCategoryApi productCategoryApi;
    @MotanReferer
    ProductBrandApi productBrandApi;
    @Autowired
    ProviderProductFashionService providerProductFashionService;
    @MotanReferer
    ProductApi productApi;
    @Autowired
    OrganizationApiStub organizationApiStub;
    @Autowired
    SequenceUtil sequenceUtil;
    @Autowired
    ProviderProductFashionTransactionService providerProductFashionTransactionService;
    @MotanReferer
    OrderMainApi orderMainApi;
    private static String ALL = "all";
    static final String ISUP_NOT_SHELF = "0";
    static final String ISUP_ALREADY_SHELF = "1";
    static final String PREFERENCE_NO = "0";
    static final String PREFERENCE_YES = "1";
    static final String JICAI = "jicai";
    static final String UNINOGIFT = "uninogift";
    static final int NOT_ON_SALE = 0;
    static final String JDCODE = "jingdong";
    @Autowired
    RedisTemplate redisTemplate;
    private static String ZERO = "0";
    private static String ONE = "1";
    private static String ISPREFERRED = "0";
    private static String DISPREFERRED = "1";
    private static String ISUP = "2";
    private static String DISUP = "3";
    private static String STORE_LOCAL = "7";
    ExecutorService preferExecutorService = new ThreadPoolExecutor(10, 15, 1L, TimeUnit.MINUTES, new LinkedBlockingDeque<Runnable>(20000));

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseResponse saveProviderGoods(ProviderGoodsDto providerGoodsDto) {
        BaseResponse baseResponse = new BaseResponse();
        try {
            List<Integer> invoiceTypeList = Arrays.asList(MessageDictionary.INVOICE_TYPE_ARRAY);
            BaseResponse result = this.validateGoods(providerGoodsDto);
            if (result != null) {
                log.info("-------------saveProviderGoods,\u521b\u5efa\u5546\u54c1\u8fd4\u56de\u8282\u70b91\uff1a(result != null)-------------");
                return result;
            }
            ProviderProductFashion providerProductFashion = (ProviderProductFashion)this.mapperFacade.map((Object)providerGoodsDto, ProviderProductFashion.class);
            ProviderProductFashion ppf = new ProviderProductFashion();
            ppf.setSku(providerProductFashion.getSku());
            ppf.setStoreId(providerProductFashion.getStoreId());
            ppf.setIsDelete(Boolean.valueOf(false));
            boolean goodsExist = this.providerProductFashionRepos.exists(Example.of((Object)ppf));
            if (goodsExist) {
                log.info("-------------saveProviderGoods,\u521b\u5efa\u5546\u54c1\u8fd4\u56de\u8282\u70b92\uff1a(goodsExist)-------------");
                return new BaseResponse(false, "\u5546\u54c1\u5df2\u7ecf\u5b58\u5728", (Object)"", "3005");
            }
            for (Object pic : providerProductFashion.getPics()) {
                pic.setProviderProductFashion(providerProductFashion);
            }
            if (Lang.isEmpty((Object)providerProductFashion.getPostSalePolicy())) {
                providerProductFashion.setPostSalePolicy(Integer.valueOf(1));
            }
            if (Lang.isEmpty((Object)providerProductFashion.getInvoiceType()) || !invoiceTypeList.contains(providerProductFashion.getInvoiceType())) {
                providerProductFashion.setInvoiceType(MessageDictionary.PROVIDER_PRODUCT_INVOICE_TYPE_DEFAULT);
            }
            if (!Lang.isEmpty((Object)providerProductFashion.getProviderGoodsSpecifications())) {
                List specs = providerProductFashion.getProviderGoodsSpecifications();
                for (ProviderGoodsSpecification spec : specs) {
                    spec.setProviderProductFashion(providerProductFashion);
                }
                providerProductFashion.setProviderGoodsSpecifications(specs);
            }
            if (!Lang.isEmpty((Object)providerProductFashion.getModelSku())) {
                ProductBrandDto productBrandDto;
                ProductCategoryVo productCategoryVo;
                ProviderProduct productModel = this.providerProductRepos.findByModelSkuAndStoreIdAndIsDelete(providerProductFashion.getModelSku(), providerProductFashion.getStoreId(), false);
                if (Lang.isEmpty((Object)productModel)) {
                    log.info("-------------saveProviderGoods,\u521b\u5efa\u5546\u54c1\u8fd4\u56de\u8282\u70b93\uff1amodelSku\u9519\u8bef-------------");
                    return new BaseResponse(false, "modelSku\u9519\u8bef", (Object)"", "3001");
                }
                providerProductFashion.setProviderProduct(productModel);
                if (!Lang.isEmpty((Object)productModel.getCategoryId()) && !Lang.isEmpty((Object)(productCategoryVo = this.productCategoryApi.findByIdAndIsDelete(productModel.getCategoryId())))) {
                    providerProductFashion.setCategoryId(productCategoryVo.getId());
                    providerProductFashion.setCategoryName(productCategoryVo.getName());
                }
                if (!Lang.isEmpty((Object)productModel.getProductBrandId()) && !Lang.isEmpty((Object)(productBrandDto = this.productBrandApi.findByIdAndIsDelete(productModel.getProductBrandId(), false)))) {
                    providerProductFashion.setBrandId(productBrandDto.getId());
                    providerProductFashion.setBrandName(productBrandDto.getName());
                }
            } else {
                providerProductFashion = this.savaProductModel(providerProductFashion, providerGoodsDto);
            }
            StoreDto storeDto = this.storeService.getStoreByStoreId(providerGoodsDto.getStoreId());
            providerProductFashion.setProvideName(storeDto.getStoreExt().getStoreName());
            if (STORE_LOCAL.equals(storeDto.getStoreExt().getType())) {
                providerProductFashion.setProviderSaleStatus(Integer.valueOf(Integer.parseInt("0")));
            }
            ProviderProductFashion resultGoods = (ProviderProductFashion)this.providerProductFashionRepos.save((Object)providerProductFashion);
            ProviderGoodsDto resultGoodsDto = (ProviderGoodsDto)this.mapperFacade.map((Object)resultGoods, ProviderGoodsDto.class);
            if (STORE_LOCAL.equals(storeDto.getStoreExt().getType())) {
                log.info("----------------------saveProviderGoods\uff1a\u672c\u5730\u5e97\u94fa\u6570\u636e\u4e0d\u81ea\u52a8\u540c\u6b65-----------------------");
                baseResponse.setResultCode("0000");
                baseResponse.setSuccess(true);
                baseResponse.setResultMessage("\u64cd\u4f5c\u6210\u529f");
                baseResponse.setResult((Object)resultGoodsDto);
                return baseResponse;
            }
            ArrayList<String> skus = new ArrayList<String>();
            skus.add(providerGoodsDto.getSku());
            Map map = this.goodsAutosyncFilterService.autoUpCategoryBrandMappingFilter(skus, providerGoodsDto.getStoreId());
            List upSuccessMsgList = (List)map.get("upSuccessMsgList");
            if (Lang.isEmpty((Object)upSuccessMsgList)) {
                log.info("\u5546\u54c1\u4e0d\u6ee1\u8db3\u81ea\u52a8\u4e0a\u67b6\u89c4\u5219");
            } else {
                List organizationDtos = this.organizationApiStub.findOrganizationAll();
                for (String sku : upSuccessMsgList) {
                    ArrayList<String> upSkuList = new ArrayList<String>();
                    Map rsp = this.goodsAutosyncFilterService.autoUpCategoryOrgUpFilter(sku, providerGoodsDto.getStoreId(), organizationDtos);
                    List orgCodes = (List)rsp.get("organizationList");
                    try {
                        ProviderProductFashionDto providerProductFashionDto;
                        BaseResponse autoBaseResponse;
                        if (Lang.isEmpty((Object)orgCodes) || !(autoBaseResponse = this.productApi.syncProduct(providerProductFashionDto = this.providerProductFashionService.findBySkuAndStoreId(sku, providerGoodsDto.getStoreId(), false))).isSuccess()) continue;
                        ArrayList<String> skuList = new ArrayList<String>();
                        skuList.add(sku);
                        this.providerProductFashionRepos.updateStateBySkuBatch(skuList, Integer.valueOf("1").intValue(), new Date(), providerGoodsDto.getStoreId());
                        upSkuList.add(sku);
                        for (String orgCode : orgCodes) {
                            this.mqHandleProducer.sendSkuUpMessage(upSkuList, providerGoodsDto.getStoreId(), orgCode);
                        }
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                }
            }
            baseResponse.setResultCode("0000");
            baseResponse.setSuccess(true);
            baseResponse.setResultMessage("\u64cd\u4f5c\u6210\u529f");
            baseResponse.setResult((Object)resultGoodsDto);
            return baseResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new BaseResponse(false, "\u5185\u90e8\u9519\u8bef", (Object)"", "3001");
        }
    }

    private BaseResponse validateGoods(ProviderGoodsDto providerGoodsDto) {
        if (Lang.isEmpty((Object)providerGoodsDto)) {
            return new BaseResponse(false, "\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a", (Object)"", "3001");
        }
        if (Lang.isEmpty((Object)providerGoodsDto.getName())) {
            return new BaseResponse(false, "\u8bf7\u6c42\u53c2\u6570name\u4e0d\u80fd\u4e3a\u7a7a", (Object)"", "3001");
        }
        if (Lang.isEmpty((Object)providerGoodsDto.getSku())) {
            return new BaseResponse(false, "\u8bf7\u6c42\u53c2\u6570sku\u4e0d\u80fd\u4e3a\u7a7a", (Object)"", "3001");
        }
        if (Lang.isEmpty((Object)providerGoodsDto.getPics())) {
            return new BaseResponse(false, "\u8bf7\u6c42\u53c2\u6570pics\u4e0d\u80fd\u4e3a\u7a7a", (Object)"", "3001");
        }
        if (Lang.isEmpty((Object)providerGoodsDto.getCostPrice())) {
            return new BaseResponse(false, "\u8bf7\u6c42\u53c2\u6570costPrice\u4e0d\u80fd\u4e3a\u7a7a", (Object)"", "3001");
        }
        if (Lang.isEmpty((Object)providerGoodsDto.getMarketPrice())) {
            return new BaseResponse(false, "\u8bf7\u6c42\u53c2\u6570marketPrice\u4e0d\u80fd\u4e3a\u7a7a", (Object)"", "3001");
        }
        return null;
    }

    @Transactional
    public ProviderProductFashion savaProductModel(ProviderProductFashion providerProductFashion, ProviderGoodsDto providerGoodsDto) {
        ProviderProduct providerProduct = new ProviderProduct();
        providerProduct.setStoreId(providerProductFashion.getStoreId());
        providerProduct.setModelSku(providerProductFashion.getSku());
        providerProduct.setName(providerProductFashion.getName());
        ProviderProductCategory providerProductCategoryThree = null;
        ProviderProductCategory providerProductCategoryTwo = null;
        ProviderProductCategory providerProductCategoryOne = null;
        ProviderCategoryDto pcd = providerGoodsDto.getProviderCategoryDto();
        if (!Lang.isEmpty((Object)pcd)) {
            if (!Lang.isEmpty((Object)pcd.getThdLevelCode())) {
                providerProductCategoryThree = this.providerProductCategoryRepos.findByCodeAndLayerIndexAndStoreIdAndIsDelete(pcd.getThdLevelCode(), Integer.valueOf(3), providerGoodsDto.getStoreId(), false);
            }
            if (!Lang.isEmpty(providerProductCategoryThree)) {
                providerProduct.setProviderProductCategoryId(providerProductCategoryThree.getId());
                providerProduct.setCategoryId(providerProductCategoryThree.getProductCategoryId());
            } else {
                if (!Lang.isEmpty((Object)pcd.getSecLevelCode())) {
                    providerProductCategoryTwo = this.providerProductCategoryRepos.findByCodeAndLayerIndexAndStoreIdAndIsDelete(pcd.getSecLevelCode(), Integer.valueOf(2), providerGoodsDto.getStoreId(), false);
                }
                if (!Lang.isEmpty(providerProductCategoryTwo)) {
                    if (!Lang.isEmpty((Object)pcd.getThdLevelName()) && !Lang.isEmpty((Object)pcd.getThdLevelCode())) {
                        providerProductCategoryThree = new ProviderProductCategory();
                        providerProductCategoryThree.setStoreId(providerGoodsDto.getStoreId());
                        providerProductCategoryThree.setName(pcd.getThdLevelName());
                        providerProductCategoryThree.setCategoryRemarks("\u4f9b\u5e94\u5546\u63a8\u9001\u5546\u54c1\u6d88\u606f\u5206\u7c7b\uff1a" + pcd.getThdLevelName());
                        providerProductCategoryThree.setCode(pcd.getThdLevelCode());
                        providerProductCategoryThree.setLayerIndex(Integer.valueOf(3));
                        providerProductCategoryThree.setParent(providerProductCategoryTwo);
                        this.providerProductCategoryRepos.save((Object)providerProductCategoryThree);
                    }
                } else {
                    if (!Lang.isEmpty((Object)pcd.getFstLevelCode())) {
                        providerProductCategoryOne = this.providerProductCategoryRepos.findByCodeAndLayerIndexAndStoreIdAndIsDelete(pcd.getFstLevelCode(), Integer.valueOf(1), providerGoodsDto.getStoreId(), false);
                    }
                    if (!Lang.isEmpty(providerProductCategoryOne)) {
                        if (!Lang.isEmpty((Object)pcd.getSecLevelCode()) && !Lang.isEmpty((Object)pcd.getSecLevelName())) {
                            providerProductCategoryTwo = new ProviderProductCategory();
                            providerProductCategoryTwo.setStoreId(providerGoodsDto.getStoreId());
                            providerProductCategoryTwo.setName(pcd.getSecLevelName());
                            providerProductCategoryTwo.setCategoryRemarks("\u4f9b\u5e94\u5546\u63a8\u9001\u5546\u54c1\u6d88\u606f\u5206\u7c7b\uff1a" + pcd.getSecLevelName());
                            providerProductCategoryTwo.setLayerIndex(Integer.valueOf(2));
                            providerProductCategoryTwo.setCode(pcd.getSecLevelCode());
                            providerProductCategoryTwo.setParent(providerProductCategoryOne);
                            providerProductCategoryTwo = (ProviderProductCategory)this.providerProductCategoryRepos.save((Object)providerProductCategoryTwo);
                        }
                        if (!Lang.isEmpty((Object)pcd.getThdLevelCode()) && !Lang.isEmpty((Object)pcd.getThdLevelName())) {
                            providerProductCategoryThree = new ProviderProductCategory();
                            providerProductCategoryThree.setStoreId(providerGoodsDto.getStoreId());
                            providerProductCategoryThree.setName(pcd.getThdLevelName());
                            providerProductCategoryThree.setCategoryRemarks("\u4f9b\u5e94\u5546\u63a8\u9001\u5546\u54c1\u6d88\u606f\u5206\u7c7b\uff1a" + pcd.getThdLevelName());
                            providerProductCategoryThree.setLayerIndex(Integer.valueOf(3));
                            providerProductCategoryThree.setCode(pcd.getThdLevelCode());
                            providerProductCategoryThree.setParent(providerProductCategoryTwo);
                            this.providerProductCategoryRepos.save((Object)providerProductCategoryThree);
                        }
                    } else {
                        if (!Lang.isEmpty((Object)pcd.getFstLevelCode()) && !Lang.isEmpty((Object)pcd.getFstLevelName())) {
                            providerProductCategoryOne = new ProviderProductCategory();
                            providerProductCategoryOne.setStoreId(providerGoodsDto.getStoreId());
                            providerProductCategoryOne.setName(pcd.getFstLevelName());
                            providerProductCategoryOne.setCategoryRemarks("\u4f9b\u5e94\u5546\u63a8\u9001\u5546\u54c1\u6d88\u606f\u5206\u7c7b\uff1a" + pcd.getFstLevelName());
                            providerProductCategoryOne.setLayerIndex(Integer.valueOf(1));
                            providerProductCategoryOne.setCode(pcd.getFstLevelCode());
                            providerProductCategoryOne = (ProviderProductCategory)this.providerProductCategoryRepos.save((Object)providerProductCategoryOne);
                        }
                        if (!Lang.isEmpty((Object)pcd.getSecLevelCode()) && !Lang.isEmpty((Object)pcd.getSecLevelName())) {
                            providerProductCategoryTwo = new ProviderProductCategory();
                            providerProductCategoryTwo.setStoreId(providerGoodsDto.getStoreId());
                            providerProductCategoryTwo.setName(pcd.getSecLevelName());
                            providerProductCategoryTwo.setCategoryRemarks("\u4f9b\u5e94\u5546\u63a8\u9001\u5546\u54c1\u6d88\u606f\u5206\u7c7b\uff1a" + pcd.getSecLevelName());
                            providerProductCategoryTwo.setLayerIndex(Integer.valueOf(2));
                            providerProductCategoryTwo.setCode(pcd.getSecLevelCode());
                            providerProductCategoryTwo.setParent(providerProductCategoryOne);
                            providerProductCategoryTwo = (ProviderProductCategory)this.providerProductCategoryRepos.save((Object)providerProductCategoryTwo);
                        }
                        if (!Lang.isEmpty((Object)pcd.getThdLevelCode()) && !Lang.isEmpty((Object)pcd.getThdLevelName())) {
                            providerProductCategoryThree = new ProviderProductCategory();
                            providerProductCategoryThree.setStoreId(providerGoodsDto.getStoreId());
                            providerProductCategoryThree.setCode(pcd.getThdLevelCode());
                            providerProductCategoryThree.setName(pcd.getThdLevelName());
                            providerProductCategoryThree.setCategoryRemarks("\u4f9b\u5e94\u5546\u63a8\u9001\u5546\u54c1\u6d88\u606f\u5206\u7c7b\uff1a" + pcd.getThdLevelName());
                            providerProductCategoryThree.setLayerIndex(Integer.valueOf(3));
                            providerProductCategoryThree.setParent(providerProductCategoryTwo);
                            this.providerProductCategoryRepos.save((Object)providerProductCategoryThree);
                        }
                    }
                }
            }
            providerProduct.setProviderProductCategoryId(providerProductCategoryThree.getId());
            providerProduct.setCategoryId(providerProductCategoryThree.getProductCategoryId());
        }
        ProviderProductBrand brand = null;
        if (!Lang.isEmpty((Object)providerGoodsDto.getBrandName())) {
            List providerProductBrands = this.providerProductBrandRepos.findByNameAndStoreIdAndIsDelete(providerGoodsDto.getBrandName(), providerGoodsDto.getStoreId(), false);
            if (!Lang.isEmpty((Object)providerProductBrands)) {
                brand = (ProviderProductBrand)providerProductBrands.get(0);
                providerProduct.setProductBrandId(brand.getProductBrandId());
                providerProduct.setBrandId(brand.getId());
            } else {
                BrandDto brandDto = new BrandDto();
                brandDto.setName(providerGoodsDto.getBrandName());
                brandDto.setStoreId(providerGoodsDto.getStoreId());
                brandDto.setSimpleName(providerGoodsDto.getBrandName());
                BaseResponse response = this.brandService.saveBrand(brandDto);
                if (response.isSuccess()) {
                    Map map = (Map)response.getResult();
                    brand = (ProviderProductBrand)this.providerProductBrandRepos.findOne((Serializable)map.get("brandId"));
                    providerProduct.setProductBrandId(brand.getProductBrandId());
                    providerProduct.setBrandId(brand.getId());
                }
            }
        }
        providerProduct = (ProviderProduct)this.providerProductRepos.save((Object)providerProduct);
        providerProductFashion.setProviderProduct(providerProduct);
        if (!Lang.isEmpty((Object)providerProduct.getCategoryId())) {
            providerProductFashion.setCategoryId(providerProduct.getCategoryId());
            ProductCategoryVo pcv = this.productCategoryApi.findByIdAndIsDelete(providerProduct.getCategoryId());
            if (pcv != null) {
                providerProductFashion.setCategoryName(pcv.getName());
            }
        }
        if (!Lang.isEmpty((Object)providerProduct.getProductBrandId())) {
            providerProductFashion.setBrandName(brand.getProductBrandName());
            providerProductFashion.setBrandId(brand.getProductBrandId());
        }
        providerProductFashion.setModelSku(providerGoodsDto.getSku());
        return providerProductFashion;
    }

    @Transactional
    public BaseResponse queryProviderGoods(String sku, String storeId) {
        BaseResponse baseResponse = new BaseResponse();
        try {
            if (Lang.isEmpty((Object)sku)) {
                return new BaseResponse(false, "\u8bf7\u6c42\u53c2\u6570sku\u4e0d\u80fd\u4e3a\u7a7a", (Object)"", "3001");
            }
            if (Lang.isEmpty((Object)storeId)) {
                return new BaseResponse(false, "\u672a\u83b7\u53d6\u5230\u4f9b\u5e94\u5546id", (Object)"", "3001");
            }
            ProviderProductFashion providerProductFashion = this.providerProductFashionRepos.findOneBySkuAndStoreId(sku, storeId);
            ProviderGoodsVo providerGoodsVo = (ProviderGoodsVo)this.mapperFacade.map((Object)providerProductFashion, ProviderGoodsVo.class);
            baseResponse.setResultCode("0000");
            baseResponse.setSuccess(true);
            baseResponse.setResultMessage("\u64cd\u4f5c\u6210\u529f");
            baseResponse.setResult((Object)providerGoodsVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            baseResponse = new BaseResponse(false, "\u5185\u90e8\u9519\u8bef", (Object)"", "110013");
        }
        return baseResponse;
    }

    public BaseResponse updateProviderGoods(ProviderGoodsDto providerGoodsDto) {
        BaseResponse baseResponse = null;
        try {
            if (Lang.isEmpty((Object)providerGoodsDto)) {
                return new BaseResponse(false, "\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a", (Object)"", "3001");
            }
            if (Lang.isEmpty((Object)providerGoodsDto.getName())) {
                return new BaseResponse(false, "\u8bf7\u6c42\u53c2\u6570name\u4e0d\u80fd\u4e3a\u7a7a", (Object)"", "3001");
            }
            if (Lang.isEmpty((Object)providerGoodsDto.getSku())) {
                return new BaseResponse(false, "\u8bf7\u6c42\u53c2\u6570sku\u4e0d\u80fd\u4e3a\u7a7a", (Object)"", "3001");
            }
            List providerProductFashion_destinationList = this.providerProductFashionRepos.findBySkuAndStoreIdAndIsDelete(providerGoodsDto.getSku(), providerGoodsDto.getStoreId(), false);
            if (Lang.isEmpty((Object)providerProductFashion_destinationList)) {
                return new BaseResponse(false, "\u5546\u54c1\u4e0d\u5b58\u5728", (Object)"", "3003");
            }
            ProviderProductFashion providerProductFashion_destination = (ProviderProductFashion)providerProductFashion_destinationList.get(0);
            providerProductFashion_destination.setName(providerGoodsDto.getName());
            providerProductFashion_destination.setBrandName(providerGoodsDto.getBrandName());
            providerProductFashion_destination.setIntroduction(providerGoodsDto.getIntroduction());
            providerProductFashion_destination.setParam(providerGoodsDto.getParam());
            providerProductFashion_destination.setProductArea(providerGoodsDto.getProductArea());
            providerProductFashion_destination.setSaleUnit(providerGoodsDto.getSaleUnit());
            if (!Lang.isEmpty((Object)providerGoodsDto.getStatus())) {
                providerProductFashion_destination.setProviderSaleStatus(Integer.valueOf(providerGoodsDto.getStatus()));
            }
            providerProductFashion_destination.setUpc(providerGoodsDto.getUpc());
            providerProductFashion_destination.setWareQD(providerGoodsDto.getWareQD());
            providerProductFashion_destination.setWeight(providerGoodsDto.getWeight());
            providerProductFashion_destination.setPushUpDate(new Date());
            List providerProductFashionPictureList = this.providerProductFashionPictureRepos.findAllByProviderProductFashion(providerProductFashion_destination);
            List specs = this.specificationRepos.findAllByProviderProductFashion(providerProductFashion_destination);
            if (!Lang.isEmpty((Object)providerGoodsDto.getPics())) {
                Object providerProductFashionPicture2;
                for (Object providerProductFashionPicture2 : providerProductFashionPictureList) {
                    this.providerProductFashionPictureRepos.delete(providerProductFashionPicture2);
                }
                List pics = this.mapperFacade.mapAsList((Iterable)providerGoodsDto.getPics(), ProviderProductFashionPicture.class);
                providerProductFashionPicture2 = pics.iterator();
                while (providerProductFashionPicture2.hasNext()) {
                    ProviderProductFashionPicture pic = (ProviderProductFashionPicture)providerProductFashionPicture2.next();
                    pic.setProviderProductFashion(providerProductFashion_destination);
                }
                providerProductFashion_destination.setPics(pics);
            }
            if (!Lang.isEmpty((Object)providerGoodsDto.getProviderGoodsSpecifications())) {
                for (ProviderGoodsSpecification spec : specs) {
                    this.specificationRepos.delete((Object)spec);
                }
                List specList = this.mapperFacade.mapAsList((Iterable)providerGoodsDto.getProviderGoodsSpecifications(), ProviderGoodsSpecification.class);
                for (ProviderGoodsSpecification spec : specList) {
                    spec.setProviderProductFashion(providerProductFashion_destination);
                }
                providerProductFashion_destination.setProviderGoodsSpecifications(specList);
            }
            this.providerProductFashionRepos.save((Object)providerProductFashion_destination);
            baseResponse = new BaseResponse(true, "\u64cd\u4f5c\u6210\u529f", null, "0000");
        }
        catch (Exception e) {
            e.printStackTrace();
            baseResponse = new BaseResponse(false, "\u5185\u90e8\u9519\u8bef");
        }
        if (baseResponse.isSuccess()) {
            StoreDto storeDto = this.storeService.getStoreByStoreId(providerGoodsDto.getStoreId());
            this.mqHandleProducer.sendProductDetailMessage(providerGoodsDto, storeDto.getStoreExt().getCode());
        }
        return baseResponse;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public BaseResponse queryProviderGoodsPage(ProductQueryDto productQueryDto) {
        BaseResponse baseResponse = new BaseResponse();
        try {
            if (!Lang.isEmpty((Object)productQueryDto) && Lang.isEmpty((Object)productQueryDto.getPageNo())) {
                productQueryDto.setPageNo(MessageDictionary.DEFAULT_PAGENO);
            }
            if (!Lang.isEmpty((Object)productQueryDto) && Lang.isEmpty((Object)productQueryDto.getPageSize())) {
                productQueryDto.setPageSize(MessageDictionary.DEFAULT_PAGESIZE);
            }
            if (Lang.isEmpty((Object)productQueryDto)) {
                productQueryDto = new ProductQueryDto();
                productQueryDto.setPageNo(MessageDictionary.DEFAULT_PAGENO);
                productQueryDto.setPageSize(MessageDictionary.DEFAULT_PAGESIZE);
            }
            int pageNo = productQueryDto.getPageNo();
            int pageSize = productQueryDto.getPageSize();
            int realPageNo = pageNo;
            Sort sort = new Sort(Sort.Direction.DESC, new String[]{ProviderProductFashion_.dateCreated.getName()});
            PageRequest pageable = new PageRequest(realPageNo, pageSize, sort);
            QueryProviderGoodsSpecification specification = new QueryProviderGoodsSpecification(productQueryDto, Boolean.valueOf(false));
            Page page = this.providerProductFashionRepos.findAll((Specification)specification, (Pageable)pageable);
            List providerProductFashionList = page.getContent();
            List providerGoodsVoList = this.mapperFacade.mapAsList((Iterable)providerProductFashionList, ProviderGoodsVo.class);
            PageVo pageVo = new PageVo();
            pageVo.setResult(providerGoodsVoList);
            long totalElements = page.getTotalElements();
            pageVo.setTotalCount(Integer.valueOf((int)totalElements));
            pageVo.setPageNum(Integer.valueOf(page.getNumber()));
            pageVo.setPageSize(Integer.valueOf(page.getSize()));
            baseResponse.setResult((Object)pageVo);
            baseResponse.setResultCode("0000");
            baseResponse.setResultMessage("\u64cd\u4f5c\u6210\u529f");
            baseResponse.setSuccess(true);
        }
        catch (Exception e) {
            baseResponse = new BaseResponse(false, "\u5185\u90e8\u9519\u8bef", null, "3001");
            e.printStackTrace();
        }
        return baseResponse;
    }

    public BaseResponse updateGoodsStatus(List<ProviderGoodsStatus> providerGoodsStatusList, String storeId) {
        BaseResponse baseResponse = null;
        ArrayList<ProductReturnVo> successReturnList = new ArrayList<ProductReturnVo>();
        ArrayList<ProductReturnVo> failReturnList = new ArrayList<ProductReturnVo>();
        ArrayList<String> downList = new ArrayList<String>();
        ArrayList<String> upList = new ArrayList<String>();
        try {
            ProductReturnVo productReturnVo;
            if (Lang.isEmpty(providerGoodsStatusList)) {
                return new BaseResponse(false, "\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a", (Object)"", "3001");
            }
            if (providerGoodsStatusList.size() > MessageDictionary.DEFAULT_MAX_PRODUCT_UPDATE_COUNT) {
                return new BaseResponse(false, MessageDictionary.RETURN_MAX_UPDATE_COUNT_ERROR_MESSAGE, (Object)"", "3002");
            }
            List<String> statusList = Arrays.asList("1", "0");
            for (ProviderGoodsStatus providerGoodsStatus : providerGoodsStatusList) {
                if (Lang.isEmpty((Object)providerGoodsStatus.getSku()) || Lang.isEmpty((Object)providerGoodsStatus.getStatus())) {
                    productReturnVo = new ProductReturnVo(providerGoodsStatus.getSku(), "3001", "\u64cd\u4f5c\u5931\u8d25");
                    failReturnList.add(productReturnVo);
                    continue;
                }
                if (!statusList.contains(providerGoodsStatus.getStatus())) {
                    productReturnVo = new ProductReturnVo(providerGoodsStatus.getSku(), "3001", "\u64cd\u4f5c\u5931\u8d25");
                    failReturnList.add(productReturnVo);
                    continue;
                }
                if ("1".equals(providerGoodsStatus.getStatus())) {
                    upList.add(providerGoodsStatus.getSku());
                    continue;
                }
                downList.add(providerGoodsStatus.getSku());
            }
            if (!Lang.isEmpty(downList)) {
                this.providerProductFashionRepos.updateStateBySkuBatch(downList, Integer.valueOf("0").intValue(), new Date(), storeId);
                log.info("\u5546\u54c1\u4e0b\u67b6\u6d88\u606f\u63a8\u9001\uff1a{}", (Object)((Object)downList).toString());
                for (String string : downList) {
                    productReturnVo = new ProductReturnVo(string, "0000", "\u64cd\u4f5c\u6210\u529f");
                    successReturnList.add(productReturnVo);
                }
                this.mqHandleProducer.sendSkuDownMessage(downList, storeId);
            }
            StoreDto storeDto = this.storeService.getStoreByStoreId(storeId);
            if (!Lang.isEmpty(upList)) {
                if (STORE_LOCAL.equals(storeDto.getStoreExt().getType())) {
                    this.providerProductFashionRepos.updateStateBySkuBatch(upList, Integer.valueOf("1").intValue(), new Date(), storeId);
                    for (String sku : upList) {
                        ProductReturnVo productReturnVo2 = new ProductReturnVo(sku, "0000", "\u64cd\u4f5c\u6210\u529f");
                        successReturnList.add(productReturnVo2);
                    }
                    ProductUpdateResult productUpdateResult = new ProductUpdateResult(successReturnList, failReturnList);
                    return new BaseResponse(true, "\u64cd\u4f5c\u6210\u529f", (Object)productUpdateResult, "0000");
                }
                Map map = this.goodsAutosyncFilterService.autoUpCategoryBrandMappingFilter(upList, storeId);
                List upSuccessMsgList = (List)map.get("upSuccessMsgList");
                List upFailList = (List)map.get("upFailList");
                if (!Lang.isEmpty((Object)upFailList)) {
                    for (int i = 0; i < upFailList.size(); ++i) {
                        ProductReturnVo productReturnVo3 = new ProductReturnVo((String)upFailList.get(i), "0404", "\u5206\u7c7b\u6216\u54c1\u724c\u672a\u6620\u5c04");
                        failReturnList.add(productReturnVo3);
                    }
                }
                if (!Lang.isEmpty((Object)upSuccessMsgList)) {
                    List organizationDtos = this.organizationApiStub.findOrganizationAll();
                    for (String sku : upSuccessMsgList) {
                        ArrayList<String> upSkuList = new ArrayList<String>();
                        Map rsp = this.goodsAutosyncFilterService.autoUpCategoryOrgUpFilter(sku, storeId, organizationDtos);
                        List orgCodes = (List)rsp.get("organizationList");
                        try {
                            if (!Lang.isEmpty((Object)orgCodes)) {
                                ProviderProductFashionDto providerProductFashionDto = this.providerProductFashionService.findBySkuAndStoreId(sku, storeId, false);
                                BaseResponse autoBaseResponse = this.productApi.syncProduct(providerProductFashionDto);
                                if (autoBaseResponse.isSuccess()) {
                                    ProductReturnVo productReturnVo4 = new ProductReturnVo(sku, "0000", "\u64cd\u4f5c\u6210\u529f");
                                    successReturnList.add(productReturnVo4);
                                    ArrayList<String> skuList = new ArrayList<String>();
                                    skuList.add(sku);
                                    this.providerProductFashionRepos.updateStateBySkuBatch(skuList, Integer.valueOf("1").intValue(), new Date(), storeId);
                                    upSkuList.add(sku);
                                    for (String orgCode : orgCodes) {
                                        this.mqHandleProducer.sendSkuUpMessage(upSkuList, storeId, orgCode);
                                    }
                                    continue;
                                }
                                ProductReturnVo productReturnVo2 = new ProductReturnVo(sku, "110013", "\u540c\u6b65\u5546\u54c1\u5931\u8d25");
                                failReturnList.add(productReturnVo2);
                                continue;
                            }
                            log.info("\u5546\u54c1sku:{},\u5728\u4efb\u4f55\u5546\u57ce\u90fd\u4e0d\u6ee1\u8db3\u81ea\u52a8\u4e0a\u67b6\uff08\u5206\u7c7b\u4e0a\u67b6\uff09\u89c4\u5219");
                            ProductReturnVo productReturnVo5 = new ProductReturnVo(sku, "0404", "\u5546\u54c1\u4e0d\u6ee1\u8db3\u4e0a\u67b6\u89c4\u5219\uff0c\u5206\u7c7b\u672a\u4e0a\u67b6");
                            failReturnList.add(productReturnVo5);
                        }
                        catch (NumberFormatException e) {
                            e.printStackTrace();
                            ProductReturnVo productReturnVo6 = new ProductReturnVo(sku, "110013", "\u64cd\u4f5c\u5931\u8d25");
                            failReturnList.add(productReturnVo6);
                        }
                    }
                } else {
                    log.info("\u5546\u54c1\u4e0d\u6ee1\u8db3\u81ea\u52a8\u4e0a\u67b6\u89c4\u5219");
                }
            }
            ProductUpdateResult productUpdateResult = new ProductUpdateResult(successReturnList, failReturnList);
            baseResponse = new BaseResponse(true, "\u64cd\u4f5c\u6210\u529f", (Object)productUpdateResult, "0000");
        }
        catch (Exception e) {
            e.printStackTrace();
            baseResponse = new BaseResponse(false, "\u5185\u90e8\u9519\u8bef", (Object)"", "110013");
        }
        return baseResponse;
    }

    public BaseResponse updateGoodsPrice(List<ProviderGoodsPrice> providerGoodsPriceList, String storeId) {
        BaseResponse baseResponse = null;
        ArrayList<ProviderGoodsPrice> successMsgList = new ArrayList<ProviderGoodsPrice>();
        try {
            if (Lang.isEmpty(providerGoodsPriceList)) {
                return new BaseResponse(false, "\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a", (Object)"", "3001");
            }
            if (providerGoodsPriceList.size() > MessageDictionary.DEFAULT_MAX_PRODUCT_UPDATE_COUNT) {
                return new BaseResponse(false, MessageDictionary.RETURN_MAX_UPDATE_COUNT_ERROR_MESSAGE, (Object)"", "3002");
            }
            ArrayList<ProductReturnVo> successList = new ArrayList<ProductReturnVo>();
            ArrayList<ProductReturnVo> failList = new ArrayList<ProductReturnVo>();
            for (ProviderGoodsPrice providerGoodsPrice : providerGoodsPriceList) {
                ProductReturnVo productReturnVo;
                if (Lang.isEmpty((Object)providerGoodsPrice.getSku()) || Lang.isEmpty((Object)providerGoodsPrice.getCostPrice()) || Lang.isEmpty((Object)providerGoodsPrice.getMarketPrice())) {
                    ProductReturnVo productReturnVo2 = new ProductReturnVo(providerGoodsPrice.getSku(), "3001", "\u64cd\u4f5c\u5931\u8d25");
                    failList.add(productReturnVo2);
                    continue;
                }
                ProviderProductFashion ppf = new ProviderProductFashion();
                ppf.setSku(providerGoodsPrice.getSku());
                ppf.setStoreId(storeId);
                ppf.setIsDelete(Boolean.valueOf(false));
                boolean goodsExist = this.providerProductFashionRepos.exists(Example.of((Object)ppf));
                if (!goodsExist) {
                    log.info("sku\uff1a{},store:{}\u4e0d\u5b58\u5728", (Object)providerGoodsPrice.getSku(), (Object)storeId);
                    productReturnVo = new ProductReturnVo(providerGoodsPrice.getSku(), "3003", "\u64cd\u4f5c\u5931\u8d25");
                    failList.add(productReturnVo);
                    continue;
                }
                try {
                    this.providerProductFashionRepos.updatePriceBySku(providerGoodsPrice.getSku(), providerGoodsPrice.getCostPrice(), providerGoodsPrice.getMarketPrice(), new Date(), storeId);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ProductReturnVo productReturnVo3 = new ProductReturnVo(providerGoodsPrice.getSku(), "110013", "\u64cd\u4f5c\u5931\u8d25");
                    failList.add(productReturnVo3);
                }
                productReturnVo = new ProductReturnVo(providerGoodsPrice.getSku(), "0000", "\u64cd\u4f5c\u6210\u529f");
                successList.add(productReturnVo);
                successMsgList.add(providerGoodsPrice);
            }
            ProductUpdateResult productUpdateResult = new ProductUpdateResult(successList, failList);
            baseResponse = new BaseResponse(true, "\u64cd\u4f5c\u6210\u529f", (Object)productUpdateResult, "0000");
        }
        catch (Exception e) {
            e.printStackTrace();
            baseResponse = new BaseResponse(false, "\u5185\u90e8\u9519\u8bef", (Object)"", "110013");
        }
        if (!Lang.isEmpty(successMsgList)) {
            StoreDto storeDto = this.storeService.getStoreByStoreId(storeId);
            this.mqHandleProducer.sendPriceUpdateMessage(successMsgList, storeDto.getStoreExt().getCode());
        }
        return baseResponse;
    }

    public BaseResponse updateGoodsStock(List<ProviderGoodsStock> providerGoodsStockList, String storeId) {
        BaseResponse baseResponse = null;
        ArrayList<ProductReturnVo> successList = null;
        ArrayList<ProductReturnVo> failList = null;
        try {
            if (Lang.isEmpty(providerGoodsStockList)) {
                return new BaseResponse(false, "\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a", (Object)"", "3001");
            }
            if (providerGoodsStockList.size() > MessageDictionary.DEFAULT_MAX_PRODUCT_UPDATE_COUNT) {
                return new BaseResponse(false, MessageDictionary.RETURN_MAX_UPDATE_COUNT_ERROR_MESSAGE, (Object)"", "3002");
            }
            successList = new ArrayList<ProductReturnVo>();
            failList = new ArrayList<ProductReturnVo>();
            for (ProviderGoodsStock providerGoodsStock : providerGoodsStockList) {
                ProductReturnVo productReturnVo;
                if (Lang.isEmpty((Object)providerGoodsStock.getSku()) || Lang.isEmpty((Object)providerGoodsStock.getStockCount())) {
                    ProductReturnVo productReturnVo2 = new ProductReturnVo(providerGoodsStock.getSku(), "3001", "error");
                    failList.add(productReturnVo2);
                    continue;
                }
                ProviderProductFashion providerProductFashion = this.providerProductFashionRepos.findOneBySkuAndStoreId(providerGoodsStock.getSku(), storeId);
                if (Lang.isEmpty((Object)providerProductFashion)) {
                    productReturnVo = new ProductReturnVo(providerGoodsStock.getSku(), "3003", "error");
                    failList.add(productReturnVo);
                    continue;
                }
                try {
                    providerProductFashion.setStockCount(providerGoodsStock.getStockCount());
                    this.providerProductFashionRepos.save((Object)providerProductFashion);
                    productReturnVo = new ProductReturnVo(providerGoodsStock.getSku(), "0000", "success");
                    successList.add(productReturnVo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ProductReturnVo productReturnVo3 = new ProductReturnVo(providerGoodsStock.getSku(), "110013", "error");
                    failList.add(productReturnVo3);
                }
            }
            ProductUpdateResult productUpdateResult = new ProductUpdateResult(successList, failList);
            baseResponse = new BaseResponse(true, "\u64cd\u4f5c\u6210\u529f", (Object)productUpdateResult, "0000");
        }
        catch (Exception e) {
            e.printStackTrace();
            baseResponse = new BaseResponse(false, "\u5185\u90e8\u9519\u8bef", (Object)"", "110013");
        }
        return baseResponse;
    }

    public BaseResponse<List<ProviderGoodsVo>> queryGoods(List<String> skus, String storeId) {
        BaseResponse baseResponse = new BaseResponse();
        try {
            if (skus.size() == 0) {
                return new BaseResponse(false, "\u8bf7\u6c42\u53c2\u6570sku\u4e0d\u80fd\u4e3a\u7a7a", (Object)"", "3001");
            }
            if (Lang.isEmpty((Object)storeId)) {
                return new BaseResponse(false, "\u672a\u83b7\u53d6\u5230\u4f9b\u5e94\u5546id", (Object)"", "3001");
            }
            List providerProductFashionList = this.providerProductFashionRepos.findBySkusAndStoreId(skus, storeId);
            ArrayList<ProviderGoodsVo> providerGoodsVoList = new ArrayList<ProviderGoodsVo>();
            for (ProviderProductFashion p : providerProductFashionList) {
                ProviderGoodsVo providerGoodsVo = new ProviderGoodsVo();
                providerGoodsVo.setSku(p.getSku());
                if (p.getProviderSaleStatus() == 1) {
                    providerGoodsVo.setStatus("1");
                }
                if (p.getProviderSaleStatus() == 0) {
                    providerGoodsVo.setStatus("0");
                }
                providerGoodsVo.setProductId(p.getId());
                providerGoodsVo.setCostPrice(p.getCostPrice());
                providerGoodsVo.setSalePrice(p.getSalePrice());
                providerGoodsVo.setMarketPrice(p.getMarketPrice());
                providerGoodsVo.setStockCount(p.getStockCount());
                providerGoodsVoList.add(providerGoodsVo);
            }
            baseResponse.setResultCode("0000");
            baseResponse.setSuccess(true);
            baseResponse.setResultMessage("\u64cd\u4f5c\u6210\u529f");
            baseResponse.setResult(providerGoodsVoList);
        }
        catch (Exception e) {
            e.printStackTrace();
            baseResponse = new BaseResponse(false, "\u5185\u90e8\u9519\u8bef", (Object)"", "110013");
        }
        return baseResponse;
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse occupyStock(LocalStoreOrderVo localStoreOrderVo) {
        BaseResponse baseResponse = new BaseResponse();
        BoundValueOperations boundValueOperations = this.redisTemplate.boundValueOps((Object)("LocalOccupyStock:OrderNo" + localStoreOrderVo.getOrderNo() + '4'));
        if (boundValueOperations.setIfAbsent((Object)true).booleanValue()) {
            boundValueOperations.expire(1L, TimeUnit.MILLISECONDS);
            if (Lang.isEmpty((Object)localStoreOrderVo)) {
                return new BaseResponse(false, "\u8bf7\u6c42\u53c2\u6570orderNo\u4e0d\u80fd\u4e3a\u7a7a", (Object)"", "3001");
            }
            List list = localStoreOrderVo.getList();
            for (ProviderGoodsStockVo p : list) {
                int temp = this.providerProductFashionRepos.updateCountBySkuAndSotreId(p.getSku(), localStoreOrderVo.getStoreId(), p.getStockCount());
                if (temp > 0) continue;
                throw new RuntimeException("\u66f4\u65b0SKU:" + p.getSku() + "\u5931\u8d25");
            }
            baseResponse.setResultCode("0000");
            baseResponse.setSuccess(true);
            baseResponse.setResultMessage("\u64cd\u4f5c\u6210\u529f");
            return baseResponse;
        }
        baseResponse.setResultCode("5002");
        baseResponse.setResultMessage("\u8ba2\u5355\u91cd\u590d\u63d0\u4ea4");
        return baseResponse;
    }

    public BaseResponse cancelOccupyStock(String thrOrderNo, String storedId) {
        BaseResponse baseResponse = new BaseResponse();
        BoundValueOperations boundValueOperations = this.redisTemplate.boundValueOps((Object)("LocalCancelOccupyStock:OrderNo" + thrOrderNo + '9'));
        if (boundValueOperations.setIfAbsent((Object)true).booleanValue()) {
            boundValueOperations.expire(1L, TimeUnit.MILLISECONDS);
            if (Lang.isEmpty((Object)thrOrderNo) && Lang.isEmpty((Object)storedId)) {
                return new BaseResponse(false, "\u8bf7\u6c42\u53c2\u6570orderNo\u4e0d\u80fd\u4e3a\u7a7a", (Object)"", "3001");
            }
            OrderMainDto order = this.orderMainApi.findOrderByThirdOrderNoAndProviderId(thrOrderNo, storedId);
            ArrayList<ProviderGoodsStockVo> list = new ArrayList<ProviderGoodsStockVo>();
            if (!Lang.isEmpty((Object)order)) {
                List orderItems = order.getOrderItems();
                for (OrderItemDto orderItem : orderItems) {
                    ProviderGoodsStockVo providerGoodsStockVo = new ProviderGoodsStockVo();
                    providerGoodsStockVo.setSku(orderItem.getSku());
                    providerGoodsStockVo.setStockCount(orderItem.getCount());
                    list.add(providerGoodsStockVo);
                }
            } else {
                return new BaseResponse("\u8ba2\u5355\u4fe1\u606f\u67e5\u8be2\u5931\u8d25");
            }
            for (ProviderGoodsStockVo p : list) {
                int temp = this.providerProductFashionRepos.updateAddCountBySkuAndSotreId(p.getSku(), storedId, p.getStockCount());
                if (temp > 0) continue;
                throw new RuntimeException("");
            }
        }
        baseResponse.setResultCode("0000");
        baseResponse.setSuccess(true);
        baseResponse.setResultMessage("\u64cd\u4f5c\u6210\u529f");
        return baseResponse;
    }

    public Map<String, Object> findGoodsUpperAndLowersSql(GoodsUpperAndLowerQueryDto goodsUpperAndLowerQueryDto) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuffer sql = new StringBuffer();
        String orgCodeStr = "";
        if (!Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getOrgCode()) && !"all".equals(goodsUpperAndLowerQueryDto.getOrgCode().trim())) {
            orgCodeStr = " and gc.organization_code = :orgcode ";
            params.put("orgcode", goodsUpperAndLowerQueryDto.getOrgCode().trim());
        }
        sql.append(" select g.* from ").append("    (").append("        SELECT").append("            ppf.category_name AS categoryname,").append("            ppf.provider_name AS providername,").append("            ppf.sku AS sku,").append("            ppf.name AS name,").append("            ppf.brand_name AS brandname,").append("            ppf.market_price AS originalPrice,").append("            ppf.cost_price AS costprice,").append("            gcc.price AS saleprice,").append("            ppf.agreement_discount_rate AS agreementdiscountrate,").append("            ppf.real_time_discount_rate AS realtimediscountrate,").append("            ppf.rate_mode_rate AS ratemoderate,").append("            gcc.is_up AS isup,").append("            gcc.is_preferred AS ispreferred,").append("            ppf.store_id AS storeid,").append("            ppf.category_id as categoryid,").append("            ppf.brand_id as brandid,").append("            gcc.organization_code AS organizationcode ").append("        FROM").append("            provider_product_fashion ppf,").append("           ( select gc.price, gc.is_up, gc.is_preferred, gc.sku, gc.user_id, gc.organization_code ").append("            from  goods_config gc where  gc.is_delete = 0 ").append(orgCodeStr).append("            ) gcc").append("        WHERE").append("                ppf.sku = gcc.sku (+)").append("            AND").append("                ppf.store_id = gcc.user_id (+)").append("            AND").append("                ppf.provider_sale_status = '1'").append("            AND").append("                ppf.is_delete = 0").append("    ) g ").append(" WHERE 1=1 ");
        if (!Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getIsUp()) && !"all".equals(goodsUpperAndLowerQueryDto.getIsUp().trim())) {
            if ("0".equals(goodsUpperAndLowerQueryDto.getIsUp())) {
                sql.append("  and (g.isup = :isup or g.isup is null)");
            }
            if ("1".equals(goodsUpperAndLowerQueryDto.getIsUp())) {
                sql.append("  and (g.isup = :isup )");
            }
            params.put("isup", goodsUpperAndLowerQueryDto.getIsUp());
        }
        if (!Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getIsPreferred()) && !"all".equals(goodsUpperAndLowerQueryDto.getIsPreferred().trim())) {
            if ("0".equals(goodsUpperAndLowerQueryDto.getIsPreferred())) {
                sql.append("  and (g.ispreferred = :ispreferred or g.ispreferred is null)");
            }
            if ("1".equals(goodsUpperAndLowerQueryDto.getIsPreferred())) {
                sql.append("  and g.ispreferred = :ispreferred ");
            }
            params.put("ispreferred", goodsUpperAndLowerQueryDto.getIsPreferred());
        }
        if (!Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getStartSalePrice()) && Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getEndSalePrice())) {
            sql.append("  and g.saleprice >= :saleprice ");
            params.put("saleprice", goodsUpperAndLowerQueryDto.getStartSalePrice());
        } else if (Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getStartSalePrice()) && !Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getEndSalePrice())) {
            sql.append("  and g.saleprice <= :saleprice ");
            params.put("saleprice", goodsUpperAndLowerQueryDto.getEndSalePrice());
        } else if (!Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getStartSalePrice()) && !Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getEndSalePrice())) {
            sql.append("  and g.saleprice >= :startsaleprice  and g.saleprice <= :endsaleprice ");
            params.put("startsaleprice", goodsUpperAndLowerQueryDto.getStartSalePrice());
            params.put("endsaleprice", goodsUpperAndLowerQueryDto.getEndSalePrice());
        }
        if (!Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getProductCategoryId())) {
            List threeCategoryId = this.productCategoryApi.findThreeCategoryByCategoryId(goodsUpperAndLowerQueryDto.getProductCategoryId());
            sql.append(" and g.categoryid  in (:categoryid) ");
            params.put("categoryid", threeCategoryId);
        }
        if (!Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getSku())) {
            sql.append(" and g.sku = :sku ");
            params.put("sku", goodsUpperAndLowerQueryDto.getSku());
        }
        if (!Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getStoreId()) && !"all".equals(goodsUpperAndLowerQueryDto.getStoreId().trim())) {
            sql.append(" and g.storeid = :storeid ");
            params.put("storeid", goodsUpperAndLowerQueryDto.getStoreId());
        }
        if (!Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getName())) {
            sql.append(" and g.name like (:name) ");
            params.put("name", "%" + goodsUpperAndLowerQueryDto.getName() + "%");
        }
        if (!Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getBrandIds())) {
            String[] brandArry;
            ArrayList<String> list = new ArrayList<String>();
            for (String brand : brandArry = goodsUpperAndLowerQueryDto.getBrandIds().split(",")) {
                list.add(brand);
            }
            sql.append(" and g.brandid in (:brandid) ");
            params.put("brandid", list);
        }
        if (!Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getStartCostPrice()) && Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getEndCostPrice())) {
            sql.append("  and g.costprice >= :costprice ");
            params.put("costprice", goodsUpperAndLowerQueryDto.getStartCostPrice());
        } else if (Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getStartCostPrice()) && !Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getEndCostPrice())) {
            sql.append("  and g.costprice <= :costprice ");
            params.put("costprice", goodsUpperAndLowerQueryDto.getEndCostPrice());
        } else if (!Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getStartCostPrice()) && !Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getEndCostPrice())) {
            sql.append("  and g.costprice >= :startcostprice  and g.costprice <= :endcostprice ");
            params.put("startcostprice", goodsUpperAndLowerQueryDto.getStartCostPrice());
            params.put("endcostprice", goodsUpperAndLowerQueryDto.getEndCostPrice());
        }
        if (!Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getStartRateModeRate()) && Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getEndRateModeRate())) {
            sql.append("  and g.ratemoderate >= :ratemoderate ");
            params.put("ratemoderate", goodsUpperAndLowerQueryDto.getStartRateModeRate());
        } else if (Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getStartRateModeRate()) && !Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getEndRateModeRate())) {
            sql.append("  and g.ratemoderate <= :ratemoderate ");
            params.put("ratemoderate", goodsUpperAndLowerQueryDto.getEndRateModeRate());
        } else if (!Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getStartRateModeRate()) && !Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getEndRateModeRate())) {
            sql.append("  and g.ratemoderate >= :startratemoderate  and g.ratemoderate <= :endratemoderate ");
            params.put("startratemoderate", goodsUpperAndLowerQueryDto.getStartRateModeRate());
            params.put("endratemoderate", goodsUpperAndLowerQueryDto.getEndRateModeRate());
        }
        if (!Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getStartAgreementDiscountRate()) && Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getEndAgreementDiscountRate())) {
            sql.append("  and g.agreementdiscountrate >= :agreementdiscountrate ");
            params.put("agreementdiscountrate", goodsUpperAndLowerQueryDto.getStartAgreementDiscountRate());
        } else if (Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getStartAgreementDiscountRate()) && !Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getEndAgreementDiscountRate())) {
            sql.append("  and g.agreementdiscountrate <= :agreementdiscountrate ");
            params.put("agreementdiscountrate", goodsUpperAndLowerQueryDto.getEndAgreementDiscountRate());
        } else if (!Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getStartAgreementDiscountRate()) && !Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getEndAgreementDiscountRate())) {
            sql.append("  and g.agreementdiscountrate >= :startagreementdiscountrate  and g.agreementdiscountrate <= :endagreementdiscountrate ");
            params.put("startagreementdiscountrate", goodsUpperAndLowerQueryDto.getStartAgreementDiscountRate());
            params.put("endagreementdiscountrate", goodsUpperAndLowerQueryDto.getEndAgreementDiscountRate());
        }
        if (!Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getStartRealTimeDiscountRate()) && Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getEndRealTimeDiscountRate())) {
            sql.append("  and  g.realtimediscountrate >= :realtimediscountrate ");
            params.put("realtimediscountrate", goodsUpperAndLowerQueryDto.getStartRealTimeDiscountRate());
        } else if (Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getStartRealTimeDiscountRate()) && !Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getEndRealTimeDiscountRate())) {
            sql.append("  and  g.realtimediscountrate <= :realtimediscountrate ");
            params.put("realtimediscountrate", goodsUpperAndLowerQueryDto.getEndRealTimeDiscountRate());
        } else if (!Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getStartRealTimeDiscountRate()) && !Lang.isEmpty((Object)goodsUpperAndLowerQueryDto.getEndRealTimeDiscountRate())) {
            sql.append("  and  g.realtimediscountrate >= :startrealtimediscountrate  and  g.realtimediscountrate <= :endrealtimediscountrate ");
            params.put("startrealtimediscountrate", goodsUpperAndLowerQueryDto.getStartRealTimeDiscountRate());
            params.put("endrealtimediscountrate", goodsUpperAndLowerQueryDto.getEndRealTimeDiscountRate());
        }
        log.info("\u5546\u54c1\u4e0a\u4e0b\u67b6\u9875\u9762\u5217\u8868\u67e5\u8be2sql===\u300b\uff1a{}", (Object)sql.toString());
        HashedMap map = new HashedMap();
        map.put("sql", sql.toString());
        map.put("params", params);
        return map;
    }

    public BaseResponse<List<GoodsUpperAndLowerDto>> findGoodsUpperAndLowersByQuery(GoodsUpperAndLowerQueryDto goodsUpperAndLowerQueryDto) {
        List goodsUpperAndLowerDtos = null;
        Map sqlListMap = this.findGoodsUpperAndLowersSql(goodsUpperAndLowerQueryDto);
        try {
            NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.jdbcTemplate.getDataSource());
            goodsUpperAndLowerDtos = namedParameterJdbcTemplate.query(String.valueOf(sqlListMap.get("sql")), (Map)sqlListMap.get("params"), (RowMapper)new BeanPropertyRowMapper(GoodsUpperAndLowerDto.class));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u5546\u54c1\u5217\u8868\u67e5\u8be2\u5931\u8d25 {}", (Throwable)e);
            return new BaseResponse(false, "\u5546\u54c1\u5217\u8868\u67e5\u8be2\u5931\u8d25", goodsUpperAndLowerDtos);
        }
        return new BaseResponse(true, "\u5546\u54c1\u5217\u8868\u67e5\u8be2\u6210\u529f", (Object)goodsUpperAndLowerDtos);
    }

    public BaseResponse deleteProviderGoodsBatch(List<String> skus, String storeId) {
        BaseResponse baseResponse = new BaseResponse();
        try {
            if (Lang.isEmpty(skus)) {
                return new BaseResponse(false, "\u8bf7\u6c42\u53c2\u6570sku\u4e0d\u80fd\u4e3a\u7a7a", (Object)"", "3001");
            }
            this.providerProductFashionRepos.deleteProviderGoodsBatch(skus, Integer.valueOf(0), Boolean.valueOf(true), storeId, new Date());
            baseResponse.setResultCode("0000");
            baseResponse.setSuccess(true);
            baseResponse.setResultMessage("\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            baseResponse = new BaseResponse(false, "\u5185\u90e8\u9519\u8bef", (Object)"", "110013");
        }
        if (baseResponse.isSuccess()) {
            StoreDto storeDto = this.storeService.getStoreByStoreId(storeId);
            this.mqHandleProducer.sendProductDeleteMessage(skus, storeDto.getStoreExt().getCode());
        }
        return baseResponse;
    }

    @Transactional
    public ProviderGoodsDto queryProviderGoodsDto(String sku, String storeId) {
        BaseResponse baseResponse = new BaseResponse();
        ArrayList providerGoodsDtos = new ArrayList();
        ProviderGoodsDto providerGoodsDto = null;
        try {
            if (Lang.isEmpty((Object)sku)) {
                return providerGoodsDto;
            }
            if (Lang.isEmpty((Object)storeId)) {
                return providerGoodsDto;
            }
            ProviderProductFashion providerProductFashion = this.providerProductFashionRepos.findOneBySkuAndStoreId(sku, storeId);
            providerGoodsDto = (ProviderGoodsDto)this.mapperFacade.map((Object)providerProductFashion, ProviderGoodsDto.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return providerGoodsDto;
    }

    @Transactional
    public List<ProviderGoodsDto> queryProviderGoodsDtoList(String modelSku, String storeId) {
        BaseResponse baseResponse = new BaseResponse();
        List goodsDtoList = null;
        try {
            if (Lang.isEmpty((Object)modelSku)) {
                return null;
            }
            if (Lang.isEmpty((Object)storeId)) {
                return null;
            }
            List providerProductFashionList = this.providerProductFashionRepos.findByModelSkuAndStoreId(modelSku, storeId);
            goodsDtoList = this.mapperFacade.mapAsList((Iterable)providerProductFashionList, ProviderGoodsDto.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return goodsDtoList;
    }

    @Transactional
    public BaseResponse<List<String>> preferredOrIsUpByThread(GoodsUpperAndLowerVo goodsUpperAndLowerVo) {
        String organizationCode = goodsUpperAndLowerVo.getGoodsUpperAndLowerQueryDto().getOrgCode();
        int pageSize = 10;
        int page = 0;
        int size = goodsUpperAndLowerVo.getGoodsUpperLowerDtos().size();
        if (size > 5000) {
            pageSize = size / 200;
        } else if (size > 2000) {
            pageSize = size / 100;
        } else if (size > 1000) {
            pageSize = size / 50;
        } else if (size < 10) {
            pageSize = 2;
        }
        int totalPage = size / pageSize;
        if (size % pageSize > 0) {
            ++totalPage;
        }
        ArrayList<Future<List>> futures = new ArrayList<Future<List>>();
        while (page < totalPage) {
            int startIndex = pageSize * page;
            int endIndexTemp = pageSize * (page + 1);
            if (endIndexTemp > size) {
                endIndexTemp = size;
            }
            int endIndex = endIndexTemp;
            try {
                log.info(" skuIndex === {} === {} ", (Object)startIndex, (Object)endIndex);
                Future<List> future = this.preferExecutorService.submit(() -> {
                    BaseResponse isUpResponse;
                    Boolean isPreferred = null;
                    Boolean isUp = null;
                    if (goodsUpperAndLowerVo.getOpertionCode().equals(ISPREFERRED)) {
                        isPreferred = true;
                    } else if (goodsUpperAndLowerVo.getOpertionCode().equals(DISPREFERRED)) {
                        isPreferred = false;
                    } else if (goodsUpperAndLowerVo.getOpertionCode().equals(ISUP)) {
                        isUp = true;
                    } else if (goodsUpperAndLowerVo.getOpertionCode().equals(DISUP)) {
                        isUp = false;
                    } else {
                        throw new RuntimeException("\u6ca1\u6709\u8981\u6267\u884c\u7684\u64cd\u4f5c");
                    }
                    if (isPreferred != null) {
                        BaseResponse preferredaseResponse = this.preferenceAndUpperShelvesImpl.preferredImpl(goodsUpperAndLowerVo.getGoodsUpperLowerDtos().subList(startIndex, endIndex), isPreferred.booleanValue(), organizationCode);
                        if (!Lang.isEmpty((Object)preferredaseResponse.getResult())) {
                            return (List)preferredaseResponse.getResult();
                        }
                    } else if (isUp != null && !Lang.isEmpty((Object)(isUpResponse = this.preferenceAndUpperShelvesImpl.goodsUpOrNot(goodsUpperAndLowerVo.getGoodsUpperLowerDtos().subList(startIndex, endIndex), isUp.booleanValue(), organizationCode)).getResult())) {
                        return (List)isUpResponse.getResult();
                    }
                    return null;
                });
                futures.add(future);
            }
            catch (Exception e) {
                log.error("\u591a\u7ebf\u7a0b\u5904\u7406\u5546\u54c1\u5f02\u5e38", (Throwable)e);
            }
            ++page;
        }
        ArrayList result = new ArrayList();
        for (int t = 0; t < futures.size(); ++t) {
            try {
                List list = (List)((Future)futures.get(t)).get();
                if (Lang.isEmpty((Object)list)) continue;
                result.addAll(list);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        if (size == result.size()) {
            if (size == 1) {
                return new BaseResponse(false, "\u5931\u8d25", result, ONE);
            }
            return new BaseResponse(false, "\u5168\u90e8\u5931\u8d25", result, ZERO);
        }
        if (!Lang.isEmpty(result)) {
            if (size == 1) {
                return new BaseResponse(true, "\u64cd\u4f5c\u7ed3\u675f", result, ONE);
            }
            return new BaseResponse(true, "\u64cd\u4f5c\u7ed3\u675f", result, ZERO);
        }
        if (size == 1) {
            return new BaseResponse(true, "\u6ca1\u6709\u8fd4\u56de\u5931\u8d25\u7684SKU,\u5168\u90e8\u6210\u529f", (Object)"", ONE);
        }
        return new BaseResponse(true, "\u6ca1\u6709\u8fd4\u56de\u5931\u8d25\u7684SKU,\u5168\u90e8\u6210\u529f", (Object)"", ZERO);
    }

    @Transactional
    public List<ProviderGoodsDto> findByModelSkuAndStoreIdAndIsDelete(String modelSku, String storeId, Boolean isDelete) {
        List providerProductFashionList = this.providerProductFashionRepos.findAll((Specification)new /* Unavailable Anonymous Inner Class!! */);
        List providerGoodsDtoList = this.mapperFacade.mapAsList((Iterable)providerProductFashionList, ProviderGoodsDto.class);
        return providerGoodsDtoList;
    }

    public void updateBrandInfo(String id, String brandName, String brandId) {
        this.providerProductFashionRepos.updateBrandInfo(id, brandName, brandId);
    }

    public BaseResponse saveProviderProduct(ProductModelDto productModel, List<ProviderGoodsDto> providerGoodsDtos) {
        log.info("\u7b2c\u4e09\u65b9\u4f9b\u5e94\u5546\u5bf9\u63a5\u63a5\u53e3\uff0c\u4fdd\u5b58\u5546\u54c1\u63a5\u53e3\u8f93\u5165\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(providerGoodsDtos, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        BaseResponse baseResponse = new BaseResponse();
        BaseResponse productModelDtoResponse = null;
        String modelSku = productModel.getModelSku();
        Boolean saveModelFlag = true;
        try {
            if (Lang.isEmpty((Object)productModel.getModelSku())) {
                modelSku = this.sequenceUtil.getOrderNo("sku");
                productModel.setModelSku(modelSku);
                productModel.setModelId(null);
                productModelDtoResponse = this.productModelService.saveModel(productModel);
                saveModelFlag = productModelDtoResponse.isSuccess() && "0000".equals(productModelDtoResponse.getResultCode());
                if (!saveModelFlag.booleanValue()) {
                    return productModelDtoResponse;
                }
            }
            if (saveModelFlag.booleanValue()) {
                for (ProviderGoodsDto providerGoods : providerGoodsDtos) {
                    providerGoods.setModelSku(modelSku);
                    if (Lang.isEmpty((Object)providerGoods.getSku())) {
                        String sku = this.sequenceUtil.getOrderNo("sku");
                        providerGoods.setSku(sku);
                        providerGoods.setStatus(String.valueOf(ProviderProductFashionStatusEnum.up.getCode()));
                    }
                    providerGoods.setBrandId(productModel.getBrandId());
                    providerGoods.setStatus(String.valueOf(ProviderProductFashionStatusEnum.dwon.getCode()));
                    providerGoods.setStoreId(productModel.getStoreId());
                }
            }
        }
        catch (InterruptedException e) {
            log.error("\u6dfb\u52a0\u4ea7\u54c1\u65f6\u62a5\u9519,storeId:{}\uff1a", (Object)productModel.getStoreId());
            throw new RuntimeException(e);
        }
        for (ProviderGoodsDto providerGoodsDto : providerGoodsDtos) {
            BaseResponse simple = this.saveProviderGoods(providerGoodsDto);
            if ("0000".equals(simple.getResultCode()) && simple.isSuccess()) continue;
            throw new RuntimeException("\u6279\u91cf\u4fdd\u5b58\u5546\u54c1\u9519\u8bef\uff0c\u5546\u54c1" + providerGoodsDto.getSku() + ",\u9519\u8bef\u4fe1\u606f\uff1a" + simple.getResultMessage());
        }
        baseResponse.setResultCode("0000");
        baseResponse.setSuccess(true);
        baseResponse.setResultMessage("\u64cd\u4f5c\u6210\u529f");
        baseResponse.setResult((Object)"");
        return baseResponse;
    }

    @Transactional
    public BaseResponse<List<ProviderGoodsDto>> updateProviderProduct(UpdateProviderGoodsVo updateProviderGoodsVo) {
        BaseResponse baseResponse = new BaseResponse();
        BaseResponse productModelDtoResponse = this.productModelService.updateModel(updateProviderGoodsVo.getProductModel());
        try {
            if (productModelDtoResponse.isSuccess() && "0000".equals(productModelDtoResponse.getResultCode())) {
                BaseResponse saveResponse;
                ArrayList<ProviderGoodsDto> addGoodsList = new ArrayList<ProviderGoodsDto>();
                ArrayList<ProviderGoodsDto> updateGoodsList = new ArrayList<ProviderGoodsDto>();
                for (ProviderGoodsDto goods : updateProviderGoodsVo.getUpdate()) {
                    goods.setModelSku(updateProviderGoodsVo.getProductModel().getModelSku());
                    goods.setStoreId(updateProviderGoodsVo.getProductModel().getStoreId());
                    if (Lang.isEmpty((Object)goods.getSku())) {
                        String sku = this.sequenceUtil.getOrderNo("sku");
                        goods.setSku(sku);
                        addGoodsList.add(goods);
                        continue;
                    }
                    updateGoodsList.add(goods);
                }
                if (!(Lang.isEmpty(addGoodsList) || "0000".equals((saveResponse = this.saveProviderProduct(updateProviderGoodsVo.getProductModel(), addGoodsList)).getResultCode()) && saveResponse.isSuccess())) {
                    throw new RuntimeException("\u66f4\u65b0\u5546\u54c1\u6dfb\u52a0\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a " + saveResponse.getResultMessage());
                }
                saveResponse = updateGoodsList.iterator();
                while (saveResponse.hasNext()) {
                    ProviderGoodsDto providerGoodsDto = (ProviderGoodsDto)saveResponse.next();
                    BaseResponse simple = this.updateProviderGoods(providerGoodsDto);
                    if ("0000".equals(simple.getResultCode()) && simple.isSuccess()) continue;
                    throw new RuntimeException("\u66f4\u65b0\u5546\u54c1\u9519\u8bef\uff0c\u5546\u54c1" + providerGoodsDto.getSku() + ",\u9519\u8bef\u4fe1\u606f\uff1a" + simple.getResultMessage());
                }
                if (!(Lang.isEmpty((Object)updateProviderGoodsVo.getDel()) || "0000".equals((saveResponse = this.deleteProviderGoodsBatch(updateProviderGoodsVo.getDel(), updateProviderGoodsVo.getStoreId())).getResultCode()) && saveResponse.isSuccess())) {
                    throw new RuntimeException("\u66f4\u65b0\u5546\u54c1\u5220\u9664\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a " + saveResponse.getResultMessage());
                }
                baseResponse.setResultCode("0000");
                baseResponse.setSuccess(true);
                baseResponse.setResultMessage("\u64cd\u4f5c\u6210\u529f");
                baseResponse.setResult((Object)"");
                return baseResponse;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        baseResponse.setResultCode(productModelDtoResponse.getResultCode());
        baseResponse.setSuccess(true);
        baseResponse.setResultMessage(productModelDtoResponse.getResultMessage());
        baseResponse.setResult(null);
        return baseResponse;
    }
}

