/*
 * Decompiled with CFR 0.152.
 */
package pool.service.service;

import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import store.api.StoreApi;
import store.api.dto.modeldto.core.StoreDto;

@Service
public class StoreService {
    private static final Logger log = LoggerFactory.getLogger(StoreService.class);
    private static String storeCacheKey = "STORE_CACHE";
    private static String storeIdCacheKey = "STORE_ID_CACHE";
    @Autowired
    RedisTemplate redisTemplate;
    @MotanReferer
    StoreApi storeApi;

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public StoreDto getStoreByCode(String storeCode) {
        BoundValueOperations storeCacheOperations = this.redisTemplate.boundValueOps((Object)(storeCacheKey + ":code:" + storeCode));
        if (storeCacheOperations.get() != null) {
            return (StoreDto)JSON.parseObject((String)((String)storeCacheOperations.get()), StoreDto.class);
        }
        StoreDto storeDto = this.storeApi.findByCode(storeCode);
        storeCacheOperations.set((Object)JSON.toJSONString((Object)storeDto), 1L, TimeUnit.HOURS);
        return storeDto;
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public StoreDto getStoreByStoreId(String storeId) {
        BoundValueOperations storeCacheOperations = this.redisTemplate.boundValueOps((Object)(storeIdCacheKey + ":storeId:" + storeId));
        if (storeCacheOperations.get() != null) {
            return (StoreDto)JSON.parseObject((String)((String)storeCacheOperations.get()), StoreDto.class);
        }
        StoreDto storeDto = this.storeApi.findByStoreId(storeId);
        if (storeDto != null) {
            storeCacheOperations.set((Object)JSON.toJSONString((Object)storeDto), 1L, TimeUnit.HOURS);
        }
        return storeDto;
    }
}

