/*
 * Decompiled with CFR 0.152.
 */
package com.qianpin.common.core.cache;

import com.danga.MemCached.MemCachedClient;
import com.danga.MemCached.SockIOPool;
import com.qianpin.common.utils.PropertiesReader;
import com.qianpin.common.utils.StringUtils;
import java.util.Date;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MemCached {
    private static Log log = LogFactory.getLog(MemCached.class);
    private static MemCachedClient mcc = new MemCachedClient();
    private static String servers = PropertiesReader.getValue("memcache", "servers");
    private static int defaultTime = 86400;
    private static int retry = 3;

    static {
        if (StringUtils.isBlank(servers)) {
            throw new NullArgumentException("memcache property servers is not null");
        }
        SockIOPool pool = SockIOPool.getInstance();
        pool.setServers(servers.split(" +"));
        pool.setInitConn(5);
        pool.setMinConn(5);
        pool.setMaxConn(250);
        pool.setMaxIdle(21600000L);
        pool.setMaintSleep(0L);
        pool.setNagle(false);
        pool.setSocketTO(3000);
        pool.setSocketConnectTO(0);
        pool.setHashingAlg(3);
        pool.setAliveCheck(false);
        pool.setFailback(true);
        pool.setFailover(false);
        pool.initialize();
    }

    public static void set(String key, Object value) {
        MemCached.set(key, value, defaultTime);
    }

    public static void set(String key, Object value, int expiry) {
        if (StringUtils.isBlank(key)) {
            throw new NullArgumentException("key is not null");
        }
        long l = expiry > 0 ? System.currentTimeMillis() + (long)(expiry * 1000) : 0L;
        boolean _result = false;
        try {
            int i = 1;
            while (i <= retry) {
                _result = mcc.set(key, value, new Date(l));
                if (!_result) {
                    log.error((Object)("[FAIL] set obj[key:" + key + " value:" + value.getClass() + " expiry:" + expiry + "] to cache failed begin to retry " + i + " times"));
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            log.error((Object)("[EXCEPTION] set obj[key:" + key + " value:" + value.getClass() + " expiry:" + expiry + "] to cache exception"));
            e.printStackTrace();
        }
    }

    public static Object get(String key) {
        if (StringUtils.isBlank(key)) {
            throw new NullArgumentException("key is not null");
        }
        Object _result = null;
        try {
            int i = 1;
            while (i <= retry) {
                _result = mcc.get(key);
                if (_result == null) {
                    log.error((Object)("[FAIL] get obj[key:" + key + "] failed from cache retry " + i + " times"));
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            _result = null;
            log.error((Object)("[EXCEPTION] get obj[key:" + key + "] exception from cache"));
            e.printStackTrace();
        }
        return _result;
    }

    public static void remove(String key) {
        Object object = MemCached.get(key);
        if (object == null) {
            return;
        }
        boolean _result = false;
        try {
            int i = 1;
            while (i <= retry) {
                _result = mcc.delete(key);
                if (!_result) {
                    log.error((Object)("[FAIL] remove obj[key:" + key + "] from cache failed begin to retry " + i + " times"));
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            _result = false;
            log.error((Object)("[EXCEPTION] remove obj[key:" + key + "] from cache exception"));
            e.printStackTrace();
        }
    }
}

