/*
 * Decompiled with CFR 0.152.
 */
package com.qianpin.common.core.cache.interceptor;

import com.qianpin.common.core.cache.MemCached;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.util.PatternMatchUtils;

public class CacheInterceptor
implements MethodInterceptor {
    private Map<String, String> attributeSource = new HashMap<String, String>();

    public Object invoke(MethodInvocation invocation) throws Throwable {
        String methodName = invocation.getMethod().getName();
        if (!methodName.toLowerCase().endsWith("cache")) {
            return invocation.proceed();
        }
        String bestNameMatch = null;
        for (String mappedName : this.attributeSource.keySet()) {
            if (!this.isMatch(methodName, mappedName) || bestNameMatch != null && bestNameMatch.length() > mappedName.length()) continue;
            bestNameMatch = mappedName;
        }
        String expiry = this.attributeSource.get(bestNameMatch);
        if ("-1".equals(expiry)) {
            return invocation.proceed();
        }
        String memKey = String.valueOf(invocation.getThis().getClass().getName()) + "." + invocation.getMethod().getName() + "." + CacheInterceptor.argsHashCode(invocation.getArguments());
        Object result = MemCached.get(memKey);
        if (result != null) {
            return result;
        }
        result = invocation.proceed();
        MemCached.set(memKey, result, Integer.parseInt(expiry) * 60);
        return result;
    }

    public void setAttributes(Map<String, String> attributeSource) {
        this.attributeSource = attributeSource;
    }

    private boolean isMatch(String methodName, String mappedName) {
        return PatternMatchUtils.simpleMatch((String)mappedName, (String)methodName);
    }

    private static int argsHashCode(Object[] arguments) {
        if (arguments == null || arguments.length == 0) {
            return 0;
        }
        StringBuilder md5Strs = new StringBuilder();
        Object[] objectArray = arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object != null) {
                md5Strs.append(object.toString());
            }
            md5Strs.append("|");
            ++n2;
        }
        return md5Strs.toString().hashCode();
    }
}

