/*
 * Decompiled with CFR 0.152.
 */
package com.qianpin.common.core.connection.interceptor;

import com.qianpin.common.core.connection.source.DataSourceKey;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.util.PatternMatchUtils;

public class DataSourceInterceptor
implements MethodInterceptor {
    private Map<String, String> attributeSource = new HashMap<String, String>();
    private DataSourceKey dataSourceKey;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        String methodName = invocation.getMethod().getName();
        String bestNameMatch = null;
        for (String mappedName : this.attributeSource.keySet()) {
            if (!this.isMatch(methodName, mappedName) || bestNameMatch != null && bestNameMatch.length() > mappedName.length()) continue;
            bestNameMatch = mappedName;
        }
        String key = this.attributeSource.get(bestNameMatch);
        if ("READ".equalsIgnoreCase(key)) {
            this.dataSourceKey.setReadKey();
        } else if ("WRITE".equalsIgnoreCase(key)) {
            this.dataSourceKey.setWriteKey();
        } else {
            this.dataSourceKey.setKey(key);
        }
        return invocation.proceed();
    }

    public void setAttributes(Map<String, String> attributeSource) {
        this.attributeSource = attributeSource;
    }

    private boolean isMatch(String methodName, String mappedName) {
        return PatternMatchUtils.simpleMatch((String)mappedName, (String)methodName);
    }

    public DataSourceKey getDataSourceKey() {
        return this.dataSourceKey;
    }

    public void setDataSourceKey(DataSourceKey dataSourceKey) {
        this.dataSourceKey = dataSourceKey;
    }
}

