/*
 * Decompiled with CFR 0.152.
 */
package com.qianpin.common.core.connection.source.impl;

import com.qianpin.common.core.connection.source.DataSourceKey;
import com.qianpin.common.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;

public class DataSourceKeyImpl
implements DataSourceKey,
InitializingBean {
    private static final Logger log = Logger.getLogger(DataSourceKeyImpl.class);
    private static final ThreadLocal<String> DB_KEY = new ThreadLocal();
    private Map<String, String> readDateSourceMap = new ConcurrentHashMap<String, String>();
    public String writeKey;
    private final Random random = new Random();
    private List<String> dateSourceReadKeys = Collections.synchronizedList(new ArrayList());

    @Override
    public void setReadDateSourceMap(Map<String, String> readDateSourceMap) {
        this.readDateSourceMap = Collections.synchronizedMap(readDateSourceMap);
        this.dateSourceReadKeys = Collections.synchronizedList(new ArrayList<String>(readDateSourceMap.values()));
    }

    @Override
    public String getKey(String key) {
        return this.readDateSourceMap.get(key);
    }

    @Override
    public String getWriteKey() {
        return this.writeKey;
    }

    @Override
    public void setWriteKey(String writeKey) {
        this.writeKey = writeKey;
    }

    @Override
    public void setWriteKey() {
        DB_KEY.set(this.writeKey);
        log.debug((Object)("set data source writeKey[" + DB_KEY.get() + "]"));
    }

    @Override
    public void setReadKey() {
        DB_KEY.set(this.getRandomKey());
        log.debug((Object)("set data source readKey[" + DB_KEY.get() + "]"));
    }

    @Override
    public void setKey(String key) {
        if (StringUtils.isBlank(key) || StringUtils.isBlank(this.readDateSourceMap.get(key))) {
            throw new RuntimeException("the data source key is null");
        }
        DB_KEY.set(this.readDateSourceMap.get(key));
        log.debug((Object)("set data source key[" + DB_KEY.get() + "]"));
    }

    @Override
    public String getKey() {
        if (DB_KEY.get() == null) {
            this.setReadKey();
        }
        String key = DB_KEY.get();
        log.debug((Object)("get data source Key[" + DB_KEY.get() + "]"));
        return key;
    }

    private String getRandomKey() {
        int randomInt = this.random.nextInt(this.readDateSourceMap.values().size());
        return this.dateSourceReadKeys.get(randomInt);
    }

    @Override
    public void clearKey() {
        DB_KEY.remove();
    }

    public static void clearKeyForce() {
        DB_KEY.remove();
    }

    public void afterPropertiesSet() throws Exception {
    }
}

