/*
 * Decompiled with CFR 0.152.
 */
package com.qianpin.common.core.filter;

import com.qianpin.common.core.cache.MemCached;
import com.qianpin.common.user.entity.LoginUser;
import com.qianpin.common.utils.ObjectUtils;
import com.qianpin.common.utils.StringUtils;
import com.qianpin.common.utils.UrlUtils;
import com.qianpin.common.utils.WebUtils;
import com.qianpin.common.utils.security.SecurityTool;
import java.io.IOException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class AuthFilter
implements Filter {
    private static Logger log = Logger.getLogger(AuthFilter.class);
    private String forbidden = "/jsp/forbidden.html";
    private SortedSet<String> excludePathv;

    public void destroy() {
    }

    public void doFilter(ServletRequest arg0, ServletResponse arg1, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)arg0;
        HttpServletResponse response = (HttpServletResponse)arg1;
        String path = String.valueOf(request.getContextPath()) + request.getServletPath();
        if (request.getParameter("method") != null) {
            path = String.valueOf(path) + "?method=" + request.getParameter("method");
        }
        String ip = WebUtils.getIpAddr(request);
        if (UrlUtils.urlMatch(this.excludePathv, path)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String ucid = SecurityTool.decrypt(WebUtils.getCookieValue("QP_COMMONS_UCID", request));
        LoginUser user = (LoginUser)MemCached.get("QP_COMMONS_USER_" + ucid);
        Set<String> urls = user.getAuthvalues();
        boolean canExecute = false;
        if (!ObjectUtils.isNull(urls)) {
            TreeSet<String> dirtySet = new TreeSet<String>();
            for (String url : urls) {
                dirtySet.add(String.valueOf(url) + "*");
            }
            canExecute = UrlUtils.urlMatch(dirtySet, path);
        }
        if (canExecute) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            log.info((Object)("############################ip[" + ip + "],user[" + ucid + "],path[" + path + "],forbidden################################"));
            response.sendRedirect(String.valueOf(request.getContextPath()) + this.forbidden);
        }
    }

    public void init(FilterConfig arg0) throws ServletException {
        this.excludePathv = new TreeSet<String>();
        String excludePath = arg0.getInitParameter("excludePath");
        String contextPath = arg0.getServletContext().getContextPath();
        if (!StringUtils.isBlank(excludePath)) {
            String[] paths;
            String[] stringArray = paths = excludePath.split(";");
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                String p = stringArray[n2];
                if (!StringUtils.isBlank(p)) {
                    this.excludePathv.add(String.valueOf(contextPath) + p);
                }
                ++n2;
            }
        }
    }
}

