/*
 * Decompiled with CFR 0.152.
 */
package com.qianpin.common.core.filter;

import com.qianpin.common.core.cache.MemCached;
import com.qianpin.common.user.entity.LoginUser;
import com.qianpin.common.user.service.UserService;
import com.qianpin.common.utils.AppUtils;
import com.qianpin.common.utils.ObjectUtils;
import com.qianpin.common.utils.PropertiesReader;
import com.qianpin.common.utils.StringUtils;
import com.qianpin.common.utils.UrlUtils;
import com.qianpin.common.utils.WebUtils;
import com.qianpin.common.utils.enums.UserStatus;
import com.qianpin.common.utils.security.SecurityTool;
import java.io.IOException;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class LoginFilter
implements Filter {
    private static Logger log = Logger.getLogger(LoginFilter.class);
    private SortedSet<String> excludePathv;
    private String excludePath;
    private String index = String.valueOf(PropertiesReader.getValue("project", "platform_path")) + "/jsp/login.jsp";

    public void destroy() {
    }

    public void doFilter(ServletRequest arg0, ServletResponse arg1, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)arg0;
        HttpServletResponse response = (HttpServletResponse)arg1;
        String ip = WebUtils.getIpAddr(request);
        String path = request.getServletPath();
        if (request.getParameter("method") != null) {
            path = String.valueOf(path) + "?method=" + request.getParameter("method");
        }
        log.info((Object)("ip[" + ip + "],path[" + request.getContextPath() + path + "]"));
        if (UrlUtils.urlMatch(this.excludePathv, path)) {
            chain.doFilter(arg0, arg1);
            return;
        }
        String ucid = SecurityTool.decrypt(WebUtils.getCookieValue("QP_COMMONS_UCID", request));
        String ucname = SecurityTool.decrypt(WebUtils.getCookieValue("QP_COMMONS_UCNAME", request));
        String pwd = SecurityTool.decrypt(WebUtils.getCookieValue("QP_COMMONS_PWD", request));
        if (StringUtils.isBlank(ucid)) {
            response.sendRedirect(this.index);
            return;
        }
        LoginUser user = (LoginUser)MemCached.get("QP_COMMONS_USER_" + ucid);
        if (ObjectUtils.isNull(user)) {
            UserService userService = (UserService)AppUtils.getBean("userService");
            try {
                Long result = userService.login(ucname, pwd);
                if (result.compareTo(0L) != 1) {
                    response.sendRedirect(this.index);
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            MemCached.set("QP_COMMONS_USER_" + ucid, user);
            if (!(user.getUcname().equals(ucname) && user.getPasswd().equals(pwd) && UserStatus.NORMAL.equals((Object)user.getStatus()))) {
                response.sendRedirect(this.index);
                return;
            }
        }
        chain.doFilter(arg0, arg1);
    }

    public void init(FilterConfig arg0) throws ServletException {
        this.excludePathv = new TreeSet<String>();
        this.excludePath = arg0.getInitParameter("excludePath");
        if (!StringUtils.isBlank(this.excludePath)) {
            String[] paths;
            String[] stringArray = paths = this.excludePath.split(";");
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                String p = stringArray[n2];
                if (!StringUtils.isBlank(p)) {
                    this.excludePathv.add(p);
                }
                ++n2;
            }
        }
    }

    public SortedSet<String> getExcludePathv() {
        return this.excludePathv;
    }

    public void setExcludePathv(SortedSet<String> excludePathv) {
        this.excludePathv = excludePathv;
    }

    public String getExcludePath() {
        return this.excludePath;
    }

    public void setExcludePath(String excludePath) {
        this.excludePath = excludePath;
    }
}

