/*
 * Decompiled with CFR 0.152.
 */
package com.qianpin.common.dictionary.dao.impl;

import com.qianpin.common.core.connection.dao.impl.GenericDaoImpl;
import com.qianpin.common.dictionary.dao.DictionaryDao;
import com.qianpin.common.dictionary.entity.BankInfo;
import com.qianpin.common.dictionary.entity.Dictionary;
import com.qianpin.common.dictionary.entity.OfficeContractCode;
import com.qianpin.common.utils.ObjectUtils;
import com.qianpin.common.utils.StringUtils;
import com.qianpin.common.utils.enums.DicType;
import com.qianpin.common.utils.page.Pager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository(value="dicDao")
public class DictionaryDaoImpl
extends GenericDaoImpl<Dictionary, Long>
implements DictionaryDao {
    @Override
    public int queryCount(Map<String, String> condition) throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT COUNT(1) ");
        sql.append("FROM common_dictionary ");
        sql.append("WHERE 1 = 1 ");
        ArrayList<Object> list = new ArrayList<Object>();
        if (!StringUtils.isBlank(condition.get("dictype"))) {
            sql.append("AND dictype = ? ");
            list.add(condition.get("dictype"));
        }
        if (!StringUtils.isBlank(condition.get("pdicid"))) {
            sql.append("AND parentid = ? ");
            list.add(Long.parseLong(condition.get("pdicid")));
        }
        if (!StringUtils.isBlank(condition.get("dicid"))) {
            sql.append("AND dicid = ? ");
            list.add(Long.parseLong(condition.get("dicid")));
        }
        if (!StringUtils.isBlank(condition.get("delFlag"))) {
            sql.append("AND del_flag = 0 ");
        }
        return this.getSimpleJdbcTemplate().queryForInt(sql.toString(), list.toArray());
    }

    @Override
    public List<Dictionary> queryList(Map<String, String> condition, Pager ... pager) throws Exception {
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> list = new ArrayList<Object>();
        sql.append("SELECT dicid, dicname, dictype, parentid, del_flag ");
        sql.append("FROM common_dictionary ");
        sql.append("WHERE 1 = 1 ");
        if (!StringUtils.isBlank(condition.get("dictype"))) {
            sql.append("AND dictype = ? ");
            list.add(condition.get("dictype"));
        }
        if (!StringUtils.isBlank(condition.get("pdicid"))) {
            sql.append("AND parentid = ? ");
            list.add(Long.parseLong(condition.get("pdicid")));
        }
        if (!StringUtils.isBlank(condition.get("dicid"))) {
            sql.append("AND dicid = ? ");
            list.add(Long.parseLong(condition.get("dicid")));
        }
        if (!StringUtils.isBlank(condition.get("delFlag"))) {
            sql.append("AND del_flag = 0 ");
        }
        if (!ObjectUtils.isNull(pager)) {
            sql.append("LIMIT ?, ? ");
            list.add(pager[0].getStartRow());
            list.add(pager[0].getPageSize());
        }
        return this.getSimpleJdbcTemplate().query(sql.toString(), (RowMapper)new RowMapper<Dictionary>(){

            public Dictionary mapRow(ResultSet rs, int index) throws SQLException {
                Dictionary dic = new Dictionary();
                dic.setDicid(rs.getLong("dicid"));
                dic.setDicname(rs.getString("dicname"));
                dic.setParentid(rs.getLong("parentid"));
                dic.setDelFlag(rs.getLong("del_flag"));
                return dic;
            }
        }, list.toArray());
    }

    @Override
    public void addDictionary(final Dictionary dictionary) throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO common_dictionary ");
        sql.append("(dicid, dicname, dictype, parentid) ");
        sql.append("VALUES(?, ?, ?, ?) ");
        this.getJdbcTemplate().update(sql.toString(), new PreparedStatementSetter(){

            public void setValues(PreparedStatement pst) throws SQLException {
                pst.setLong(1, dictionary.getDicid());
                pst.setString(2, dictionary.getDicname());
                pst.setString(3, dictionary.getDictype().toString());
                pst.setLong(4, dictionary.getParentid());
            }
        });
    }

    @Override
    public int queryMaxId(DicType dicType) throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT MAX(dicid)  ");
        sql.append("FROM common_dictionary ");
        sql.append("WHERE dictype = ? FOR UPDATE");
        return this.getSimpleJdbcTemplate().queryForInt(sql.toString(), new Object[]{dicType.toString()});
    }

    @Override
    public void editDictionary(final Dictionary dictionary) throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE common_dictionary ");
        sql.append("SET dicname = ?, parentid = ?, del_flag = ? ");
        sql.append("WHERE dicid = ? ");
        this.getJdbcTemplate().update(sql.toString(), new PreparedStatementSetter(){

            public void setValues(PreparedStatement pst) throws SQLException {
                pst.setString(1, dictionary.getDicname());
                pst.setLong(2, dictionary.getParentid());
                pst.setLong(3, dictionary.getDelFlag());
                pst.setLong(4, dictionary.getDicid());
            }
        });
    }

    @Override
    public List<BankInfo> queryBankList(Map<String, String> condition, int ... type) throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT bank_id, bank_name, bank_province_id, bank_city_id, parentid ");
        sql.append("FROM crm_bank_info ");
        sql.append("WHERE 1 = 1 ");
        ArrayList<Object> list = new ArrayList<Object>();
        if (ObjectUtils.isNull(condition)) {
            sql.append("AND parentid = 0 ");
        } else {
            if (!StringUtils.isBlank(condition.get("pbankId"))) {
                sql.append("AND parentid = ? ");
                list.add(Long.parseLong(condition.get("pbankId")));
            }
            if (!StringUtils.isBlank(condition.get("provinceId"))) {
                sql.append("AND bank_province_id = ? ");
                list.add(Long.parseLong(condition.get("provinceId")));
            }
            if (!StringUtils.isBlank(condition.get("cityId"))) {
                sql.append("AND bank_city_id = ? ");
                list.add(Long.parseLong(condition.get("cityId")));
            }
            if (!StringUtils.isBlank(condition.get("branchName"))) {
                if (type.length == 0 || type[0] == 0) {
                    sql.append("AND bank_name LIKE ? ");
                    list.add(String.valueOf(condition.get("branchName")) + "%");
                } else if (type[0] == 1) {
                    sql.append("AND bank_name LIKE ? ");
                    list.add("%" + condition.get("branchName") + "%");
                    sql.append("LIMIT ? ");
                    list.add(Integer.parseInt(condition.get("len")));
                } else {
                    sql.append("AND bank_name = ? ");
                    list.add(condition.get("branchName"));
                }
            }
        }
        return this.getSimpleJdbcTemplate().query(sql.toString(), (RowMapper)new RowMapper<BankInfo>(){

            public BankInfo mapRow(ResultSet rs, int index) throws SQLException {
                BankInfo bi = new BankInfo();
                bi.setBankId(rs.getLong("bank_id"));
                bi.setBankName(rs.getString("bank_name"));
                bi.setBankProvinceId(rs.getLong("bank_province_id"));
                bi.setBankCityId(rs.getLong("bank_city_id"));
                bi.setParentid(rs.getLong("parentid"));
                return bi;
            }
        }, list.toArray());
    }

    @Override
    public BankInfo queryBankById(Long bankId) throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT bank_id, bank_name, bank_province_id, bank_city_id, parentid ");
        sql.append("FROM crm_bank_info ");
        sql.append("WHERE bank_id = ? ");
        List list = this.getSimpleJdbcTemplate().query(sql.toString(), (RowMapper)new RowMapper<BankInfo>(){

            public BankInfo mapRow(ResultSet rs, int index) throws SQLException {
                BankInfo bi = new BankInfo();
                bi.setBankId(rs.getLong("bank_id"));
                bi.setBankName(rs.getString("bank_name"));
                bi.setBankProvinceId(rs.getLong("bank_province_id"));
                bi.setBankCityId(rs.getLong("bank_city_id"));
                bi.setParentid(rs.getLong("parentid"));
                return bi;
            }
        }, new Object[]{bankId});
        if (ObjectUtils.isNull(list)) {
            return null;
        }
        return (BankInfo)list.get(0);
    }

    @Override
    public Map<Long, BankInfo> queryBankById(Set<Long> bankId) throws Exception {
        HashMap<Long, BankInfo> rsMap = new HashMap<Long, BankInfo>();
        if (ObjectUtils.isNull(bankId)) {
            return rsMap;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT bank_id, bank_name, bank_province_id, bank_city_id, parentid ");
        sql.append("FROM crm_bank_info ");
        sql.append("WHERE bank_id IN (").append(StringUtils.set2str(bankId, new String[0])).append(")");
        List list = this.getSimpleJdbcTemplate().query(sql.toString(), (RowMapper)new RowMapper<BankInfo>(){

            public BankInfo mapRow(ResultSet rs, int index) throws SQLException {
                BankInfo bi = new BankInfo();
                bi.setBankId(rs.getLong("bank_id"));
                bi.setBankName(rs.getString("bank_name"));
                bi.setBankProvinceId(rs.getLong("bank_province_id"));
                bi.setBankCityId(rs.getLong("bank_city_id"));
                bi.setParentid(rs.getLong("parentid"));
                return bi;
            }
        }, new Object[0]);
        if (ObjectUtils.isNull(list)) {
            return rsMap;
        }
        for (BankInfo bank : list) {
            rsMap.put(bank.getBankId(), bank);
        }
        return rsMap;
    }

    @Override
    public int queryContractCodeCount(Map<String, String> condition) throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        sql.append("COUNT(1) ");
        sql.append("FROM ");
        sql.append("uc_post_info t1 ");
        sql.append("LEFT JOIN ");
        sql.append("crm_office_contract_code t2 ");
        sql.append("ON ");
        sql.append("t1.postid = t2.officeid ");
        sql.append("WHERE ");
        sql.append("t1.office = 1 ");
        ArrayList<Object> list = new ArrayList<Object>();
        if (!StringUtils.isBlank(condition.get("officeIds"))) {
            sql.append("AND t1.postid IN (" + condition.get("officeIds") + ") ");
        }
        if (!StringUtils.isBlank(condition.get("officeId"))) {
            sql.append("AND t1.postid = ? ");
            list.add(Long.parseLong(condition.get("officeId")));
        }
        if (!StringUtils.isBlank(condition.get("officeName"))) {
            sql.append("AND t1.postname LIKE ? ");
            list.add(String.valueOf(condition.get("officeName")) + "%");
        }
        return this.getSimpleJdbcTemplate().queryForInt(sql.toString(), list.toArray());
    }

    @Override
    public List<OfficeContractCode> queryContractCodeList(Map<String, String> condition, Pager ... pager) throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        sql.append("t1.postid, t1.postname, t2.code, t2.fax ");
        sql.append("FROM ");
        sql.append("uc_post_info t1 ");
        sql.append("LEFT JOIN ");
        sql.append("crm_office_contract_code t2 ");
        sql.append("ON ");
        sql.append("t1.postid = t2.officeid ");
        sql.append("WHERE ");
        sql.append("t1.office = 1 ");
        ArrayList<Object> list = new ArrayList<Object>();
        if (!StringUtils.isBlank(condition.get("officeIds"))) {
            sql.append("AND t1.postid IN (" + condition.get("officeIds") + ") ");
        }
        if (!StringUtils.isBlank(condition.get("officeId"))) {
            sql.append("AND t1.postid = ? ");
            list.add(Long.parseLong(condition.get("officeId")));
        }
        if (!StringUtils.isBlank(condition.get("officeName"))) {
            sql.append("AND t1.postname LIKE ? ");
            list.add(String.valueOf(condition.get("officeName")) + "%");
        }
        if (!ObjectUtils.isNull(pager)) {
            sql.append("LIMIT ?, ? ");
            list.add(pager[0].getStartRow());
            list.add(pager[0].getPageSize());
        }
        return this.getSimpleJdbcTemplate().query(sql.toString(), (RowMapper)new RowMapper<OfficeContractCode>(){

            public OfficeContractCode mapRow(ResultSet rs, int index) throws SQLException {
                OfficeContractCode occ = new OfficeContractCode();
                occ.setOfficeid(rs.getLong("postid"));
                occ.setOfficeName(rs.getString("postname"));
                occ.setCode(rs.getString("code"));
                occ.setFax(rs.getString("fax"));
                return occ;
            }
        }, list.toArray());
    }

    @Override
    public OfficeContractCode queryOfficeContractCode(Long officeId) throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT officeid, code FROM crm_office_contract_code WHERE officeid = ? ");
        List list = this.getSimpleJdbcTemplate().query(sql.toString(), (RowMapper)new RowMapper<OfficeContractCode>(){

            public OfficeContractCode mapRow(ResultSet rs, int index) throws SQLException {
                OfficeContractCode occ = new OfficeContractCode();
                occ.setOfficeid(rs.getLong("officeid"));
                occ.setCode(rs.getString("code"));
                return occ;
            }
        }, new Object[]{officeId});
        if (ObjectUtils.isNull(list)) {
            return null;
        }
        return (OfficeContractCode)list.get(0);
    }

    @Override
    public void addOfficeContractCode(OfficeContractCode code) throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO crm_office_contract_code VALUES(?, ?, ?) ");
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(code.getOfficeid());
        list.add(code.getCode());
        list.add(code.getFax());
        this.getSimpleJdbcTemplate().update(sql.toString(), list.toArray());
    }

    @Override
    public void editOfficeContractCode(OfficeContractCode code) throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE crm_office_contract_code SET code = ?, fax = ? WHERE officeid = ? ");
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(code.getCode());
        list.add(code.getFax());
        list.add(code.getOfficeid());
        this.getSimpleJdbcTemplate().update(sql.toString(), list.toArray());
    }

    @Override
    public void remove(Long dicid) throws Exception {
        String sql = "UPDATE common_dictionary SET del_flag = 1 WHERE dicid = ? ";
        this.getSimpleJdbcTemplate().update(sql.toString(), new Object[]{dicid});
    }

    @Override
    public void removeChild(Long parentid) throws Exception {
        String sql = "UPDATE common_dictionary SET del_flag = 1 WHERE parentid = ? ";
        this.getSimpleJdbcTemplate().update(sql.toString(), new Object[]{parentid});
    }

    @Override
    public void active(Long dicid) {
        String sql = "UPDATE common_dictionary SET del_flag = 0 WHERE dicid = ? ";
        this.getSimpleJdbcTemplate().update(sql.toString(), new Object[]{dicid});
    }

    @Override
    public void activeChile(Long parentid) throws Exception {
        String sql = "UPDATE common_dictionary SET del_flag = 0 WHERE parentid = ? ";
        this.getSimpleJdbcTemplate().update(sql.toString(), new Object[]{parentid});
    }

    @Override
    public Dictionary dictionary(DicType dicType, String dicName) {
        StringBuilder sql = new StringBuilder("");
        sql.append("SELECT dicid, dicname, dictype, parentid, del_flag ");
        sql.append("FROM common_dictionary ");
        sql.append("WHERE dictype = ? AND dicname = ? ");
        List list = this.getSimpleJdbcTemplate().queryForList(sql.toString(), new Object[]{new RowMapper<Dictionary>(){

            public Dictionary mapRow(ResultSet rs, int i) throws SQLException {
                Dictionary dic = new Dictionary();
                dic.setDicid(rs.getLong("dicid"));
                dic.setDicname(rs.getString("dicname"));
                dic.setDictype(DicType.valueOf(rs.getString("dictype")));
                dic.setParentid(rs.getLong("parentid"));
                dic.setDelFlag(rs.getLong("del_flag"));
                return dic;
            }
        }, dicType.toString(), dicName});
        return ObjectUtils.isNull(list) ? null : (Dictionary)list.get(0);
    }
}

