/*
 * Decompiled with CFR 0.152.
 */
package com.qianpin.common.dictionary.service.impl;

import com.qianpin.common.dictionary.dao.DictionaryDao;
import com.qianpin.common.dictionary.entity.BankInfo;
import com.qianpin.common.dictionary.entity.Dictionary;
import com.qianpin.common.dictionary.entity.OfficeContractCode;
import com.qianpin.common.dictionary.service.DictionaryService;
import com.qianpin.common.user.entity.User;
import com.qianpin.common.user.service.UserService;
import com.qianpin.common.utils.ConstantDic;
import com.qianpin.common.utils.ConstantUser;
import com.qianpin.common.utils.ObjectUtils;
import com.qianpin.common.utils.StringUtils;
import com.qianpin.common.utils.enums.DicType;
import com.qianpin.common.utils.json.JsonUtils;
import com.qianpin.common.utils.page.Pager;
import com.qianpin.common.utils.security.SecurityTool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.NullArgumentException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="dicService")
public class DictionaryServiceImpl
implements DictionaryService {
    @Autowired
    DictionaryDao dicDao;
    @Autowired
    UserService userService;

    @Override
    public List<Dictionary> dictionary(DicType type, String ... filter) throws Exception {
        Map<Long, Dictionary> dictionary = null;
        switch (type) {
            case PROVINCE: {
                dictionary = ConstantDic.PROVINCE();
                break;
            }
            case CATEGORY_PARENT: {
                dictionary = ConstantDic.CATEGORY_PARENT();
                break;
            }
            case QUALIFICATION: {
                dictionary = ConstantDic.QUALIFICATION();
                break;
            }
            case GUESTINTENTION: {
                dictionary = ConstantDic.GUEST_INTENTION();
                break;
            }
            case CONTRACTREJECTEDCLASSIFICATION: {
                dictionary = ConstantDic.CONTRACTREJECTEDCLASSIFICATION();
                break;
            }
            case LABEL: {
                dictionary = ConstantDic.LABEL();
                break;
            }
            case CUISINE: {
                dictionary = ConstantDic.CUISINE();
            }
            case ENVIRONMENT: {
                dictionary = ConstantDic.ENVIRONMENT();
            }
            case RECEPTIONCAPACITY: {
                dictionary = ConstantDic.RECEPTIONCAPACITY();
            }
            case OTHERSERVICES: {
                dictionary = ConstantDic.OTHERSERVICES();
            }
            default: {
                throw new IllegalArgumentException("no match dictype(" + (Object)((Object)type) + ") dictionary");
            }
        }
        if (ObjectUtils.isNull(dictionary)) {
            return null;
        }
        ArrayList<Dictionary> list = new ArrayList<Dictionary>();
        for (Map.Entry<Long, Dictionary> entry : dictionary.entrySet()) {
            if (ObjectUtils.isNull(filter)) {
                if (entry.getValue().getDelFlag().compareTo(0L) != 0) continue;
                list.add(entry.getValue());
                continue;
            }
            list.add(entry.getValue());
        }
        return list;
    }

    @Override
    public List<Dictionary> dictionary(DicType type, Long parentId, String ... filter) throws Exception {
        if (ObjectUtils.isNull(parentId)) {
            throw new IllegalArgumentException("parentid is not null");
        }
        Map<Long, Dictionary> dictionary = null;
        switch (type) {
            case AREA: {
                dictionary = ConstantDic.AREA();
                break;
            }
            case DISTRICT: {
                dictionary = ConstantDic.DISTRICT();
                break;
            }
            case CATEGORY_CHILD: {
                dictionary = ConstantDic.CATEGORY_CHILD();
                break;
            }
            case CONTRACTREJECTEDREASONS: {
                dictionary = ConstantDic.CONTRACTREJECTEDREASONS();
                break;
            }
            default: {
                throw new IllegalArgumentException("no match dictype(" + (Object)((Object)type) + ") dictionary");
            }
        }
        if (ObjectUtils.isNull(dictionary)) {
            return null;
        }
        ArrayList<Dictionary> list = new ArrayList<Dictionary>();
        for (Map.Entry<Long, Dictionary> entry : dictionary.entrySet()) {
            if (ObjectUtils.isNull(filter)) {
                if (entry.getValue().getParentid().compareTo(parentId) != 0 || entry.getValue().getDelFlag().compareTo(0L) != 0) continue;
                list.add(entry.getValue());
                continue;
            }
            list.add(entry.getValue());
        }
        return list;
    }

    @Override
    public Dictionary dictionary(Long dicId) throws Exception {
        if (ObjectUtils.isNull(dicId)) {
            throw new NullArgumentException("dicId is not null");
        }
        HashMap<String, String> condition = new HashMap<String, String>();
        condition.put("dicid", dicId.toString());
        List<Dictionary> list = this.dicDao.queryList(condition, new Pager[0]);
        return ObjectUtils.isNull(list) ? null : list.get(0);
    }

    @Override
    public String city(Long provinceId, String filter) throws Exception {
        ArrayList<Dictionary> cityes;
        block4: {
            Map<Long, Dictionary> CITY = ConstantDic.CITY();
            cityes = new ArrayList<Dictionary>();
            if (ObjectUtils.isNull(CITY)) break block4;
            if ("district".equals(filter)) {
                Map<Long, Dictionary> AREA = ConstantDic.AREA();
                for (Map.Entry<Long, Dictionary> entry : AREA.entrySet()) {
                    Dictionary city = CITY.get(entry.getValue().getParentid());
                    if (cityes.contains(city) || city.getParentid().compareTo((long)provinceId) != 0) continue;
                    cityes.add(city);
                }
            } else {
                for (Map.Entry<Long, Dictionary> entry : CITY.entrySet()) {
                    if (entry.getValue().getParentid().compareTo((long)provinceId) != 0) continue;
                    cityes.add(entry.getValue());
                }
            }
        }
        return JsonUtils.list2Json(cityes, new String[0]);
    }

    @Override
    public String pbank() throws Exception {
        Map<Long, BankInfo> BANK_PARENT = ConstantDic.BANK_PARENT();
        ArrayList result = new ArrayList();
        for (Map.Entry<Long, BankInfo> entry : BANK_PARENT.entrySet()) {
            HashMap<String, String> map = new HashMap<String, String>();
            BankInfo bank = entry.getValue();
            map.put("bankId", bank.getBankId().toString());
            map.put("bankName", bank.getBankName());
            result.add(map);
        }
        return JsonUtils.list2Json(result, new String[0]);
    }

    @Override
    public String bankPro(Long pbankId) throws Exception {
        ArrayList<Dictionary> provinces = new ArrayList<Dictionary>();
        HashMap<String, String> condition = new HashMap<String, String>();
        condition.put("pbankId", pbankId.toString());
        List<BankInfo> bankList = this.dicDao.queryBankList(condition, new int[0]);
        Map<Long, Dictionary> PROVINCE = ConstantDic.PROVINCE();
        if (!ObjectUtils.isNull(PROVINCE)) {
            for (BankInfo bankInfo : bankList) {
                Dictionary province = PROVINCE.get(bankInfo.getBankProvinceId());
                if (provinces.contains(province)) continue;
                provinces.add(province);
            }
            Collections.sort(provinces, new Comparator<Dictionary>(){

                @Override
                public int compare(Dictionary o1, Dictionary o2) {
                    return o1.getDicid().compareTo(o2.getDicid());
                }
            });
        }
        return JsonUtils.list2Json(provinces, new String[0]);
    }

    @Override
    public String bankCity(Long pbankId, Long provinceId) throws Exception {
        ArrayList<Dictionary> cities = new ArrayList<Dictionary>();
        HashMap<String, String> condition = new HashMap<String, String>();
        condition.put("pbankId", pbankId.toString());
        condition.put("provinceId", provinceId.toString());
        List<BankInfo> bankList = this.dicDao.queryBankList(condition, new int[0]);
        Map<Long, Dictionary> CITY = ConstantDic.CITY();
        if (!ObjectUtils.isNull(CITY)) {
            for (BankInfo bankInfo : bankList) {
                Dictionary city = CITY.get(bankInfo.getBankCityId());
                if (cities.contains(city)) continue;
                cities.add(city);
            }
            Collections.sort(cities, new Comparator<Dictionary>(){

                @Override
                public int compare(Dictionary o1, Dictionary o2) {
                    return o1.getDicid().compareTo(o2.getDicid());
                }
            });
        }
        return JsonUtils.list2Json(cities, new String[0]);
    }

    @Override
    public String bankBranch(Long pbankId, Long provinceId, Long cityId, final String branchName) throws Exception {
        HashMap<String, String> condition = new HashMap<String, String>();
        condition.put("pbankId", pbankId.toString());
        condition.put("provinceId", provinceId.toString());
        condition.put("cityId", cityId.toString());
        condition.put("branchName", branchName);
        int len = 7;
        condition.put("len", String.valueOf(len));
        HashSet<BankInfo> set = new HashSet<BankInfo>();
        List<BankInfo> list_full = this.dicDao.queryBankList(condition, 2);
        set.addAll(list_full);
        if (set.size() < len) {
            List<BankInfo> list_front = this.dicDao.queryBankList(condition, 0);
            set.addAll(list_front);
        }
        if (set.size() < len) {
            List<BankInfo> list_fuzzy = this.dicDao.queryBankList(condition, 1);
            set.addAll(list_fuzzy);
        }
        if (ObjectUtils.isNull(set)) {
            return "";
        }
        List list = new ArrayList(set);
        Collections.sort(list, new Comparator<BankInfo>(){

            @Override
            public int compare(BankInfo o1, BankInfo o2) {
                if (branchName.equals(o1.getBankName())) {
                    return -1;
                }
                if (branchName.equalsIgnoreCase(o1.getBankName())) {
                    return -1;
                }
                if (o1.getBankName().indexOf(branchName) < o2.getBankName().indexOf(branchName)) {
                    return -1;
                }
                return 1;
            }
        });
        if (list.size() > len) {
            list = list.subList(0, len);
        }
        ArrayList result = new ArrayList();
        for (BankInfo bank : list) {
            HashMap<String, String> jsonMap = new HashMap<String, String>();
            jsonMap.put("bankId", bank.getBankId().toString());
            jsonMap.put("bankName", bank.getBankName());
            result.add(jsonMap);
        }
        return JsonUtils.list2Json(result, new String[0]);
    }

    @Override
    public Map<Long, BankInfo> queryBankById(Set<Long> bankId) throws Exception {
        if (ObjectUtils.isNull(bankId)) {
            return new HashMap<Long, BankInfo>();
        }
        return this.dicDao.queryBankById(bankId);
    }

    @Override
    public String queryList(Map<String, String> condition, int cpage) throws Exception {
        int total = this.dicDao.queryCount(condition);
        Pager pager = new Pager(total, cpage, new String[0]);
        List<Dictionary> list = null;
        if (total > 0) {
            list = this.dicDao.queryList(condition, pager);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("pager", pager.getPageJson());
        result.put("list", list);
        return JsonUtils.map2Json(result, new String[0]);
    }

    @Override
    public String queryListR(Map<String, String> condition, int cpage) throws Exception {
        int total = this.dicDao.queryCount(condition);
        Pager pager = new Pager(total, cpage, new String[0]);
        List<Dictionary> list = null;
        ArrayList resonList = null;
        if (total > 0) {
            resonList = new ArrayList();
            Map<Long, Dictionary> dictionaryMap = null;
            if (DicType.CONTRACTREJECTEDREASONS.toString().equals(condition.get("dictype"))) {
                dictionaryMap = ConstantDic.CONTRACTREJECTEDCLASSIFICATION();
            }
            list = this.dicDao.queryList(condition, pager);
            for (Dictionary dictionary : list) {
                Dictionary pdic = dictionaryMap.get(dictionary.getParentid());
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("dicid", dictionary.getDicid());
                map.put("dicname", dictionary.getDicname());
                map.put("pdicid", pdic.getDicid());
                map.put("pdicname", pdic.getDicname());
                resonList.add(map);
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("pager", pager.getPageJson());
        result.put("list", resonList);
        return JsonUtils.map2Json(result, new String[0]);
    }

    @Override
    public void edit(Dictionary dictionary) throws Exception {
        if (ObjectUtils.isNull(dictionary.getDicid())) {
            int maxid = this.dicDao.queryMaxId(dictionary.getDictype());
            dictionary.setDicid(new Long(maxid + 1));
            this.dicDao.addDictionary(dictionary);
        } else {
            this.dicDao.editDictionary(dictionary);
        }
    }

    @Override
    public String contractCodeList(Map<String, String> condition, int cpage) throws Exception {
        if (StringUtils.isBlank(condition.get("ucid"))) {
            throw new NullArgumentException("ucid");
        }
        Long ucid = Long.parseLong(condition.get("ucid"));
        User user = this.userService.queryById(ucid);
        Iterator<Long> iterator = user.getPostids().iterator();
        Long postid = 0L;
        if (iterator.hasNext()) {
            postid = iterator.next();
        }
        if (ObjectUtils.isNull(postid)) {
            throw new NullArgumentException("user(" + ucid + ") has not post");
        }
        Long officeId = ConstantUser.getBranchOffice(postid);
        if (ObjectUtils.isNull(officeId)) {
            List<Long> chilePost = ConstantUser.getChilePost(postid);
            Iterator<Long> it = chilePost.iterator();
            while (it.hasNext()) {
                Long child = it.next();
                if (!ObjectUtils.isNull(ConstantUser.OFFICE(child))) continue;
                it.remove();
            }
            condition.put("officeIds", StringUtils.list2str(chilePost, new String[0]));
        } else {
            condition.put("officeId", officeId.toString());
        }
        int total = this.dicDao.queryContractCodeCount(condition);
        Pager pager = new Pager(total, cpage, new String[0]);
        List<OfficeContractCode> list = null;
        if (total > 0) {
            list = this.dicDao.queryContractCodeList(condition, pager);
            for (OfficeContractCode code : list) {
                code.setEncryptOfficeId(SecurityTool.encryptValue(code.getOfficeid(), ucid.toString()));
                code.setOfficeid(0L);
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("pager", pager.getPageJson());
        result.put("list", list);
        return JsonUtils.map2Json(result, new String[0]);
    }

    @Override
    public void edit(OfficeContractCode code) throws Exception {
        OfficeContractCode occ = this.dicDao.queryOfficeContractCode(code.getOfficeid());
        if (ObjectUtils.isNull(occ)) {
            this.dicDao.addOfficeContractCode(code);
        } else {
            this.dicDao.editOfficeContractCode(code);
        }
    }

    @Override
    public void remove(DicType type, Long dicid) throws Exception {
        this.dicDao.remove(dicid);
        this.dicDao.removeChild(dicid);
    }

    @Override
    public void reset(Long dicid) throws Exception {
        this.dicDao.active(dicid);
    }
}

