/*
 * Decompiled with CFR 0.152.
 */
package com.qianpin.common.user.dao.impl;

import com.qianpin.common.core.connection.dao.impl.GenericDaoImpl;
import com.qianpin.common.user.dao.UserDao;
import com.qianpin.common.user.entity.AuthInfo;
import com.qianpin.common.user.entity.PostChange;
import com.qianpin.common.user.entity.PostInfo;
import com.qianpin.common.user.entity.RoleInfo;
import com.qianpin.common.user.entity.User;
import com.qianpin.common.user.entity.UserInfo;
import com.qianpin.common.user.entity.UserPostMap;
import com.qianpin.common.utils.ConstantUser;
import com.qianpin.common.utils.ObjectUtils;
import com.qianpin.common.utils.StringUtils;
import com.qianpin.common.utils.enums.Gender;
import com.qianpin.common.utils.enums.UserStatus;
import com.qianpin.common.utils.page.Pager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Repository;

@Repository(value="userDao")
public class UserDaoimpl
extends GenericDaoImpl<User, Long>
implements UserDao {
    @Override
    public Long addUser(final User user) throws Exception {
        final StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO uc_user ");
        sql.append("(ucname, passwd, status) ");
        sql.append("VALUES(?, ?, ?) ");
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        this.getJdbcTemplate().update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                PreparedStatement pst = con.prepareStatement(sql.toString(), new String[]{"ucname", "passwd", "status"});
                pst.setString(1, user.getUcname());
                pst.setString(2, user.getPasswd());
                pst.setString(3, user.getStatus().toString());
                return pst;
            }
        }, (KeyHolder)keyHolder);
        return keyHolder.getKey().longValue();
    }

    @Override
    public void addUserInfo(UserInfo userInfo) throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO uc_user_info ");
        sql.append("(");
        sql.append("ucid, realname, sex, birthday, email, plane, phone,  ");
        sql.append("entrytime, leavetime, updatetime, updateucid, regtime, regucid");
        sql.append(") ");
        sql.append("VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(userInfo.getUcid());
        list.add(userInfo.getRealname());
        list.add(userInfo.getSex().toString());
        list.add(userInfo.getBirthday());
        list.add(userInfo.getEmail());
        list.add(userInfo.getPlane());
        list.add(userInfo.getPhone());
        list.add(userInfo.getEntrytime());
        list.add(userInfo.getLeavetime());
        list.add(userInfo.getUpdatetime());
        list.add(userInfo.getUpdateucid());
        list.add(userInfo.getRegtime());
        list.add(userInfo.getRegucid());
        this.getSimpleJdbcTemplate().update(sql.toString(), list.toArray());
    }

    @Override
    public void addUserPostMap(final List<Long> userPostMaps, final Long ucid) throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO uc_user_post_map ");
        sql.append("(ucid, postid) ");
        sql.append("VALUES (?, ?)");
        this.getJdbcTemplate().batchUpdate(sql.toString(), new BatchPreparedStatementSetter(){

            public int getBatchSize() {
                return userPostMaps.size();
            }

            public void setValues(PreparedStatement pst, int i) throws SQLException {
                pst.setLong(1, ucid);
                pst.setLong(2, (Long)userPostMaps.get(i));
            }
        });
    }

    @Override
    public void addUserRoleMap(final List<Long> userRoleMaps, final Long ucid) throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO uc_user_role_map ");
        sql.append("(ucid, roleid, isgiven) ");
        sql.append("VALUES (?, ?, ?)");
        this.getJdbcTemplate().batchUpdate(sql.toString(), new BatchPreparedStatementSetter(){

            public int getBatchSize() {
                return userRoleMaps.size();
            }

            public void setValues(PreparedStatement pst, int i) throws SQLException {
                pst.setLong(1, ucid);
                pst.setLong(2, (Long)userRoleMaps.get(i));
                pst.setLong(3, ConstantUser.ISGIVEN);
            }
        });
    }

    @Override
    public void addUserRoleMap(List<Long> userRoleMaps, Long ucid, Long isGiven) throws Exception {
        if (ObjectUtils.isNull(userRoleMaps)) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO uc_user_role_map ");
        sql.append("(ucid, roleid, isgiven) ");
        sql.append("VALUES ");
        ArrayList<Long> list = new ArrayList<Long>();
        for (Long roleId : userRoleMaps) {
            sql.append("(?, ?, ?),");
            list.add(ucid);
            list.add(roleId);
            list.add(isGiven);
        }
        this.getSimpleJdbcTemplate().update(sql.substring(0, sql.length() - 1), list.toArray());
    }

    @Override
    public void editUser(User user) throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE uc_user ");
        sql.append("SET ");
        sql.append("passwd = ?, status = ? ");
        sql.append("WHERE ucid = ?");
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(user.getPasswd());
        list.add(user.getStatus().toString());
        list.add(user.getUcid());
        this.getSimpleJdbcTemplate().update(sql.toString(), list.toArray());
    }

    @Override
    public void editUserInfo(UserInfo userInfo) throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE uc_user_info ");
        sql.append("SET ");
        sql.append("realname = ?, sex = ?, birthday = ?, email = ?, plane = ?, phone = ?, ");
        sql.append("entrytime = ?, leavetime = ?, updatetime = ?, updateucid = ? ");
        sql.append("WHERE ucid = ?");
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(userInfo.getRealname());
        list.add(userInfo.getSex().toString());
        list.add(userInfo.getBirthday());
        list.add(userInfo.getEmail());
        list.add(userInfo.getPlane());
        list.add(userInfo.getPhone());
        list.add(userInfo.getEntrytime());
        list.add(userInfo.getLeavetime());
        list.add(userInfo.getUpdatetime());
        list.add(userInfo.getUpdateucid());
        list.add(userInfo.getUcid());
        this.getSimpleJdbcTemplate().update(sql.toString(), list.toArray());
    }

    @Override
    public List<AuthInfo> queryAuthInfoByAuthid(List<Long> authid) throws Exception {
        if (ObjectUtils.isNull(authid)) {
            return null;
        }
        String authids = StringUtils.list2str(authid, new String[0]);
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT authid, authvalue, descr, ismenu, menuclass, parentid, shownum, app ");
        sql.append("FROM uc_auth_info ");
        sql.append("WHERE authid IN (" + authids + ") ORDER BY shownum ");
        return this.getSimpleJdbcTemplate().query(sql.toString(), (RowMapper)new RowMapper<AuthInfo>(){

            public AuthInfo mapRow(ResultSet rs, int index) throws SQLException {
                AuthInfo authInfo = new AuthInfo();
                authInfo.setAuthid(rs.getLong("authid"));
                authInfo.setAuthvalue(rs.getString("authvalue"));
                authInfo.setDescr(rs.getString("descr"));
                authInfo.setIsmenu(rs.getLong("ismenu"));
                authInfo.setMenuclass(rs.getString("menuclass"));
                authInfo.setParentid(rs.getLong("parentid"));
                authInfo.setShownum(Float.valueOf(rs.getFloat("shownum")));
                authInfo.setApp(rs.getLong("app"));
                return authInfo;
            }
        }, new Object[0]);
    }

    @Override
    public List<Long> queryAuthidByRoleid(List<Long> roleid) throws Exception {
        if (ObjectUtils.isNull(roleid)) {
            return null;
        }
        String roleids = StringUtils.list2str(roleid, new String[0]);
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT authid ");
        sql.append("FROM uc_role_auth_map ");
        sql.append("WHERE roleid IN (" + roleids + ") ");
        return this.getSimpleJdbcTemplate().query(sql.toString(), (RowMapper)new RowMapper<Long>(){

            public Long mapRow(ResultSet rs, int index) throws SQLException {
                return rs.getLong("authid");
            }
        }, new Object[0]);
    }

    @Override
    public List<PostInfo> queryPostInfo() throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT postid, postname, parentid, office, post_type ");
        sql.append("FROM uc_post_info ORDER BY shownum ");
        return this.getSimpleJdbcTemplate().query(sql.toString(), (RowMapper)new RowMapper<PostInfo>(){

            public PostInfo mapRow(ResultSet rs, int index) throws SQLException {
                PostInfo postInfo = new PostInfo();
                postInfo.setPostid(rs.getLong("postid"));
                postInfo.setPostname(rs.getString("postname"));
                postInfo.setParentid(rs.getLong("parentid"));
                postInfo.setOffice(rs.getLong("office"));
                postInfo.setPostType(rs.getLong("post_type"));
                return postInfo;
            }
        }, new Object[0]);
    }

    @Override
    public List<PostInfo> queryPostInfoByPostid(List<Long> postid) throws Exception {
        if (ObjectUtils.isNull(postid)) {
            return null;
        }
        String postids = StringUtils.list2str(postid, new String[0]);
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT postid, postname, parentid ");
        sql.append("FROM uc_post_info ");
        sql.append("WHERE postid IN (" + postids + ") ");
        return this.getSimpleJdbcTemplate().query(sql.toString(), (RowMapper)new RowMapper<PostInfo>(){

            public PostInfo mapRow(ResultSet rs, int index) throws SQLException {
                PostInfo postInfo = new PostInfo();
                postInfo.setPostid(rs.getLong("postid"));
                postInfo.setPostname(rs.getString("postname"));
                postInfo.setParentid(rs.getLong("parentid"));
                return postInfo;
            }
        }, new Object[0]);
    }

    @Override
    public List<Long> queryPostidByUcid(Long ucid) throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT postid ");
        sql.append("FROM uc_user_post_map ");
        sql.append("WHERE ucid = ? ");
        return this.getSimpleJdbcTemplate().query(sql.toString(), (RowMapper)new RowMapper<Long>(){

            public Long mapRow(ResultSet rs, int index) throws SQLException {
                return rs.getLong("postid");
            }
        }, new Object[]{ucid});
    }

    @Override
    public Map<Long, Set<Long>> queryPostidByUcid(Set<Long> ucids) throws Exception {
        HashMap<Long, Set<Long>> postes = new HashMap<Long, Set<Long>>();
        if (ObjectUtils.isNull(ucids)) {
            return postes;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ucid, postid ");
        sql.append("FROM uc_user_post_map ");
        sql.append("WHERE ucid IN (" + StringUtils.set2str(ucids, new String[0]) + ") ");
        List list = this.getSimpleJdbcTemplate().query(sql.toString(), (RowMapper)new RowMapper<Map<String, Long>>(){

            public Map<String, Long> mapRow(ResultSet rs, int index) throws SQLException {
                HashMap<String, Long> map = new HashMap<String, Long>();
                map.put("ucid", rs.getLong("ucid"));
                map.put("postid", rs.getLong("postid"));
                return map;
            }
        }, new Object[0]);
        if (ObjectUtils.isNull(list)) {
            return postes;
        }
        for (Map map : list) {
            Long ucid = (Long)map.get("ucid");
            Long postid = (Long)map.get("postid");
            Set<Long> postids = ObjectUtils.isNull((Set)postes.get(ucid)) ? new TreeSet() : (Set)postes.get(ucid);
            postids.add(postid);
            postes.put(ucid, postids);
        }
        return postes;
    }

    @Override
    public Map<Long, User> queryUserByUcid(Set<Long> ucids) throws Exception {
        HashMap<Long, User> rsMap = new HashMap<Long, User>();
        if (ObjectUtils.isNull(ucids)) {
            return rsMap;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ucid, ucname, passwd, status ");
        sql.append("FROM uc_user ");
        sql.append("WHERE ucid IN (" + StringUtils.set2str(ucids, new String[0]) + ") ");
        List list = this.getSimpleJdbcTemplate().query(sql.toString(), (RowMapper)new RowMapper<User>(){

            public User mapRow(ResultSet rs, int index) throws SQLException {
                User user = new User();
                user.setUcid(rs.getLong("ucid"));
                user.setUcname(rs.getString("ucname"));
                user.setPasswd(rs.getString("passwd"));
                user.setStatus(UserStatus.valueOf(rs.getString("status")));
                return user;
            }
        }, new Object[0]);
        if (ObjectUtils.isNull(list)) {
            return rsMap;
        }
        for (User user : list) {
            rsMap.put(user.getUcid(), user);
        }
        return rsMap;
    }

    @Override
    public List<RoleInfo> queryRoleInfo() throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT roleid, rolename, roletag ");
        sql.append("FROM uc_role_info ");
        return this.getSimpleJdbcTemplate().query(sql.toString(), (RowMapper)new RowMapper<RoleInfo>(){

            public RoleInfo mapRow(ResultSet rs, int index) throws SQLException {
                RoleInfo roleInfo = new RoleInfo();
                roleInfo.setRoleid(rs.getLong("roleid"));
                roleInfo.setRolename(rs.getString("rolename"));
                roleInfo.setRoletag(rs.getString("roletag"));
                return roleInfo;
            }
        }, new Object[0]);
    }

    @Override
    public List<RoleInfo> queryRoleInfoByRoleid(List<Long> roleid) throws Exception {
        if (ObjectUtils.isNull(roleid)) {
            return null;
        }
        String roleids = StringUtils.list2str(roleid, new String[0]);
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT roleid, rolename, roletag ");
        sql.append("FROM uc_role_info ");
        sql.append("WHERE roleid IN (" + roleids + ") ");
        return this.getSimpleJdbcTemplate().query(sql.toString(), (RowMapper)new RowMapper<RoleInfo>(){

            public RoleInfo mapRow(ResultSet rs, int index) throws SQLException {
                RoleInfo roleInfo = new RoleInfo();
                roleInfo.setRoleid(rs.getLong("roleid"));
                roleInfo.setRolename(rs.getString("rolename"));
                roleInfo.setRoletag(rs.getString("roletag"));
                return roleInfo;
            }
        }, new Object[0]);
    }

    @Override
    public List<Long> queryRoleidByUcid(Long ucid, Long ... isgiven) throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT roleid ");
        sql.append("FROM uc_user_role_map ");
        sql.append("WHERE ucid = ? ");
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(ucid);
        if (!ObjectUtils.isNull(isgiven)) {
            sql.append("AND isgiven = ? ");
            list.add(isgiven[0]);
        }
        return this.getSimpleJdbcTemplate().query(sql.toString(), (RowMapper)new RowMapper<Long>(){

            public Long mapRow(ResultSet rs, int index) throws SQLException {
                return rs.getLong("roleid");
            }
        }, list.toArray());
    }

    @Override
    public Map<Long, Set<Long>> queryRoleidByUcid(Set<Long> ucids) throws Exception {
        HashMap<Long, Set<Long>> roles = new HashMap<Long, Set<Long>>();
        if (ObjectUtils.isNull(ucids)) {
            return roles;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ucid, roleid ");
        sql.append("FROM uc_user_role_map ");
        sql.append("WHERE ucid IN (" + StringUtils.set2str(ucids, new String[0]) + ") ");
        List list = this.getSimpleJdbcTemplate().query(sql.toString(), (RowMapper)new RowMapper<Map<String, Long>>(){

            public Map<String, Long> mapRow(ResultSet rs, int index) throws SQLException {
                HashMap<String, Long> map = new HashMap<String, Long>();
                map.put("ucid", rs.getLong("ucid"));
                map.put("roleid", rs.getLong("roleid"));
                return map;
            }
        }, new Object[0]);
        if (ObjectUtils.isNull(list)) {
            return roles;
        }
        for (Map map : list) {
            Long ucid = (Long)map.get("ucid");
            Long roleid = (Long)map.get("roleid");
            Set<Long> roleids = ObjectUtils.isNull((Set)roles.get(ucid)) ? new TreeSet() : (Set)roles.get(ucid);
            roleids.add(roleid);
            roles.put(ucid, roleids);
        }
        return roles;
    }

    @Override
    public List<Long> queryUcidByRole(Long roleid, Set<Long> ucids) throws Exception {
        if (ObjectUtils.isNull(roleid)) {
            return null;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ucid ");
        sql.append("FROM uc_user_role_map ");
        sql.append("WHERE roleid = ? ");
        if (!ObjectUtils.isNull(ucids)) {
            sql.append("AND ucid IN (" + StringUtils.set2str(ucids, new String[0]) + ") ");
        }
        return this.getSimpleJdbcTemplate().query(sql.toString(), (RowMapper)new RowMapper<Long>(){

            public Long mapRow(ResultSet rs, int i) throws SQLException {
                return rs.getLong("ucid");
            }
        }, new Object[]{roleid});
    }

    @Override
    public User queryUserByUcid(Long ucid) throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ucid, ucname, passwd, status ");
        sql.append("FROM uc_user ");
        sql.append("WHERE ucid = ? ");
        List list = this.getSimpleJdbcTemplate().query(sql.toString(), (RowMapper)new RowMapper<User>(){

            public User mapRow(ResultSet rs, int index) throws SQLException {
                User user = new User();
                user.setUcid(rs.getLong("ucid"));
                user.setUcname(rs.getString("ucname"));
                user.setPasswd(rs.getString("passwd"));
                user.setStatus(UserStatus.valueOf(rs.getString("status")));
                return user;
            }
        }, new Object[]{ucid});
        return ObjectUtils.isNull(list) ? null : (User)list.get(0);
    }

    @Override
    public List<Map<String, Object>> queryUserByUcid(String ucids) throws Exception {
        if (StringUtils.isBlank(ucids)) {
            return null;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT t1.ucid, t1.ucname, t2.realname, t2.email ");
        sql.append("FROM uc_user t1 ");
        sql.append("INNER JOIN ");
        sql.append("uc_user_info t2 ");
        sql.append("ON t1.ucid = t2.ucid ");
        sql.append("AND t1.ucid IN (" + ucids + ") ");
        return this.getSimpleJdbcTemplate().queryForList(sql.toString(), new Object[0]);
    }

    @Override
    public User queryUserByUcname(String ucname) throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ucid, ucname, passwd, status ");
        sql.append("FROM uc_user ");
        sql.append("WHERE ucname = ? ");
        List list = this.getSimpleJdbcTemplate().query(sql.toString(), (RowMapper)new RowMapper<User>(){

            public User mapRow(ResultSet rs, int index) throws SQLException {
                User user = new User();
                user.setUcid(rs.getLong("ucid"));
                user.setUcname(rs.getString("ucname"));
                user.setPasswd(rs.getString("passwd"));
                user.setStatus(UserStatus.valueOf(rs.getString("status")));
                return user;
            }
        }, new Object[]{ucname});
        return ObjectUtils.isNull(list) ? null : (User)list.get(0);
    }

    @Override
    public User queryUserByUcnameAndPwd(String ucname, String passwd) throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ucid, ucname, passwd, status ");
        sql.append("FROM uc_user ");
        sql.append("WHERE ucname = ? AND passwd = ? ");
        List list = this.getSimpleJdbcTemplate().query(sql.toString(), (RowMapper)new RowMapper<User>(){

            public User mapRow(ResultSet rs, int index) throws SQLException {
                User user = new User();
                user.setUcid(rs.getLong("ucid"));
                user.setUcname(rs.getString("ucname"));
                user.setPasswd(rs.getString("passwd"));
                user.setStatus(UserStatus.valueOf(rs.getString("status")));
                return user;
            }
        }, new Object[]{ucname, passwd});
        return ObjectUtils.isNull(list) ? null : (User)list.get(0);
    }

    @Override
    public UserInfo queryUserInfoByUcid(Long ucid) throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        sql.append("ucid, realname, sex, birthday, email, plane, phone, ");
        sql.append("entrytime, leavetime, updatetime, updateucid, regtime, regucid ");
        sql.append("FROM uc_user_info ");
        sql.append("WHERE ucid = ? ");
        List list = this.getSimpleJdbcTemplate().query(sql.toString(), (RowMapper)new RowMapper<UserInfo>(){

            public UserInfo mapRow(ResultSet rs, int index) throws SQLException {
                UserInfo userInfo = new UserInfo();
                userInfo.setUcid(rs.getLong("ucid"));
                userInfo.setRealname(rs.getString("realname"));
                userInfo.setSex(Gender.valueOf(rs.getString("sex")));
                userInfo.setBirthday(rs.getString("birthday"));
                userInfo.setEmail(rs.getString("email"));
                userInfo.setPlane(rs.getString("plane"));
                userInfo.setPhone(rs.getString("phone"));
                userInfo.setEntrytime(rs.getTimestamp("entrytime"));
                userInfo.setLeavetime(rs.getTimestamp("leavetime"));
                userInfo.setUpdatetime(rs.getTimestamp("updatetime"));
                userInfo.setUpdateucid(rs.getLong("updateucid"));
                userInfo.setRegtime(rs.getTimestamp("regtime"));
                userInfo.setRegucid(rs.getLong("regucid"));
                return userInfo;
            }
        }, new Object[]{ucid});
        return ObjectUtils.isNull(list) ? null : (UserInfo)list.get(0);
    }

    @Override
    public void removeUserPostMap(Long ucid) throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM uc_user_post_map ");
        sql.append("WHERE ucid = ? ");
        this.getSimpleJdbcTemplate().update(sql.toString(), new Object[]{ucid});
    }

    @Override
    public void removeUserRoleMap(Long ucid, Set<Long> roleids) throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM uc_user_role_map ");
        sql.append("WHERE ucid = ? ");
        sql.append("AND roleid IN (" + StringUtils.set2str(roleids, new String[0]) + ")");
        this.getSimpleJdbcTemplate().update(sql.toString(), new Object[]{ucid});
    }

    @Override
    public Set<Long> queryUcidByPostId(List<Long> postid) throws Exception {
        if (ObjectUtils.isNull(postid)) {
            return null;
        }
        String postids = StringUtils.list2str(postid, new String[0]);
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ucid ");
        sql.append("FROM uc_user_post_map ");
        sql.append("WHERE postid IN (" + postids + ") ");
        List list = this.getSimpleJdbcTemplate().query(sql.toString(), (RowMapper)new RowMapper<Long>(){

            public Long mapRow(ResultSet rs, int index) throws SQLException {
                return rs.getLong("ucid");
            }
        }, new Object[0]);
        return ObjectUtils.isNull(list) ? null : new TreeSet(list);
    }

    @Override
    public int queryCount(Map<String, String> condition) throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT COUNT(1) ");
        sql.append("FROM uc_user t1 INNER JOIN uc_user_info t2 ");
        sql.append("ON t1.ucid = t2.ucid ");
        sql.append("WHERE 1 = 1 ");
        ArrayList<String> list = new ArrayList<String>();
        if (!StringUtils.isBlank(condition.get("ucname"))) {
            sql.append("AND t1.ucname = ? ");
            list.add(condition.get("ucname"));
        }
        if (!StringUtils.isBlank(condition.get("email"))) {
            sql.append("AND t2.email = ? ");
            list.add(condition.get("email"));
        }
        if (!StringUtils.isBlank(condition.get("ucid"))) {
            sql.append("AND t1.ucid IN (" + condition.get("ucid") + ") ");
        }
        return this.getSimpleJdbcTemplate().queryForInt(sql.toString(), list.toArray());
    }

    @Override
    public List<User> queryList(Map<String, String> condition, Pager pager) throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        sql.append("t1.ucid, t1.ucname, t1.passwd, t1.status, t2.realname, t2.sex, t2.birthday, t2.email, t2.plane, ");
        sql.append("t2.phone, t2.entrytime, t2.leavetime, t2.updatetime, t2.updateucid, t2.regtime, t2.regucid ");
        sql.append("FROM uc_user t1 INNER JOIN uc_user_info t2 ");
        sql.append("ON t1.ucid = t2.ucid ");
        sql.append("WHERE 1 = 1 ");
        ArrayList<Object> list = new ArrayList<Object>();
        if (!StringUtils.isBlank(condition.get("ucname"))) {
            sql.append("AND t1.ucname = ? ");
            list.add(condition.get("ucname"));
        }
        if (!StringUtils.isBlank(condition.get("email"))) {
            sql.append("AND t2.email = ? ");
            list.add(condition.get("email"));
        }
        if (!StringUtils.isBlank(condition.get("ucid"))) {
            sql.append("AND t1.ucid IN (" + condition.get("ucid") + ") ");
        }
        sql.append("ORDER BY regtime DESC ");
        if (!ObjectUtils.isNull(pager)) {
            sql.append("LIMIT ?, ? ");
            list.add(pager.getStartRow());
            list.add(pager.getPageSize());
        }
        return this.getSimpleJdbcTemplate().query(sql.toString(), (RowMapper)new RowMapper<User>(){

            public User mapRow(ResultSet rs, int index) throws SQLException {
                User user = new User();
                user.setUcid(rs.getLong("ucid"));
                user.setUcname(rs.getString("ucname"));
                user.setPasswd(rs.getString("passwd"));
                user.setStatus(UserStatus.valueOf(rs.getString("status")));
                UserInfo userInfo = new UserInfo();
                userInfo.setUcid(rs.getLong("ucid"));
                userInfo.setRealname(rs.getString("realname"));
                userInfo.setSex(Gender.valueOf(rs.getString("sex")));
                userInfo.setBirthday(rs.getString("birthday"));
                userInfo.setEmail(rs.getString("email"));
                userInfo.setPlane(rs.getString("plane"));
                userInfo.setPhone(rs.getString("phone"));
                userInfo.setEntrytime(rs.getTimestamp("entrytime"));
                userInfo.setLeavetime(rs.getTimestamp("leavetime"));
                userInfo.setUpdatetime(rs.getTimestamp("updatetime"));
                userInfo.setUpdateucid(rs.getLong("updateucid"));
                userInfo.setRegtime(rs.getTimestamp("regtime"));
                userInfo.setRegucid(rs.getLong("regucid"));
                user.setUserInfo(userInfo);
                return user;
            }
        }, list.toArray());
    }

    @Override
    public void addPostChange(PostChange change) throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO uc_post_change ");
        sql.append("(");
        sql.append("ucid, oldpostid, newpostid, changetime, updateucid, updatetime");
        sql.append(") ");
        sql.append("VALUES (?, ?, ?, ?, ?, ?)");
        ArrayList<Comparable<Long>> list = new ArrayList<Comparable<Long>>();
        list.add(change.getUcid());
        list.add(change.getOldpostid());
        list.add(change.getNewpostid());
        list.add(change.getChangetime());
        list.add(change.getUpdateucid());
        list.add(change.getUpdatetime());
        this.getSimpleJdbcTemplate().update(sql.toString(), list.toArray());
    }

    @Override
    public List<UserPostMap> queryUserPostMap() throws Exception {
        String sql = "SELECT ucid, postid FROM uc_user_post_map";
        return this.getSimpleJdbcTemplate().query(sql, (RowMapper)new RowMapper<UserPostMap>(){

            public UserPostMap mapRow(ResultSet rs, int arg1) throws SQLException {
                UserPostMap up = new UserPostMap();
                up.setUcid(rs.getLong("ucid"));
                up.setPostid(rs.getLong("postid"));
                return up;
            }
        }, new Object[0]);
    }
}

