/*
 * Decompiled with CFR 0.152.
 */
package com.qianpin.common.user.entity;

import com.qianpin.common.user.entity.UserInfo;
import com.qianpin.common.utils.ConstantUser;
import com.qianpin.common.utils.ObjectUtils;
import com.qianpin.common.utils.StringUtils;
import com.qianpin.common.utils.enums.UserStatus;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class User
implements Serializable {
    private static final long serialVersionUID = 6831913144115446550L;
    private Long ucid;
    private String ucname;
    private String passwd;
    private UserStatus status;
    private String statusName;
    private String opHTML;
    private UserInfo userInfo;
    private List<Long> roleids;
    private List<Long> postids;
    private String roleName;
    private String postName;

    public Long getUcid() {
        return this.ucid;
    }

    public void setUcid(Long ucid) {
        this.ucid = ucid;
    }

    public String getUcname() {
        return this.ucname;
    }

    public void setUcname(String ucname) {
        this.ucname = ucname;
    }

    public String getPasswd() {
        return this.passwd;
    }

    public void setPasswd(String passwd) {
        this.passwd = passwd;
    }

    public UserStatus getStatus() {
        return this.status;
    }

    public void setStatus(UserStatus status) {
        this.status = status;
    }

    public String getStatusName() {
        if (this.statusName != null) {
            return this.statusName;
        }
        if (this.status == null) {
            return "";
        }
        this.statusName = !UserStatus.NORMAL.equals((Object)this.status) ? "<span class=\"fontred\">" + UserStatus.getText(this.status) + "</span>" : UserStatus.getText(this.status);
        return this.statusName;
    }

    public String getOpHTML() {
        return this.opHTML;
    }

    public void setOpHTML(String opHTML) {
        this.opHTML = opHTML;
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(UserInfo userInfo) {
        this.userInfo = userInfo;
    }

    public List<Long> getRoleids() {
        return this.roleids;
    }

    public void setRoleids(List<Long> roleids) {
        this.roleids = roleids;
    }

    public List<Long> getPostids() {
        return this.postids;
    }

    public void setPostids(List<Long> postids) {
        this.postids = postids;
    }

    public String getRoleName() {
        if (this.roleName != null) {
            return this.roleName;
        }
        if (this.roleids == null) {
            return "";
        }
        try {
            StringBuilder sb = new StringBuilder();
            for (Long roleid : this.roleids) {
                sb.append(ConstantUser.ROLE(roleid).getRolename());
                sb.append("|");
            }
            this.roleName = sb.substring(0, sb.length() - 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        return this.roleName;
    }

    public String getPostName() {
        if (!StringUtils.isBlank(this.postName)) {
            return this.postName;
        }
        if (ObjectUtils.isNull(this.postids)) {
            return "";
        }
        try {
            StringBuilder sb = new StringBuilder();
            Iterator<Long> iterator = this.postids.iterator();
            while (iterator.hasNext()) {
                Long postid = iterator.next();
                List<Long> parent = ConstantUser.getParentPost(postid);
                Collections.reverse(parent);
                for (Long pid : parent) {
                    sb.append(ConstantUser.POST(pid).getPostname());
                    sb.append("|");
                }
                sb.deleteCharAt(sb.length() - 1);
                if (!iterator.hasNext()) continue;
                sb.append("<br />");
            }
            this.postName = sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        return this.postName;
    }
}

