/*
 * Decompiled with CFR 0.152.
 */
package com.qianpin.common.user.service.impl;

import com.qianpin.common.core.cache.MemCached;
import com.qianpin.common.user.dao.UserDao;
import com.qianpin.common.user.entity.AuthInfo;
import com.qianpin.common.user.entity.LoginUser;
import com.qianpin.common.user.entity.PostChange;
import com.qianpin.common.user.entity.PostInfo;
import com.qianpin.common.user.entity.RoleInfo;
import com.qianpin.common.user.entity.User;
import com.qianpin.common.user.entity.UserInfo;
import com.qianpin.common.user.service.UserService;
import com.qianpin.common.utils.ConstantUser;
import com.qianpin.common.utils.ObjectUtils;
import com.qianpin.common.utils.StringUtils;
import com.qianpin.common.utils.TimeUtils;
import com.qianpin.common.utils.email.EmailTools;
import com.qianpin.common.utils.enums.UserStatus;
import com.qianpin.common.utils.freemarker.FreeMarkerTemplateHandler;
import com.qianpin.common.utils.json.JsonUtils;
import com.qianpin.common.utils.page.Pager;
import com.qianpin.common.utils.security.SecurityTool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.NullArgumentException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="userService")
public class UserServiceImpl
implements UserService {
    @Autowired
    UserDao userDao;

    @Override
    public String validateUcname(User user) throws Exception {
        if (ObjectUtils.isNull(user)) {
            throw new NullArgumentException("user");
        }
        HashMap<String, String> result = new HashMap<String, String>();
        User u = this.userDao.queryUserByUcname(user.getUcname());
        if (ObjectUtils.isNull(u)) {
            result.put("status", "success");
        } else if (u.getUcid().compareTo(user.getUcid()) == 0) {
            result.put("status", "success");
        } else {
            result.put("status", "error");
        }
        return JsonUtils.map2Json(result, new String[0]);
    }

    @Override
    public User queryUserByName(String ucname) throws Exception {
        if (StringUtils.isBlank(ucname)) {
            return null;
        }
        return this.userDao.queryUserByUcname(ucname);
    }

    @Override
    public boolean addUser(User user) throws Exception {
        User _user = this.userDao.queryUserByUcname(user.getUcname());
        if (!ObjectUtils.isNull(_user)) {
            return false;
        }
        if (ObjectUtils.isNull(user)) {
            throw new NullArgumentException("user");
        }
        if (ObjectUtils.isNull(user.getUserInfo())) {
            throw new NullArgumentException("userinfo");
        }
        if (ObjectUtils.isNull(user.getRoleids())) {
            throw new NullArgumentException("user-roleids");
        }
        if (ObjectUtils.isNull(user.getPostids())) {
            throw new NullArgumentException("user-postids");
        }
        String passwd = SecurityTool.random();
        user.setPasswd(SecurityTool.MD5Encode(passwd));
        Long ucid = this.userDao.addUser(user);
        user.getUserInfo().setUcid(ucid);
        this.userDao.addUserInfo(user.getUserInfo());
        this.userDao.addUserRoleMap(user.getRoleids(), ucid);
        this.userDao.addUserPostMap(user.getPostids(), ucid);
        FreeMarkerTemplateHandler fmtHandler = new FreeMarkerTemplateHandler();
        EmailTools emailTools = new EmailTools();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ucname", user.getUcname());
        map.put("ucname", user.getUcname());
        map.put("passwd", passwd);
        map.put("date", TimeUtils.dateStr(new Date()));
        String text = "";
        try {
            text = fmtHandler.applyTemplate("com/qianpin/common/user/service/impl/addUserMail.ftl", map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            emailTools.sendMail(user.getUserInfo().getEmail(), text, "\u5343\u54c1\u7f51\u5e94\u7528\u7ba1\u7406\u5e73\u53f0\u5f00\u6237\u901a\u77e5\uff08\u81ea\u52a8\u53d1\u9001\u90ae\u4ef6\uff0c\u8bf7\u52ff\u56de\u590d\uff09");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    @Override
    public boolean editUser(Long ucid, String orpasswd, String passwd) throws Exception {
        if (ObjectUtils.isNull(ucid)) {
            throw new NullArgumentException("ucid");
        }
        if (StringUtils.isBlank(orpasswd)) {
            throw new NullArgumentException(ucid + "'s orpasswd");
        }
        if (StringUtils.isBlank(passwd)) {
            throw new NullArgumentException(ucid + "'s passwd");
        }
        String orpwd = SecurityTool.MD5Encode(orpasswd);
        String pwd = SecurityTool.MD5Encode(passwd);
        User user = this.userDao.queryUserByUcid(ucid);
        if (!user.getPasswd().equals(orpwd)) {
            return false;
        }
        user.setPasswd(pwd);
        this.userDao.editUser(user);
        LoginUser loginUser = (LoginUser)MemCached.get("QP_COMMONS_USER_" + ucid);
        if (!ObjectUtils.isNull(loginUser)) {
            loginUser.setPasswd(pwd);
            MemCached.set("QP_COMMONS_USER_" + ucid, loginUser);
        }
        return true;
    }

    @Override
    public void editUser(Long ucid, UserStatus status) throws Exception {
        if (ObjectUtils.isNull(ucid)) {
            throw new NullArgumentException("ucid");
        }
        if (ObjectUtils.isNull((Object)status)) {
            throw new NullArgumentException(ucid + "'s status");
        }
        User user = this.userDao.queryUserByUcid(ucid);
        user.setStatus(status);
        this.userDao.editUser(user);
        LoginUser loginUser = (LoginUser)MemCached.get("QP_COMMONS_USER_" + ucid);
        if (!ObjectUtils.isNull(loginUser)) {
            loginUser.setStatus(status);
            MemCached.set("QP_COMMONS_USER_" + ucid, loginUser);
        }
    }

    @Override
    public void editUser(User user, Set<Long> roleids) throws Exception {
        if (ObjectUtils.isNull(user)) {
            throw new NullArgumentException("user");
        }
        if (ObjectUtils.isNull(user.getUserInfo())) {
            throw new NullArgumentException("userinfo");
        }
        if (ObjectUtils.isNull(user.getRoleids())) {
            throw new NullArgumentException("user-roleids");
        }
        if (ObjectUtils.isNull(user.getPostids())) {
            throw new NullArgumentException("user-postids");
        }
        this.userDao.editUserInfo(user.getUserInfo());
        this.userDao.removeUserRoleMap(user.getUcid(), roleids);
        this.userDao.addUserRoleMap(user.getRoleids(), user.getUcid());
        List<Long> oldpostids = this.userDao.queryPostidByUcid(user.getUcid());
        List<Long> newpostids = user.getPostids();
        if (!oldpostids.equals(newpostids)) {
            PostChange change = new PostChange();
            change.setUcid(user.getUcid());
            change.setOldpostid(oldpostids.get(0));
            change.setNewpostid(newpostids.get(0));
            change.setChangetime(user.getUserInfo().getUpdatetime());
            change.setUpdateucid(user.getUserInfo().getUpdateucid());
            change.setUpdatetime(user.getUserInfo().getUpdatetime());
            this.userDao.addPostChange(change);
            this.userDao.removeUserPostMap(user.getUcid());
            this.userDao.addUserPostMap(user.getPostids(), user.getUcid());
        }
    }

    @Override
    public String queryList(Map<String, String> condition, int cpage) throws Exception {
        String ucid = condition.get("currentucid");
        Set<Long> postids = new TreeSet<Long>();
        if (StringUtils.isBlank(condition.get("postid"))) {
            LoginUser user = (LoginUser)MemCached.get("QP_COMMONS_USER_" + ucid);
            postids = user.getPostids();
        } else {
            postids.add(Long.parseLong(condition.get("postid")));
        }
        Set<Long> ucids = this.getPostUcid(postids);
        if (ObjectUtils.isNull(ucids)) {
            condition.put("ucid", "0");
        } else {
            condition.put("ucid", StringUtils.set2str(ucids, new String[0]));
        }
        int total = this.userDao.queryCount(condition);
        Pager pager = new Pager(total, cpage, new String[0]);
        List<User> list = null;
        if (total > 0 && !ObjectUtils.isNull(list = this.userDao.queryList(condition, pager))) {
            String edit = "<a href=\"javascript:;\" onclick=\"detail('{userId}');\" class=\"a_link_3\">\u7f16\u8f91</a>";
            String status = "<a href=\"javascript:;\" onclick=\"status('{userId}', '{status}');\" class=\"a_link_3\">{opname}</a>";
            ucids.clear();
            for (User user : list) {
                String encryptUcid = SecurityTool.encryptValue(user.getUcid().toString(), ucid);
                ucids.add(user.getUcid());
                if (UserStatus.NORMAL.equals((Object)user.getStatus())) {
                    user.setOpHTML(String.valueOf(edit.replace("{userId}", encryptUcid)) + "<br />" + status.replace("{userId}", encryptUcid).replace("{status}", UserStatus.DEPARTURE.toString()).replace("{opname}", "\u79bb\u804c") + status.replace("{userId}", encryptUcid).replace("{status}", UserStatus.DISABLED.toString()).replace("{opname}", "\u7981\u6b62\u767b\u5f55"));
                }
                if (UserStatus.DISABLED.equals((Object)user.getStatus())) {
                    user.setOpHTML(String.valueOf(edit.replace("{userId}", encryptUcid)) + status.replace("{userId}", encryptUcid).replace("{status}", UserStatus.NORMAL.toString()).replace("{opname}", "\u6062\u590d\u767b\u5f55"));
                }
                if (!UserStatus.DEPARTURE.equals((Object)user.getStatus())) continue;
                user.setOpHTML(String.valueOf(edit.replace("{userId}", encryptUcid)) + status.replace("{userId}", encryptUcid).replace("{status}", UserStatus.NORMAL.toString()).replace("{opname}", "\u91cd\u65b0\u5165\u804c"));
            }
            Map<Long, Set<Long>> roleMap = this.userDao.queryRoleidByUcid(ucids);
            Map<Long, Set<Long>> postMap = this.userDao.queryPostidByUcid(ucids);
            for (User user : list) {
                user.setRoleids(new ArrayList<Long>((Collection)roleMap.get(user.getUcid())));
                user.setPostids(new ArrayList<Long>((Collection)postMap.get(user.getUcid())));
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("pager", pager.getPageJson());
        result.put("list", list);
        return JsonUtils.map2Json(result, "yyyy-MM-dd");
    }

    @Override
    public Long login(String ucname, String passwd) throws Exception {
        if (StringUtils.isBlank(ucname)) {
            return -1L;
        }
        if (StringUtils.isBlank(passwd)) {
            return -2L;
        }
        User user = this.userDao.queryUserByUcname(ucname);
        if (ObjectUtils.isNull(user)) {
            return -3L;
        }
        if (!user.getPasswd().equals(passwd)) {
            return -4L;
        }
        if (UserStatus.DISABLED.equals((Object)user.getStatus())) {
            return -5L;
        }
        if (UserStatus.DEPARTURE.equals((Object)user.getStatus())) {
            return -6L;
        }
        LoginUser loginUser = new LoginUser();
        BeanUtils.copyProperties((Object)loginUser, (Object)user);
        Long ucid = loginUser.getUcid();
        UserInfo userInfo = this.userDao.queryUserInfoByUcid(ucid);
        loginUser.setUserInfo(userInfo);
        List<Long> roleid = this.userDao.queryRoleidByUcid(ucid, new Long[0]);
        List<RoleInfo> roleinfoList = this.userDao.queryRoleInfoByRoleid(roleid);
        TreeSet<String> roletags = new TreeSet<String>();
        if (!ObjectUtils.isNull(roleinfoList)) {
            for (RoleInfo roleInfo : roleinfoList) {
                roletags.add(roleInfo.getRoletag());
            }
        }
        loginUser.setRoletags(roletags);
        loginUser.setRoleids(new TreeSet<Long>(roleid));
        List<Long> authid = this.userDao.queryAuthidByRoleid(roleid);
        List<AuthInfo> authinfoList = this.userDao.queryAuthInfoByAuthid(authid);
        TreeSet<String> authvalues = new TreeSet<String>();
        LinkedHashSet<AuthInfo> menu = new LinkedHashSet<AuthInfo>();
        if (!ObjectUtils.isNull(authinfoList)) {
            for (AuthInfo authInfo : authinfoList) {
                if (!StringUtils.isBlank(authInfo.getAuthvalue())) {
                    authvalues.add(authInfo.getAuthvalue());
                }
                if (authInfo.getIsmenu().compareTo(1L) != 0) continue;
                menu.add(authInfo);
            }
        }
        loginUser.setAuthvalues(authvalues);
        List<Object> pmenus = new ArrayList();
        HashMap<Long, ArrayList<AuthInfo>> _menu = new HashMap<Long, ArrayList<AuthInfo>>();
        authid.clear();
        for (AuthInfo authInfo : menu) {
            authid.add(authInfo.getParentid());
            ArrayList<AuthInfo> cmenu = (List)_menu.get(authInfo.getParentid());
            if (cmenu == null) {
                cmenu = new ArrayList<AuthInfo>();
            }
            cmenu.add(authInfo);
            _menu.put(authInfo.getParentid(), cmenu);
        }
        pmenus = this.userDao.queryAuthInfoByAuthid(authid);
        LinkedHashMap<AuthInfo, List<AuthInfo>> menus = new LinkedHashMap<AuthInfo, List<AuthInfo>>();
        for (AuthInfo authInfo : pmenus) {
            menus.put(authInfo, (List)_menu.get(authInfo.getAuthid()));
        }
        loginUser.setMenus(menus);
        List<Long> list = this.userDao.queryPostidByUcid(ucid);
        TreeSet<Long> postids = new TreeSet<Long>(list);
        loginUser.setPostids(postids);
        MemCached.set("QP_COMMONS_USER_" + ucid, loginUser);
        return ucid;
    }

    @Override
    public String initPostTree(Long ucid, String type, String scope) throws Exception {
        LoginUser user = (LoginUser)MemCached.get("QP_COMMONS_USER_" + ucid);
        Long postid = user.getPostids().iterator().next();
        ArrayList<PostInfo> postes = new ArrayList<PostInfo>();
        if ("all".equalsIgnoreCase(scope)) {
            Long rootid = ConstantUser.getRootPost(postid);
            if (ObjectUtils.isNull(rootid)) {
                throw new NullArgumentException("the post(" + postid + ") has not root post");
            }
            postid = rootid;
        } else if (user.getRoletags().contains("FGSYY") && ObjectUtils.isNull(postid = ConstantUser.getBranchOffice(postid))) {
            postid = user.getPostids().iterator().next();
        }
        PostInfo postInfo = ConstantUser.getChilePostInfo(postid);
        if (postInfo.getParentid().compareTo(0L) == 0) {
            Long _type = -1L;
            if ("crm".equalsIgnoreCase(type)) {
                _type = 1L;
            } else if ("editor".equalsIgnoreCase(type)) {
                _type = 2L;
            }
            if (_type.compareTo(-1L) == 1) {
                List<PostInfo> childPost = postInfo.getChildPost();
                Iterator<PostInfo> iterator = childPost.iterator();
                while (iterator.hasNext()) {
                    PostInfo _p = iterator.next();
                    if (_p.getPostType().compareTo(_type) == 0) continue;
                    iterator.remove();
                }
            }
            postInfo = postInfo.getChildPost().get(0);
        }
        ConstantUser.encryptPostid(postInfo, ucid);
        postInfo.setEncryptPostId(SecurityTool.encryptValue(postInfo.getPostid(), ucid.toString()));
        postInfo.setPostid(0L);
        postes.add(postInfo);
        return JsonUtils.list2Json(postes, new String[0]);
    }

    @Override
    public String initPostUserTree(Long ucid) throws Exception {
        LoginUser user = (LoginUser)MemCached.get("QP_COMMONS_USER_" + ucid);
        Set<Long> postids = user.getPostids();
        ArrayList<PostInfo> postes = new ArrayList<PostInfo>();
        for (Long postid : postids) {
            PostInfo postInfo = ConstantUser.getChilePostInfo(postid);
            this.initPostUser(postInfo);
            ConstantUser.encryptPostid(postInfo, ucid);
            postInfo.setEncryptPostId(SecurityTool.encryptValue(postInfo.getPostid(), ucid.toString()));
            postes.add(postInfo);
        }
        return JsonUtils.list2Json(postes, new String[0]);
    }

    private void initPostUser(PostInfo postInfo) throws Exception {
        List<Map<String, Object>> userList;
        if (!ObjectUtils.isNull(postInfo.getChildPost())) {
            for (PostInfo pi : postInfo.getChildPost()) {
                this.initPostUser(pi);
            }
        }
        ArrayList<Long> postid = new ArrayList<Long>();
        postid.add(postInfo.getPostid());
        Set<Long> users = this.userDao.queryUcidByPostId(postid);
        if (!ObjectUtils.isNull(users) && !ObjectUtils.isNull(userList = this.userDao.queryUserByUcid(StringUtils.set2str(users, new String[0])))) {
            for (Map<String, Object> user : userList) {
                PostInfo info = new PostInfo();
                info.setPostid(Long.parseLong(user.get("ucid").toString()));
                info.setPostname(user.get("ucname").toString());
                postInfo.getChildPost().add(info);
            }
        }
    }

    @Override
    public String initOffice(Long ucid) throws Exception {
        LoginUser user = (LoginUser)MemCached.get("QP_COMMONS_USER_" + ucid);
        Iterator<Long> iterator = user.getPostids().iterator();
        Long postid = 0L;
        if (iterator.hasNext()) {
            postid = iterator.next();
        }
        List<Long> postids = ConstantUser.getChilePost(postid);
        postids.add(postid);
        ArrayList offices = new ArrayList();
        for (Long pid : postids) {
            if (ObjectUtils.isNull(ConstantUser.OFFICE(pid))) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            String encryptPostId = SecurityTool.encryptValue(pid.toString(), ucid.toString());
            map.put("encryptId", encryptPostId);
            map.put("officeName", ConstantUser.OFFICE(pid).getPostname());
            offices.add(map);
        }
        if (ObjectUtils.isNull(offices)) {
            Long office = ConstantUser.getBranchOffice(postid);
            if (ObjectUtils.isNull(office)) {
                throw new IllegalArgumentException("the user(" + user.getUcid() + ") has not office");
            }
            HashMap<String, String> map = new HashMap<String, String>();
            String encryptOfficeId = SecurityTool.encryptValue(office.toString(), ucid.toString());
            map.put("encryptId", encryptOfficeId);
            map.put("officeName", ConstantUser.OFFICE(office).getPostname());
            offices.add(map);
        }
        return JsonUtils.list2Json(offices, new String[0]);
    }

    @Override
    public String initUser(Long postid, Long currenucid) throws Exception {
        HashSet<Long> postids = new HashSet<Long>();
        postids.add(postid);
        Set<Long> ucid = this.getPostUcid(postids);
        String ucids = StringUtils.set2str(ucid, new String[0]);
        List<Map<String, Object>> list = this.userDao.queryUserByUcid(ucids);
        if (ObjectUtils.isNull(list)) {
            return "";
        }
        for (Map<String, Object> map : list) {
            String encryptUcid = SecurityTool.encryptValue(map.get("ucid"), currenucid.toString());
            map.put("ucid", encryptUcid);
        }
        return JsonUtils.list2Json(list, new String[0]);
    }

    @Override
    public User queryById(Long ucid) throws Exception {
        User user = this.userDao.queryUserByUcid(ucid);
        if (ObjectUtils.isNull(user)) {
            return null;
        }
        UserInfo userInfo = this.userDao.queryUserInfoByUcid(ucid);
        List<Long> roles = this.userDao.queryRoleidByUcid(ucid, new Long[0]);
        user.setRoleids(roles);
        List<Long> posts = this.userDao.queryPostidByUcid(ucid);
        user.setPostids(posts);
        user.setUserInfo(userInfo);
        return user;
    }

    @Override
    public Map<Long, User> queryByIds(Set<Long> ucids) throws Exception {
        if (ObjectUtils.isNull(ucids)) {
            return null;
        }
        List<Map<String, Object>> users = this.userDao.queryUserByUcid(StringUtils.set2str(ucids, new String[0]));
        if (ObjectUtils.isNull(users)) {
            return null;
        }
        Map<Long, Set<Long>> roles = this.userDao.queryRoleidByUcid(ucids);
        Map<Long, Set<Long>> posts = this.userDao.queryPostidByUcid(ucids);
        HashMap<Long, User> result = new HashMap<Long, User>();
        for (Map<String, Object> user : users) {
            User u = new User();
            UserInfo info = new UserInfo();
            Long ucid = Long.parseLong(user.get("ucid").toString());
            String ucname = user.get("ucname").toString();
            u.setUcid(ucid);
            u.setUcname(ucname);
            info.setRealname(user.get("realname").toString());
            info.setEmail(user.get("email").toString());
            u.setUserInfo(info);
            u.setRoleids(new ArrayList<Long>((Collection)roles.get(ucid)));
            u.setPostids(new ArrayList<Long>((Collection)posts.get(ucid)));
            result.put(ucid, u);
        }
        return result;
    }

    @Override
    public List<RoleInfo> queryUserRoleInfo(Long ucid) throws Exception {
        List<Long> roleid = this.userDao.queryRoleidByUcid(ucid, ConstantUser.ISGIVEN);
        List<RoleInfo> roles = this.userDao.queryRoleInfoByRoleid(roleid);
        if (ObjectUtils.isNull(roles)) {
            return null;
        }
        for (RoleInfo roleInfo : roles) {
            String encryptRoleid = SecurityTool.encryptValue(roleInfo.getRoleid(), ucid.toString());
            roleInfo.setEncryptRoleid(encryptRoleid);
        }
        return roles;
    }

    @Override
    public List<RoleInfo> queryRoleInfoByUcid(Long ucid, Long ... isGiven) throws Exception {
        List<Long> roleid = this.userDao.queryRoleidByUcid(ucid, isGiven);
        return this.userDao.queryRoleInfoByRoleid(roleid);
    }

    @Override
    public Set<Long> getPostUcid(Set<Long> postids) throws Exception {
        if (ObjectUtils.isNull(postids)) {
            return null;
        }
        ArrayList<Long> postes = new ArrayList<Long>();
        for (Long postid : postids) {
            postes.addAll(ConstantUser.getChilePost(postid));
            postes.add(postid);
        }
        Set<Long> ucids = this.userDao.queryUcidByPostId(postes);
        return ucids;
    }

    @Override
    public Set<Long> getPostUcid(Long ucid) throws Exception {
        List<Long> child;
        if (ObjectUtils.isNull(ucid)) {
            return null;
        }
        LoginUser user = (LoginUser)MemCached.get("QP_COMMONS_USER_" + ucid);
        if (ObjectUtils.isNull(user)) {
            return null;
        }
        HashSet<Long> ucids = new HashSet<Long>();
        Long postid = user.getPostids().iterator().next();
        if (user.getRoletags().contains("FGSYY")) {
            postid = ConstantUser.getBranchOffice(postid);
        }
        if (ObjectUtils.isNull(child = ConstantUser.POST_PID(postid))) {
            ucids.add(ucid);
            return ucids;
        }
        return this.getPostUcid(user.getPostids());
    }

    @Override
    public List<PostInfo> queryPostInfoById(List<Long> posetid) throws Exception {
        return this.userDao.queryPostInfoByPostid(posetid);
    }

    @Override
    public Long queryOfficeByUcid(Long ucid) throws Exception {
        List<Long> postids = this.userDao.queryPostidByUcid(ucid);
        if (ObjectUtils.isNull(postids)) {
            throw new IllegalArgumentException("the user(" + ucid + ") has not post");
        }
        return ConstantUser.getBranchOffice(postids.get(0));
    }

    @Override
    public Long resetPwd(String ucname, String email) throws Exception {
        User user = this.userDao.queryUserByUcname(ucname);
        if (ObjectUtils.isNull(user)) {
            return -1L;
        }
        UserInfo userInfo = this.userDao.queryUserInfoByUcid(user.getUcid());
        if (ObjectUtils.isNull(userInfo)) {
            return -1L;
        }
        if (!email.equals(userInfo.getEmail())) {
            return -2L;
        }
        String passwd = SecurityTool.random();
        String pwd = SecurityTool.MD5Encode(passwd);
        user.setPasswd(pwd);
        this.userDao.editUser(user);
        LoginUser loginUser = (LoginUser)MemCached.get("QP_COMMONS_USER_" + user.getUcid());
        if (!ObjectUtils.isNull(loginUser)) {
            loginUser.setPasswd(pwd);
            MemCached.set("QP_COMMONS_USER_" + user.getUcid(), loginUser);
        }
        FreeMarkerTemplateHandler fmtHandler = new FreeMarkerTemplateHandler();
        EmailTools emailTools = new EmailTools();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ucname", user.getUcname());
        map.put("ucname", user.getUcname());
        map.put("passwd", passwd);
        map.put("date", TimeUtils.dateStr(new Date()));
        String text = "";
        try {
            text = fmtHandler.applyTemplate("com/qianpin/common/user/service/impl/addUserMail.ftl", map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            emailTools.sendMail(email, text, "\u5343\u54c1\u7f51CRM\u5ba2\u6237\u7ba1\u7406\u5e73\u53f0\u627e\u56de\u5bc6\u7801\u901a\u77e5\uff08\u81ea\u52a8\u53d1\u9001\u90ae\u4ef6\uff0c\u8bf7\u52ff\u56de\u590d\uff09");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 1L;
    }

    @Override
    public List<Long> queryUcidByRole(String roleTag, Set<Long> ucids) throws Exception {
        if (StringUtils.isBlank(roleTag)) {
            return null;
        }
        if (ObjectUtils.isNull(ucids)) {
            return null;
        }
        Map<Long, RoleInfo> ROLE = ConstantUser.ROLE();
        Long roleid = 0L;
        for (Map.Entry<Long, RoleInfo> entry : ROLE.entrySet()) {
            if (!roleTag.equals(entry.getValue().getRoletag())) continue;
            roleid = entry.getKey();
            break;
        }
        if (ObjectUtils.isNull(roleid)) {
            return null;
        }
        return this.userDao.queryUcidByRole(roleid, ucids);
    }

    @Override
    public Map<Long, User> queryUserByRole(String roleTag, Set<Long> ucids) throws Exception {
        List<Long> ids = this.queryUcidByRole(roleTag, ucids);
        if (ObjectUtils.isNull(ids)) {
            return null;
        }
        return this.queryByIds(new HashSet<Long>(ids));
    }

    @Override
    public void addUserRoleMap(List<Long> userRoleMaps, Long ucid, Long isGiven) throws Exception {
        this.userDao.addUserRoleMap(userRoleMaps, ucid, isGiven);
    }
}

