/*
 * Decompiled with CFR 0.152.
 */
package com.qianpin.common.utils;

import com.qianpin.common.core.cache.MemCached;
import com.qianpin.common.dictionary.dao.DictionaryDao;
import com.qianpin.common.dictionary.entity.BankInfo;
import com.qianpin.common.dictionary.entity.Dictionary;
import com.qianpin.common.dictionary.entity.OfficeContractCode;
import com.qianpin.common.utils.AppUtils;
import com.qianpin.common.utils.ObjectUtils;
import com.qianpin.common.utils.enums.DicType;
import com.qianpin.common.utils.page.Pager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ConstantDic {
    private static DictionaryDao dicDao = (DictionaryDao)AppUtils.getBean("dicDao");
    private static final String DIC_PROVINCE = "QP_COMMON_DIC_PROVINCE";
    private static final String DIC_CITY = "QP_COMMON_DIC_CITY";
    private static final String DIC_AREA = "QP_COMMON_DIC_AREA";
    private static final String DIC_DISTRICT = "QP_COMMON_DIC_DISTRICT";
    private static final String DIC_CATEGORY_PARENT = "QP_COMMON_DIC_CATEGORY_PARENT";
    private static final String DIC_CATEGORY_CHILD = "QP_COMMON_DIC_CATEGORY_CHILD";
    private static final String DIC_QUALIFICATION = "QP_COMMON_DIC_QUALIFICATION";
    private static final String DIC_GUEST_INTENTION = "QP_COMMON_DIC_GUEST_INTENTION";
    private static final String DIC_BANK_PARENT = "QP_COMMON_DIC_BANK_PARENT";
    private static final String DIC_CONTRACTREJECTEDCLASSIFICATION = "QP_COMMON_DIC_CONTRACTREJECTEDCLASSIFICATION";
    private static final String DIC_CONTRACTREJECTEDREASONS = "QP_COMMON_DIC_CONTRACTREJECTEDREASONS";
    private static final String DIC_OFFICE_CONTRACT_CODE = "QP_COMMON_DIC_OFFICE_CONTRACT_CODE";
    private static final String DIC_LABEL = "QP_COMMON_DIC_LABEL";
    private static final String DIC_CUISINE = "QP_COMMON_DIC_CUISINE";
    private static final String DIC_ENVIRONMENT = "QP_COMMON_DIC_ENVIRONMENT";
    private static final String DIC_RECEPTIONCAPACITY = "QP_COMMON_DIC_RECEPTIONCAPACITY";
    private static final String DIC_OTHERSERVICES = "QP_COMMON_DIC_OTHERSERVICES";
    private static final String DIC_SERVICEEVENTCLASS = "QP_COMMON_DIC_SERVICEEVENTCLASS";
    private static final String DIC_SERVICEEVENT = "QP_COMMON_DIC_SERVICEEVENT";
    private static final String DIC_ZCB_SERVICE = "QP_COMMON_DIC_ZCB_SERVICE";

    public static void reloadPROVINCE() {
        TreeMap<Long, Dictionary> PROVINCE = new TreeMap<Long, Dictionary>();
        try {
            HashMap<String, String> condition = new HashMap<String, String>();
            condition.put("dictype", DicType.PROVINCE.toString());
            List<Dictionary> provinceList = dicDao.queryList(condition, new Pager[0]);
            if (ObjectUtils.isNull(provinceList)) {
                throw new NullPointerException("PROVINCE is null");
            }
            for (Dictionary dictionary : provinceList) {
                PROVINCE.put(dictionary.getDicid(), dictionary);
            }
            MemCached.set(DIC_PROVINCE, PROVINCE, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void reloadCITY() {
        TreeMap<Long, Dictionary> CITY = new TreeMap<Long, Dictionary>();
        try {
            HashMap<String, String> condition = new HashMap<String, String>();
            condition.put("dictype", DicType.CITY.toString());
            List<Dictionary> cityList = dicDao.queryList(condition, new Pager[0]);
            if (ObjectUtils.isNull(cityList)) {
                throw new NullPointerException("CITY is null");
            }
            for (Dictionary dictionary : cityList) {
                CITY.put(dictionary.getDicid(), dictionary);
            }
            MemCached.set(DIC_CITY, CITY, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void reloadAREA() {
        TreeMap<Long, Dictionary> AREA = new TreeMap<Long, Dictionary>();
        try {
            HashMap<String, String> condition = new HashMap<String, String>();
            condition.put("dictype", DicType.AREA.toString());
            List<Dictionary> areaList = dicDao.queryList(condition, new Pager[0]);
            if (ObjectUtils.isNull(areaList)) {
                throw new NullPointerException("AREA is null");
            }
            for (Dictionary dictionary : areaList) {
                AREA.put(dictionary.getDicid(), dictionary);
            }
            MemCached.set(DIC_AREA, AREA, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void reloadDISTRICT() {
        TreeMap<Long, Dictionary> DISTRICT = new TreeMap<Long, Dictionary>();
        try {
            HashMap<String, String> condition = new HashMap<String, String>();
            condition.put("dictype", DicType.DISTRICT.toString());
            List<Dictionary> districtList = dicDao.queryList(condition, new Pager[0]);
            if (ObjectUtils.isNull(districtList)) {
                throw new NullPointerException("DISTRICT is null");
            }
            for (Dictionary dictionary : districtList) {
                DISTRICT.put(dictionary.getDicid(), dictionary);
            }
            MemCached.set(DIC_DISTRICT, DISTRICT, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void reloadCATEGORY_PARENT() {
        TreeMap<Long, Dictionary> CATEGORY_PARENT = new TreeMap<Long, Dictionary>();
        try {
            HashMap<String, String> condition = new HashMap<String, String>();
            condition.put("dictype", DicType.CATEGORY_PARENT.toString());
            List<Dictionary> districtList = dicDao.queryList(condition, new Pager[0]);
            if (ObjectUtils.isNull(districtList)) {
                throw new NullPointerException("CATEGORY_PARENT is null");
            }
            for (Dictionary dictionary : districtList) {
                CATEGORY_PARENT.put(dictionary.getDicid(), dictionary);
            }
            MemCached.set(DIC_CATEGORY_PARENT, CATEGORY_PARENT, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void reloadCATEGORY_CHILD() {
        TreeMap<Long, Dictionary> CATEGORY_CHILD = new TreeMap<Long, Dictionary>();
        try {
            HashMap<String, String> condition = new HashMap<String, String>();
            condition.put("dictype", DicType.CATEGORY_CHILD.toString());
            List<Dictionary> districtList = dicDao.queryList(condition, new Pager[0]);
            if (ObjectUtils.isNull(districtList)) {
                throw new NullPointerException("CATEGORY_CHILD is null");
            }
            for (Dictionary dictionary : districtList) {
                CATEGORY_CHILD.put(dictionary.getDicid(), dictionary);
            }
            MemCached.set(DIC_CATEGORY_CHILD, CATEGORY_CHILD, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void reloadQUALIFICATION() {
        TreeMap<Long, Dictionary> QUALIFICATION = new TreeMap<Long, Dictionary>();
        try {
            HashMap<String, String> condition = new HashMap<String, String>();
            condition.put("dictype", DicType.QUALIFICATION.toString());
            List<Dictionary> qualificationList = dicDao.queryList(condition, new Pager[0]);
            if (ObjectUtils.isNull(qualificationList)) {
                throw new NullPointerException("QUALIFICATION is null");
            }
            for (Dictionary dictionary : qualificationList) {
                QUALIFICATION.put(dictionary.getDicid(), dictionary);
            }
            MemCached.set(DIC_QUALIFICATION, QUALIFICATION, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void reloadGUESTINTENTION() {
        TreeMap<Long, Dictionary> GUEST_INTENTION = new TreeMap<Long, Dictionary>();
        try {
            HashMap<String, String> condition = new HashMap<String, String>();
            condition.put("dictype", DicType.GUESTINTENTION.toString());
            List<Dictionary> guestintentionList = dicDao.queryList(condition, new Pager[0]);
            if (ObjectUtils.isNull(guestintentionList)) {
                throw new NullPointerException("GUESTINTENTION is null");
            }
            for (Dictionary dictionary : guestintentionList) {
                GUEST_INTENTION.put(dictionary.getDicid(), dictionary);
            }
            MemCached.set(DIC_GUEST_INTENTION, GUEST_INTENTION, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void reloadBANK() {
        TreeMap<Long, BankInfo> BANK_PARENT = new TreeMap<Long, BankInfo>();
        try {
            List<BankInfo> bankList = dicDao.queryBankList(new HashMap<String, String>(), new int[0]);
            if (ObjectUtils.isNull(bankList)) {
                throw new NullPointerException("BANK_PARENT is null");
            }
            for (BankInfo bankInfo : bankList) {
                BANK_PARENT.put(bankInfo.getBankId(), bankInfo);
            }
            MemCached.set(DIC_BANK_PARENT, BANK_PARENT, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void reloadCONTRACTREJECTEDCLASSIFICATION() {
        TreeMap<Long, Dictionary> CONTRACTREJECTEDCLASSIFICATION = new TreeMap<Long, Dictionary>();
        try {
            HashMap<String, String> condition = new HashMap<String, String>();
            condition.put("dictype", DicType.CONTRACTREJECTEDCLASSIFICATION.toString());
            List<Dictionary> list = dicDao.queryList(condition, new Pager[0]);
            if (ObjectUtils.isNull(list)) {
                throw new NullPointerException("CONTRACTREJECTEDCLASSIFICATION is null");
            }
            for (Dictionary dictionary : list) {
                CONTRACTREJECTEDCLASSIFICATION.put(dictionary.getDicid(), dictionary);
            }
            MemCached.set(DIC_CONTRACTREJECTEDCLASSIFICATION, CONTRACTREJECTEDCLASSIFICATION, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void reloadCONTRACTREJECTEDREASONS() {
        TreeMap<Long, Dictionary> CONTRACTREJECTEDREASONS = new TreeMap<Long, Dictionary>();
        try {
            HashMap<String, String> condition = new HashMap<String, String>();
            condition.put("dictype", DicType.CONTRACTREJECTEDREASONS.toString());
            List<Dictionary> list = dicDao.queryList(condition, new Pager[0]);
            if (ObjectUtils.isNull(list)) {
                throw new NullPointerException("CONTRACTREJECTEDREASONS is null");
            }
            for (Dictionary dictionary : list) {
                CONTRACTREJECTEDREASONS.put(dictionary.getDicid(), dictionary);
            }
            MemCached.set(DIC_CONTRACTREJECTEDREASONS, CONTRACTREJECTEDREASONS, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void reloadOFFICECONTRACTCODE() {
        TreeMap<Long, OfficeContractCode> OFFICE_CONTRACT_CODE = new TreeMap<Long, OfficeContractCode>();
        try {
            List<OfficeContractCode> occList = dicDao.queryContractCodeList(new HashMap<String, String>(), new Pager[0]);
            if (!ObjectUtils.isNull(occList)) {
                for (OfficeContractCode occ : occList) {
                    OFFICE_CONTRACT_CODE.put(occ.getOfficeid(), occ);
                }
                MemCached.set(DIC_OFFICE_CONTRACT_CODE, OFFICE_CONTRACT_CODE, 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void reloadLABEL() {
        TreeMap<Long, Dictionary> LABEL = new TreeMap<Long, Dictionary>();
        try {
            HashMap<String, String> condition = new HashMap<String, String>();
            condition.put("dictype", DicType.LABEL.toString());
            List<Dictionary> list = dicDao.queryList(condition, new Pager[0]);
            if (ObjectUtils.isNull(list)) {
                throw new NullPointerException("LABEL is null");
            }
            for (Dictionary dictionary : list) {
                LABEL.put(dictionary.getDicid(), dictionary);
            }
            MemCached.set(DIC_LABEL, LABEL, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void reloadCUISINE() {
        TreeMap<Long, Dictionary> CUISINE = new TreeMap<Long, Dictionary>();
        try {
            HashMap<String, String> condition = new HashMap<String, String>();
            condition.put("dictype", DicType.CUISINE.toString());
            List<Dictionary> list = dicDao.queryList(condition, new Pager[0]);
            if (ObjectUtils.isNull(list)) {
                throw new NullPointerException("CUISINE is null");
            }
            for (Dictionary dictionary : list) {
                CUISINE.put(dictionary.getDicid(), dictionary);
            }
            MemCached.set(DIC_CUISINE, CUISINE, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void reloadENVIRONMENT() {
        TreeMap<Long, Dictionary> ENVIRONMENT = new TreeMap<Long, Dictionary>();
        try {
            HashMap<String, String> condition = new HashMap<String, String>();
            condition.put("dictype", DicType.ENVIRONMENT.toString());
            List<Dictionary> list = dicDao.queryList(condition, new Pager[0]);
            if (ObjectUtils.isNull(list)) {
                throw new NullPointerException("ENVIRONMENT is null");
            }
            for (Dictionary dictionary : list) {
                ENVIRONMENT.put(dictionary.getDicid(), dictionary);
            }
            MemCached.set(DIC_ENVIRONMENT, ENVIRONMENT, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void reloadRECEPTIONCAPACITY() {
        TreeMap<Long, Dictionary> RECEPTIONCAPACITY = new TreeMap<Long, Dictionary>();
        try {
            HashMap<String, String> condition = new HashMap<String, String>();
            condition.put("dictype", DicType.RECEPTIONCAPACITY.toString());
            List<Dictionary> list = dicDao.queryList(condition, new Pager[0]);
            if (ObjectUtils.isNull(list)) {
                throw new NullPointerException("RECEPTIONCAPACITY is null");
            }
            for (Dictionary dictionary : list) {
                RECEPTIONCAPACITY.put(dictionary.getDicid(), dictionary);
            }
            MemCached.set(DIC_RECEPTIONCAPACITY, RECEPTIONCAPACITY, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void reloadOTHERSERVICES() {
        TreeMap<Long, Dictionary> OTHERSERVICES = new TreeMap<Long, Dictionary>();
        try {
            HashMap<String, String> condition = new HashMap<String, String>();
            condition.put("dictype", DicType.OTHERSERVICES.toString());
            List<Dictionary> list = dicDao.queryList(condition, new Pager[0]);
            if (ObjectUtils.isNull(list)) {
                throw new NullPointerException("OTHERSERVICES is null");
            }
            for (Dictionary dictionary : list) {
                OTHERSERVICES.put(dictionary.getDicid(), dictionary);
            }
            MemCached.set(DIC_OTHERSERVICES, OTHERSERVICES, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void reloadSERVICEEVENTCLASS() {
        TreeMap<Long, Dictionary> SERVICEEVENTCLASS = new TreeMap<Long, Dictionary>();
        try {
            HashMap<String, String> condition = new HashMap<String, String>();
            condition.put("dictype", DicType.SERVICEEVENTCLASS.toString());
            List<Dictionary> list = dicDao.queryList(condition, new Pager[0]);
            if (ObjectUtils.isNull(list)) {
                throw new NullPointerException("SERVICEEVENTCLASS is null");
            }
            for (Dictionary dictionary : list) {
                SERVICEEVENTCLASS.put(dictionary.getDicid(), dictionary);
            }
            MemCached.set(DIC_SERVICEEVENTCLASS, SERVICEEVENTCLASS, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void reloadSERVICEEVENT() {
        TreeMap<Long, Dictionary> SERVICEEVENT = new TreeMap<Long, Dictionary>();
        try {
            HashMap<String, String> condition = new HashMap<String, String>();
            condition.put("dictype", DicType.SERVICEEVENT.toString());
            List<Dictionary> list = dicDao.queryList(condition, new Pager[0]);
            if (ObjectUtils.isNull(list)) {
                throw new NullPointerException("SERVICEEVENT is null");
            }
            for (Dictionary dictionary : list) {
                SERVICEEVENT.put(dictionary.getDicid(), dictionary);
            }
            MemCached.set(DIC_SERVICEEVENT, SERVICEEVENT, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void reloadZCBSERVICE() {
        TreeMap<Long, Dictionary> ZCBSERVICE = new TreeMap<Long, Dictionary>();
        try {
            HashMap<String, String> condition = new HashMap<String, String>();
            condition.put("dictype", DicType.ZCBSERVICE.toString());
            List<Dictionary> list = dicDao.queryList(condition, new Pager[0]);
            if (ObjectUtils.isNull(list)) {
                throw new NullPointerException("ZCBSERVICE is null");
            }
            for (Dictionary dictionary : list) {
                ZCBSERVICE.put(dictionary.getDicid(), dictionary);
            }
            MemCached.set(DIC_ZCB_SERVICE, ZCBSERVICE, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Map<Long, Dictionary> PROVINCE() {
        Map PROVINCE = (Map)MemCached.get(DIC_PROVINCE);
        if (ObjectUtils.isNull(PROVINCE)) {
            ConstantDic.reloadPROVINCE();
            PROVINCE = (Map)MemCached.get(DIC_PROVINCE);
        }
        return PROVINCE;
    }

    public static Map<Long, Dictionary> CITY() {
        Map CITY = (Map)MemCached.get(DIC_CITY);
        if (ObjectUtils.isNull(CITY)) {
            ConstantDic.reloadCITY();
            CITY = (Map)MemCached.get(DIC_CITY);
        }
        return CITY;
    }

    public static Map<Long, Dictionary> AREA() {
        Map AREA = (Map)MemCached.get(DIC_AREA);
        if (ObjectUtils.isNull(AREA)) {
            ConstantDic.reloadAREA();
            AREA = (Map)MemCached.get(DIC_AREA);
        }
        return AREA;
    }

    public static Map<Long, Dictionary> DISTRICT() {
        Map DISTRICT = (Map)MemCached.get(DIC_DISTRICT);
        if (ObjectUtils.isNull(DISTRICT)) {
            ConstantDic.reloadDISTRICT();
            DISTRICT = (Map)MemCached.get(DIC_DISTRICT);
        }
        return DISTRICT;
    }

    public static Map<Long, Dictionary> CATEGORY_PARENT() {
        Map CATEGORY_PARENT = (Map)MemCached.get(DIC_CATEGORY_PARENT);
        if (ObjectUtils.isNull(CATEGORY_PARENT)) {
            ConstantDic.reloadCATEGORY_PARENT();
            CATEGORY_PARENT = (Map)MemCached.get(DIC_CATEGORY_PARENT);
        }
        return CATEGORY_PARENT;
    }

    public static Map<Long, Dictionary> CATEGORY_CHILD() {
        Map CATEGORY_CHILD = (Map)MemCached.get(DIC_CATEGORY_CHILD);
        if (ObjectUtils.isNull(CATEGORY_CHILD)) {
            ConstantDic.reloadCATEGORY_CHILD();
            CATEGORY_CHILD = (Map)MemCached.get(DIC_CATEGORY_CHILD);
        }
        return CATEGORY_CHILD;
    }

    public static Map<Long, Dictionary> QUALIFICATION() {
        Map QUALIFICATION = (Map)MemCached.get(DIC_QUALIFICATION);
        if (ObjectUtils.isNull(QUALIFICATION)) {
            ConstantDic.reloadQUALIFICATION();
            QUALIFICATION = (Map)MemCached.get(DIC_QUALIFICATION);
        }
        return QUALIFICATION;
    }

    public static Map<Long, Dictionary> GUEST_INTENTION() {
        Map GUEST_INTENTION = (Map)MemCached.get(DIC_GUEST_INTENTION);
        if (ObjectUtils.isNull(GUEST_INTENTION)) {
            ConstantDic.reloadGUESTINTENTION();
            GUEST_INTENTION = (Map)MemCached.get(DIC_GUEST_INTENTION);
        }
        return GUEST_INTENTION;
    }

    public static Map<Long, BankInfo> BANK_PARENT() {
        Map BANK_PARENT = (Map)MemCached.get(DIC_BANK_PARENT);
        if (ObjectUtils.isNull(BANK_PARENT)) {
            ConstantDic.reloadBANK();
            BANK_PARENT = (Map)MemCached.get(DIC_BANK_PARENT);
        }
        return BANK_PARENT;
    }

    public static Map<Long, Dictionary> CONTRACTREJECTEDCLASSIFICATION() {
        Map CONTRACTREJECTEDCLASSIFICATION = (Map)MemCached.get(DIC_CONTRACTREJECTEDCLASSIFICATION);
        if (ObjectUtils.isNull(CONTRACTREJECTEDCLASSIFICATION)) {
            ConstantDic.reloadCONTRACTREJECTEDCLASSIFICATION();
            CONTRACTREJECTEDCLASSIFICATION = (Map)MemCached.get(DIC_CONTRACTREJECTEDCLASSIFICATION);
        }
        return CONTRACTREJECTEDCLASSIFICATION;
    }

    public static Map<Long, Dictionary> CONTRACTREJECTEDREASONS() {
        Map CONTRACTREJECTEDREASONS = (Map)MemCached.get(DIC_CONTRACTREJECTEDREASONS);
        if (ObjectUtils.isNull(CONTRACTREJECTEDREASONS)) {
            ConstantDic.reloadCONTRACTREJECTEDREASONS();
            CONTRACTREJECTEDREASONS = (Map)MemCached.get(DIC_CONTRACTREJECTEDREASONS);
        }
        return CONTRACTREJECTEDREASONS;
    }

    public static Map<Long, OfficeContractCode> OFFICECONTRACTCODE() {
        Map OFFICE_CONTRACT_CODE = (Map)MemCached.get(DIC_OFFICE_CONTRACT_CODE);
        if (ObjectUtils.isNull(OFFICE_CONTRACT_CODE)) {
            ConstantDic.reloadOFFICECONTRACTCODE();
            OFFICE_CONTRACT_CODE = (Map)MemCached.get(DIC_OFFICE_CONTRACT_CODE);
        }
        return OFFICE_CONTRACT_CODE;
    }

    public static Map<Long, Dictionary> LABEL() {
        Map LABEL = (Map)MemCached.get(DIC_LABEL);
        if (ObjectUtils.isNull(LABEL)) {
            ConstantDic.reloadLABEL();
            LABEL = (Map)MemCached.get(DIC_LABEL);
        }
        return LABEL;
    }

    public static Map<Long, Dictionary> CUISINE() {
        Map CUISINE = (Map)MemCached.get(DIC_CUISINE);
        if (ObjectUtils.isNull(CUISINE)) {
            ConstantDic.reloadCUISINE();
            CUISINE = (Map)MemCached.get(DIC_CUISINE);
        }
        return CUISINE;
    }

    public static Map<Long, Dictionary> ENVIRONMENT() {
        Map ENVIRONMENT = (Map)MemCached.get(DIC_ENVIRONMENT);
        if (ObjectUtils.isNull(ENVIRONMENT)) {
            ConstantDic.reloadENVIRONMENT();
            ENVIRONMENT = (Map)MemCached.get(DIC_ENVIRONMENT);
        }
        return ENVIRONMENT;
    }

    public static Map<Long, Dictionary> RECEPTIONCAPACITY() {
        Map RECEPTIONCAPACITY = (Map)MemCached.get(DIC_RECEPTIONCAPACITY);
        if (ObjectUtils.isNull(RECEPTIONCAPACITY)) {
            ConstantDic.reloadRECEPTIONCAPACITY();
            RECEPTIONCAPACITY = (Map)MemCached.get(DIC_RECEPTIONCAPACITY);
        }
        return RECEPTIONCAPACITY;
    }

    public static Map<Long, Dictionary> OTHERSERVICES() {
        Map OTHERSERVICES = (Map)MemCached.get(DIC_OTHERSERVICES);
        if (ObjectUtils.isNull(OTHERSERVICES)) {
            ConstantDic.reloadOTHERSERVICES();
            OTHERSERVICES = (Map)MemCached.get(DIC_OTHERSERVICES);
        }
        return OTHERSERVICES;
    }

    public static Map<Long, Dictionary> SERVICEEVENTCLASS() {
        Map SERVICEEVENTCLASS = (Map)MemCached.get(DIC_SERVICEEVENTCLASS);
        if (ObjectUtils.isNull(SERVICEEVENTCLASS)) {
            ConstantDic.reloadSERVICEEVENTCLASS();
            SERVICEEVENTCLASS = (Map)MemCached.get(DIC_SERVICEEVENTCLASS);
        }
        return SERVICEEVENTCLASS;
    }

    public static Map<Long, Dictionary> SERVICEEVENT() {
        Map SERVICEEVENT = (Map)MemCached.get(DIC_SERVICEEVENT);
        if (ObjectUtils.isNull(SERVICEEVENT)) {
            ConstantDic.reloadSERVICEEVENT();
            SERVICEEVENT = (Map)MemCached.get(DIC_SERVICEEVENT);
        }
        return SERVICEEVENT;
    }

    public static Map<Long, Dictionary> ZCBSERVICE() {
        Map ZCBSERVICE = (Map)MemCached.get(DIC_ZCB_SERVICE);
        if (ObjectUtils.isNull(ZCBSERVICE)) {
            ConstantDic.reloadZCBSERVICE();
            ZCBSERVICE = (Map)MemCached.get(DIC_ZCB_SERVICE);
        }
        return ZCBSERVICE;
    }
}

