/*
 * Decompiled with CFR 0.152.
 */
package com.qianpin.common.utils;

import com.qianpin.common.core.cache.MemCached;
import com.qianpin.common.user.dao.UserDao;
import com.qianpin.common.user.entity.PostInfo;
import com.qianpin.common.user.entity.RoleInfo;
import com.qianpin.common.utils.AppUtils;
import com.qianpin.common.utils.ObjectUtils;
import com.qianpin.common.utils.security.SecurityTool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ConstantUser {
    public static final String COUNTOFERRORS = "QP_COMMONS_ERRORS_";
    public static final String VERICODE = "QP_COMMONS_VERICODE_";
    public static final String USER = "QP_COMMONS_USER_";
    public static final String COOKIE_UCID = "QP_COMMONS_UCID";
    public static final String COOKIE_UCNAME = "QP_COMMONS_UCNAME";
    public static final String COOKIE_PWD = "QP_COMMONS_PWD";
    public static final String COOKIE_UUID = "QP_COMMONSUUID";
    private static final String USER_POST = "QP_COMMONS_USER_POST";
    private static final String USER_POST_PID = "QP_COMMONS_USER_POST_PID";
    private static final String USER_POST_CHILD_ID = "QP_COMMONS_USER_POST_CHILD_ID";
    private static final String USER_POST_CHILD_BEAN = "QP_COMMONS_USER_POST_CHILD_BEAN";
    private static final String USER_OFFICE = "QP_COMMONS_USER_OFFICE";
    private static final String USER_TEAM = "QP_COMMONS_USER_TEAM";
    private static final String USER_ROLE = "QP_COMMONS_USER_ROLE";
    public static final Long UNGIVEN = 0L;
    public static final Long ISGIVEN = 1L;
    public static final String YHGL = "YHGL";
    public static final String XS = "XS";
    public static final String XSZG = "XSZG";
    public static final String FGSYY = "FGSYY";
    public static final String FGSYYZG = "FGSYYZG";
    public static final String ZBYY = "ZBYY";
    public static final String HTSHY = "HTSHY";
    public static final String SGBFZR = "SGBFZR";
    public static final String GJHTSHY = "GJHTSHY";
    public static final String WXHYKSH = "WXHYKSH";
    public static final String SJJGGLY = "SJJGGLY";
    public static final String SFFZR = "SFFZR";
    public static final String SFGJR = "SFGJR";
    public static final String BJFZR = "BJFZR";
    public static final String BJGJR = "BJGJR";
    public static final String CWFZR = "CWFZR";
    public static final String CWGJR = "CWGJR";
    public static final String ZD = "OPENZD";
    public static final String FD = "OPENFD";
    public static final String CWJL = "CWJL";
    public static final String CWZY = "CWZY";

    public static void reloadPOST() {
        LinkedHashMap<Long, PostInfo> POST = new LinkedHashMap<Long, PostInfo>();
        try {
            UserDao userDao = (UserDao)AppUtils.getBean("userDao");
            List<PostInfo> postList = userDao.queryPostInfo();
            if (ObjectUtils.isNull(postList)) {
                throw new NullPointerException("POST is null");
            }
            for (PostInfo postInfo : postList) {
                POST.put(postInfo.getPostid(), postInfo);
            }
            MemCached.set(USER_POST, POST, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void reloadPOST_PID() {
        LinkedHashMap POST_PID = new LinkedHashMap();
        Map POST = (Map)MemCached.get(USER_POST);
        if (ObjectUtils.isNull(POST)) {
            ConstantUser.reloadPOST();
            POST = (Map)MemCached.get(USER_POST);
        }
        for (PostInfo post : POST.values()) {
            Long parentId = post.getParentid();
            if (ObjectUtils.isNull((List)POST_PID.get(parentId))) {
                ArrayList<Long> list = new ArrayList<Long>();
                list.add(post.getPostid());
                POST_PID.put(post.getParentid(), list);
                continue;
            }
            ((List)POST_PID.get(parentId)).add(post.getPostid());
        }
        MemCached.set(USER_POST_PID, POST_PID, 0);
    }

    public static void reloadOFFICE() {
        LinkedHashMap<Long, PostInfo> OFFICE = new LinkedHashMap<Long, PostInfo>();
        Map POST = (Map)MemCached.get(USER_POST);
        if (ObjectUtils.isNull(POST)) {
            ConstantUser.reloadPOST();
            POST = (Map)MemCached.get(USER_POST);
        }
        for (Map.Entry entry : POST.entrySet()) {
            if (((PostInfo)entry.getValue()).getOffice().compareTo(1L) != 0 || ((PostInfo)entry.getValue()).getPostType().compareTo(1L) != 0) continue;
            OFFICE.put((Long)entry.getKey(), (PostInfo)entry.getValue());
        }
        MemCached.set(USER_OFFICE, OFFICE, 0);
    }

    public static void reloadTEAM() {
        LinkedHashMap<Long, PostInfo> TEAM = new LinkedHashMap<Long, PostInfo>();
        Map POST = (Map)MemCached.get(USER_POST);
        if (ObjectUtils.isNull(POST)) {
            ConstantUser.reloadPOST();
            POST = (Map)MemCached.get(USER_POST);
        }
        for (Map.Entry entry : POST.entrySet()) {
            if (((PostInfo)entry.getValue()).getOffice().compareTo(1L) != 0 || ((PostInfo)entry.getValue()).getPostType().compareTo(2L) != 0) continue;
            TEAM.put((Long)entry.getKey(), (PostInfo)entry.getValue());
        }
        MemCached.set(USER_TEAM, TEAM, 0);
    }

    public static void reloadROLE() {
        LinkedHashMap<Long, RoleInfo> ROLE = new LinkedHashMap<Long, RoleInfo>();
        try {
            UserDao userDao = (UserDao)AppUtils.getBean("userDao");
            List<RoleInfo> roleList = userDao.queryRoleInfo();
            if (ObjectUtils.isNull(roleList)) {
                throw new NullPointerException("ROLE is null");
            }
            for (RoleInfo roleInfo : roleList) {
                ROLE.put(roleInfo.getRoleid(), roleInfo);
            }
            MemCached.set(USER_ROLE, ROLE, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void reloadPOST_CHILD() {
        int COUNT = 4;
        HashMap<Long, List<Long>> POST_CHILD_ID = new HashMap<Long, List<Long>>();
        HashMap<Long, PostInfo> POST_CHILD_BEAN = new HashMap<Long, PostInfo>();
        List<Long> postList = null;
        int i = 0;
        while (i < COUNT) {
            if (i == 0) {
                postList = ConstantUser.POST_PID(0L);
            }
            if (ObjectUtils.isNull(postList)) break;
            ArrayList<Long> temp = new ArrayList<Long>();
            for (Long postid : postList) {
                List<Long> chilePost = ConstantUser.chilePost(postid);
                PostInfo postInfo = ConstantUser.POST(postid);
                ConstantUser.chilePost(postInfo);
                POST_CHILD_ID.put(postid, chilePost);
                POST_CHILD_BEAN.put(postid, postInfo);
                List<Long> clist = ConstantUser.POST_PID(postid);
                if (ObjectUtils.isNull(clist)) continue;
                temp.addAll(clist);
            }
            postList.clear();
            postList.addAll(temp);
            ++i;
        }
        MemCached.set(USER_POST_CHILD_ID, POST_CHILD_ID, 0);
        MemCached.set(USER_POST_CHILD_BEAN, POST_CHILD_BEAN, 0);
    }

    public static PostInfo POST(Long postid) {
        Map POST = (Map)MemCached.get(USER_POST);
        if (ObjectUtils.isNull(POST)) {
            ConstantUser.reloadPOST();
            POST = (Map)MemCached.get(USER_POST);
        }
        return ObjectUtils.isNull(POST) ? null : (PostInfo)POST.get(postid);
    }

    public static Map<Long, PostInfo> POST() {
        Map POST = (Map)MemCached.get(USER_POST);
        if (ObjectUtils.isNull(POST)) {
            ConstantUser.reloadPOST();
            POST = (Map)MemCached.get(USER_POST);
        }
        return ObjectUtils.isNull(POST) ? null : POST;
    }

    public static List<Long> POST_PID(Long parentid) {
        Map POST_PID = (Map)MemCached.get(USER_POST_PID);
        if (ObjectUtils.isNull(POST_PID)) {
            ConstantUser.reloadPOST_PID();
            POST_PID = (Map)MemCached.get(USER_POST_PID);
        }
        return ObjectUtils.isNull(POST_PID) ? null : (List)POST_PID.get(parentid);
    }

    public static PostInfo OFFICE(Long officeid) {
        Map OFFICE = (Map)MemCached.get(USER_OFFICE);
        if (ObjectUtils.isNull(OFFICE)) {
            ConstantUser.reloadOFFICE();
            OFFICE = (Map)MemCached.get(USER_OFFICE);
        }
        return ObjectUtils.isNull(OFFICE) ? null : (PostInfo)OFFICE.get(officeid);
    }

    public static Map<Long, PostInfo> OFFICE() {
        Map OFFICE = (Map)MemCached.get(USER_OFFICE);
        if (ObjectUtils.isNull(OFFICE)) {
            ConstantUser.reloadOFFICE();
            OFFICE = (Map)MemCached.get(USER_OFFICE);
        }
        return OFFICE;
    }

    public static PostInfo TEAM(Long teamid) {
        Map TEAM = (Map)MemCached.get(USER_TEAM);
        if (ObjectUtils.isNull(TEAM)) {
            ConstantUser.reloadTEAM();
            TEAM = (Map)MemCached.get(USER_TEAM);
        }
        return ObjectUtils.isNull(TEAM) ? null : (PostInfo)TEAM.get(teamid);
    }

    public static Map<Long, PostInfo> TEAM() {
        Map TEAM = (Map)MemCached.get(USER_TEAM);
        if (ObjectUtils.isNull(TEAM)) {
            ConstantUser.reloadTEAM();
            TEAM = (Map)MemCached.get(USER_TEAM);
        }
        return TEAM;
    }

    public static Map<Long, RoleInfo> ROLE() {
        Map ROLE = (Map)MemCached.get(USER_ROLE);
        if (ObjectUtils.isNull(ROLE)) {
            ConstantUser.reloadROLE();
            ROLE = (Map)MemCached.get(USER_ROLE);
        }
        return ROLE;
    }

    public static RoleInfo ROLE(Long roleid) {
        Map ROLE = (Map)MemCached.get(USER_ROLE);
        if (ObjectUtils.isNull(ROLE)) {
            ConstantUser.reloadROLE();
            ROLE = (Map)MemCached.get(USER_ROLE);
        }
        return ObjectUtils.isNull(roleid) ? null : (RoleInfo)ROLE.get(roleid);
    }

    private static List<Long> chilePost(Long postid) {
        ArrayList<Long> postids = new ArrayList<Long>();
        List<Long> cList = ConstantUser.POST_PID(postid);
        if (ObjectUtils.isNull(cList)) {
            return postids;
        }
        postids.addAll(cList);
        ArrayList<Long> temp = new ArrayList<Long>();
        for (Long pid : postids) {
            temp.addAll(ConstantUser.chilePost(pid));
        }
        postids.addAll(temp);
        return postids;
    }

    public static List<Long> getChilePost(Long postid) {
        List postids;
        Map POST_CHILD_ID = (Map)MemCached.get(USER_POST_CHILD_ID);
        if (ObjectUtils.isNull(POST_CHILD_ID)) {
            ConstantUser.reloadPOST_CHILD();
            POST_CHILD_ID = (Map)MemCached.get(USER_POST_CHILD_ID);
        }
        if (!ObjectUtils.isNull(postids = (List)POST_CHILD_ID.get(postid))) {
            return postids;
        }
        return ConstantUser.chilePost(postid);
    }

    private static void chilePost(PostInfo postInfo) {
        List<Long> cList = ConstantUser.POST_PID(postInfo.getPostid());
        if (ObjectUtils.isNull(cList)) {
            return;
        }
        for (Long id : cList) {
            postInfo.getChildPost().add(ConstantUser.POST(id));
        }
        for (PostInfo pi : postInfo.getChildPost()) {
            ConstantUser.chilePost(pi);
        }
    }

    public static PostInfo getChilePostInfo(Long postid) {
        PostInfo postInfo;
        Map POST_CHILD_BEAN = (Map)MemCached.get(USER_POST_CHILD_BEAN);
        if (ObjectUtils.isNull(POST_CHILD_BEAN)) {
            ConstantUser.reloadPOST_CHILD();
            POST_CHILD_BEAN = (Map)MemCached.get(USER_POST_CHILD_BEAN);
        }
        if (ObjectUtils.isNull(postInfo = (PostInfo)POST_CHILD_BEAN.get(postid))) {
            postInfo = ConstantUser.POST(postid);
            ConstantUser.chilePost(postInfo);
        }
        return postInfo;
    }

    public static List<Long> getParentPost(Long postid) {
        ArrayList<Long> postids = new ArrayList<Long>();
        PostInfo postInfo = ConstantUser.POST(postid);
        while (!ObjectUtils.isNull(postInfo)) {
            postids.add(postInfo.getPostid());
            postInfo = ConstantUser.POST(postInfo.getParentid());
        }
        return postids;
    }

    public static Long getBranchOffice(Long postid) {
        PostInfo postInfo = ConstantUser.POST(postid);
        while (!ObjectUtils.isNull(postInfo)) {
            if (postInfo.getOffice().compareTo(1L) == 0) {
                return postInfo.getPostid();
            }
            postInfo = ConstantUser.POST(postInfo.getParentid());
        }
        return 0L;
    }

    public static Long getRootPost(Long postid) {
        PostInfo postInfo = ConstantUser.POST(postid);
        while (!ObjectUtils.isNull(postInfo)) {
            if (postInfo.getParentid().compareTo(0L) == 0) {
                return postInfo.getPostid();
            }
            postInfo = ConstantUser.POST(postInfo.getParentid());
        }
        return 0L;
    }

    public static void encryptPostid(PostInfo postInfo, Long ucid) {
        if (ObjectUtils.isNull(postInfo.getChildPost())) {
            return;
        }
        List<PostInfo> childPost = postInfo.getChildPost();
        for (PostInfo child : childPost) {
            Long postid = child.getPostid();
            String encryptPostid = SecurityTool.encryptValue(postid, ucid.toString());
            child.setEncryptPostId(encryptPostid);
            child.setPostid(0L);
            ConstantUser.encryptPostid(child, ucid);
        }
    }
}

