/*
 * Decompiled with CFR 0.152.
 */
package com.qianpin.common.utils;

import com.qianpin.common.utils.FileUtils;
import com.qianpin.common.utils.ObjectUtils;
import com.qianpin.common.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelUtils {
    public static int getColCount(Workbook workbook, Integer ... idx) {
        Sheet sheet = null;
        short colcount = 0;
        if (ObjectUtils.isNull(idx)) {
            sheet = workbook.getSheetAt(0);
            colcount = sheet.getRow(0).getLastCellNum();
        } else if (idx.length == 1) {
            sheet = workbook.getSheetAt(idx[0].intValue());
            colcount = sheet.getRow(0).getLastCellNum();
        } else {
            sheet = workbook.getSheetAt(idx[0].intValue());
            colcount = sheet.getRow(idx[1].intValue()).getLastCellNum();
        }
        return colcount;
    }

    private static Workbook getHSSFWorkbook(InputStream stream) throws IOException {
        return new HSSFWorkbook(stream);
    }

    private static Workbook getXSSFWorkbook(InputStream stream) throws IOException {
        return new XSSFWorkbook(stream);
    }

    public static Workbook getWorkbook(InputStream stream) {
        Workbook workbook = null;
        try {
            workbook = ExcelUtils.getHSSFWorkbook(stream);
        }
        catch (IOException e) {
            try {
                workbook = ExcelUtils.getXSSFWorkbook(stream);
            }
            catch (IOException e1) {
                e1.printStackTrace();
                return null;
            }
        }
        return workbook;
    }

    public static Workbook getWorkbook(File file) {
        if (file == null) {
            return null;
        }
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            String fileExt = FileUtils.getFileExt(file.getName());
            if (".xls".equalsIgnoreCase(fileExt)) {
                Workbook workbook = ExcelUtils.getHSSFWorkbook(stream);
                return workbook;
            }
            if (".xlsx".equalsIgnoreCase(fileExt)) {
                Workbook workbook = ExcelUtils.getXSSFWorkbook(stream);
                return workbook;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (stream != null) {
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static List<List<String>> getExcelToList(Workbook workbook, Integer ... idx) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        Sheet sheet = null;
        sheet = ObjectUtils.isNull(idx) ? workbook.getSheetAt(0) : workbook.getSheetAt(idx[0].intValue());
        int i = 0;
        if (!ObjectUtils.isNull(idx) && idx.length > 1) {
            i = idx[1];
        }
        while (i <= sheet.getLastRowNum()) {
            Row row = sheet.getRow(i);
            String value = null;
            ArrayList<String> values = new ArrayList<String>();
            if (!ObjectUtils.isNull(row)) {
                int j = 0;
                while (j < row.getLastCellNum()) {
                    Cell cell = row.getCell(j);
                    if (ObjectUtils.isNull(cell)) {
                        value = "";
                    } else {
                        switch (cell.getCellType()) {
                            case 0: {
                                value = ObjectUtils.numberFormat(cell.getNumericCellValue(), new String[0]);
                                break;
                            }
                            case 1: {
                                value = cell.getStringCellValue();
                                break;
                            }
                            case 4: {
                                value = String.valueOf(cell.getBooleanCellValue());
                                break;
                            }
                            default: {
                                value = "";
                            }
                        }
                    }
                    values.add(StringUtils.getStr(value));
                    ++j;
                }
                while (values.remove("")) {
                }
                if (!ObjectUtils.isNull(values)) {
                    result.add(values);
                }
            }
            ++i;
        }
        return result;
    }

    public static void getListToExcel(List<List<String>> list, String outpath, List<List<CellStyle>> cellstyle) {
        block15: {
            HSSFWorkbook workbook = new HSSFWorkbook();
            HSSFSheet sheet = workbook.createSheet();
            Cell cell = null;
            int i = 0;
            while (i < list.size()) {
                HSSFRow row = sheet.createRow(i);
                List<String> values = list.get(i);
                int j = 0;
                while (j < values.size()) {
                    cell = row.createCell(j);
                    cell.setCellValue(values.get(j));
                    if (!ObjectUtils.isNull(cellstyle)) {
                        cell.setCellStyle(cellstyle.get(i).get(j));
                    }
                    ++j;
                }
                ++i;
            }
            FileOutputStream fOut = null;
            try {
                try {
                    fOut = new FileOutputStream(outpath);
                    workbook.write((OutputStream)fOut);
                    fOut.flush();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (fOut == null) break block15;
                    try {
                        fOut.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (fOut != null) {
                    try {
                        fOut.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static void getListToExcel(List<List<String>> list, String outpath) {
        block14: {
            HSSFWorkbook workbook = new HSSFWorkbook();
            HSSFSheet sheet = workbook.createSheet();
            Cell cell = null;
            int i = 0;
            while (i < list.size()) {
                HSSFRow row = sheet.createRow(i);
                List<String> values = list.get(i);
                int j = 0;
                while (j < values.size()) {
                    cell = row.createCell(j);
                    cell.setCellValue(values.get(j));
                    ++j;
                }
                ++i;
            }
            FileOutputStream fOut = null;
            try {
                try {
                    fOut = new FileOutputStream(outpath);
                    workbook.write((OutputStream)fOut);
                    fOut.flush();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (fOut == null) break block14;
                    try {
                        fOut.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (fOut != null) {
                    try {
                        fOut.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

