/*
 * Decompiled with CFR 0.152.
 */
package com.qianpin.common.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ObjectUtils {
    private static Format FORMAT = new DecimalFormat("#.##");

    public static boolean isNull(Object o) {
        return o == null;
    }

    public static boolean isNull(List<?> list) {
        return list == null || list.size() == 0;
    }

    public static boolean isNull(Set<?> set) {
        return set == null || set.size() == 0;
    }

    public static boolean isNull(Map<?, ?> map) {
        return map == null || map.size() == 0;
    }

    public static boolean isNull(Long lg) {
        return lg == null || lg == 0L;
    }

    public static boolean isNull(Integer it) {
        return it == null || it == 0;
    }

    public static boolean isNull(File file) {
        return file == null || !file.exists();
    }

    public static boolean isNull(Object[] strs) {
        return strs == null || strs.length == 0;
    }

    public static Number getNumber(Number number) {
        return ObjectUtils.isNull(number) ? (Number)0L : (Number)number;
    }

    public static String numberFormat(Number number, String ... pattern) {
        if (ObjectUtils.isNull(pattern)) {
            return FORMAT.format(number);
        }
        return FORMAT.format(pattern[0]);
    }

    public static Object clone(Object o) {
        if (o == null) {
            return null;
        }
        ByteArrayOutputStream bos = null;
        ObjectOutputStream oos = null;
        ObjectInputStream ois = null;
        try {
            bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bos);
            oos.writeObject(o);
            ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
            Object object = ois.readObject();
            return object;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                }
                if (oos != null) {
                    oos.close();
                }
                if (ois != null) {
                    ois.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

