/*
 * Decompiled with CFR 0.152.
 */
package com.qianpin.common.utils;

import com.qianpin.common.utils.ObjectUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    public static final char[] c = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8'};

    public static boolean isBlank(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isBlank(Object obj) {
        return ObjectUtils.isNull(obj) ? true : StringUtils.isBlank(obj.toString());
    }

    public static String getStr(String str) {
        return StringUtils.isBlank(str) ? "" : str.trim();
    }

    public static String getStr(Object obj) {
        return ObjectUtils.isNull(obj) ? "" : obj.toString().trim();
    }

    public static boolean matches(String str, String regex) {
        if (StringUtils.isBlank(str)) {
            return false;
        }
        Pattern p = Pattern.compile(regex);
        Matcher matcher = p.matcher(str);
        return matcher.find();
    }

    public static String list2str(List<?> list, String ... prev) {
        String prefix;
        String string = prefix = ObjectUtils.isNull(prev) ? "" : prev[0];
        if (ObjectUtils.isNull(list)) {
            return String.valueOf(prefix) + "-1" + prefix;
        }
        StringBuffer sb = new StringBuffer();
        for (Object object : list) {
            sb.append(prefix);
            sb.append(object);
            sb.append(prefix);
            sb.append(",");
        }
        return sb.substring(0, sb.length() - 1);
    }

    public static String set2str(Set<?> set, String ... prev) {
        String prefix;
        String string = prefix = ObjectUtils.isNull(prev) ? "" : prev[0];
        if (ObjectUtils.isNull(set)) {
            return String.valueOf(prefix) + "-1" + prefix;
        }
        StringBuffer sb = new StringBuffer();
        for (Object object : set) {
            sb.append(prefix);
            sb.append(object);
            sb.append(prefix);
            sb.append(",");
        }
        return sb.substring(0, sb.length() - 1);
    }

    public static String array2str(Object[] arrays, String ... prev) {
        String prefix;
        String string = prefix = ObjectUtils.isNull(prev) ? "" : prev[0];
        if (ObjectUtils.isNull(arrays)) {
            return String.valueOf(prefix) + "-1" + prefix;
        }
        StringBuffer sb = new StringBuffer();
        Object[] objectArray = arrays;
        int n = arrays.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            sb.append(prefix);
            sb.append(object);
            sb.append(prefix);
            sb.append(",");
            ++n2;
        }
        return sb.substring(0, sb.length() - 1);
    }

    public static String subStr(String str, int length, String suffix) {
        if (StringUtils.isBlank(str)) {
            return "";
        }
        if (str.getBytes().length <= length) {
            return str;
        }
        int byteslen = 0;
        StringBuilder sb = new StringBuilder();
        char[] chars = str.toCharArray();
        int i = 0;
        while (i < chars.length - 1 && byteslen < length) {
            String c = String.valueOf(chars[i]);
            byteslen += c.getBytes().length;
            sb.append(chars[i]);
            ++i;
        }
        if (sb.length() != str.length()) {
            sb.append(suffix);
        }
        return sb.toString();
    }

    public static String sn(String sn, int len) {
        if (StringUtils.isBlank(sn)) {
            sn = "0";
        }
        if (!StringUtils.matches(sn, "^\\d+$")) {
            throw new IllegalArgumentException("sn(" + sn + ") is number");
        }
        String result = ((Object)(Long.parseLong(sn) + 1L)).toString();
        while (len > result.length()) {
            result = "0" + result;
        }
        return result;
    }

    public static String encode(String str) {
        if (StringUtils.isBlank(str)) {
            return "";
        }
        try {
            return URLEncoder.encode(str, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String repKeyString(String str) {
        if (StringUtils.isBlank(str)) {
            return "";
        }
        return str.replace("&", "&amp;").replace(">", "&gt;").replace("<", "&lt;").replace("\"", "&quot;").replace("'", "&apos;");
    }
}

