/*
 * Decompiled with CFR 0.152.
 */
package com.qianpin.common.utils;

import com.qianpin.common.utils.ObjectUtils;
import com.qianpin.common.utils.StringUtils;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class TimeUtils {
    public static String dateStr(Object obj) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        return df.format(obj);
    }

    public static String dateTimeStr(Object obj) {
        if (ObjectUtils.isNull(obj)) {
            return "";
        }
        if ("0000-00-00 00:00:00".equals(obj.toString())) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return df.format(obj);
    }

    public static String dateStr(Object obj, String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        return df.format(obj);
    }

    public static Date strToDate(String str) {
        if (!StringUtils.matches(str, "((^((1[8-9]\\d{2})|([2-9]\\d{3}))[-](10|12|0?[13578])[-](3[01]|[12][0-9]|0?[1-9])(\\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^((1[8-9]\\d{2})|([2-9]\\d{3}))[-](11|0?[469])[-](30|[12][0-9]|0?[1-9])(\\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^((1[8-9]\\d{2})|([2-9]\\d{3}))[-](0?2)[-](2[0-8]|1[0-9]|0?[1-9])(\\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^([2468][048]00)[-](0?2)[-](29)(\\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^([3579][26]00)[-](0?2)[-](29)(\\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^([1][89][0][48])[-](0?2)[-](29)(\\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^([2-9][0-9][0][48])[-](0?2)[-](29)(\\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^([1][89][2468][048])[-](0?2)[-](29)(\\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^([2-9][0-9][2468][048])[-](0?2)[-](29)(\\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^([1][89][13579][26])[-](0?2)[-](29)(\\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^([2-9][0-9][13579][26])[-](0?2)[-](29)(\\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$))")) {
            throw new RuntimeException("str is not date");
        }
        Date date = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            date = sdf.parse(str);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static Date strToDateTime(String str) {
        if (!StringUtils.matches(str, "((^((1[8-9]\\d{2})|([2-9]\\d{3}))[-](10|12|0?[13578])[-](3[01]|[12][0-9]|0?[1-9])(\\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^((1[8-9]\\d{2})|([2-9]\\d{3}))[-](11|0?[469])[-](30|[12][0-9]|0?[1-9])(\\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^((1[8-9]\\d{2})|([2-9]\\d{3}))[-](0?2)[-](2[0-8]|1[0-9]|0?[1-9])(\\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^([2468][048]00)[-](0?2)[-](29)(\\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^([3579][26]00)[-](0?2)[-](29)(\\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^([1][89][0][48])[-](0?2)[-](29)(\\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^([2-9][0-9][0][48])[-](0?2)[-](29)(\\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^([1][89][2468][048])[-](0?2)[-](29)(\\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^([2-9][0-9][2468][048])[-](0?2)[-](29)(\\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^([1][89][13579][26])[-](0?2)[-](29)(\\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^([2-9][0-9][13579][26])[-](0?2)[-](29)(\\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$))")) {
            throw new RuntimeException("str is not datetime");
        }
        Date date = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            date = sdf.parse(str);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static Timestamp strToTimeStamp(String str) {
        if (!StringUtils.matches(str, "((^((1[8-9]\\d{2})|([2-9]\\d{3}))[-](10|12|0?[13578])[-](3[01]|[12][0-9]|0?[1-9])(\\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^((1[8-9]\\d{2})|([2-9]\\d{3}))[-](11|0?[469])[-](30|[12][0-9]|0?[1-9])(\\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^((1[8-9]\\d{2})|([2-9]\\d{3}))[-](0?2)[-](2[0-8]|1[0-9]|0?[1-9])(\\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^([2468][048]00)[-](0?2)[-](29)(\\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^([3579][26]00)[-](0?2)[-](29)(\\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^([1][89][0][48])[-](0?2)[-](29)(\\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^([2-9][0-9][0][48])[-](0?2)[-](29)(\\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^([1][89][2468][048])[-](0?2)[-](29)(\\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^([2-9][0-9][2468][048])[-](0?2)[-](29)(\\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^([1][89][13579][26])[-](0?2)[-](29)(\\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^([2-9][0-9][13579][26])[-](0?2)[-](29)(\\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$))")) {
            throw new RuntimeException("str is not datetime");
        }
        if (str.contains(":")) {
            return new Timestamp(TimeUtils.strToDateTime(str).getTime());
        }
        return new Timestamp(TimeUtils.strToDate(str).getTime());
    }

    public static Date timestampToDate(Timestamp ts) {
        return ts;
    }

    public static Timestamp dateToTimestamp(Date date) {
        return TimeUtils.strToTimeStamp(TimeUtils.dateTimeStr(date));
    }

    public static Date getMinTime(Date dt) {
        Date dt1 = null;
        try {
            SimpleDateFormat sf = new SimpleDateFormat("yyyyMMdd");
            dt1 = sf.parse(sf.format(dt));
        }
        catch (ParseException e) {
            e.printStackTrace();
            System.out.println("date formate error \uff1a" + dt + ".   " + e.getMessage());
        }
        return dt1;
    }

    public static String getNextDay(Date date, int delay) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, delay);
        return TimeUtils.dateStr(c.getTime());
    }

    public static Timestamp getNextDay(Timestamp time, int delay) {
        Calendar c = Calendar.getInstance();
        c.setTime(TimeUtils.timestampToDate(time));
        c.add(5, delay);
        return new Timestamp(c.getTime().getTime());
    }

    public static Long diffTimeStamp(Timestamp time1, Timestamp time2, int type) {
        long t1 = 0L;
        long t2 = 0L;
        if (ObjectUtils.isNull(time1) || ObjectUtils.isNull(time2) || time1.before(time2)) {
            return 0L;
        }
        t1 = time1.getTime();
        t2 = time2.getTime();
        if (1 == type) {
            Long day = (t1 - t2) / 3600000L / 24L;
            return day;
        }
        if (2 == type) {
            Long hour = (t1 - t2) / 3600000L;
            return hour;
        }
        return 0L;
    }

    public static String DAYOFWEEK(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int week = calendar.get(7) - 1;
        switch (week) {
            case 0: {
                return "\u661f\u671f\u65e5";
            }
            case 1: {
                return "\u661f\u671f\u4e00";
            }
            case 2: {
                return "\u661f\u671f\u4e8c";
            }
            case 3: {
                return "\u661f\u671f\u4e09";
            }
            case 4: {
                return "\u661f\u671f\u56db";
            }
            case 5: {
                return "\u661f\u671f\u4e94";
            }
            case 6: {
                return "\u661f\u671f\u516d";
            }
        }
        return "";
    }
}

