/*
 * Decompiled with CFR 0.152.
 */
package com.qianpin.common.utils;

import com.qianpin.common.core.annotation.NotTransformation;
import com.qianpin.common.utils.ObjectUtils;
import com.qianpin.common.utils.StringUtils;
import com.qianpin.common.utils.TimeUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class WebUtils {
    public static final String METHOD_HEAD = "HEAD";
    public static final String METHOD_GET = "GET";
    public static final String METHOD_POST = "POST";
    public static final String HEADER_PRAGMA = "Pragma";
    public static final String HEADER_EXPIRES = "Expires";
    public static final String HEADER_CACHE_CONTROL = "Cache-Control";
    public static final int SESSION_COOKIE = -1;
    public static final int FOREVER_COOKIE = 315360000;

    protected WebUtils() {
    }

    public static Cookie cookie(String key, String value, int validy) {
        if (key != null && value != null) {
            Cookie cookie = new Cookie(key, value);
            cookie.setMaxAge(validy);
            cookie.setPath("/");
            return cookie;
        }
        return null;
    }

    public static Cookie cookie(String key, String value, int validy, String domainName) {
        if (key != null && value != null) {
            Cookie cookie = new Cookie(key, value);
            cookie.setMaxAge(validy);
            cookie.setPath("/");
            if (domainName != null) {
                cookie.setDomain(domainName);
            }
            return cookie;
        }
        return null;
    }

    public static Cookie removeableCookie(String key, String domainName) {
        if (key != null) {
            Cookie cookie = new Cookie(key, "");
            cookie.setMaxAge(0);
            cookie.setPath("/");
            if (domainName != null) {
                cookie.setDomain(domainName);
            }
            return cookie;
        }
        return null;
    }

    public static boolean areEquals(Cookie cookie1, Cookie cookie2) {
        return cookie1.getName().equals(cookie2.getName()) && (cookie1.getValue() != null ? cookie1.getValue().equals(cookie2.getValue()) : cookie2.getValue() == null) && cookie1.getMaxAge() == cookie2.getMaxAge() && cookie1.getSecure() == cookie2.getSecure() && cookie1.getVersion() == cookie2.getVersion() && (cookie1.getComment() != null ? cookie1.getComment().equals(cookie2.getComment()) : cookie2.getComment() == null) && (cookie1.getDomain() != null ? cookie1.getDomain().equals(cookie2.getDomain()) : cookie2.getDomain() == null) && (cookie1.getPath() != null ? cookie1.getPath().equals(cookie2.getPath()) : cookie2.getPath() == null);
    }

    public static final String getCookieValue(String key, HttpServletRequest req) {
        Object str = null;
        Cookie[] cookies = req.getCookies();
        if (cookies == null) {
            return null;
        }
        int i = 0;
        while (i < cookies.length && str == null) {
            Cookie cookie = cookies[i];
            if (cookie.getName().equals(key)) {
                return cookie.getValue();
            }
            ++i;
        }
        return null;
    }

    public static void applyCacheSeconds(HttpServletResponse response, int pageCacheSecond, boolean mustRevalidate) {
        if (pageCacheSecond > 0) {
            response.setDateHeader(HEADER_EXPIRES, System.currentTimeMillis() + (long)pageCacheSecond * 1000L);
            String headerValue = "max-age=" + pageCacheSecond;
            if (mustRevalidate) {
                headerValue = String.valueOf(headerValue) + ", must-revalidate";
            }
            response.setHeader(HEADER_CACHE_CONTROL, headerValue);
        } else if (pageCacheSecond == 0) {
            response.setHeader(HEADER_PRAGMA, "No-cache");
            response.setDateHeader(HEADER_EXPIRES, 1L);
            response.setHeader(HEADER_CACHE_CONTROL, "no-cache");
            response.addHeader(HEADER_CACHE_CONTROL, "no-store");
        }
    }

    public static String parseQueryString(HttpServletRequest request) {
        Map map = request.getParameterMap();
        String result = "";
        for (Object o : map.keySet()) {
            String[] values;
            String key = "" + o;
            String[] stringArray = values = (String[])map.get(key);
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                result = String.valueOf(result) + key + "=" + value + "&";
                ++n2;
            }
        }
        if (result.length() > 0) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public static String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("X-Real-IP");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("x-forwarded-for");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static String getRequestPath(HttpServletRequest request) {
        StringBuilder sb = new StringBuilder(request.getRequestURI());
        Enumeration enumeration = request.getParameterNames();
        if (enumeration.hasMoreElements()) {
            sb.append("?");
        }
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            sb.append(object);
            sb.append("=");
            sb.append(request.getParameter(object.toString()));
            sb.append("&");
        }
        String requesturi = "";
        String contextPath = request.getContextPath();
        requesturi = sb.indexOf("&") != -1 ? sb.substring(0, sb.lastIndexOf("&")) : sb.toString();
        requesturi = requesturi.substring(requesturi.indexOf(contextPath) + contextPath.length());
        return requesturi;
    }

    public static void printWriteJson(HttpServletResponse response, String jsonStr) {
        if (StringUtils.isBlank(jsonStr)) {
            throw new RuntimeException("return json is null");
        }
        response.setCharacterEncoding("UTF-8");
        PrintWriter out = null;
        try {
            try {
                out = response.getWriter();
                out.print(jsonStr);
            }
            catch (IOException e) {
                e.printStackTrace();
                if (out != null) {
                    out.close();
                }
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static Object request2Bean(HttpServletRequest request, Class<? extends Serializable> beanClass) {
        Map parmap = request.getParameterMap();
        if (ObjectUtils.isNull(parmap)) {
            return null;
        }
        Serializable bean = null;
        try {
            Field[] fields;
            bean = beanClass.newInstance();
            Field[] fieldArray = fields = beanClass.getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                WebUtils.packBean(field, bean, parmap);
                ++n2;
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return bean;
    }

    /*
     * Unable to fully structure code
     */
    private static void packBean(Field _f, Object _o, Map<String, String[]> parmap) {
        block20: {
            values = parmap.get(_f.getName());
            if (ObjectUtils.isNull(values) && _f.getType() != List.class) {
                return;
            }
            try {
                if (_f.getType() != List.class) ** GOTO lbl57
                t = _f.getGenericType();
                if (!(t instanceof ParameterizedType)) break block20;
                pt = (ParameterizedType)t;
                c = (Class)pt.getActualTypeArguments()[0];
                list = new ArrayList<Long>();
                if (c != Long.class) ** GOTO lbl26
                v = parmap.get(_f.getName());
                if (ObjectUtils.isNull(v)) {
                    return;
                }
                try {
                    block21: {
                        var12_14 = v;
                        var11_17 = v.length;
                        var10_20 = 0;
                        while (var10_20 < var11_17) {
                            _v = var12_14[var10_20];
                            list.add(Long.parseLong((String)_v));
                            ++var10_20;
                        }
                        break block21;
lbl26:
                        // 1 sources

                        count = 0;
                        var13_25 = fields = c.getDeclaredFields();
                        var12_15 = fields.length;
                        var11_18 = 0;
                        while (var11_18 < var12_15) {
                            field = var13_25[var11_18];
                            v = parmap.get(field.getName());
                            if (!ObjectUtils.isNull(v)) {
                                count = v.length > count ? v.length : count;
                            }
                            ++var11_18;
                        }
                        i = 0;
                        while (i < count) {
                            act_o = c.newInstance();
                            var15_29 = fields;
                            var14_28 = fields.length;
                            var13_26 = 0;
                            while (var13_26 < var14_28) {
                                field = var15_29[var13_26];
                                v = parmap.get(field.getName());
                                if (!ObjectUtils.isNull(v)) {
                                    WebUtils.setBean(field, act_o, v[v.length - 1 < i ? 0 : i]);
                                }
                                ++var13_26;
                            }
                            list.add((Long)act_o);
                            ++i;
                        }
                    }
                    WebUtils.setBean(_f, _o, list);
                    break block20;
lbl57:
                    // 1 sources

                    WebUtils.setBean(_f, _o, values[0]);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
            }
            finally {
                _f.setAccessible(false);
            }
        }
    }

    private static void setBean(Field _f, Object _o, Object o) {
        try {
            try {
                Class<?> type = _f.getType();
                _f.setAccessible(true);
                if (o instanceof List) {
                    _f.set(_o, o);
                } else {
                    String value = StringUtils.getStr(o);
                    if (type == String.class) {
                        NotTransformation annotation = _f.getAnnotation(NotTransformation.class);
                        if (annotation == null) {
                            _f.set(_o, StringUtils.repKeyString(value));
                        } else {
                            _f.set(_o, value);
                        }
                    } else if (type == Long.class) {
                        if (StringUtils.matches(value, "^-?\\d+$")) {
                            _f.set(_o, Long.parseLong(value));
                        } else {
                            _f.set(_o, 0L);
                        }
                    } else if (type == Integer.class) {
                        if (StringUtils.matches(value, "^-?\\d+$")) {
                            _f.set(_o, Integer.parseInt(value));
                        } else {
                            _f.set(_o, 0);
                        }
                    } else if (type == Double.class) {
                        if (StringUtils.matches(value, "^(-?\\d+)(\\.\\d+)?$")) {
                            _f.set(_o, Double.parseDouble(value));
                        } else {
                            _f.set(_o, 0.0);
                        }
                    } else if (type == Float.class) {
                        if (StringUtils.matches(value, "^(-?\\d+)(\\.\\d+)?$")) {
                            _f.set(_o, Float.valueOf(Float.parseFloat(value)));
                        } else {
                            _f.set(_o, Float.valueOf(0.0f));
                        }
                    } else if (type == Timestamp.class) {
                        if (StringUtils.matches(value, "((^((1[8-9]\\d{2})|([2-9]\\d{3}))[-](10|12|0?[13578])[-](3[01]|[12][0-9]|0?[1-9])(\\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^((1[8-9]\\d{2})|([2-9]\\d{3}))[-](11|0?[469])[-](30|[12][0-9]|0?[1-9])(\\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^((1[8-9]\\d{2})|([2-9]\\d{3}))[-](0?2)[-](2[0-8]|1[0-9]|0?[1-9])(\\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^([2468][048]00)[-](0?2)[-](29)(\\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^([3579][26]00)[-](0?2)[-](29)(\\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^([1][89][0][48])[-](0?2)[-](29)(\\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^([2-9][0-9][0][48])[-](0?2)[-](29)(\\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^([1][89][2468][048])[-](0?2)[-](29)(\\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^([2-9][0-9][2468][048])[-](0?2)[-](29)(\\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^([1][89][13579][26])[-](0?2)[-](29)(\\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^([2-9][0-9][13579][26])[-](0?2)[-](29)(\\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$))")) {
                            _f.set(_o, TimeUtils.strToTimeStamp(value));
                        } else {
                            _f.set(_o, null);
                        }
                    } else if (type == BigDecimal.class) {
                        if (StringUtils.matches(value, "^(-?\\d+)(\\.\\d+)?$")) {
                            _f.set(_o, new BigDecimal(value).setScale(2, 4));
                        } else {
                            _f.set(_o, new BigDecimal("0.00"));
                        }
                    } else if (type.isEnum()) {
                        _f.set(_o, Enum.valueOf(type, value));
                    }
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                _f.setAccessible(false);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                _f.setAccessible(false);
            }
        }
        finally {
            _f.setAccessible(false);
        }
    }

    public static String vericode(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("image/jpeg");
        response.setHeader(HEADER_PRAGMA, "No-cache");
        response.setHeader(HEADER_CACHE_CONTROL, "no-cache");
        response.setDateHeader(HEADER_EXPIRES, 0L);
        int width = 80;
        int height = 27;
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics g = image.getGraphics();
        Random random = new Random();
        g.setColor(WebUtils.getRandColor(200, 250));
        g.fillRect(0, 0, width, height);
        g.setFont(new Font("Times New Roman", 0, 23));
        g.setColor(WebUtils.getRandColor(160, 200));
        int i = 0;
        while (i < 155) {
            int x = random.nextInt(width);
            int y = random.nextInt(height);
            int xl = random.nextInt(12);
            int yl = random.nextInt(12);
            g.drawLine(x, y, x + xl, y + yl);
            ++i;
        }
        String sRand = "";
        int i2 = 0;
        while (i2 < 4) {
            String rand = String.valueOf(random.nextInt(10));
            sRand = String.valueOf(sRand) + rand;
            g.setColor(new Color(20 + random.nextInt(110), 20 + random.nextInt(110), 20 + random.nextInt(110)));
            g.drawString(rand, 13 * i2 + 14, 22);
            ++i2;
        }
        g.dispose();
        ServletOutputStream responseOutputStream = response.getOutputStream();
        ImageIO.write((RenderedImage)image, "JPEG", (OutputStream)responseOutputStream);
        responseOutputStream.flush();
        responseOutputStream.close();
        return sRand;
    }

    private static Color getRandColor(int s, int e) {
        Random random = new Random();
        if (s > 255) {
            s = 255;
        }
        if (e > 255) {
            e = 255;
        }
        int r = s + random.nextInt(e - s);
        int g = s + random.nextInt(e - s);
        int b = s + random.nextInt(e - s);
        return new Color(r, g, b);
    }
}

