/*
 * Decompiled with CFR 0.152.
 */
package com.qianpin.common.utils.email;

import com.qianpin.common.utils.AppUtils;
import com.qianpin.common.utils.ObjectUtils;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;

public class EmailTools {
    static final Log log = LogFactory.getLog(EmailTools.class);
    private JavaMailSenderImpl javaMailSender = (JavaMailSenderImpl)AppUtils.getApp().getBean("javaMailSender");

    public void sendMail(final String mailto, final String text, final String title) throws Exception {
        new Thread(){

            @Override
            public void run() {
                try {
                    MimeMessage mimeMessage = EmailTools.this.javaMailSender.createMimeMessage();
                    MimeMessageHelper messageHelper = new MimeMessageHelper(mimeMessage, true, "GBK");
                    InternetAddress internetAddress = new InternetAddress();
                    internetAddress.setAddress(EmailTools.this.javaMailSender.getUsername());
                    internetAddress.setPersonal("\u5343\u54c1\u7f51");
                    messageHelper.setFrom(internetAddress);
                    messageHelper.setSubject(title);
                    messageHelper.setText(text, true);
                    messageHelper.setTo(new InternetAddress(mailto));
                    mimeMessage = messageHelper.getMimeMessage();
                    EmailTools.this.javaMailSender.send(mimeMessage);
                }
                catch (AddressException e) {
                    log.error((Object)("mailto=" + mailto + ",text=" + text + ",title=" + title));
                    e.printStackTrace();
                }
                catch (MessagingException e) {
                    log.error((Object)("mailto=" + mailto + ",text=" + text + ",title=" + title));
                    e.printStackTrace();
                }
                catch (Exception e) {
                    log.error((Object)("mailto=" + mailto + ",text=" + text + ",title=" + title));
                    e.printStackTrace();
                }
            }
        }.start();
    }

    public void sendMail(final String mailto, final String[] cc, final String text, final String title) throws Exception {
        new Thread(){

            @Override
            public void run() {
                try {
                    MimeMessage mimeMessage = EmailTools.this.javaMailSender.createMimeMessage();
                    MimeMessageHelper messageHelper = new MimeMessageHelper(mimeMessage, true, "GBK");
                    InternetAddress internetAddress = new InternetAddress();
                    internetAddress.setAddress(EmailTools.this.javaMailSender.getUsername());
                    internetAddress.setPersonal("\u5343\u54c1\u7f51");
                    messageHelper.setFrom(internetAddress);
                    messageHelper.setSubject(title);
                    messageHelper.setText(text, true);
                    messageHelper.setTo(new InternetAddress(mailto));
                    if (!ObjectUtils.isNull(cc)) {
                        InternetAddress[] addresses = new InternetAddress[cc.length];
                        int i = 0;
                        while (i < cc.length) {
                            addresses[i] = new InternetAddress(cc[i]);
                            ++i;
                        }
                        messageHelper.setCc(addresses);
                    }
                    mimeMessage = messageHelper.getMimeMessage();
                    EmailTools.this.javaMailSender.send(mimeMessage);
                }
                catch (AddressException e) {
                    log.error((Object)("mailto=" + mailto + ",cc=" + cc + ",text=" + text + ",title=" + title));
                    e.printStackTrace();
                }
                catch (MessagingException e) {
                    log.error((Object)("mailto=" + mailto + ",cc=" + cc + ",text=" + text + ",title=" + title));
                    e.printStackTrace();
                }
                catch (Exception e) {
                    log.error((Object)("mailto=" + mailto + ",cc=" + cc + ",text=" + text + ",title=" + title));
                    e.printStackTrace();
                }
            }
        }.start();
    }
}

