/*
 * Decompiled with CFR 0.152.
 */
package com.qianpin.common.utils.freemarker;

import com.qianpin.common.utils.freemarker.TemplateHandler;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FreeMarkerTemplateHandler
implements TemplateHandler {
    private static final Log log = LogFactory.getLog(FreeMarkerTemplateHandler.class);
    private static Configuration cfg;
    private static String charset;

    static {
        charset = "UTF-8";
    }

    public FreeMarkerTemplateHandler() {
        cfg = new Configuration();
        cfg.setClassForTemplateLoading(FreeMarkerTemplateHandler.class, "/");
        cfg.setOutputEncoding(charset);
        cfg.setDefaultEncoding(charset);
        cfg.setNumberFormat("#");
    }

    public FreeMarkerTemplateHandler(String diycharset) {
        charset = diycharset;
        cfg = new Configuration();
        cfg.setClassForTemplateLoading(FreeMarkerTemplateHandler.class, "/");
        cfg.setOutputEncoding(charset);
        cfg.setDefaultEncoding(charset);
        cfg.setNumberFormat("#");
    }

    @Override
    public String applyTemplate(String templatePath, Map<String, String> args) throws Exception {
        Template template = null;
        try {
            template = cfg.getTemplate(templatePath, charset);
        }
        catch (IOException e1) {
            return null;
        }
        StringWriter writer = new StringWriter();
        template.process(args, (Writer)writer);
        return writer.toString();
    }

    @Override
    public void writeToFile(String templatePath, Map<String, String> args, String filePath) {
        FileOutputStream fout = null;
        try {
            try {
                String content = this.applyTemplate(templatePath, args);
                fout = new FileOutputStream(filePath);
                fout.write(content.getBytes(charset));
            }
            catch (Exception e) {
                String errorMessage = "exception happened when write to file in function VelocityTemplateHandler:writeToFile";
                log.fatal((Object)errorMessage);
                try {
                    if (fout != null) {
                        fout.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return;
            }
        }
        finally {
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

