/*
 * Decompiled with CFR 0.152.
 */
package com.qianpin.common.utils.json;

import com.qianpin.common.utils.json.TimestampJsonValueProcessor;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonValueProcessor;
import net.sf.json.util.CycleDetectionStrategy;

public class JsonUtils {
    public static JsonConfig config(String ... datePattern) {
        JsonConfig config = new JsonConfig();
        config.setIgnoreDefaultExcludes(false);
        config.setCycleDetectionStrategy(CycleDetectionStrategy.LENIENT);
        if (datePattern.length == 0) {
            config.registerJsonValueProcessor(Timestamp.class, (JsonValueProcessor)new TimestampJsonValueProcessor());
        } else {
            config.registerJsonValueProcessor(Timestamp.class, (JsonValueProcessor)new TimestampJsonValueProcessor(datePattern[0]));
        }
        return config;
    }

    public static String bean2Json(Object bean, String ... datePattern) {
        JSONObject jsonObject = null;
        jsonObject = datePattern.length == 0 ? JSONObject.fromObject((Object)bean, (JsonConfig)JsonUtils.config(new String[0])) : JSONObject.fromObject((Object)bean, (JsonConfig)JsonUtils.config(datePattern[0]));
        return jsonObject.toString();
    }

    public static String list2Json(List<?> list, String ... datePattern) {
        JSONArray jsonArray = null;
        jsonArray = datePattern.length == 0 ? JSONArray.fromObject(list, (JsonConfig)JsonUtils.config(new String[0])) : JSONArray.fromObject(list, (JsonConfig)JsonUtils.config(datePattern[0]));
        return jsonArray.toString();
    }

    public static String map2Json(Map<?, ?> map, String ... datePattern) {
        JSONArray jsonArray = null;
        jsonArray = datePattern.length == 0 ? JSONArray.fromObject(map, (JsonConfig)JsonUtils.config(new String[0])) : JSONArray.fromObject(map, (JsonConfig)JsonUtils.config(datePattern[0]));
        return jsonArray.toString();
    }

    public static Object json2Bean(String json, Class<?> clzss) {
        JSONObject jsonObject = JSONObject.fromObject((Object)json.replaceAll("\\[|\\]", ""));
        return JSONObject.toBean((JSONObject)jsonObject, clzss);
    }
}

