/*
 * Decompiled with CFR 0.152.
 */
package com.qianpin.common.utils.json;

import com.qianpin.common.utils.StringUtils;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonValueProcessor;

public class TimestampJsonValueProcessor
implements JsonValueProcessor {
    public static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private DateFormat dateFormat;

    public TimestampJsonValueProcessor() {
        this.dateFormat = new SimpleDateFormat(DEFAULT_DATE_PATTERN);
    }

    public TimestampJsonValueProcessor(String pattern) {
        this.dateFormat = StringUtils.isBlank(pattern) ? new SimpleDateFormat(DEFAULT_DATE_PATTERN) : new SimpleDateFormat(pattern);
    }

    public Object processArrayValue(Object value, JsonConfig jsonConfig) {
        return this.process(value);
    }

    public Object processObjectValue(String key, Object value, JsonConfig jsonConfig) {
        return this.process(value);
    }

    private Object process(Object value) {
        if (value instanceof Timestamp) {
            return this.dateFormat.format((Date)value);
        }
        return value == null ? "" : value.toString();
    }
}

