/*
 * Decompiled with CFR 0.152.
 */
package com.qianpin.common.utils.page;

import com.qianpin.common.utils.ObjectUtils;
import com.qianpin.common.utils.StringUtils;
import org.apache.commons.lang.NullArgumentException;

public class Pager {
    private int totalRows;
    private int pageSize;
    private int currentPage;
    private int totalPages;
    private int startRow = 0;
    private String pageJson;

    public Pager(int total, int current, String ... functionName) {
        this.totalRows = total;
        this.pageSize = 10;
        this.currentPage = current <= 1 ? 1 : current;
        this.totalPages = (this.totalRows - 1) / this.pageSize + 1;
        this.currentPage = this.totalPages < this.currentPage ? 1 : this.currentPage;
        this.startRow = this.pageSize * (this.currentPage - 1);
        this.getPagerJson(this, functionName.length == 0 ? null : functionName[0]);
    }

    public Pager(int total, int current, int size, String ... functionName) {
        this.totalRows = total;
        this.pageSize = size <= 0 ? 10 : size;
        this.currentPage = current <= 1 ? 1 : current;
        this.totalPages = (this.totalRows - 1) / this.pageSize + 1;
        this.currentPage = this.totalPages < this.currentPage ? 1 : this.currentPage;
        this.startRow = this.pageSize * (this.currentPage - 1);
        this.getPagerJson(this, functionName.length == 0 ? null : functionName[0]);
    }

    public void getPagerJson(Pager pager, String functionName) {
        String cpage;
        String funcName = StringUtils.isBlank(functionName) ? "gopage" : functionName;
        String string = cpage = StringUtils.isBlank(functionName) ? "cpage" : "ccpage";
        if (ObjectUtils.isNull(pager)) {
            throw new NullArgumentException("pager is not null");
        }
        StringBuffer pageHTML = new StringBuffer();
        if (pager.getTotalPages() > 1) {
            pageHTML.append("<input type=\"hidden\" name=\"" + cpage + "\" id=\"" + cpage + "\" value=\"" + pager.getCurrentPage() + "\" />");
            if (pager.getCurrentPage() == 1) {
                pageHTML.append("<span class=\"disabled\">\u9996\u9875</span>");
                pageHTML.append("<span class=\"disabled\">\u4e0a\u4e00\u9875</span>");
            } else {
                pageHTML.append("<a style='cursor:pointer;' onclick='" + funcName + "(1);'>\u9996\u9875</a>");
                pageHTML.append("<a style='cursor:pointer;' onclick='" + funcName + "(" + (pager.getCurrentPage() - 1) + ");'>\u4e0a\u4e00\u9875</a>");
            }
            if (pager.getTotalPages() <= 10) {
                int i = 1;
                while (i <= pager.getTotalPages()) {
                    if (pager.getCurrentPage() == i) {
                        pageHTML.append("<span class='current'>" + i + "</span>");
                    } else {
                        pageHTML.append("<a style='cursor:pointer;' onclick='" + funcName + "(" + i + ");'>" + i + "</a>");
                    }
                    ++i;
                }
            } else {
                if (pager.getCurrentPage() == 1) {
                    pageHTML.append("<span class='current'>1</span>");
                } else {
                    pageHTML.append("<a style='cursor:pointer;' onclick='" + funcName + "(1);'>1</a>");
                }
                if (pager.getCurrentPage() - 1 >= 4) {
                    pageHTML.append("...");
                    if (pager.getTotalPages() - pager.getCurrentPage() >= 7) {
                        int i = pager.getCurrentPage() - 1;
                        while (i < pager.getCurrentPage() - 1 + 6) {
                            if (pager.getCurrentPage() == i) {
                                pageHTML.append("<span class='current'>" + i + "</span>");
                            } else {
                                pageHTML.append("<a style='cursor:pointer;' onclick='" + funcName + "(" + i + ");'>" + i + "</a>");
                            }
                            ++i;
                        }
                    } else {
                        int i = pager.getTotalPages() - 7;
                        while (i < pager.getTotalPages() - 7 + 6) {
                            if (pager.getCurrentPage() == i) {
                                pageHTML.append("<span class='current'>" + i + "</span>");
                            } else {
                                pageHTML.append("<a style='cursor:pointer;' onclick='" + funcName + "(" + i + ");'>" + i + "</a>");
                            }
                            ++i;
                        }
                    }
                } else {
                    int i = 2;
                    while (i <= 8) {
                        if (pager.getCurrentPage() == i) {
                            pageHTML.append("<span class='current'>" + i + "</span>");
                        } else {
                            pageHTML.append("<a style='cursor:pointer;' onclick='" + funcName + "(" + i + ");'>" + i + "</a>");
                        }
                        ++i;
                    }
                }
                if (pager.getTotalPages() - pager.getCurrentPage() >= 7) {
                    pageHTML.append("...");
                } else if (pager.getCurrentPage() == pager.getTotalPages() - 1) {
                    pageHTML.append("<span class='current'>" + (pager.getTotalPages() - 1) + "</span>");
                } else {
                    pageHTML.append("<a style='cursor:pointer;' onclick='" + funcName + "(" + (pager.getTotalPages() - 1) + ");'>" + (pager.getTotalPages() - 1) + "</a>");
                }
                if (pager.getCurrentPage() == pager.getTotalPages()) {
                    pageHTML.append("<span class='current'>" + pager.getTotalPages() + "</span>");
                } else {
                    pageHTML.append("<a style='cursor:pointer;' onclick='" + funcName + "(" + pager.getTotalPages() + ");'>" + pager.getTotalPages() + "</a>");
                }
            }
            if (pager.getCurrentPage() == pager.getTotalPages()) {
                pageHTML.append("<span class=\"disabled\">\u4e0b\u4e00\u9875</span>");
                pageHTML.append("<span class=\"disabled\">\u5c3e\u9875</span>");
            } else {
                pageHTML.append("<a style='cursor:pointer;' onclick='" + funcName + "(" + (pager.getCurrentPage() + 1) + ");'>\u4e0b\u4e00\u9875</a>");
                pageHTML.append("<a style='cursor:pointer;' onclick='" + funcName + "(" + pager.getTotalPages() + ");'>\u5c3e\u9875</a>");
            }
        }
        pageHTML.append("<span class=\"pages_num\">\u5171<font class=\"font478c2f\">" + pager.getTotalPages() + "</font>\u9875\uff0c<font class=\"font478c2f\">" + pager.getTotalRows() + "</font>\u6761\u8bb0\u5f55</span>");
        this.pageJson = pageHTML.toString();
    }

    public int getTotalRows() {
        return this.totalRows;
    }

    public void setTotalRows(int totalRows) {
        this.totalRows = totalRows;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public void setTotalPages(int totalPages) {
        this.totalPages = totalPages;
    }

    public int getStartRow() {
        return this.startRow;
    }

    public void setStartRow(int startRow) {
        this.startRow = startRow;
    }

    public String getPageJson() {
        return this.pageJson;
    }

    public void setPageJson(String pageJson) {
        this.pageJson = pageJson;
    }

    public static void main(String[] args) {
        Pager pager = new Pager(23, 0, 2, new String[0]);
        System.out.println(pager.getTotalRows());
        System.out.println(pager.getPageSize());
        System.out.println(pager.getCurrentPage());
        System.out.println(pager.getTotalPages());
        System.out.println(pager.getStartRow());
    }
}

