/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.net.URI;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.AdvancedJedisCommands;
import redis.clients.jedis.BasicCommands;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.BinaryJedis;
import redis.clients.jedis.BitOP;
import redis.clients.jedis.BitPosParams;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.ClusterCommands;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisCommands;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.MultiKeyCommands;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.ScriptingCommands;
import redis.clients.jedis.SentinelCommands;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.ZParams;
import redis.clients.util.Pool;
import redis.clients.util.SafeEncoder;
import redis.clients.util.Slowlog;

public class Jedis
extends BinaryJedis
implements JedisCommands,
MultiKeyCommands,
AdvancedJedisCommands,
ScriptingCommands,
BasicCommands,
ClusterCommands,
SentinelCommands {
    protected Pool<Jedis> dataSource = null;

    public Jedis(String host) {
        super(host);
    }

    public Jedis(String host, int port) {
        super(host, port);
    }

    public Jedis(String host, int port, int timeout) {
        super(host, port, timeout);
    }

    public Jedis(JedisShardInfo shardInfo) {
        super(shardInfo);
    }

    public Jedis(URI uri) {
        super(uri);
    }

    public Jedis(URI uri, int timeout) {
        super(uri, timeout);
    }

    @Override
    public String set(String key, String value) {
        this.checkIsInMulti();
        this.client.set(key, value);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String set(String key, String value, String nxxx, String expx, long time) {
        this.checkIsInMulti();
        this.client.set(key, value, nxxx, expx, time);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String get(String key) {
        this.checkIsInMulti();
        this.client.sendCommand(Protocol.Command.GET, key);
        return this.client.getBulkReply();
    }

    @Override
    public Boolean exists(String key) {
        this.checkIsInMulti();
        this.client.exists(key);
        return this.client.getIntegerReply() == 1L;
    }

    @Override
    public Long del(String ... keys) {
        this.checkIsInMulti();
        this.client.del(keys);
        return this.client.getIntegerReply();
    }

    @Override
    public Long del(String key) {
        this.client.del(key);
        return this.client.getIntegerReply();
    }

    @Override
    public String type(String key) {
        this.checkIsInMulti();
        this.client.type(key);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Set<String> keys(String pattern) {
        this.checkIsInMulti();
        this.client.keys(pattern);
        return BuilderFactory.STRING_SET.build(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public String randomKey() {
        this.checkIsInMulti();
        this.client.randomKey();
        return this.client.getBulkReply();
    }

    @Override
    public String rename(String oldkey, String newkey) {
        this.checkIsInMulti();
        this.client.rename(oldkey, newkey);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long renamenx(String oldkey, String newkey) {
        this.checkIsInMulti();
        this.client.renamenx(oldkey, newkey);
        return this.client.getIntegerReply();
    }

    @Override
    public Long expire(String key, int seconds) {
        this.checkIsInMulti();
        this.client.expire(key, seconds);
        return this.client.getIntegerReply();
    }

    @Override
    public Long expireAt(String key, long unixTime) {
        this.checkIsInMulti();
        this.client.expireAt(key, unixTime);
        return this.client.getIntegerReply();
    }

    @Override
    public Long ttl(String key) {
        this.checkIsInMulti();
        this.client.ttl(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long move(String key, int dbIndex) {
        this.checkIsInMulti();
        this.client.move(key, dbIndex);
        return this.client.getIntegerReply();
    }

    @Override
    public String getSet(String key, String value) {
        this.checkIsInMulti();
        this.client.getSet(key, value);
        return this.client.getBulkReply();
    }

    @Override
    public List<String> mget(String ... keys) {
        this.checkIsInMulti();
        this.client.mget(keys);
        return this.client.getMultiBulkReply();
    }

    @Override
    public Long setnx(String key, String value) {
        this.checkIsInMulti();
        this.client.setnx(key, value);
        return this.client.getIntegerReply();
    }

    @Override
    public String setex(String key, int seconds, String value) {
        this.checkIsInMulti();
        this.client.setex(key, seconds, value);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String mset(String ... keysvalues) {
        this.checkIsInMulti();
        this.client.mset(keysvalues);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long msetnx(String ... keysvalues) {
        this.checkIsInMulti();
        this.client.msetnx(keysvalues);
        return this.client.getIntegerReply();
    }

    @Override
    public Long decrBy(String key, long integer) {
        this.checkIsInMulti();
        this.client.decrBy(key, integer);
        return this.client.getIntegerReply();
    }

    @Override
    public Long decr(String key) {
        this.checkIsInMulti();
        this.client.decr(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long incrBy(String key, long integer) {
        this.checkIsInMulti();
        this.client.incrBy(key, integer);
        return this.client.getIntegerReply();
    }

    public Double incrByFloat(String key, double value) {
        this.checkIsInMulti();
        this.client.incrByFloat(key, value);
        String dval = this.client.getBulkReply();
        return dval != null ? new Double(dval) : null;
    }

    @Override
    public Long incr(String key) {
        this.checkIsInMulti();
        this.client.incr(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long append(String key, String value) {
        this.checkIsInMulti();
        this.client.append(key, value);
        return this.client.getIntegerReply();
    }

    @Override
    public String substr(String key, int start, int end) {
        this.checkIsInMulti();
        this.client.substr(key, start, end);
        return this.client.getBulkReply();
    }

    @Override
    public Long hset(String key, String field, String value) {
        this.checkIsInMulti();
        this.client.hset(key, field, value);
        return this.client.getIntegerReply();
    }

    @Override
    public String hget(String key, String field) {
        this.checkIsInMulti();
        this.client.hget(key, field);
        return this.client.getBulkReply();
    }

    @Override
    public Long hsetnx(String key, String field, String value) {
        this.checkIsInMulti();
        this.client.hsetnx(key, field, value);
        return this.client.getIntegerReply();
    }

    @Override
    public String hmset(String key, Map<String, String> hash) {
        this.checkIsInMulti();
        this.client.hmset(key, hash);
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<String> hmget(String key, String ... fields) {
        this.checkIsInMulti();
        this.client.hmget(key, fields);
        return this.client.getMultiBulkReply();
    }

    @Override
    public Long hincrBy(String key, String field, long value) {
        this.checkIsInMulti();
        this.client.hincrBy(key, field, value);
        return this.client.getIntegerReply();
    }

    public Double hincrByFloat(String key, String field, double value) {
        this.checkIsInMulti();
        this.client.hincrByFloat(key, field, value);
        String dval = this.client.getBulkReply();
        return dval != null ? new Double(dval) : null;
    }

    @Override
    public Boolean hexists(String key, String field) {
        this.checkIsInMulti();
        this.client.hexists(key, field);
        return this.client.getIntegerReply() == 1L;
    }

    @Override
    public Long hdel(String key, String ... fields) {
        this.checkIsInMulti();
        this.client.hdel(key, fields);
        return this.client.getIntegerReply();
    }

    @Override
    public Long hlen(String key) {
        this.checkIsInMulti();
        this.client.hlen(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<String> hkeys(String key) {
        this.checkIsInMulti();
        this.client.hkeys(key);
        return BuilderFactory.STRING_SET.build(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public List<String> hvals(String key) {
        this.checkIsInMulti();
        this.client.hvals(key);
        List<String> lresult = this.client.getMultiBulkReply();
        return lresult;
    }

    @Override
    public Map<String, String> hgetAll(String key) {
        this.checkIsInMulti();
        this.client.hgetAll(key);
        return BuilderFactory.STRING_MAP.build(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Long rpush(String key, String ... strings) {
        this.checkIsInMulti();
        this.client.rpush(key, strings);
        return this.client.getIntegerReply();
    }

    @Override
    public Long lpush(String key, String ... strings) {
        this.checkIsInMulti();
        this.client.lpush(key, strings);
        return this.client.getIntegerReply();
    }

    @Override
    public Long llen(String key) {
        this.checkIsInMulti();
        this.client.llen(key);
        return this.client.getIntegerReply();
    }

    @Override
    public List<String> lrange(String key, long start, long end) {
        this.checkIsInMulti();
        this.client.lrange(key, start, end);
        return this.client.getMultiBulkReply();
    }

    @Override
    public String ltrim(String key, long start, long end) {
        this.checkIsInMulti();
        this.client.ltrim(key, start, end);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String lindex(String key, long index) {
        this.checkIsInMulti();
        this.client.lindex(key, index);
        return this.client.getBulkReply();
    }

    @Override
    public String lset(String key, long index, String value) {
        this.checkIsInMulti();
        this.client.lset(key, index, value);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long lrem(String key, long count, String value) {
        this.checkIsInMulti();
        this.client.lrem(key, count, value);
        return this.client.getIntegerReply();
    }

    @Override
    public String lpop(String key) {
        this.checkIsInMulti();
        this.client.lpop(key);
        return this.client.getBulkReply();
    }

    @Override
    public String rpop(String key) {
        this.checkIsInMulti();
        this.client.rpop(key);
        return this.client.getBulkReply();
    }

    @Override
    public String rpoplpush(String srckey, String dstkey) {
        this.checkIsInMulti();
        this.client.rpoplpush(srckey, dstkey);
        return this.client.getBulkReply();
    }

    @Override
    public Long sadd(String key, String ... members) {
        this.checkIsInMulti();
        this.client.sadd(key, members);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<String> smembers(String key) {
        this.checkIsInMulti();
        this.client.smembers(key);
        List<String> members = this.client.getMultiBulkReply();
        if (members == null) {
            return null;
        }
        return new HashSet<String>(members);
    }

    @Override
    public Long srem(String key, String ... members) {
        this.checkIsInMulti();
        this.client.srem(key, members);
        return this.client.getIntegerReply();
    }

    @Override
    public String spop(String key) {
        this.checkIsInMulti();
        this.client.spop(key);
        return this.client.getBulkReply();
    }

    @Override
    public Long smove(String srckey, String dstkey, String member) {
        this.checkIsInMulti();
        this.client.smove(srckey, dstkey, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Long scard(String key) {
        this.checkIsInMulti();
        this.client.scard(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Boolean sismember(String key, String member) {
        this.checkIsInMulti();
        this.client.sismember(key, member);
        return this.client.getIntegerReply() == 1L;
    }

    @Override
    public Set<String> sinter(String ... keys) {
        this.checkIsInMulti();
        this.client.sinter(keys);
        List<String> members = this.client.getMultiBulkReply();
        if (members == null) {
            return null;
        }
        return new HashSet<String>(members);
    }

    @Override
    public Long sinterstore(String dstkey, String ... keys) {
        this.checkIsInMulti();
        this.client.sinterstore(dstkey, keys);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<String> sunion(String ... keys) {
        this.checkIsInMulti();
        this.client.sunion(keys);
        List<String> members = this.client.getMultiBulkReply();
        if (members == null) {
            return null;
        }
        return new HashSet<String>(members);
    }

    @Override
    public Long sunionstore(String dstkey, String ... keys) {
        this.checkIsInMulti();
        this.client.sunionstore(dstkey, keys);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<String> sdiff(String ... keys) {
        this.checkIsInMulti();
        this.client.sdiff(keys);
        return BuilderFactory.STRING_SET.build(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Long sdiffstore(String dstkey, String ... keys) {
        this.checkIsInMulti();
        this.client.sdiffstore(dstkey, keys);
        return this.client.getIntegerReply();
    }

    @Override
    public String srandmember(String key) {
        this.checkIsInMulti();
        this.client.srandmember(key);
        return this.client.getBulkReply();
    }

    @Override
    public List<String> srandmember(String key, int count) {
        this.checkIsInMulti();
        this.client.srandmember(key, count);
        return this.client.getMultiBulkReply();
    }

    @Override
    public Long zadd(String key, double score, String member) {
        this.checkIsInMulti();
        this.client.zadd(key, score, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zadd(String key, Map<String, Double> scoreMembers) {
        this.checkIsInMulti();
        this.client.zadd(key, scoreMembers);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<String> zrange(String key, long start, long end) {
        this.checkIsInMulti();
        this.client.zrange(key, start, end);
        List<String> members = this.client.getMultiBulkReply();
        if (members == null) {
            return null;
        }
        return new LinkedHashSet<String>(members);
    }

    @Override
    public Long zrem(String key, String ... members) {
        this.checkIsInMulti();
        this.client.zrem(key, members);
        return this.client.getIntegerReply();
    }

    @Override
    public Double zincrby(String key, double score, String member) {
        this.checkIsInMulti();
        this.client.zincrby(key, score, member);
        String newscore = this.client.getBulkReply();
        return Double.valueOf(newscore);
    }

    @Override
    public Long zrank(String key, String member) {
        this.checkIsInMulti();
        this.client.zrank(key, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zrevrank(String key, String member) {
        this.checkIsInMulti();
        this.client.zrevrank(key, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<String> zrevrange(String key, long start, long end) {
        this.checkIsInMulti();
        this.client.zrevrange(key, start, end);
        List<String> members = this.client.getMultiBulkReply();
        if (members == null) {
            return null;
        }
        return new LinkedHashSet<String>(members);
    }

    @Override
    public Set<Tuple> zrangeWithScores(String key, long start, long end) {
        this.checkIsInMulti();
        this.client.zrangeWithScores(key, start, end);
        Set<Tuple> set = this.getTupledSet();
        return set;
    }

    @Override
    public Set<Tuple> zrevrangeWithScores(String key, long start, long end) {
        this.checkIsInMulti();
        this.client.zrevrangeWithScores(key, start, end);
        Set<Tuple> set = this.getTupledSet();
        return set;
    }

    @Override
    public Long zcard(String key) {
        this.checkIsInMulti();
        this.client.zcard(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Double zscore(String key, String member) {
        this.checkIsInMulti();
        this.client.zscore(key, member);
        String score = this.client.getBulkReply();
        return score != null ? new Double(score) : null;
    }

    @Override
    public String watch(String ... keys) {
        this.client.watch(keys);
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<String> sort(String key) {
        this.checkIsInMulti();
        this.client.sort(key);
        return this.client.getMultiBulkReply();
    }

    @Override
    public List<String> sort(String key, SortingParams sortingParameters) {
        this.checkIsInMulti();
        this.client.sort(key, sortingParameters);
        return this.client.getMultiBulkReply();
    }

    @Override
    public List<String> blpop(int timeout, String ... keys) {
        return this.blpop(this.getArgsAddTimeout(timeout, keys));
    }

    private String[] getArgsAddTimeout(int timeout, String[] keys) {
        int keyCount = keys.length;
        String[] args = new String[keyCount + 1];
        for (int at = 0; at != keyCount; ++at) {
            args[at] = keys[at];
        }
        args[keyCount] = String.valueOf(timeout);
        return args;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> blpop(String ... args) {
        this.checkIsInMulti();
        this.client.blpop(args);
        this.client.setTimeoutInfinite();
        try {
            List<String> list = this.client.getMultiBulkReply();
            return list;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> brpop(String ... args) {
        this.checkIsInMulti();
        this.client.brpop(args);
        this.client.setTimeoutInfinite();
        try {
            List<String> list = this.client.getMultiBulkReply();
            return list;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    @Override
    @Deprecated
    public List<String> blpop(String arg) {
        return this.blpop(new String[]{arg});
    }

    @Override
    @Deprecated
    public List<String> brpop(String arg) {
        return this.brpop(new String[]{arg});
    }

    @Override
    public Long sort(String key, SortingParams sortingParameters, String dstkey) {
        this.checkIsInMulti();
        this.client.sort(key, sortingParameters, dstkey);
        return this.client.getIntegerReply();
    }

    @Override
    public Long sort(String key, String dstkey) {
        this.checkIsInMulti();
        this.client.sort(key, dstkey);
        return this.client.getIntegerReply();
    }

    @Override
    public List<String> brpop(int timeout, String ... keys) {
        return this.brpop(this.getArgsAddTimeout(timeout, keys));
    }

    @Override
    public Long zcount(String key, double min, double max) {
        this.checkIsInMulti();
        this.client.zcount(key, min, max);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zcount(String key, String min, String max) {
        this.checkIsInMulti();
        this.client.zcount(key, min, max);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<String> zrangeByScore(String key, double min, double max) {
        this.checkIsInMulti();
        this.client.zrangeByScore(key, min, max);
        List<String> members = this.client.getMultiBulkReply();
        if (members == null) {
            return null;
        }
        return new LinkedHashSet<String>(members);
    }

    @Override
    public Set<String> zrangeByScore(String key, String min, String max) {
        this.checkIsInMulti();
        this.client.zrangeByScore(key, min, max);
        List<String> members = this.client.getMultiBulkReply();
        if (members == null) {
            return null;
        }
        return new LinkedHashSet<String>(members);
    }

    @Override
    public Set<String> zrangeByScore(String key, double min, double max, int offset, int count) {
        this.checkIsInMulti();
        this.client.zrangeByScore(key, min, max, offset, count);
        List<String> members = this.client.getMultiBulkReply();
        if (members == null) {
            return null;
        }
        return new LinkedHashSet<String>(members);
    }

    @Override
    public Set<String> zrangeByScore(String key, String min, String max, int offset, int count) {
        this.checkIsInMulti();
        this.client.zrangeByScore(key, min, max, offset, count);
        List<String> members = this.client.getMultiBulkReply();
        if (members == null) {
            return null;
        }
        return new LinkedHashSet<String>(members);
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(String key, double min, double max) {
        this.checkIsInMulti();
        this.client.zrangeByScoreWithScores(key, min, max);
        Set<Tuple> set = this.getTupledSet();
        return set;
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(String key, String min, String max) {
        this.checkIsInMulti();
        this.client.zrangeByScoreWithScores(key, min, max);
        Set<Tuple> set = this.getTupledSet();
        return set;
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(String key, double min, double max, int offset, int count) {
        this.checkIsInMulti();
        this.client.zrangeByScoreWithScores(key, min, max, offset, count);
        Set<Tuple> set = this.getTupledSet();
        return set;
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(String key, String min, String max, int offset, int count) {
        this.checkIsInMulti();
        this.client.zrangeByScoreWithScores(key, min, max, offset, count);
        Set<Tuple> set = this.getTupledSet();
        return set;
    }

    private Set<Tuple> getTupledSet() {
        this.checkIsInMulti();
        List<String> membersWithScores = this.client.getMultiBulkReply();
        if (membersWithScores == null) {
            return null;
        }
        LinkedHashSet<Tuple> set = new LinkedHashSet<Tuple>();
        Iterator<String> iterator = membersWithScores.iterator();
        while (iterator.hasNext()) {
            set.add(new Tuple(iterator.next(), Double.valueOf(iterator.next())));
        }
        return set;
    }

    @Override
    public Set<String> zrevrangeByScore(String key, double max, double min) {
        this.checkIsInMulti();
        this.client.zrevrangeByScore(key, max, min);
        List<String> members = this.client.getMultiBulkReply();
        if (members == null) {
            return null;
        }
        return new LinkedHashSet<String>(members);
    }

    @Override
    public Set<String> zrevrangeByScore(String key, String max, String min) {
        this.checkIsInMulti();
        this.client.zrevrangeByScore(key, max, min);
        List<String> members = this.client.getMultiBulkReply();
        if (members == null) {
            return null;
        }
        return new LinkedHashSet<String>(members);
    }

    @Override
    public Set<String> zrevrangeByScore(String key, double max, double min, int offset, int count) {
        this.checkIsInMulti();
        this.client.zrevrangeByScore(key, max, min, offset, count);
        List<String> members = this.client.getMultiBulkReply();
        if (members == null) {
            return null;
        }
        return new LinkedHashSet<String>(members);
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(String key, double max, double min) {
        this.checkIsInMulti();
        this.client.zrevrangeByScoreWithScores(key, max, min);
        Set<Tuple> set = this.getTupledSet();
        return set;
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(String key, double max, double min, int offset, int count) {
        this.checkIsInMulti();
        this.client.zrevrangeByScoreWithScores(key, max, min, offset, count);
        Set<Tuple> set = this.getTupledSet();
        return set;
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(String key, String max, String min, int offset, int count) {
        this.checkIsInMulti();
        this.client.zrevrangeByScoreWithScores(key, max, min, offset, count);
        Set<Tuple> set = this.getTupledSet();
        return set;
    }

    @Override
    public Set<String> zrevrangeByScore(String key, String max, String min, int offset, int count) {
        this.checkIsInMulti();
        this.client.zrevrangeByScore(key, max, min, offset, count);
        List<String> members = this.client.getMultiBulkReply();
        if (members == null) {
            return null;
        }
        return new LinkedHashSet<String>(members);
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(String key, String max, String min) {
        this.checkIsInMulti();
        this.client.zrevrangeByScoreWithScores(key, max, min);
        Set<Tuple> set = this.getTupledSet();
        return set;
    }

    @Override
    public Long zremrangeByRank(String key, long start, long end) {
        this.checkIsInMulti();
        this.client.zremrangeByRank(key, start, end);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zremrangeByScore(String key, double start, double end) {
        this.checkIsInMulti();
        this.client.zremrangeByScore(key, start, end);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zremrangeByScore(String key, String start, String end) {
        this.checkIsInMulti();
        this.client.zremrangeByScore(key, start, end);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zunionstore(String dstkey, String ... sets) {
        this.checkIsInMulti();
        this.client.zunionstore(dstkey, sets);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zunionstore(String dstkey, ZParams params, String ... sets) {
        this.checkIsInMulti();
        this.client.zunionstore(dstkey, params, sets);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zinterstore(String dstkey, String ... sets) {
        this.checkIsInMulti();
        this.client.zinterstore(dstkey, sets);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zinterstore(String dstkey, ZParams params, String ... sets) {
        this.checkIsInMulti();
        this.client.zinterstore(dstkey, params, sets);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zlexcount(String key, String min, String max) {
        this.checkIsInMulti();
        this.client.zlexcount(key, min, max);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<String> zrangeByLex(String key, String min, String max) {
        this.checkIsInMulti();
        this.client.zrangeByLex(key, min, max);
        List<String> members = this.client.getMultiBulkReply();
        if (members == null) {
            return null;
        }
        return new LinkedHashSet<String>(members);
    }

    @Override
    public Set<String> zrangeByLex(String key, String min, String max, int offset, int count) {
        this.checkIsInMulti();
        this.client.zrangeByLex(key, min, max, offset, count);
        List<String> members = this.client.getMultiBulkReply();
        if (members == null) {
            return null;
        }
        return new LinkedHashSet<String>(members);
    }

    @Override
    public Long zremrangeByLex(String key, String min, String max) {
        this.checkIsInMulti();
        this.client.zremrangeByLex(key, min, max);
        return this.client.getIntegerReply();
    }

    @Override
    public Long strlen(String key) {
        this.client.strlen(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long lpushx(String key, String ... string) {
        this.client.lpushx(key, string);
        return this.client.getIntegerReply();
    }

    @Override
    public Long persist(String key) {
        this.client.persist(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long rpushx(String key, String ... string) {
        this.client.rpushx(key, string);
        return this.client.getIntegerReply();
    }

    @Override
    public String echo(String string) {
        this.client.echo(string);
        return this.client.getBulkReply();
    }

    @Override
    public Long linsert(String key, BinaryClient.LIST_POSITION where, String pivot, String value) {
        this.client.linsert(key, where, pivot, value);
        return this.client.getIntegerReply();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String brpoplpush(String source, String destination, int timeout) {
        this.client.brpoplpush(source, destination, timeout);
        this.client.setTimeoutInfinite();
        try {
            String string = this.client.getBulkReply();
            return string;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    @Override
    public Boolean setbit(String key, long offset, boolean value) {
        this.client.setbit(key, offset, value);
        return this.client.getIntegerReply() == 1L;
    }

    @Override
    public Boolean setbit(String key, long offset, String value) {
        this.client.setbit(key, offset, value);
        return this.client.getIntegerReply() == 1L;
    }

    @Override
    public Boolean getbit(String key, long offset) {
        this.client.getbit(key, offset);
        return this.client.getIntegerReply() == 1L;
    }

    @Override
    public Long setrange(String key, long offset, String value) {
        this.client.setrange(key, offset, value);
        return this.client.getIntegerReply();
    }

    @Override
    public String getrange(String key, long startOffset, long endOffset) {
        this.client.getrange(key, startOffset, endOffset);
        return this.client.getBulkReply();
    }

    public Long bitpos(String key, boolean value) {
        return this.bitpos(key, value, new BitPosParams());
    }

    public Long bitpos(String key, boolean value, BitPosParams params) {
        this.client.bitpos(key, value, params);
        return this.client.getIntegerReply();
    }

    @Override
    public List<String> configGet(String pattern) {
        this.client.configGet(pattern);
        return this.client.getMultiBulkReply();
    }

    @Override
    public String configSet(String parameter, String value) {
        this.client.configSet(parameter, value);
        return this.client.getStatusCodeReply();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object eval(String script, int keyCount, String ... params) {
        this.client.setTimeoutInfinite();
        try {
            this.client.eval(script, keyCount, params);
            Object object = this.getEvalResult();
            return object;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(JedisPubSub jedisPubSub, String ... channels) {
        this.client.setTimeoutInfinite();
        try {
            jedisPubSub.proceed(this.client, channels);
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    @Override
    public Long publish(String channel, String message) {
        this.checkIsInMulti();
        this.connect();
        this.client.publish(channel, message);
        return this.client.getIntegerReply();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void psubscribe(JedisPubSub jedisPubSub, String ... patterns) {
        this.checkIsInMulti();
        this.client.setTimeoutInfinite();
        try {
            jedisPubSub.proceedWithPatterns(this.client, patterns);
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    protected static String[] getParams(List<String> keys, List<String> args) {
        int i;
        int keyCount = keys.size();
        int argCount = args.size();
        String[] params = new String[keyCount + args.size()];
        for (i = 0; i < keyCount; ++i) {
            params[i] = keys.get(i);
        }
        for (i = 0; i < argCount; ++i) {
            params[keyCount + i] = args.get(i);
        }
        return params;
    }

    @Override
    public Object eval(String script, List<String> keys, List<String> args) {
        return this.eval(script, keys.size(), Jedis.getParams(keys, args));
    }

    @Override
    public Object eval(String script) {
        return this.eval(script, 0, new String[0]);
    }

    @Override
    public Object evalsha(String script) {
        return this.evalsha(script, 0, new String[0]);
    }

    private Object getEvalResult() {
        return this.evalResult(this.client.getOne());
    }

    private Object evalResult(Object result) {
        if (result instanceof byte[]) {
            return SafeEncoder.encode((byte[])result);
        }
        if (result instanceof List) {
            List list = (List)result;
            ArrayList<Object> listResult = new ArrayList<Object>(list.size());
            for (Object bin : list) {
                listResult.add(this.evalResult(bin));
            }
            return listResult;
        }
        return result;
    }

    @Override
    public Object evalsha(String sha1, List<String> keys, List<String> args) {
        return this.evalsha(sha1, keys.size(), Jedis.getParams(keys, args));
    }

    @Override
    public Object evalsha(String sha1, int keyCount, String ... params) {
        this.checkIsInMulti();
        this.client.evalsha(sha1, keyCount, params);
        return this.getEvalResult();
    }

    @Override
    public Boolean scriptExists(String sha1) {
        String[] a = new String[]{sha1};
        return this.scriptExists(a).get(0);
    }

    @Override
    public List<Boolean> scriptExists(String ... sha1) {
        this.client.scriptExists(sha1);
        List<Long> result = this.client.getIntegerMultiBulkReply();
        ArrayList<Boolean> exists = new ArrayList<Boolean>();
        for (Long value : result) {
            exists.add(value == 1L);
        }
        return exists;
    }

    @Override
    public String scriptLoad(String script) {
        this.client.scriptLoad(script);
        return this.client.getBulkReply();
    }

    @Override
    public List<Slowlog> slowlogGet() {
        this.client.slowlogGet();
        return Slowlog.from(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<Slowlog> slowlogGet(long entries) {
        this.client.slowlogGet(entries);
        return Slowlog.from(this.client.getObjectMultiBulkReply());
    }

    @Override
    public Long objectRefcount(String string) {
        this.client.objectRefcount(string);
        return this.client.getIntegerReply();
    }

    @Override
    public String objectEncoding(String string) {
        this.client.objectEncoding(string);
        return this.client.getBulkReply();
    }

    @Override
    public Long objectIdletime(String string) {
        this.client.objectIdletime(string);
        return this.client.getIntegerReply();
    }

    @Override
    public Long bitcount(String key) {
        this.client.bitcount(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long bitcount(String key, long start, long end) {
        this.client.bitcount(key, start, end);
        return this.client.getIntegerReply();
    }

    @Override
    public Long bitop(BitOP op, String destKey, String ... srcKeys) {
        this.client.bitop(op, destKey, srcKeys);
        return this.client.getIntegerReply();
    }

    @Override
    public List<Map<String, String>> sentinelMasters() {
        this.client.sentinel("masters");
        List<Object> reply = this.client.getObjectMultiBulkReply();
        ArrayList<Map<String, String>> masters = new ArrayList<Map<String, String>>();
        for (Object obj : reply) {
            masters.add(BuilderFactory.STRING_MAP.build((List)obj));
        }
        return masters;
    }

    @Override
    public List<String> sentinelGetMasterAddrByName(String masterName) {
        this.client.sentinel("get-master-addr-by-name", masterName);
        List<Object> reply = this.client.getObjectMultiBulkReply();
        return BuilderFactory.STRING_LIST.build(reply);
    }

    @Override
    public Long sentinelReset(String pattern) {
        this.client.sentinel("reset", pattern);
        return this.client.getIntegerReply();
    }

    @Override
    public List<Map<String, String>> sentinelSlaves(String masterName) {
        this.client.sentinel("slaves", masterName);
        List<Object> reply = this.client.getObjectMultiBulkReply();
        ArrayList<Map<String, String>> slaves = new ArrayList<Map<String, String>>();
        for (Object obj : reply) {
            slaves.add(BuilderFactory.STRING_MAP.build((List)obj));
        }
        return slaves;
    }

    @Override
    public String sentinelFailover(String masterName) {
        this.client.sentinel("failover", masterName);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String sentinelMonitor(String masterName, String ip, int port, int quorum) {
        this.client.sentinel("monitor", masterName, ip, String.valueOf(port), String.valueOf(quorum));
        return this.client.getStatusCodeReply();
    }

    @Override
    public String sentinelRemove(String masterName) {
        this.client.sentinel("remove", masterName);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String sentinelSet(String masterName, Map<String, String> parameterMap) {
        int index = 0;
        int paramsLength = parameterMap.size() * 2 + 2;
        String[] params = new String[paramsLength];
        params[index++] = "set";
        params[index++] = masterName;
        for (Map.Entry<String, String> entry : parameterMap.entrySet()) {
            params[index++] = entry.getKey();
            params[index++] = entry.getValue();
        }
        this.client.sentinel(params);
        return this.client.getStatusCodeReply();
    }

    public byte[] dump(String key) {
        this.checkIsInMulti();
        this.client.dump(key);
        return this.client.getBinaryBulkReply();
    }

    public String restore(String key, int ttl, byte[] serializedValue) {
        this.checkIsInMulti();
        this.client.restore(key, ttl, serializedValue);
        return this.client.getStatusCodeReply();
    }

    @Deprecated
    public Long pexpire(String key, int milliseconds) {
        return this.pexpire(key, (long)milliseconds);
    }

    @Override
    public Long pexpire(String key, long milliseconds) {
        this.checkIsInMulti();
        this.client.pexpire(key, milliseconds);
        return this.client.getIntegerReply();
    }

    @Override
    public Long pexpireAt(String key, long millisecondsTimestamp) {
        this.checkIsInMulti();
        this.client.pexpireAt(key, millisecondsTimestamp);
        return this.client.getIntegerReply();
    }

    public Long pttl(String key) {
        this.checkIsInMulti();
        this.client.pttl(key);
        return this.client.getIntegerReply();
    }

    public String psetex(String key, int milliseconds, String value) {
        this.checkIsInMulti();
        this.client.psetex(key, milliseconds, value);
        return this.client.getStatusCodeReply();
    }

    public String set(String key, String value, String nxxx) {
        this.checkIsInMulti();
        this.client.set(key, value, nxxx);
        return this.client.getStatusCodeReply();
    }

    public String set(String key, String value, String nxxx, String expx, int time) {
        this.checkIsInMulti();
        this.client.set(key, value, nxxx, expx, time);
        return this.client.getStatusCodeReply();
    }

    public String clientKill(String client) {
        this.checkIsInMulti();
        this.client.clientKill(client);
        return this.client.getStatusCodeReply();
    }

    public String clientSetname(String name) {
        this.checkIsInMulti();
        this.client.clientSetname(name);
        return this.client.getStatusCodeReply();
    }

    public String migrate(String host, int port, String key, int destinationDb, int timeout) {
        this.checkIsInMulti();
        this.client.migrate(host, port, key, destinationDb, timeout);
        return this.client.getStatusCodeReply();
    }

    @Override
    @Deprecated
    public ScanResult<String> scan(int cursor) {
        return this.scan(cursor, new ScanParams());
    }

    @Deprecated
    public ScanResult<String> scan(int cursor, ScanParams params) {
        this.checkIsInMulti();
        this.client.scan(cursor, params);
        List<Object> result = this.client.getObjectMultiBulkReply();
        int newcursor = Integer.parseInt(new String((byte[])result.get(0)));
        ArrayList<String> results = new ArrayList<String>();
        List rawResults = (List)result.get(1);
        for (byte[] bs : rawResults) {
            results.add(SafeEncoder.encode(bs));
        }
        return new ScanResult<String>(newcursor, results);
    }

    @Override
    @Deprecated
    public ScanResult<Map.Entry<String, String>> hscan(String key, int cursor) {
        return this.hscan(key, cursor, new ScanParams());
    }

    @Deprecated
    public ScanResult<Map.Entry<String, String>> hscan(String key, int cursor, ScanParams params) {
        this.checkIsInMulti();
        this.client.hscan(key, cursor, params);
        List<Object> result = this.client.getObjectMultiBulkReply();
        int newcursor = Integer.parseInt(new String((byte[])result.get(0)));
        ArrayList<AbstractMap.SimpleEntry<String, String>> results = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
        List rawResults = (List)result.get(1);
        Iterator iterator = rawResults.iterator();
        while (iterator.hasNext()) {
            results.add(new AbstractMap.SimpleEntry<String, String>(SafeEncoder.encode((byte[])iterator.next()), SafeEncoder.encode((byte[])iterator.next())));
        }
        return new ScanResult<Map.Entry<String, String>>(newcursor, results);
    }

    @Override
    @Deprecated
    public ScanResult<String> sscan(String key, int cursor) {
        return this.sscan(key, cursor, new ScanParams());
    }

    @Deprecated
    public ScanResult<String> sscan(String key, int cursor, ScanParams params) {
        this.checkIsInMulti();
        this.client.sscan(key, cursor, params);
        List<Object> result = this.client.getObjectMultiBulkReply();
        int newcursor = Integer.parseInt(new String((byte[])result.get(0)));
        ArrayList<String> results = new ArrayList<String>();
        List rawResults = (List)result.get(1);
        for (byte[] bs : rawResults) {
            results.add(SafeEncoder.encode(bs));
        }
        return new ScanResult<String>(newcursor, results);
    }

    @Override
    @Deprecated
    public ScanResult<Tuple> zscan(String key, int cursor) {
        return this.zscan(key, cursor, new ScanParams());
    }

    @Deprecated
    public ScanResult<Tuple> zscan(String key, int cursor, ScanParams params) {
        this.checkIsInMulti();
        this.client.zscan(key, cursor, params);
        List<Object> result = this.client.getObjectMultiBulkReply();
        int newcursor = Integer.parseInt(new String((byte[])result.get(0)));
        ArrayList<Tuple> results = new ArrayList<Tuple>();
        List rawResults = (List)result.get(1);
        Iterator iterator = rawResults.iterator();
        while (iterator.hasNext()) {
            results.add(new Tuple(SafeEncoder.encode((byte[])iterator.next()), Double.valueOf(SafeEncoder.encode((byte[])iterator.next()))));
        }
        return new ScanResult<Tuple>(newcursor, results);
    }

    @Override
    public ScanResult<String> scan(String cursor) {
        return this.scan(cursor, new ScanParams());
    }

    public ScanResult<String> scan(String cursor, ScanParams params) {
        this.checkIsInMulti();
        this.client.scan(cursor, params);
        List<Object> result = this.client.getObjectMultiBulkReply();
        String newcursor = new String((byte[])result.get(0));
        ArrayList<String> results = new ArrayList<String>();
        List rawResults = (List)result.get(1);
        for (byte[] bs : rawResults) {
            results.add(SafeEncoder.encode(bs));
        }
        return new ScanResult<String>(newcursor, results);
    }

    @Override
    public ScanResult<Map.Entry<String, String>> hscan(String key, String cursor) {
        return this.hscan(key, cursor, new ScanParams());
    }

    public ScanResult<Map.Entry<String, String>> hscan(String key, String cursor, ScanParams params) {
        this.checkIsInMulti();
        this.client.hscan(key, cursor, params);
        List<Object> result = this.client.getObjectMultiBulkReply();
        String newcursor = new String((byte[])result.get(0));
        ArrayList<AbstractMap.SimpleEntry<String, String>> results = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
        List rawResults = (List)result.get(1);
        Iterator iterator = rawResults.iterator();
        while (iterator.hasNext()) {
            results.add(new AbstractMap.SimpleEntry<String, String>(SafeEncoder.encode((byte[])iterator.next()), SafeEncoder.encode((byte[])iterator.next())));
        }
        return new ScanResult<Map.Entry<String, String>>(newcursor, results);
    }

    @Override
    public ScanResult<String> sscan(String key, String cursor) {
        return this.sscan(key, cursor, new ScanParams());
    }

    public ScanResult<String> sscan(String key, String cursor, ScanParams params) {
        this.checkIsInMulti();
        this.client.sscan(key, cursor, params);
        List<Object> result = this.client.getObjectMultiBulkReply();
        String newcursor = new String((byte[])result.get(0));
        ArrayList<String> results = new ArrayList<String>();
        List rawResults = (List)result.get(1);
        for (byte[] bs : rawResults) {
            results.add(SafeEncoder.encode(bs));
        }
        return new ScanResult<String>(newcursor, results);
    }

    @Override
    public ScanResult<Tuple> zscan(String key, String cursor) {
        return this.zscan(key, cursor, new ScanParams());
    }

    public ScanResult<Tuple> zscan(String key, String cursor, ScanParams params) {
        this.checkIsInMulti();
        this.client.zscan(key, cursor, params);
        List<Object> result = this.client.getObjectMultiBulkReply();
        String newcursor = new String((byte[])result.get(0));
        ArrayList<Tuple> results = new ArrayList<Tuple>();
        List rawResults = (List)result.get(1);
        Iterator iterator = rawResults.iterator();
        while (iterator.hasNext()) {
            results.add(new Tuple(SafeEncoder.encode((byte[])iterator.next()), Double.valueOf(SafeEncoder.encode((byte[])iterator.next()))));
        }
        return new ScanResult<Tuple>(newcursor, results);
    }

    @Override
    public String clusterNodes() {
        this.checkIsInMulti();
        this.client.clusterNodes();
        return this.client.getBulkReply();
    }

    @Override
    public String clusterMeet(String ip, int port) {
        this.checkIsInMulti();
        this.client.clusterMeet(ip, port);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clusterReset(JedisCluster.Reset resetType) {
        this.checkIsInMulti();
        this.client.clusterReset(resetType);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clusterAddSlots(int ... slots) {
        this.checkIsInMulti();
        this.client.clusterAddSlots(slots);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clusterDelSlots(int ... slots) {
        this.checkIsInMulti();
        this.client.clusterDelSlots(slots);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clusterInfo() {
        this.checkIsInMulti();
        this.client.clusterInfo();
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<String> clusterGetKeysInSlot(int slot, int count) {
        this.checkIsInMulti();
        this.client.clusterGetKeysInSlot(slot, count);
        return this.client.getMultiBulkReply();
    }

    @Override
    public String clusterSetSlotNode(int slot, String nodeId) {
        this.checkIsInMulti();
        this.client.clusterSetSlotNode(slot, nodeId);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clusterSetSlotMigrating(int slot, String nodeId) {
        this.checkIsInMulti();
        this.client.clusterSetSlotMigrating(slot, nodeId);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clusterSetSlotImporting(int slot, String nodeId) {
        this.checkIsInMulti();
        this.client.clusterSetSlotImporting(slot, nodeId);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clusterSetSlotStable(int slot) {
        this.checkIsInMulti();
        this.client.clusterSetSlotStable(slot);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clusterForget(String nodeId) {
        this.checkIsInMulti();
        this.client.clusterForget(nodeId);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clusterFlushSlots() {
        this.checkIsInMulti();
        this.client.clusterFlushSlots();
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long clusterKeySlot(String key) {
        this.checkIsInMulti();
        this.client.clusterKeySlot(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long clusterCountKeysInSlot(int slot) {
        this.checkIsInMulti();
        this.client.clusterCountKeysInSlot(slot);
        return this.client.getIntegerReply();
    }

    @Override
    public String clusterSaveConfig() {
        this.checkIsInMulti();
        this.client.clusterSaveConfig();
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clusterReplicate(String nodeId) {
        this.checkIsInMulti();
        this.client.clusterReplicate(nodeId);
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<String> clusterSlaves(String nodeId) {
        this.checkIsInMulti();
        this.client.clusterSlaves(nodeId);
        return this.client.getMultiBulkReply();
    }

    @Override
    public String clusterFailover() {
        this.checkIsInMulti();
        this.client.clusterFailover();
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<Object> clusterSlots() {
        this.checkIsInMulti();
        this.client.clusterSlots();
        return this.client.getObjectMultiBulkReply();
    }

    public String asking() {
        this.checkIsInMulti();
        this.client.asking();
        return this.client.getStatusCodeReply();
    }

    public List<String> pubsubChannels(String pattern) {
        this.checkIsInMulti();
        this.client.pubsubChannels(pattern);
        return this.client.getMultiBulkReply();
    }

    public Long pubsubNumPat() {
        this.checkIsInMulti();
        this.client.pubsubNumPat();
        return this.client.getIntegerReply();
    }

    public Map<String, String> pubsubNumSub(String ... channels) {
        this.checkIsInMulti();
        this.client.pubsubNumSub(channels);
        return BuilderFactory.PUBSUB_NUMSUB_MAP.build(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public void close() {
        if (this.dataSource != null) {
            if (this.client.isBroken()) {
                this.dataSource.returnBrokenResource(this);
            } else {
                this.dataSource.returnResource(this);
            }
        } else {
            this.client.close();
        }
    }

    public void setDataSource(Pool<Jedis> jedisPool) {
        this.dataSource = jedisPool;
    }

    @Override
    public Long pfadd(String key, String ... elements) {
        this.checkIsInMulti();
        this.client.pfadd(key, elements);
        return this.client.getIntegerReply();
    }

    @Override
    public long pfcount(String key) {
        this.checkIsInMulti();
        this.client.pfcount(key);
        return this.client.getIntegerReply();
    }

    @Override
    public long pfcount(String ... keys) {
        this.checkIsInMulti();
        this.client.pfcount(keys);
        return this.client.getIntegerReply();
    }

    @Override
    public String pfmerge(String destkey, String ... sourcekeys) {
        this.checkIsInMulti();
        this.client.pfmerge(destkey, sourcekeys);
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<String> blpop(int timeout, String key) {
        return this.blpop(key, String.valueOf(timeout));
    }

    @Override
    public List<String> brpop(int timeout, String key) {
        return this.brpop(key, String.valueOf(timeout));
    }
}

