/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.Map;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisClusterInfoCache;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.exceptions.JedisConnectionException;

public abstract class JedisClusterConnectionHandler {
    protected final JedisClusterInfoCache cache;

    abstract Jedis getConnection();

    abstract Jedis getConnectionFromSlot(int var1);

    public Jedis getConnectionFromNode(HostAndPort node) {
        this.cache.setNodeIfNotExist(node);
        return this.cache.getNode(JedisClusterInfoCache.getNodeKey(node)).getResource();
    }

    public JedisClusterConnectionHandler(Set<HostAndPort> nodes, GenericObjectPoolConfig poolConfig, int connectionTimeout, int soTimeout) {
        this.cache = new JedisClusterInfoCache(poolConfig, connectionTimeout, soTimeout);
        this.initializeSlotsCache(nodes, poolConfig);
    }

    public Map<String, JedisPool> getNodes() {
        return this.cache.getNodes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeSlotsCache(Set<HostAndPort> startNodes, GenericObjectPoolConfig poolConfig) {
        for (HostAndPort hostAndPort : startNodes) {
            Jedis jedis = new Jedis(hostAndPort.getHost(), hostAndPort.getPort());
            try {
                this.cache.discoverClusterNodesAndSlots(jedis);
                break;
            }
            catch (JedisConnectionException e) {}
            continue;
            finally {
                if (jedis == null) continue;
                jedis.close();
            }
        }
        for (HostAndPort node : startNodes) {
            this.cache.setNodeIfNotExist(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renewSlotCache() {
        for (JedisPool jp : this.cache.getNodes().values()) {
            Jedis jedis = null;
            try {
                jedis = jp.getResource();
                this.cache.discoverClusterSlots(jedis);
                break;
            }
            catch (JedisConnectionException e) {}
            continue;
            finally {
                if (jedis == null) continue;
                jedis.close();
            }
        }
    }
}

