package score.api;

import score.api.dto.entitydto.*;
import score.api.dto.requestdto.*;
import score.api.dto.responsedto.PageResponseDTO;
import score.api.dto.responsedto.ScoreStatisticsResponseDTO;
import score.api.dto.responsedto.TransactionResponseDTO;
import sinomall.config.api.base.BaseResponse;

public interface ScoreApi {

    public static String SCORE_LOCK_PREFIX = ":SCORE:USER_LOCK:";
    public static String SCORE_CREATE_LOCK_PREFIX = ":SCORE:CREATE:USER_LOCK:";

    /**
     * 查询积分账户api
     *
     * @param scoreAccountRequestDTO
     * @return
     */
    public ScoreAccountDTO queryScoreAccount(ScoreAccountRequestDTO scoreAccountRequestDTO);

    /**
     * 增加积分api
     *
     * @param scoreIncomeDetailRequestDTO
     * @return
     */
    public TransactionResponseDTO addScore(ScoreIncomeDetailRequestDTO scoreIncomeDetailRequestDTO);

    /**
     * 消费积分api
     *
     * @param scoreExpenseDetailRequestDTO
     * @return
     */
    public TransactionResponseDTO expenseScore(ScoreExpenseDetailRequestDTO scoreExpenseDetailRequestDTO);

    /**
     * 个人查询收入明细api
     *
     * @param scoreDetailQueryDTO
     * @return
     */
    public PageResponseDTO<ScoreIncomeDetailDTO> queryScoreIncomeDetais(ScoreDetailQueryDTO scoreDetailQueryDTO);

    /**
     * 个人查询支出明细api
     *
     * @param scoreDetailQueryDTO
     * @return
     */
    public PageResponseDTO<ScoreExpenseDetailDTO> queryScoreExpenseDetails(ScoreDetailQueryDTO scoreDetailQueryDTO);

    /**
     * 个人查询收入支出明细api
     *
     * @param scoreDetailQueryDTO
     * @return
     */
    PageResponseDTO<ScoreIncomeExpenseDetailDTO> queryScoreIncomeExpenseDetails(ScoreDetailQueryDTO scoreDetailQueryDTO);

    /**
     * 积分赠送api
     */
    public ScoreGiveAwayLogDTO scoreGiveAway(ScoreGiveAwayRequestDTO scoreGiveAwayRequestDTO);

    /**
     * 获取赠送记录api
     */
    public ScoreGiveAwayLogDTO getScoreGiveAwayInfo(GetScoreGiveAwayInfoRequestDTO getScoreGiveAwayInfoRequestDTO);

    /**
     * 统计积分收入
     *
     * @param scoreStatisticsRequestDTO
     * @return
     */
    public ScoreStatisticsResponseDTO scoreIncomeStatics(ScoreStatisticsRequestDTO scoreStatisticsRequestDTO);

    /**
     * 统计积分支出
     *
     * @param scoreStatisticsRequestDTO
     * @return
     */
    public ScoreStatisticsResponseDTO scoreExpenseStatics(ScoreStatisticsRequestDTO scoreStatisticsRequestDTO);

    /**
     * 注销账户
     */
    public BaseResponse deleteAccount(String scoreAccountId);
}
