package score.api.dto.entitydto;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 企业预存款明细表DTO
 */

public class PrepaidDepositChangeLogDTO  implements Serializable{

    private String id;
    /**
     * 合作伙伴代码
     */
    private String organizationCode;
    /**
     * 交易明细凭证号
     */
    private String rcptCode;
    /**
     * 原有预存款
     */
    private BigDecimal oldPrepaidDeposiVal;
    /**
     * 本次变更存款值
     */
    private BigDecimal depositVal;
    /**
     * 变更后预存款值
     */
    private BigDecimal newPrepaidDepositVal;
    /**
     * 变更类型（0，新增，1扣减）
     */
    private String type;
    /**
     * 交易备注
     */
    private String memo;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOrganizationCode() {
        return organizationCode;
    }

    public void setOrganizationCode(String organizationCode) {
        this.organizationCode = organizationCode;
    }

    public String getRcptCode() {
        return rcptCode;
    }

    public void setRcptCode(String rcptCode) {
        this.rcptCode = rcptCode;
    }

    public BigDecimal getOldPrepaidDeposiVal() {
        return oldPrepaidDeposiVal;
    }

    public void setOldPrepaidDeposiVal(BigDecimal oldPrepaidDeposiVal) {
        this.oldPrepaidDeposiVal = oldPrepaidDeposiVal;
    }

    public BigDecimal getDepositVal() {
        return depositVal;
    }

    public void setDepositVal(BigDecimal depositVal) {
        this.depositVal = depositVal;
    }

    public BigDecimal getNewPrepaidDepositVal() {
        return newPrepaidDepositVal;
    }

    public void setNewPrepaidDepositVal(BigDecimal newPrepaidDepositVal) {
        this.newPrepaidDepositVal = newPrepaidDepositVal;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        PrepaidDepositChangeLogDTO that = (PrepaidDepositChangeLogDTO) o;

        return id != null ? id.equals(that.id) : that.id == null;
    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }

    @Override
    public String toString() {
        return "PrepaidDepositChangeLogDTO{" +
                "id='" + id + '\'' +
                ", organizationCode='" + organizationCode + '\'' +
                ", rcptCode='" + rcptCode + '\'' +
                ", oldPrepaidDeposiVal=" + oldPrepaidDeposiVal +
                ", depositVal=" + depositVal +
                ", newPrepaidDepositVal=" + newPrepaidDepositVal +
                ", type='" + type + '\'' +
                ", memo='" + memo + '\'' +
                '}';
    }
}
