package score.api.dto.entitydto;

import com.alibaba.fastjson.annotation.JSONField;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 积分总账表DTO
 */

public class ScoreAccountDTO implements Serializable {

    private String id;
    /**
     * 合作伙伴代码
     */
    private String organizationCode;
    /**
     * 用户id
     */
    private String userId;
    /**
     * 手机号
     */
    private String phone;
    /**
     * 邮箱
     */
    private String email;
    /**
     * 总收入积分值
     */
    private BigDecimal incomeScoreVal;
    /**
     * 冻结积分值
     */
    private BigDecimal freezeScoreVal;
    /**
     * 已消费积分值
     */
    private BigDecimal expendedScoreVal;
    /**
     * 已失效积分值
     */
    private BigDecimal invalidScoreVal;
    /**
     * 即将失效积分值
     */
    private BigDecimal aboutOfInvalidScoreVal;
    /**
     * 创建时间
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date dateCreated;
    /**
     * 更新时间
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date lastUpdated;

    /**
     * 用户昵称
     */
    private String nickName;
    /**
     * 备用字段1
     */
    private String standby1;
    /**
     * 备用字段2
     */
    private String standby2;
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOrganizationCode() {
        return organizationCode;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getStandby1() {
        return standby1;
    }

    public void setStandby1(String standby1) {
        this.standby1 = standby1;
    }

    public String getStandby2() {
        return standby2;
    }

    public void setStandby2(String standby2) {
        this.standby2 = standby2;
    }

    public void setOrganizationCode(String organizationCode) {
        this.organizationCode = organizationCode;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public BigDecimal getIncomeScoreVal() {
        return incomeScoreVal;
    }

    public void setIncomeScoreVal(BigDecimal incomeScoreVal) {
        this.incomeScoreVal = incomeScoreVal;
    }

    public BigDecimal getFreezeScoreVal() {
        return freezeScoreVal;
    }

    public void setFreezeScoreVal(BigDecimal freezeScoreVal) {
        this.freezeScoreVal = freezeScoreVal;
    }

    public BigDecimal getExpendedScoreVal() {
        return expendedScoreVal;
    }

    public void setExpendedScoreVal(BigDecimal expendedScoreVal) {
        this.expendedScoreVal = expendedScoreVal;
    }

    public BigDecimal getInvalidScoreVal() {
        return invalidScoreVal;
    }

    public void setInvalidScoreVal(BigDecimal invalidScoreVal) {
        this.invalidScoreVal = invalidScoreVal;
    }

    public BigDecimal getAboutOfInvalidScoreVal() {
        return aboutOfInvalidScoreVal;
    }

    public void setAboutOfInvalidScoreVal(BigDecimal aboutOfInvalidScoreVal) {
        this.aboutOfInvalidScoreVal = aboutOfInvalidScoreVal;
    }

    public Date getDateCreated() {
        return dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public Date getLastUpdated() {
        return lastUpdated;
    }

    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ScoreAccountDTO that = (ScoreAccountDTO) o;

        return id != null ? id.equals(that.id) : that.id == null;
    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }

    @Override
    public String toString() {
        return "ScoreAccountDTO{" +
                "id='" + id + '\'' +
                ", organizationCode='" + organizationCode + '\'' +
                ", userId='" + userId + '\'' +
                ", phone='" + phone + '\'' +
                ", email='" + email + '\'' +
                ", incomeScoreVal=" + incomeScoreVal +
                ", freezeScoreVal=" + freezeScoreVal +
                ", expendedScoreVal=" + expendedScoreVal +
                ", invalidScoreVal=" + invalidScoreVal +
                ", aboutOfInvalidScoreVal=" + aboutOfInvalidScoreVal +
                ", dateCreated=" + dateCreated +
                ", lastUpdated=" + lastUpdated +
                ", nickName='" + nickName + '\'' +
                ", standby1='" + standby1 + '\'' +
                ", standby2='" + standby2 + '\'' +
                '}';
    }
}
