package score.api.dto.entitydto;

import com.alibaba.fastjson.annotation.JSONField;

import java.io.Serializable;
import java.util.Date;

/**
 * 积分支出明细表DTO
 */

public class ScoreExpenseDetailDTO implements Serializable {

    private String id;
    /**
     * 积分账户表id
     */
//    private String scoreAccountId;
    private ScoreAccountDTO scoreAccount;
    /**
     * 消费渠道名称
     */
    private String busiSource;
    /**
     * 消费渠道代码
     */
    private String busiCode;
    /**
     * 请求流水号（合作商内唯一）
     */
    private String transactionNo;
    /**
     * 积分交易明细凭证号
     */
    private String scoreRcptCode;
    /**
     * 交易积分值
     */
    private String scoreVal;
    /**
     * 积分交易时间
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date transaTime;
    /**
     * 交易备注
     */
    private String memo;
    /**
     * 备用字段1
     */
    private String standby1;
    /**
     * 备用字段2
     */
    private String standby2;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ScoreAccountDTO getScoreAccount() {
        return scoreAccount;
    }

    public void setScoreAccount(ScoreAccountDTO scoreAccount) {
        this.scoreAccount = scoreAccount;
    }

    public String getBusiSource() {
        return busiSource;
    }

    public void setBusiSource(String busiSource) {
        this.busiSource = busiSource;
    }

    public String getBusiCode() {
        return busiCode;
    }

    public void setBusiCode(String busiCode) {
        this.busiCode = busiCode;
    }

    public String getTransactionNo() {
        return transactionNo;
    }

    public void setTransactionNo(String transactionNo) {
        this.transactionNo = transactionNo;
    }

    public String getScoreRcptCode() {
        return scoreRcptCode;
    }

    public void setScoreRcptCode(String scoreRcptCode) {
        this.scoreRcptCode = scoreRcptCode;
    }

    public String getScoreVal() {
        return scoreVal;
    }

    public void setScoreVal(String scoreVal) {
        this.scoreVal = scoreVal;
    }

    public Date getTransaTime() {
        return transaTime;
    }

    public void setTransaTime(Date transaTime) {
        this.transaTime = transaTime;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getStandby1() {
        return standby1;
    }

    public void setStandby1(String standby1) {
        this.standby1 = standby1;
    }

    public String getStandby2() {
        return standby2;
    }

    public void setStandby2(String standby2) {
        this.standby2 = standby2;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ScoreExpenseDetailDTO that = (ScoreExpenseDetailDTO) o;

        return id != null ? id.equals(that.id) : that.id == null;
    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }

    @Override
    public String toString() {
        return "ScoreExpenseDetailDTO{" +
                "id='" + id + '\'' +
                ", scoreAccountId='" +(scoreAccount==null?"":scoreAccount.getId())  + '\'' +
                ", busiSource='" + busiSource + '\'' +
                ", busiCode='" + busiCode + '\'' +
                ", transactionNo='" + transactionNo + '\'' +
                ", scoreRcptCode='" + scoreRcptCode + '\'' +
                ", scoreVal='" + scoreVal + '\'' +
                ", transaTime=" + transaTime +
                ", memo='" + memo + '\'' +
                ", standby1='" + standby1 + '\'' +
                ", standby2='" + standby2 + '\'' +
                '}';
    }
}
