package score.api.dto.entitydto;

import com.alibaba.fastjson.annotation.JSONField;
import sinomall.config.api.base.BaseResponse;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 积分转赠记录表DTO
 */

public class ScoreGiveAwayLogDTO extends BaseResponse implements Serializable {

    private String id;
    /**
     * 赠送积分账户id
     */
//    private String giveAwayScoreAccountId;
    private ScoreAccountDTO giveAwayScoreAccount;

    /**
     * 获赠账户id
     */
//    private String receiveScoreAccountId;
    private ScoreAccountDTO receiveScoreAccount;
    /**
     * 转赠积分
     */
    private BigDecimal scoreVal;
    /**
     * 积分交易明细凭证号（收入）
     */
    private String scoreIncomeRcptCode;
    /**
     * 积分交易明细凭证号（支出）
     */
    private String scoreExpenseRcptCode;
    /**
     * 备注
     */
    private String memo;
    /**
     * 赠送时间
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date giveAwayTime;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ScoreAccountDTO getGiveAwayScoreAccount() {
        return giveAwayScoreAccount;
    }

    public void setGiveAwayScoreAccount(ScoreAccountDTO giveAwayScoreAccount) {
        this.giveAwayScoreAccount = giveAwayScoreAccount;
    }

    public ScoreAccountDTO getReceiveScoreAccount() {
        return receiveScoreAccount;
    }

    public void setReceiveScoreAccount(ScoreAccountDTO receiveScoreAccount) {
        this.receiveScoreAccount = receiveScoreAccount;
    }

    public BigDecimal getScoreVal() {
        return scoreVal;
    }

    public void setScoreVal(BigDecimal scoreVal) {
        this.scoreVal = scoreVal;
    }

    public String getScoreIncomeRcptCode() {
        return scoreIncomeRcptCode;
    }

    public void setScoreIncomeRcptCode(String scoreIncomeRcptCode) {
        this.scoreIncomeRcptCode = scoreIncomeRcptCode;
    }

    public String getScoreExpenseRcptCode() {
        return scoreExpenseRcptCode;
    }

    public void setScoreExpenseRcptCode(String scoreExpenseRcptCode) {
        this.scoreExpenseRcptCode = scoreExpenseRcptCode;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Date getGiveAwayTime() {
        return giveAwayTime;
    }

    public void setGiveAwayTime(Date giveAwayTime) {
        this.giveAwayTime = giveAwayTime;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ScoreGiveAwayLogDTO that = (ScoreGiveAwayLogDTO) o;

        return id != null ? id.equals(that.id) : that.id == null;
    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }

    @Override
    public String toString() {
        return "ScoreGiveAwayLogDTO{" +
                "id='" + id + '\'' +
                ", giveAwayScoreAccountId='" + (giveAwayScoreAccount==null?"": giveAwayScoreAccount.getId()) + '\'' +
                ", receiveScoreAccountId='" +(receiveScoreAccount==null?"":receiveScoreAccount.getId() ) + '\'' +
                ", scoreVal=" + scoreVal +
                ", scoreIncomeRcptCode='" + scoreIncomeRcptCode + '\'' +
                ", scoreExpenseRcptCode='" + scoreExpenseRcptCode + '\'' +
                ", memo='" + memo + '\'' +
                ", giveAwayTime=" + giveAwayTime +
                '}';
    }
}
