package score.api.dto.modeldto;

import sinomall.global.dto.base.BaseDomainDto;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 订单明细企业预存款变更记录表
 */
public class PrepaidDepositOrderLogDto extends BaseDomainDto implements Serializable {
    private String id;
    /**
     * 合作伙伴代码
     */
    private String organizationCode;
    /**
     * 交易明细凭证号
     */
    private String rcptCode;
    /**
     * 订单号
     */
    private String orderNo;
    /**
     * 本次变更存款值
     */
    private BigDecimal depositVal;
    /**
     * 预存款类型（0，积分，1金额）
     */
    private String prepaidDepositType;
    /**
     * 预存款变更类型（0，新增，1扣减
     */
    private String changeType;
    /**
     * 备注
     */
    private String memo;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOrganizationCode() {
        return organizationCode;
    }

    public void setOrganizationCode(String organizationCode) {
        this.organizationCode = organizationCode;
    }

    public String getRcptCode() {
        return rcptCode;
    }

    public void setRcptCode(String rcptCode) {
        this.rcptCode = rcptCode;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public BigDecimal getDepositVal() {
        return depositVal;
    }

    public void setDepositVal(BigDecimal depositVal) {
        this.depositVal = depositVal;
    }

    public String getPrepaidDepositType() {
        return prepaidDepositType;
    }

    public void setPrepaidDepositType(String prepaidDepositType) {
        this.prepaidDepositType = prepaidDepositType;
    }

    public String getChangeType() {
        return changeType;
    }

    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        PrepaidDepositOrderLogDto that = (PrepaidDepositOrderLogDto) o;

        return id != null ? id.equals(that.id) : that.id == null;
    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }
}
