package score.api.dto.modeldto;

import com.alibaba.fastjson.annotation.JSONField;
import sinomall.global.dto.base.BaseDomainDto;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 积分转赠记录表
 */
public class ScoreGiveAwayLogDto extends BaseDomainDto implements Serializable {
    private String id;
    /**
     * 赠送积分账户id
     */
//    private String giveAwayScoreAccountId;
    private ScoreAccountDto giveAwayScoreAccount;

    /**
     * 获赠账户id
     */
//    private String receiveScoreAccountId;
    private ScoreAccountDto receiveScoreAccount;
    /**
     * 转赠积分
     */
    private BigDecimal scoreVal;
    /**
     * 积分交易明细凭证号（收入）
     */
    private String scoreIncomeRcptCode;
    /**
     * 积分交易明细凭证号（支出）
     */
    private String scoreExpenseRcptCode;
    /**
     * 备注
     */
    private String memo;
    /**
     * 赠送时间
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date giveAwayTime;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ScoreAccountDto getGiveAwayScoreAccount() {
        return giveAwayScoreAccount;
    }

    public void setGiveAwayScoreAccount(ScoreAccountDto giveAwayScoreAccount) {
        this.giveAwayScoreAccount = giveAwayScoreAccount;
    }

    public ScoreAccountDto getReceiveScoreAccount() {
        return receiveScoreAccount;
    }

    public void setReceiveScoreAccount(ScoreAccountDto receiveScoreAccount) {
        this.receiveScoreAccount = receiveScoreAccount;
    }

    public BigDecimal getScoreVal() {
        return scoreVal;
    }

    public void setScoreVal(BigDecimal scoreVal) {
        this.scoreVal = scoreVal;
    }

    public String getScoreIncomeRcptCode() {
        return scoreIncomeRcptCode;
    }

    public void setScoreIncomeRcptCode(String scoreIncomeRcptCode) {
        this.scoreIncomeRcptCode = scoreIncomeRcptCode;
    }

    public String getScoreExpenseRcptCode() {
        return scoreExpenseRcptCode;
    }

    public void setScoreExpenseRcptCode(String scoreExpenseRcptCode) {
        this.scoreExpenseRcptCode = scoreExpenseRcptCode;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Date getGiveAwayTime() {
        return giveAwayTime;
    }

    public void setGiveAwayTime(Date giveAwayTime) {
        this.giveAwayTime = giveAwayTime;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ScoreGiveAwayLogDto that = (ScoreGiveAwayLogDto) o;

        return id != null ? id.equals(that.id) : that.id == null;
    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }

    @Override
    public String toString() {
        return "ScoreGiveAwayLogDto{" +
                "id='" + id + '\'' +
                ", giveAwayScoreAccountId='" + (giveAwayScoreAccount==null?"": giveAwayScoreAccount.getId()) + '\'' +
                ", receiveScoreAccountId='" +(receiveScoreAccount==null?"":receiveScoreAccount.getId() ) + '\'' +
                ", scoreVal=" + scoreVal +
                ", scoreIncomeRcptCode='" + scoreIncomeRcptCode + '\'' +
                ", scoreExpenseRcptCode='" + scoreExpenseRcptCode + '\'' +
                ", memo='" + memo + '\'' +
                ", giveAwayTime=" + giveAwayTime +
                '}';
    }
}
