package score.api.dto.modeldto;

import com.alibaba.fastjson.annotation.JSONField;
import sinomall.global.dto.base.BaseDomainDto;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 积分收入明细表
 */
public class ScoreIncomeDetailDto extends BaseDomainDto implements Serializable {

    private String id;
    /**
     * 积分账户表id
     */
//    private String scoreAccountId;
    private ScoreAccountDto scoreAccount;
    /**
     * 业务来源（授予、返还、 获赠）
     */
    private String busiSource;
    /**
     * 0 1 2 业务来源编码
     */
    private String busiCode;
    /**
     * 请求流水号（合作商内唯一）
     */
    private String transactionNo;
    /**
     * 积分交易明细凭证号
     */
    private String scoreRcptCode;
    /**
     * 积分值
     */
    private BigDecimal scoreVal;
    /**
     * 积分交易时间
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date transaTime;
    /**
     * 积分生效日期
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date effectDate;
    /**
     * 积分失效日期
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date overDate;
    /**
     * 交易备注
     */
    private String memo;
    /**
     * 备用字段1
     */
    private String standby1;
    /**
     * 备用字段2
     */
    private String standby2;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }


    public String getBusiSource() {
        return busiSource;
    }

    public void setBusiSource(String busiSource) {
        this.busiSource = busiSource;
    }

    public String getBusiCode() {
        return busiCode;
    }

    public void setBusiCode(String busiCode) {
        this.busiCode = busiCode;
    }

    public String getTransactionNo() {
        return transactionNo;
    }

    public void setTransactionNo(String transactionNo) {
        this.transactionNo = transactionNo;
    }

    public String getScoreRcptCode() {
        return scoreRcptCode;
    }

    public void setScoreRcptCode(String scoreRcptCode) {
        this.scoreRcptCode = scoreRcptCode;
    }

    public BigDecimal getScoreVal() {
        return scoreVal;
    }

    public void setScoreVal(BigDecimal scoreVal) {
        this.scoreVal = scoreVal;
    }

    public ScoreAccountDto getScoreAccount() {
        return scoreAccount;
    }

    public void setScoreAccount(ScoreAccountDto scoreAccount) {
        this.scoreAccount = scoreAccount;
    }


    public Date getTransaTime() {
        return transaTime;
    }

    public void setTransaTime(Date transaTime) {
        this.transaTime = transaTime;
    }

    public Date getEffectDate() {
        return effectDate;
    }

    public void setEffectDate(Date effectDate) {
        this.effectDate = effectDate;
    }

    public Date getOverDate() {
        return overDate;
    }

    public void setOverDate(Date overDate) {
        this.overDate = overDate;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getStandby1() {
        return standby1;
    }

    public void setStandby1(String standby1) {
        this.standby1 = standby1;
    }

    public String getStandby2() {
        return standby2;
    }

    public void setStandby2(String standby2) {
        this.standby2 = standby2;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ScoreIncomeDetailDto that = (ScoreIncomeDetailDto) o;

        return id != null ? id.equals(that.id) : that.id == null;
    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }

    @Override
    public String toString() {
        return "ScoreIncomeDetailDto{" +
                "id='" + id + '\'' +
                ", scoreAccountId='" +(scoreAccount==null?"": scoreAccount.getId() )+ '\'' +
                ", busiSource='" + busiSource + '\'' +
                ", busiCode='" + busiCode + '\'' +
                ", transactionNo='" + transactionNo + '\'' +
                ", scoreRcptCode='" + scoreRcptCode + '\'' +
                ", scoreVal='" + scoreVal + '\'' +
                ", transaTime=" + transaTime +
                ", effectDate=" + effectDate +
                ", overDate=" + overDate +
                ", memo='" + memo + '\'' +
                ", standby1='" + standby1 + '\'' +
                ", standby2='" + standby2 + '\'' +
                '}';
    }
}
