package score.api.dto.requestdto;

import com.alibaba.fastjson.annotation.JSONField;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;


public class ScoreDetailRequestDTO implements Serializable {

    /**
     * 积分账户表id
     */
    private String scoreAccountId;
    /**
     * 消费渠道名称
     */
    private String busiSource;
    /**
     * 消费渠道代码
     */
    private String busiCode;
    /**
     * 请求流水号（合作商内唯一）
     */
    private String transactionNo;

    /**
     * 交易积分值
     */
    private BigDecimal scoreVal;
    /**
     * 积分交易时间
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date transaTime;
    /**
     * 交易备注
     */
    private String memo;
    /**
     * 备用字段1
     */
    private String standby1;
    /**
     * 备用字段2
     */
    private String standby2;

    public String getScoreAccountId() {
        return scoreAccountId;
    }

    public void setScoreAccountId(String scoreAccountId) {
        this.scoreAccountId = scoreAccountId;
    }

    public String getBusiSource() {
        return busiSource;
    }

    public void setBusiSource(String busiSource) {
        this.busiSource = busiSource;
    }

    public String getBusiCode() {
        return busiCode;
    }

    public void setBusiCode(String busiCode) {
        this.busiCode = busiCode;
    }

    public String getTransactionNo() {
        return transactionNo;
    }

    public void setTransactionNo(String transactionNo) {
        this.transactionNo = transactionNo;
    }


    public BigDecimal getScoreVal() {
        return scoreVal;
    }

    public void setScoreVal(BigDecimal scoreVal) {
        this.scoreVal = scoreVal;
    }

    public Date getTransaTime() {
        return transaTime;
    }

    public void setTransaTime(Date transaTime) {
        this.transaTime = transaTime;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getStandby1() {
        return standby1;
    }

    public void setStandby1(String standby1) {
        this.standby1 = standby1;
    }

    public String getStandby2() {
        return standby2;
    }

    public void setStandby2(String standby2) {
        this.standby2 = standby2;
    }


    @Override
    public String toString() {
        return "ScoreExpenseDetailDTO{" +
                ", scoreAccountId='" +scoreAccountId + '\'' +
                ", busiSource='" + busiSource + '\'' +
                ", busiCode='" + busiCode + '\'' +
                ", transactionNo='" + transactionNo + '\'' +
                ", scoreVal='" + scoreVal + '\'' +
                ", transaTime=" + transaTime +
                ", memo='" + memo + '\'' +
                ", standby1='" + standby1 + '\'' +
                ", standby2='" + standby2 + '\'' +
                '}';
    }
}
