package score.api.dto.requestdto;

import com.alibaba.fastjson.annotation.JSONField;
import score.api.dto.entitydto.ScoreAccountDTO;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 积分转赠请求DTO
 */

public class ScoreGiveAwayRequestDTO implements Serializable {


    private String giveAwayScoreAccountId;

    /**
     * 获赠账户id
     */
    private String receiveScoreAccountId;
    /**
     * 转赠积分
     */
    private BigDecimal scoreVal;
    /**
     * 备注
     */
    private String memo;
    /**
     * 赠送时间
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date giveAwayTime;

    public String getGiveAwayScoreAccountId() {
        return giveAwayScoreAccountId;
    }

    public void setGiveAwayScoreAccountId(String giveAwayScoreAccountId) {
        this.giveAwayScoreAccountId = giveAwayScoreAccountId;
    }

    public String getReceiveScoreAccountId() {
        return receiveScoreAccountId;
    }

    public void setReceiveScoreAccountId(String receiveScoreAccountId) {
        this.receiveScoreAccountId = receiveScoreAccountId;
    }

    public BigDecimal getScoreVal() {
        return scoreVal;
    }

    public void setScoreVal(BigDecimal scoreVal) {
        this.scoreVal = scoreVal;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Date getGiveAwayTime() {
        return giveAwayTime;
    }

    public void setGiveAwayTime(Date giveAwayTime) {
        this.giveAwayTime = giveAwayTime;
    }
}
