package score.model;

import global.model.base.BaseDomain;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 企业预存款明细表
 */
@Entity
public class PrepaidDepositChangeLog extends BaseDomain implements Serializable {
    @Id
    @GenericGenerator(name = "PKUUID", strategy = "uuid2")
    @GeneratedValue(generator = "PKUUID")
    private String id;
    /**
     * 合作伙伴代码
     */
    private String organizationCode;
    /**
     * 交易明细凭证号
     */
    private String rcptCode;
    /**
     * 管理员id
     */
    private String adminId;
    /**
     * 管理员姓名
     */
    private String adminName;

    /**
     * 原有预存款(预存款目前只有畅悦使用)
     */
    private BigDecimal oldPrepaidDeposiVal;
    /**
     * 本次变更存款值
     */
    private BigDecimal depositVal;
    /**
     * 变更后预存款值
     */
    private BigDecimal newPrepaidDepositVal;
    /**
     * 预存款类型（0 积分，1 金额）
     */
    private String prepaidDepositType;
    /**
     * 变更类型（0，新增，1扣减）
     */
    private String changeType;
    /**
     * 交易备注
     */
    private String memo;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOrganizationCode() {
        return organizationCode;
    }

    public String getAdminId() {
        return adminId;
    }

    public void setAdminId(String adminId) {
        this.adminId = adminId;
    }

    public String getAdminName() {
        return adminName;
    }

    public void setAdminName(String adminName) {
        this.adminName = adminName;
    }

    public void setOrganizationCode(String organizationCode) {
        this.organizationCode = organizationCode;
    }

    public String getRcptCode() {
        return rcptCode;
    }

    public void setRcptCode(String rcptCode) {
        this.rcptCode = rcptCode;
    }

    public BigDecimal getOldPrepaidDeposiVal() {
        return oldPrepaidDeposiVal;
    }

    public void setOldPrepaidDeposiVal(BigDecimal oldPrepaidDeposiVal) {
        this.oldPrepaidDeposiVal = oldPrepaidDeposiVal;
    }



    public BigDecimal getDepositVal() {
        return depositVal;
    }

    public void setDepositVal(BigDecimal depositVal) {
        this.depositVal = depositVal;
    }

    public BigDecimal getNewPrepaidDepositVal() {
        return newPrepaidDepositVal;
    }

    public void setNewPrepaidDepositVal(BigDecimal newPrepaidDepositVal) {
        this.newPrepaidDepositVal = newPrepaidDepositVal;
    }

    public String getPrepaidDepositType() {
        return prepaidDepositType;
    }

    public void setPrepaidDepositType(String prepaidDepositType) {
        this.prepaidDepositType = prepaidDepositType;
    }

    public String getChangeType() {
        return changeType;
    }

    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        PrepaidDepositChangeLog that = (PrepaidDepositChangeLog) o;

        return id != null ? id.equals(that.id) : that.id == null;
    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }


}
