package score.model;

import global.model.base.BaseDomain;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.math.BigDecimal;
import java.util.List;

/**
 * 积分总账表
 */
@Entity
@Table(indexes = {
        @Index(name = "idx_Sc_Acc_userId",columnList = "userId"),
        @Index(name = "idx_Sc_Acc_phone",columnList = "phone"),
        @Index(name = "idx_Sc_Acc_email",columnList = "email")
})
public class ScoreAccount extends BaseDomain {
    @Id
    @GenericGenerator(name = "PKUUID", strategy = "uuid2")
    @GeneratedValue(generator = "PKUUID")
    private String id;
    /**
     * 合作伙伴代码
     */
    private String organizationCode;
    /**
     * 用户id
     */
    private String userId;
    /**
     * 手机号
     */
    private String phone;
    /**
     * 邮箱
     */
    private String email;
    /**
     * 总收入积分值
     */
    private BigDecimal incomeScoreVal;
    /**
     * 冻结积分值
     */
    private BigDecimal freezeScoreVal;
    /**
     * 已消费积分值
     */
    private BigDecimal expendedScoreVal;
    /**
     * 已失效积分值
     */
    private BigDecimal invalidScoreVal;
    /**
     * 即将失效积分值
     */
    private BigDecimal aboutOfInvalidScoreVal;
    /**
     * 用户昵称
     */
    private String nickName;
    /**
     * 备用字段1
     */
    private String standby1;
    /**
     * 备用字段2
     */
    private String standby2;

    /**
     * 服务间传输不能传输实体以及一对多关联，只能以DTO形式传输，传输一对多关联相当于热加载
     */
    @OneToMany(fetch = FetchType.LAZY ,cascade = CascadeType.ALL ,mappedBy = "scoreAccount")
    List<ScoreIncomeDetail> scoreIncomeDetails;
    @OneToMany(fetch = FetchType.LAZY ,cascade = CascadeType.ALL ,mappedBy = "scoreAccount")
    List<ScoreExpenseDetail> scoreExpenseDetails;
    @OneToMany(fetch = FetchType.LAZY ,cascade = CascadeType.ALL ,mappedBy = "giveAwayScoreAccount")
    List<ScoreGiveAwayLog> scoreGiveAwayLogs;
    @OneToMany(fetch = FetchType.LAZY ,cascade = CascadeType.ALL ,mappedBy = "receiveScoreAccount")
    List<ScoreGiveAwayLog> scoreReceiveLogs;
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOrganizationCode() {
        return organizationCode;
    }

    public void setOrganizationCode(String organizationCode) {
        this.organizationCode = organizationCode;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public BigDecimal getIncomeScoreVal() {
        return incomeScoreVal;
    }

    public void setIncomeScoreVal(BigDecimal incomeScoreVal) {
        this.incomeScoreVal = incomeScoreVal;
    }

    public BigDecimal getFreezeScoreVal() {
        return freezeScoreVal;
    }

    public void setFreezeScoreVal(BigDecimal freezeScoreVal) {
        this.freezeScoreVal = freezeScoreVal;
    }

    public BigDecimal getExpendedScoreVal() {
        return expendedScoreVal;
    }

    public void setExpendedScoreVal(BigDecimal expendedScoreVal) {
        this.expendedScoreVal = expendedScoreVal;
    }

    public BigDecimal getInvalidScoreVal() {
        return invalidScoreVal;
    }

    public void setInvalidScoreVal(BigDecimal invalidScoreVal) {
        this.invalidScoreVal = invalidScoreVal;
    }

    public BigDecimal getAboutOfInvalidScoreVal() {
        return aboutOfInvalidScoreVal;
    }

    public void setAboutOfInvalidScoreVal(BigDecimal aboutOfInvalidScoreVal) {
        this.aboutOfInvalidScoreVal = aboutOfInvalidScoreVal;
    }

    public List<ScoreIncomeDetail> getScoreIncomeDetails() {
        return scoreIncomeDetails;
    }

    public void setScoreIncomeDetails(List<ScoreIncomeDetail> scoreIncomeDetails) {
        this.scoreIncomeDetails = scoreIncomeDetails;
    }

    public List<ScoreExpenseDetail> getScoreExpenseDetails() {
        return scoreExpenseDetails;
    }

    public void setScoreExpenseDetails(List<ScoreExpenseDetail> scoreExpenseDetails) {
        this.scoreExpenseDetails = scoreExpenseDetails;
    }

    public List<ScoreGiveAwayLog> getScoreGiveAwayLogs() {
        return scoreGiveAwayLogs;
    }

    public void setScoreGiveAwayLogs(List<ScoreGiveAwayLog> scoreGiveAwayLogs) {
        this.scoreGiveAwayLogs = scoreGiveAwayLogs;
    }

    public List<ScoreGiveAwayLog> getScoreReceiveLogs() {
        return scoreReceiveLogs;
    }

    public void setScoreReceiveLogs(List<ScoreGiveAwayLog> scoreReceiveLogs) {
        this.scoreReceiveLogs = scoreReceiveLogs;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ScoreAccount that = (ScoreAccount) o;

        return id != null ? id.equals(that.id) : that.id == null;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getStandby1() {
        return standby1;
    }

    public void setStandby1(String standby1) {
        this.standby1 = standby1;
    }

    public String getStandby2() {
        return standby2;
    }

    public void setStandby2(String standby2) {
        this.standby2 = standby2;
    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }

    @Override
    public String toString() {
        return "ScoreAccount{" +
                "id='" + id + '\'' +
                ", organizationCode='" + organizationCode + '\'' +
                ", userId='" + userId + '\'' +
                ", phone='" + phone + '\'' +
                ", email='" + email + '\'' +
                ", incomeScoreVal=" + incomeScoreVal +
                ", freezeScoreVal=" + freezeScoreVal +
                ", expendedScoreVal=" + expendedScoreVal +
                ", invalidScoreVal=" + invalidScoreVal +
                ", aboutOfInvalidScoreVal=" + aboutOfInvalidScoreVal +
                ", nickName='" + nickName + '\'' +
                ", standby1='" + standby1 + '\'' +
                ", standby2='" + standby2 + '\'' +
                '}';
    }
}
