package score.model;

import com.alibaba.fastjson.annotation.JSONField;
import global.model.base.BaseDomain;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * 积分支出明细表
 */
@Entity
@Table(indexes = {
        @Index(name = "idx_Score_Ex_Acc_Id", columnList = "score_Account_Id"),
        @Index(name = "idx_Score_Ex_bCode", columnList = "busiCode"),
        @Index(name = "idx_Score_Ex_Rcpt_Code", columnList = "scoreRcptCode")
})
public class ScoreExpenseDetail extends BaseDomain {

    @Id
    @GenericGenerator(name = "PKUUID", strategy = "uuid2")
    @GeneratedValue(generator = "PKUUID")
    private String id;
    /**
     * 积分账户表id
     */
//    private String scoreAccountId;
    @ManyToOne
    @JoinColumn(name = "score_account_id", foreignKey = @ForeignKey(name = "fk_sc_acc_sc_exp"))
    private ScoreAccount scoreAccount;
    /**
     * 消费渠道名称
     */
    private String busiSource;
    /**
     * 消费渠道代码
     */
    private String busiCode;
    /**
     * 请求流水号（合作商内唯一）
     */
    private String transactionNo;
    /**
     * 积分交易明细凭证号
     */
    private String scoreRcptCode;
    /**
     * 交易积分值
     */
    private BigDecimal scoreVal;
    /**
     * 积分交易时间
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date transaTime;
    /**
     * 交易备注
     */
    private String memo;
    /**
     * 备用字段1
     */
    private String standby1;
    /**
     * 备用字段2
     */
    private String standby2;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ScoreAccount getScoreAccount() {
        return scoreAccount;
    }

    public void setScoreAccount(ScoreAccount scoreAccount) {
        this.scoreAccount = scoreAccount;
    }

    public String getBusiSource() {
        return busiSource;
    }

    public void setBusiSource(String busiSource) {
        this.busiSource = busiSource;
    }

    public String getBusiCode() {
        return busiCode;
    }

    public void setBusiCode(String busiCode) {
        this.busiCode = busiCode;
    }

    public String getTransactionNo() {
        return transactionNo;
    }

    public void setTransactionNo(String transactionNo) {
        this.transactionNo = transactionNo;
    }

    public String getScoreRcptCode() {
        return scoreRcptCode;
    }

    public void setScoreRcptCode(String scoreRcptCode) {
        this.scoreRcptCode = scoreRcptCode;
    }

    public BigDecimal getScoreVal() {
        return scoreVal;
    }

    public void setScoreVal(BigDecimal scoreVal) {
        this.scoreVal = scoreVal;
    }

    public Date getTransaTime() {
        return transaTime;
    }

    public void setTransaTime(Date transaTime) {
        this.transaTime = transaTime;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getStandby1() {
        return standby1;
    }

    public void setStandby1(String standby1) {
        this.standby1 = standby1;
    }

    public String getStandby2() {
        return standby2;
    }

    public void setStandby2(String standby2) {
        this.standby2 = standby2;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ScoreExpenseDetail that = (ScoreExpenseDetail) o;

        return id != null ? id.equals(that.id) : that.id == null;
    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }

    @Override
    public String toString() {
        return "ScoreExpenseDetail{" +
                "id='" + id + '\'' +
                ", scoreAccountId='" + (scoreAccount == null ? "" : scoreAccount.getId()) + '\'' +
                ", busiSource='" + busiSource + '\'' +
                ", busiCode='" + busiCode + '\'' +
                ", transactionNo='" + transactionNo + '\'' +
                ", scoreRcptCode='" + scoreRcptCode + '\'' +
                ", scoreVal='" + scoreVal + '\'' +
                ", transaTime=" + transaTime +
                ", memo='" + memo + '\'' +
                ", standby1='" + standby1 + '\'' +
                ", standby2='" + standby2 + '\'' +
                '}';
    }
}
