package score.model;

import com.alibaba.fastjson.annotation.JSONField;
import global.model.base.BaseDomain;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 积分转赠记录表
 */
@Entity
@Table(indexes = {
        @Index(name = "idx_Sc_Give_Acc_Id",columnList = "give_away_score_account_id"),
        @Index(name = "idx_Sc_Give_recAcc_Id",columnList = "receive_score_account_id"),
        @Index(name = "idx_Sc_Detail_in_Rc",columnList = "scoreIncomeRcptCode"),
        @Index(name = "idx_Sc_Detail_ex_Rc",columnList = "scoreExpenseRcptCode")
})
public class ScoreGiveAwayLog extends BaseDomain {
    @Id
    @GenericGenerator(name = "PKUUID", strategy = "uuid2")
    @GeneratedValue(generator = "PKUUID")
    private String id;
    /**
     * 赠送积分账户id
     */
//    private String giveAwayScoreAccountId;
    @ManyToOne
    @JoinColumn(name = "give_away_score_account_id",foreignKey = @ForeignKey(name = "fk_sc_acc_give_acc"))
    private ScoreAccount giveAwayScoreAccount;

    /**
     * 获赠账户id
     */
//    private String receiveScoreAccountId;
    @ManyToOne
    @JoinColumn(name = "receive_score_account_id",foreignKey = @ForeignKey(name = "fk_sc_acc_rec_acc"))
    private ScoreAccount receiveScoreAccount;
    /**
     * 转赠积分
     */
    private BigDecimal scoreVal;
    /**
     * 积分交易明细凭证号（收入）
     */
    private String scoreIncomeRcptCode;
    /**
     * 积分交易明细凭证号（支出）
     */
    private String scoreExpenseRcptCode;
    /**
     * 备注
     */
    private String memo;
    /**
     * 赠送时间
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date giveAwayTime;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ScoreAccount getGiveAwayScoreAccount() {
        return giveAwayScoreAccount;
    }

    public void setGiveAwayScoreAccount(ScoreAccount giveAwayScoreAccount) {
        this.giveAwayScoreAccount = giveAwayScoreAccount;
    }

    public ScoreAccount getReceiveScoreAccount() {
        return receiveScoreAccount;
    }

    public void setReceiveScoreAccount(ScoreAccount receiveScoreAccount) {
        this.receiveScoreAccount = receiveScoreAccount;
    }

    public BigDecimal getScoreVal() {
        return scoreVal;
    }

    public void setScoreVal(BigDecimal scoreVal) {
        this.scoreVal = scoreVal;
    }

    public String getScoreIncomeRcptCode() {
        return scoreIncomeRcptCode;
    }

    public void setScoreIncomeRcptCode(String scoreIncomeRcptCode) {
        this.scoreIncomeRcptCode = scoreIncomeRcptCode;
    }

    public String getScoreExpenseRcptCode() {
        return scoreExpenseRcptCode;
    }

    public void setScoreExpenseRcptCode(String scoreExpenseRcptCode) {
        this.scoreExpenseRcptCode = scoreExpenseRcptCode;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Date getGiveAwayTime() {
        return giveAwayTime;
    }

    public void setGiveAwayTime(Date giveAwayTime) {
        this.giveAwayTime = giveAwayTime;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ScoreGiveAwayLog that = (ScoreGiveAwayLog) o;

        return id != null ? id.equals(that.id) : that.id == null;
    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }

    @Override
    public String toString() {
        return "ScoreGiveAwayLog{" +
                "id='" + id + '\'' +
                ", giveAwayScoreAccountId='" + (giveAwayScoreAccount==null?"": giveAwayScoreAccount.getId()) + '\'' +
                ", receiveScoreAccountId='" +(receiveScoreAccount==null?"":receiveScoreAccount.getId() ) + '\'' +
                ", scoreVal=" + scoreVal +
                ", scoreIncomeRcptCode='" + scoreIncomeRcptCode + '\'' +
                ", scoreExpenseRcptCode='" + scoreExpenseRcptCode + '\'' +
                ", memo='" + memo + '\'' +
                ", giveAwayTime=" + giveAwayTime +
                '}';
    }
}
