package score.model.repository;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import score.api.dto.entitydto.ScoreIncomeExpenseDetailDTO;
import score.model.ScoreExpenseDetail;
import score.model.ScoreIncomeDetail;

import java.math.BigDecimal;
import java.util.List;

public interface ScoreExpenseDetailRepos extends JpaRepository<ScoreExpenseDetail, String>, JpaSpecificationExecutor<ScoreExpenseDetail> {
    @Query("select count (*) from ScoreAccount account,ScoreExpenseDetail  detail where account=detail.scoreAccount and account.organizationCode=?1 and detail.transactionNo=?2")
    Integer validateExpenseTransactionNo(String organizationCode, String transactionNo);

    @Query("select sum (detail.scoreVal) from ScoreAccount account,ScoreExpenseDetail  detail where account=detail.scoreAccount and account.organizationCode=?1 and detail.busiCode=?2")
    BigDecimal queryOrgExpenseStaticsVal(String organizationCode, String busiCode);

    @Query("select sum (detail.scoreVal) from ScoreAccount account,ScoreExpenseDetail  detail where account=detail.scoreAccount and account.organizationCode=?1 and account.id=?2 and detail.busiCode=?3")
    BigDecimal queryExpenseStaticsVal(String organizationCode, String scoreAccountId, String busiCode);

    @Query(nativeQuery = true, value = "SELECT a.* FROM (SELECT rownum as rn, t.* FROM (SELECT d.* FROM (SELECT sid.score_account_id as scoreAccountId, sid.transa_time as transaTime, sid.busi_source as busiSource, sid.score_val as scoreVal, sid.memo as memo FROM score_income_detail sid UNION SELECT sed.score_account_id as scoreAccountId, sed.transa_time as transaTime, sed.busi_source as busiSource, sed.score_val * -1 as scoreVal, sed.memo as memo FROM score_expense_detail sed) d WHERE d.scoreAccountId = ?1 ORDER BY d.transatime DESC NULLS LAST ) t) a WHERE A.RN >= ?2 AND A.RN < ?3")
    List<Object[]> queryIncomeExpenseDetail(String scoreAccountId, Integer start, Integer end);

    @Query(nativeQuery = true, value = "SELECT count(*) FROM (SELECT sid.score_account_id as scoreAccountId, sid.transa_time as transaTime, sid.busi_source as busiSource, sid.score_val as scoreVal, sid.memo as memo FROM score_income_detail sid UNION SELECT sed.score_account_id as scoreAccountId, sed.transa_time as transaTime, sed.busi_source as busiSource, sed.score_val as scoreVal, sed.memo as memo FROM score_expense_detail sed) d WHERE d.scoreAccountId = ?1")
    BigDecimal getIncomeExpenseDetailCount(String scoreAccountId);

}
