package score.model.repository;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import score.model.ScoreGiveAwayLog;

import java.util.List;

public interface ScoreGiveAwayLogRepos extends JpaRepository<ScoreGiveAwayLog,String> {

    @Query("select sgal from ScoreGiveAwayLog sgal where sgal.scoreIncomeRcptCode=?1 and sgal.scoreExpenseRcptCode=?2")
    public ScoreGiveAwayLog getScoreGiveAwayInfo(String scoreIncomeRcptCode,String scoreExpenseRcptCode);

    @Query("select sgal from ScoreGiveAwayLog sgal where sgal.scoreIncomeRcptCode=?1")
    public ScoreGiveAwayLog getScoreGiveAwayByIncomeCode(String scoreIncomeRcptCode);

    @Query("select sgal from ScoreGiveAwayLog sgal where sgal.scoreExpenseRcptCode=?1")
    public ScoreGiveAwayLog getScoreGiveAwayByExpenseCode(String scoreExpenseRcptCode);

    @Query("select sgal from ScoreGiveAwayLog sgal where sgal.scoreIncomeRcptCode IN ?1")
    List<ScoreGiveAwayLog> findScoreGiveAwayByIncomeCodes(List<String> scoreIncomeRcptCodes);

    @Query("select sgal from ScoreGiveAwayLog sgal where sgal.scoreExpenseRcptCode IN ?1")
    List<ScoreGiveAwayLog> findScoreGiveAwayByExpenseCodes(List<String> scoreExpenseRcptCodes);
}
