package score.model.repository;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import score.model.ScoreIncomeDetail;

import java.math.BigDecimal;

public interface ScoreIncomeDetailRepos extends JpaRepository<ScoreIncomeDetail, String>, JpaSpecificationExecutor<ScoreIncomeDetail> {
    @Query("select count (*) from ScoreAccount account,ScoreIncomeDetail  detail where account=detail.scoreAccount and account.organizationCode=?1 and detail.transactionNo=?2")
    public Integer validateIncomeTransactionNo(String organizationCode, String transactionNo);

    @Query("select sum (detail.scoreVal) from ScoreAccount account,ScoreIncomeDetail  detail where account=detail.scoreAccount and account.organizationCode=?1 and detail.busiCode=?2")
    BigDecimal queryOrgIncomeStaticsVal(String organizationCode, String busiCode);

    @Query("select sum (detail.scoreVal) from ScoreAccount account,ScoreIncomeDetail  detail where account=detail.scoreAccount and account.organizationCode=?1 and account.id=?2 and detail.busiCode=?3")
    BigDecimal queryIncomeStaticsVal(String organizationCode, String scoreAccountId, String busiCode);
}
