package score.model.specification;

import org.springframework.data.jpa.domain.Specification;
import org.springframework.util.StringUtils;
import score.api.dto.requestdto.ScoreDetailQueryDTO;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;

public class ScoreDetailSpecification<T> implements Specification<T> {
    private ScoreDetailQueryDTO scoreDetailQueryDTO;

    public ScoreDetailSpecification(ScoreDetailQueryDTO scoreDetailQueryDTO) {
        this.scoreDetailQueryDTO = scoreDetailQueryDTO;
    }

    public ScoreDetailSpecification() {
    }

    @Override
    public Predicate toPredicate(Root root, CriteriaQuery query, CriteriaBuilder cb) {
        Predicate predicate = cb.equal(root.get("scoreAccount").get("organizationCode"), scoreDetailQueryDTO.getOrganizationCode());
//        Predicate predicate =null;
        if (!StringUtils.isEmpty(scoreDetailQueryDTO.getScoreAccountIds()) && !scoreDetailQueryDTO.getScoreAccountIds().isEmpty()) {
            predicate = cb.and(root.get("scoreAccount").get("id").in(scoreDetailQueryDTO.getScoreAccountIds()));
        }
        if (!StringUtils.isEmpty(scoreDetailQueryDTO.getBusiCode())) {
            predicate = cb.and(predicate, cb.equal(root.get("busiCode"), scoreDetailQueryDTO.getBusiCode()));
        }
        if (scoreDetailQueryDTO.getStartDate() != null) {
            predicate = cb.and(predicate, cb.greaterThanOrEqualTo(root.get("transaTime"), scoreDetailQueryDTO.getStartDate()));
        }
        if (scoreDetailQueryDTO.getEndDate() != null) {
            predicate = cb.and(predicate, cb.lessThanOrEqualTo(root.get("transaTime"), scoreDetailQueryDTO.getEndDate()));
        }
        if(!StringUtils.isEmpty(scoreDetailQueryDTO.getNickName())){
            predicate=cb.and(predicate,cb.like(root.get("scoreAccount").get("nickName"),"%"+scoreDetailQueryDTO.getNickName()+"%"));
        }
        return predicate;
    }
}
